/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.diagnostic.ThreadTracePersistingConfig;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.ThreadStat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadTrace {
    private static final Logger LOG = Logger.getInstance((String)ThreadTrace.class.getName());
    private final ThreadTracePersistingConfig myThreadTracePersistingConfig;
    private final EventDispatcher<TraceListener> myTracesDispatcher = EventDispatcher.create(TraceListener.class);
    private static final AtomicReference<ThreadTrace> ourThreadTraceRef = new AtomicReference();

    private ThreadTrace() {
        this.myThreadTracePersistingConfig = ThreadTracePersistingConfig.getInstance();
    }

    @NotNull
    public static ThreadTrace getInstance() {
        ThreadTrace trace = ourThreadTraceRef.get();
        if (trace != null) {
            ThreadTrace threadTrace = trace;
            if (threadTrace == null) {
                ThreadTrace.$$$reportNull$$$0(0);
            }
            return threadTrace;
        }
        trace = new ThreadTrace();
        if (ourThreadTraceRef.compareAndSet(null, trace)) {
            ThreadTrace threadTrace = trace;
            if (threadTrace == null) {
                ThreadTrace.$$$reportNull$$$0(1);
            }
            return threadTrace;
        }
        ThreadTrace threadTrace = ourThreadTraceRef.get();
        if (threadTrace == null) {
            ThreadTrace.$$$reportNull$$$0(2);
        }
        return threadTrace;
    }

    public void enableTraceRecording() {
        ThreadStat.init();
    }

    public void persistTrace(@NotNull String comment, @NotNull String traceName) {
        if (comment == null) {
            ThreadTrace.$$$reportNull$$$0(3);
        }
        if (traceName == null) {
            ThreadTrace.$$$reportNull$$$0(4);
        }
        this.persistTrace(comment, this.myThreadTracePersistingConfig.getPersistThresholdMillis(traceName), traceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void persistTrace(@NotNull String comment, long persistThresholdMillis, @NotNull String string) {
        if (comment == null) {
            ThreadTrace.$$$reportNull$$$0(5);
        }
        if (string == null) {
            ThreadTrace.$$$reportNull$$$0(6);
        }
        try {
            void traceName;
            if (!this.isEnabled()) {
                return;
            }
            Iterator<ThreadStat.ThreadOperation> iter = ThreadStat.get().getOperations();
            if (!iter.hasNext()) {
                return;
            }
            long durationNanos = iter.next().getDurationNanos();
            if (TimeUnit.NANOSECONDS.toMillis(durationNanos) < persistThresholdMillis) {
                return;
            }
            boolean persistJson = this.myThreadTracePersistingConfig.isPersistJsonEnabled();
            String fileName = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "_id" + Thread.currentThread().getId() + "_" + (String)traceName + "_" + TimeUnit.SECONDS.convert(durationNanos, TimeUnit.NANOSECONDS) + "s";
            ArrayList<File> savedTraces = new ArrayList<File>();
            savedTraces.add(this.persistTraceTxt(comment, fileName + ".txt"));
            if (persistJson) {
                savedTraces.add(this.persistTraceJson(fileName + ".json"));
            }
            this.myTracesDispatcher.getMulticaster().traceFilesSaved(savedTraces);
            LOG.info("Saved thread traces into files: " + savedTraces);
        }
        catch (Throwable e) {
            LOG.warnAndDebugDetails("Error while persisting thread trace", e);
        }
        finally {
            ThreadStat.reset();
        }
    }

    public void discardTrace() {
        ThreadStat.reset();
    }

    public void addListener(@NotNull TraceListener traceListener) {
        if (traceListener == null) {
            ThreadTrace.$$$reportNull$$$0(7);
        }
        this.myTracesDispatcher.addListener(traceListener);
    }

    private boolean isEnabled() {
        return this.myThreadTracePersistingConfig.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private File persistTraceTxt(@Nullable String comment, @NotNull String fileName) throws IOException {
        if (fileName == null) {
            ThreadTrace.$$$reportNull$$$0(8);
        }
        File trace = new File(this.myThreadTracePersistingConfig.getCurrentDiagnosticDir(), fileName);
        Iterator<ThreadStat.ThreadOperation> iter = ThreadStat.get().getOperations();
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(trace));
            w.write("Thread name: ");
            w.write(Thread.currentThread().getName());
            if (comment != null) {
                w.write("; ");
                w.write(comment);
            }
            w.write("\n");
            while (iter.hasNext()) {
                ThreadStat.ThreadOperation operation = iter.next();
                w.write(String.valueOf(operation.getLevel()));
                w.write(" ");
                this.writeInterval(w, operation.getDurationNanos());
                w.write(" ");
                w.write(operation.getDescription());
                w.write("\n");
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(w);
            throw throwable;
        }
        FileUtil.close(w);
        File file = trace;
        if (file == null) {
            ThreadTrace.$$$reportNull$$$0(9);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private File persistTraceJson(@NotNull String fileName) throws IOException {
        if (fileName == null) {
            ThreadTrace.$$$reportNull$$$0(10);
        }
        File trace = new File(this.myThreadTracePersistingConfig.getCurrentDiagnosticDir(), fileName);
        Iterator<ThreadStat.ThreadOperation> iter = ThreadStat.get().getOperations();
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(trace));
            long requestStart = 0L;
            w.write("[");
            LinkedList<ThreadStat.ThreadOperation> path = new LinkedList<ThreadStat.ThreadOperation>();
            while (iter.hasNext()) {
                ThreadStat.ThreadOperation operation = iter.next();
                if (requestStart == 0L) {
                    requestStart = operation.getStartNanos();
                }
                while (!path.isEmpty() && ((ThreadStat.ThreadOperation)path.peek()).getLevel() >= operation.getLevel()) {
                    this.writeOperationEndEvent(w, requestStart, (ThreadStat.ThreadOperation)path.pop());
                    w.write(",\n");
                }
                path.push(operation);
                this.writeOperationStartEvent(w, requestStart, operation);
                if (!iter.hasNext()) continue;
                w.write(",\n");
            }
            while (!path.isEmpty()) {
                ThreadStat.ThreadOperation op = (ThreadStat.ThreadOperation)path.pop();
                w.write(",\n");
                this.writeOperationEndEvent(w, requestStart, op);
            }
            w.write("]");
        }
        catch (Throwable throwable) {
            FileUtil.close(w);
            throw throwable;
        }
        FileUtil.close(w);
        File file = trace;
        if (file == null) {
            ThreadTrace.$$$reportNull$$$0(11);
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private void writeOperationStartEvent(@NotNull Writer w, long requestStart, @NotNull ThreadStat.ThreadOperation threadOperation) throws IOException {
        void operation;
        if (w == null) {
            ThreadTrace.$$$reportNull$$$0(12);
        }
        if (threadOperation == null) {
            ThreadTrace.$$$reportNull$$$0(13);
        }
        long ts = operation.getStartNanos() - requestStart;
        w.write("{\"ph\":\"B\",\"pid\":\"TeamCity\",\"tid\":" + Thread.currentThread().getId() + ",");
        w.write("\"name\":\"");
        w.write(operation.getDescription().replaceAll("\"", "'"));
        w.write("\",");
        w.write("\"ts\":");
        w.write(String.valueOf(ts / 1000L) + ".");
        long nanos = ts % 1000L;
        if (nanos < 100L) {
            w.write("0");
        }
        if (nanos < 10L) {
            w.write("0");
        }
        w.write(String.valueOf(nanos));
        w.write("}");
    }

    /*
     * WARNING - void declaration
     */
    private void writeOperationEndEvent(@NotNull Writer w, long requestStart, @NotNull ThreadStat.ThreadOperation threadOperation) throws IOException {
        void op;
        if (w == null) {
            ThreadTrace.$$$reportNull$$$0(14);
        }
        if (threadOperation == null) {
            ThreadTrace.$$$reportNull$$$0(15);
        }
        long ts = op.getStartNanos() + op.getDurationNanos() - requestStart;
        w.write("{\"ph\":\"E\",\"pid\":\"TeamCity\",\"tid\":" + Thread.currentThread().getId() + ",");
        w.write("\"name\":\"");
        w.write(op.getDescription().replaceAll("\"", "'").replaceAll("\\\\'", "'"));
        w.write("\",");
        w.write("\"ts\":");
        w.write(String.valueOf(ts / 1000L) + ".");
        long nanos = ts % 1000L;
        if (nanos < 100L) {
            w.write("0");
        }
        if (nanos < 10L) {
            w.write("0");
        }
        w.write(String.valueOf(nanos));
        w.write("}");
    }

    private void writeInterval(@NotNull Writer w, long nanos) throws IOException {
        if (w == null) {
            ThreadTrace.$$$reportNull$$$0(16);
        }
        long seconds = TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS);
        long millis = TimeUnit.MILLISECONDS.convert(nanos -= TimeUnit.NANOSECONDS.convert(seconds, TimeUnit.SECONDS), TimeUnit.NANOSECONDS);
        long micros = TimeUnit.MICROSECONDS.convert(nanos -= TimeUnit.NANOSECONDS.convert(millis, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS);
        nanos -= TimeUnit.NANOSECONDS.convert(micros, TimeUnit.MICROSECONDS);
        boolean nonZeroFound = false;
        this.writeAligned(w, seconds, "s", nonZeroFound);
        if (seconds != 0L) {
            nonZeroFound = true;
        }
        this.writeAligned(w, millis, "ms", nonZeroFound);
        if (millis != 0L) {
            nonZeroFound = true;
        }
        this.writeAligned(w, micros, "us", nonZeroFound);
        if (micros != 0L) {
            nonZeroFound = true;
        }
        this.writeAligned(w, nanos, "ns", nonZeroFound, true);
    }

    /*
     * WARNING - void declaration
     */
    private void writeAligned(@NotNull Writer w, long dur, @NotNull String suffix, boolean bl) throws IOException {
        void writeLeadingZeros;
        if (w == null) {
            ThreadTrace.$$$reportNull$$$0(17);
        }
        if (suffix == null) {
            ThreadTrace.$$$reportNull$$$0(18);
        }
        this.writeAligned(w, dur, suffix, (boolean)writeLeadingZeros, false);
    }

    /*
     * WARNING - void declaration
     */
    private void writeAligned(@NotNull Writer w, long dur, @NotNull String suffix, boolean writeLeadingZeros, boolean bl) throws IOException {
        void writeSingleZero;
        if (w == null) {
            ThreadTrace.$$$reportNull$$$0(19);
        }
        if (suffix == null) {
            ThreadTrace.$$$reportNull$$$0(20);
        }
        if (dur < 100L) {
            this.writeZeroOrSpace(w, writeLeadingZeros);
        }
        if (dur < 10L) {
            this.writeZeroOrSpace(w, writeLeadingZeros);
        }
        if (dur == 0L) {
            this.writeZeroOrSpace(w, writeLeadingZeros || writeSingleZero != false);
        } else {
            w.write(String.valueOf(dur));
        }
        if (dur > 0L || writeLeadingZeros || writeSingleZero != false) {
            w.write(suffix);
        } else {
            for (int i = 0; i < suffix.length(); ++i) {
                w.write(" ");
            }
        }
    }

    private void writeZeroOrSpace(@NotNull Writer w, boolean writeZero) throws IOException {
        if (w == null) {
            ThreadTrace.$$$reportNull$$$0(21);
        }
        if (writeZero) {
            w.write("0");
        } else {
            w.write(" ");
        }
    }

    @Nullable
    public String getTraceNameForThread(@NotNull String threadName) {
        if (threadName == null) {
            ThreadTrace.$$$reportNull$$$0(22);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/diagnostic/ThreadTrace";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceListener";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/diagnostic/ThreadTrace";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "persistTraceTxt";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "persistTraceJson";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "persistTrace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "persistTraceTxt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "persistTraceJson";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeOperationStartEvent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeOperationEndEvent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeInterval";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "writeAligned";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeZeroOrSpace";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTraceNameForThread";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface TraceListener
    extends EventListener {
        public void traceFilesSaved(@NotNull Collection<File> var1);
    }
}

