/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.diagnostic;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.diagnostic.DiagnosticDirsConfig;
import jetbrains.buildServer.log.LogInitializationException;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import org.jetbrains.annotations.NotNull;

public class ThreadTracePersistingConfig
extends DiagnosticDirsConfig {
    public static final String THREAD_STAT_DIR_PREFIX = "traces-";
    public static final String THREAD_STAT_PERSIST_ENABLED = "teamcity.diagnostics.threadStatPersistEnabled";
    private static final String THREAD_STAT_PERSIST_JSON_ENABLED = "teamcity.diagnostics.threadStatPersistJsonEnabled";
    public static final String THREAD_STAT_PERSIST_THRESHOLD_MILLIS = "teamcity.diagnostics.threadStatPersistThresholdMillis";

    protected ThreadTracePersistingConfig(@NotNull File tracesParentDir) {
        if (tracesParentDir == null) {
            ThreadTracePersistingConfig.$$$reportNull$$$0(0);
        }
        super(tracesParentDir, THREAD_STAT_DIR_PREFIX);
    }

    @NotNull
    public static ThreadTracePersistingConfig getInstance() {
        File logsDir = null;
        try {
            logsDir = LogInitializer.getLogDir();
        }
        catch (LogInitializationException e) {
            System.out.println("Could not obtain the logs directory: " + e.toString() + ", thread tracing will be disabled");
        }
        if (logsDir == null) {
            ThreadTracePersistingConfig threadTracePersistingConfig = new ThreadTracePersistingConfig(new File(".")){

                @Override
                public boolean isEnabled() {
                    return false;
                }

                @Override
                @NotNull
                public List<File> getDiagnosticDirs(boolean onlyStandard) {
                    List<File> list = Collections.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                @Override
                @NotNull
                public List<DiagnosticDirsConfig.DirData> getDiagnosticDirsData(boolean onlyStandard) {
                    List<DiagnosticDirsConfig.DirData> list = Collections.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "jetbrains/buildServer/diagnostic/ThreadTracePersistingConfig$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDiagnosticDirs";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDiagnosticDirsData";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            if (threadTracePersistingConfig == null) {
                ThreadTracePersistingConfig.$$$reportNull$$$0(1);
            }
            return threadTracePersistingConfig;
        }
        ThreadTracePersistingConfig threadTracePersistingConfig = new ThreadTracePersistingConfig(logsDir);
        if (threadTracePersistingConfig == null) {
            ThreadTracePersistingConfig.$$$reportNull$$$0(2);
        }
        return threadTracePersistingConfig;
    }

    public boolean isEnabled() {
        return TeamCityProperties.getBoolean(THREAD_STAT_PERSIST_ENABLED);
    }

    public long getPersistThresholdMillis(@NotNull String traceName) {
        if (traceName == null) {
            ThreadTracePersistingConfig.$$$reportNull$$$0(3);
        }
        long defaultThreshold = TeamCityProperties.getLong(THREAD_STAT_PERSIST_THRESHOLD_MILLIS, TimeUnit.MINUTES.toMillis(1L));
        return TeamCityProperties.getLong("teamcity.diagnostics.threadStatPersistThresholdMillis." + traceName, defaultThreshold);
    }

    public boolean isPersistJsonEnabled() {
        return TeamCityProperties.getBoolean(THREAD_STAT_PERSIST_JSON_ENABLED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracesParentDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/diagnostic/ThreadTracePersistingConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/diagnostic/ThreadTracePersistingConfig";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPersistThresholdMillis";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

