/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.duplicator;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class DuplicateInfo {
    private final Fragment[] myFragments;
    private final DuplicateMetrics myMetrics;

    public DuplicateInfo(int hash, int cost, Fragment[] fragments) {
        this.myMetrics = new DuplicateMetrics(hash, cost);
        this.myFragments = fragments;
    }

    public DuplicateMetrics getMetrics() {
        return this.myMetrics;
    }

    public Fragment[] getFragments() {
        return this.myFragments;
    }

    public int getHash() {
        return this.myMetrics.getHash();
    }

    public int getCost() {
        return this.myMetrics.getCost();
    }

    public int getDensity() {
        return this.myFragments.length;
    }

    public String toString() {
        return this.myMetrics.getHash() + ":" + this.myMetrics.getCost() + ":" + this.myFragments.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DuplicateInfo that = (DuplicateInfo)o;
        if (!this.myMetrics.equals(that.myMetrics)) {
            return false;
        }
        return Arrays.equals(this.myFragments, that.myFragments);
    }

    public int hashCode() {
        return 31 * this.myMetrics.hashCode() + Arrays.hashCode(this.myFragments);
    }

    public static class LineOffset
    extends FragmentOffset {
        private final int myStartLine;
        private final int myEndLine;
        public static final String PREFIX = "line:";

        public LineOffset(int startOffset, int endOffset) {
            this.myStartLine = startOffset;
            this.myEndLine = endOffset;
        }

        public LineOffset(String serialized) {
            String withoutPrefix = serialized.substring(PREFIX.length());
            StringTokenizer st = new StringTokenizer(withoutPrefix, ",");
            this.myStartLine = Integer.valueOf(st.nextToken());
            this.myEndLine = Integer.valueOf(st.nextToken());
        }

        @Override
        public String getAsString() {
            return PREFIX + this.myStartLine + "," + this.myEndLine;
        }

        @Override
        public String extractFragment(String fileContent) {
            String normalizedContent = StringUtil.convertLineSeparators((String)fileContent);
            int startOffset = 0;
            int endOffset = -1;
            int lineFeed = 0;
            int pos = 0;
            while ((pos = normalizedContent.indexOf(10, pos)) >= 0) {
                ++pos;
                if (++lineFeed == this.myStartLine - 1) {
                    startOffset = pos;
                }
                if (lineFeed != this.myEndLine) continue;
                endOffset = pos - 1;
            }
            if (startOffset < 0 || startOffset > normalizedContent.length()) {
                startOffset = 0;
            }
            if (endOffset <= 0 || endOffset > normalizedContent.length()) {
                endOffset = normalizedContent.length();
            }
            if (endOffset <= startOffset) {
                return "";
            }
            return normalizedContent.substring(startOffset, endOffset);
        }
    }

    public static class CharOffset
    extends FragmentOffset {
        private int myStartOffset;
        private int myEndOffset;
        public static final String PREFIX = "char:";

        public CharOffset(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public CharOffset(String serialized) {
            String withoutPrefix = serialized.substring(PREFIX.length());
            StringTokenizer st = new StringTokenizer(withoutPrefix, ",");
            this.myStartOffset = Integer.valueOf(st.nextToken());
            this.myEndOffset = Integer.valueOf(st.nextToken());
        }

        @Override
        public String getAsString() {
            return PREFIX + this.myStartOffset + "," + this.myEndOffset;
        }

        @Override
        public String extractFragment(String fileContent) {
            if (this.myStartOffset < 0 || this.myStartOffset > fileContent.length()) {
                this.myStartOffset = 0;
            }
            if (this.myEndOffset <= 0 || this.myEndOffset > fileContent.length()) {
                this.myEndOffset = fileContent.length();
            }
            return fileContent.substring(this.myStartOffset, this.myEndOffset);
        }
    }

    public static class NormalizedLineEndOffset
    extends FragmentOffset {
        private int myStartOffset;
        private int myEndOffset;
        public static final String PREFIX = "normalizedLE:";

        public NormalizedLineEndOffset(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public NormalizedLineEndOffset(String serialized) {
            String withoutPrefix = serialized.substring(PREFIX.length());
            StringTokenizer st = new StringTokenizer(withoutPrefix, ",");
            this.myStartOffset = Integer.valueOf(st.nextToken());
            this.myEndOffset = Integer.valueOf(st.nextToken());
        }

        @Override
        public String getAsString() {
            return PREFIX + this.myStartOffset + "," + this.myEndOffset;
        }

        @Override
        public String extractFragment(String fileContent) {
            String normalizedContent = StringUtil.convertLineSeparators((String)fileContent);
            if (this.myStartOffset < 0 || this.myStartOffset > normalizedContent.length()) {
                this.myStartOffset = 0;
            }
            if (this.myEndOffset <= 0 || this.myEndOffset > normalizedContent.length()) {
                this.myEndOffset = normalizedContent.length();
            }
            return normalizedContent.substring(this.myStartOffset, this.myEndOffset);
        }
    }

    public static abstract class FragmentOffset {
        public abstract String getAsString();

        public abstract String extractFragment(String var1);

        public static FragmentOffset createFromString(String serialized) {
            if (serialized.startsWith("normalizedLE:")) {
                return new NormalizedLineEndOffset(serialized);
            }
            if (serialized.startsWith("char:")) {
                return new CharOffset(serialized);
            }
            if (serialized.startsWith("line:")) {
                return new LineOffset(serialized);
            }
            throw new IllegalArgumentException("Unknown fragment offset format: " + serialized);
        }

        public String toString() {
            return this.getAsString();
        }
    }

    public static class MetricsWithFiles {
        private final DuplicateMetrics myMetrics;
        private String[] myFiles;

        public MetricsWithFiles(DuplicateMetrics metrics, String file) {
            this.myMetrics = metrics;
            this.myFiles = new String[]{file};
        }

        public DuplicateMetrics getMetrics() {
            return this.myMetrics;
        }

        public String[] getFiles() {
            return this.myFiles;
        }

        public void addFile(String file) {
            if (ArrayUtil.find((Object[])this.myFiles, (Object)file) == -1) {
                this.myFiles = MetricsWithFiles.doAddFile(this.myFiles, file);
            }
        }

        @NotNull
        private static String[] doAddFile(@NotNull String[] files, String file) {
            if (files == null) {
                MetricsWithFiles.$$$reportNull$$$0(0);
            }
            String[] newFiles = new String[files.length + 1];
            System.arraycopy(files, 0, newFiles, 0, files.length);
            newFiles[files.length] = file;
            if (newFiles == null) {
                MetricsWithFiles.$$$reportNull$$$0(1);
            }
            return newFiles;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricsWithFiles that = (MetricsWithFiles)o;
            return !(this.myMetrics == null ? that.myMetrics != null : !this.myMetrics.equals(that.myMetrics));
        }

        public int hashCode() {
            return this.myMetrics != null ? this.myMetrics.hashCode() : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/duplicator/DuplicateInfo$MetricsWithFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/duplicator/DuplicateInfo$MetricsWithFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doAddFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doAddFile";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Fragment {
        private final int myHash;
        private final int myStartLine;
        private final String myFile;
        private final String myOffset;

        public Fragment(int hash, @NotNull String file, int startLine, @NotNull FragmentOffset offset) {
            if (file == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            if (offset == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            this.myHash = hash;
            this.myFile = file;
            this.myStartLine = startLine;
            this.myOffset = offset.getAsString();
        }

        public int getHash() {
            return this.myHash;
        }

        @NotNull
        public String getFile() {
            String string = this.myFile;
            if (string == null) {
                Fragment.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int getStartLine() {
            return this.myStartLine;
        }

        @NotNull
        public String getOffsetInfo() {
            String string = this.myOffset;
            if (string == null) {
                Fragment.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fragment fragment = (Fragment)o;
            if (this.myHash != fragment.myHash) {
                return false;
            }
            if (!this.myFile.equals(fragment.myFile)) {
                return false;
            }
            return this.myOffset.equals(fragment.myOffset);
        }

        public int hashCode() {
            int result = this.myHash;
            result = 31 * result + this.myFile.hashCode();
            result = 31 * result + this.myOffset.hashCode();
            return result;
        }

        public String toString() {
            return "Fragment{myFile='" + this.myFile + '\'' + ", myStartLine=" + this.myStartLine + ", myOffset='" + this.myOffset + '\'' + ", myHash=" + this.myHash + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "offset";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/duplicator/DuplicateInfo$Fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/duplicator/DuplicateInfo$Fragment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOffsetInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DuplicateMetrics {
        private final int myHash;
        private final int myCost;
        private int myDensity = 1;

        public DuplicateMetrics(int hash, int cost) {
            this.myHash = hash;
            this.myCost = cost;
        }

        public DuplicateMetrics(int hash, int cost, int density) {
            this(hash, cost);
            this.myDensity = density;
        }

        public int getHash() {
            return this.myHash;
        }

        public int getCost() {
            return this.myCost;
        }

        public int getDensity() {
            return this.myDensity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DuplicateMetrics that = (DuplicateMetrics)o;
            if (this.myCost != that.myCost) {
                return false;
            }
            return this.myHash == that.myHash;
        }

        public int hashCode() {
            int result = this.myHash;
            result = 31 * result + this.myCost;
            return result;
        }

        public void incDensity() {
            ++this.myDensity;
        }
    }
}

