/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.http;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import jetbrains.buildServer.http.HttpUserAgent;
import jetbrains.buildServer.http.SimpleCredentials;
import jetbrains.buildServer.http.UserSecureProtocolSocketFactory;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.ssl.SSLContextUtil;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpUtil {
    private static final Logger LOG = Logger.getInstance((String)HttpUtil.class.getName());
    private static final String HTTP_CLIENT_OPTION_PREFIX = "teamcity.httpClient.connection.";
    private static final String[] HTTP_CLIENT_OPTIONS_INT_LIST = new String[]{"http.socket.timeout", "http.socket.sendbuffer", "http.socket.receivebuffer", "http.socket.linger", "http.connection.timeout"};
    private static final String[] HTTP_CLIENT_OPTIONS_BOOLEAN_LIST = new String[]{"http.tcp.nodelay", "http.connection.stalecheck"};

    @NotNull
    public static HttpClient createHttpClient(int connectionTimeoutSeconds, @Nullable URL url, @Nullable Credentials credentials) {
        HttpClient httpClient = HttpUtil.createHttpClient(connectionTimeoutSeconds, url, credentials, true);
        if (httpClient == null) {
            HttpUtil.$$$reportNull$$$0(0);
        }
        return httpClient;
    }

    @NotNull
    public static HttpClient createHttpClient(int connectionTimeoutSeconds, @Nullable URL url, @Nullable Credentials credentials, boolean isBasicAuth) {
        HttpClient client = HttpUtil.createHttpClient(connectionTimeoutSeconds);
        if (url != null && credentials != null) {
            if (isBasicAuth) {
                client.getParams().setAuthenticationPreemptive(true);
            }
            HttpState state = new HttpState();
            state.setCredentials(new AuthScope(url.getHost(), url.getPort()), credentials);
            client.setState(state);
        }
        HttpClient httpClient = client;
        if (httpClient == null) {
            HttpUtil.$$$reportNull$$$0(1);
        }
        return httpClient;
    }

    @NotNull
    public static HttpClient createHttpClient(int connectionTimeoutSeconds) {
        HttpClient client = new HttpClient();
        client.getParams().setVersion(HttpVersion.HTTP_1_1);
        client.getParams().setParameter("http.useragent", (Object)HttpUserAgent.getUserAgent());
        int timeoutMillis = 1000 * connectionTimeoutSeconds;
        HttpClientParams params = client.getParams();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(timeoutMillis);
        params.setConnectionManagerTimeout((long)timeoutMillis);
        params.setSoTimeout(timeoutMillis);
        HttpUtil.patchHttpConnectionParameters(client.getHttpConnectionManager().getParams());
        HttpClient httpClient = client;
        if (httpClient == null) {
            HttpUtil.$$$reportNull$$$0(2);
        }
        return httpClient;
    }

    @NotNull
    public static HttpConnectionManager createMultiThreadedHttpConnectionManager(int connectionTimeoutSeconds) {
        MultiThreadedHttpConnectionManager threadSafeConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setConnectionTimeout(1000 * connectionTimeoutSeconds);
        params.setSoTimeout(1000 * connectionTimeoutSeconds);
        params.setStaleCheckingEnabled(true);
        threadSafeConnectionManager.setParams(params);
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = threadSafeConnectionManager;
        if (multiThreadedHttpConnectionManager == null) {
            HttpUtil.$$$reportNull$$$0(3);
        }
        return multiThreadedHttpConnectionManager;
    }

    public static PostMethod postMethod(@NotNull HttpClient client, @NotNull String url, @Nullable KeyStore trustStore) throws MalformedURLException {
        if (client == null) {
            HttpUtil.$$$reportNull$$$0(4);
        }
        if (url == null) {
            HttpUtil.$$$reportNull$$$0(5);
        }
        return HttpUtil.postMethod(client, url, trustStore, false);
    }

    public static PostMethod postMethod(@NotNull HttpClient client, @NotNull String url, @Nullable KeyStore trustStore, final boolean followRedirects) throws MalformedURLException {
        if (client == null) {
            HttpUtil.$$$reportNull$$$0(6);
        }
        if (url == null) {
            HttpUtil.$$$reportNull$$$0(7);
        }
        URL urlObj = new URL(url);
        if (trustStore == null || !"https".equals(urlObj.getProtocol())) {
            return HttpUserAgent.addHeader(new PostMethod(url));
        }
        UserSecureProtocolSocketFactory factory = new UserSecureProtocolSocketFactory(SSLContextUtil.createUserSSLContext(trustStore));
        Protocol myHttps = new Protocol("https", (SecureProtocolSocketFactory)factory, HttpUtil.getPort(urlObj));
        client.getHostConfiguration().setHost(urlObj.getHost(), HttpUtil.getPort(urlObj), myHttps);
        return HttpUserAgent.addHeader(new PostMethod(urlObj.getPath()){

            public boolean getFollowRedirects() {
                return followRedirects;
            }
        });
    }

    public static GetMethod getMethod(@NotNull HttpClient client, @NotNull String url, @Nullable KeyStore trustStore) throws MalformedURLException {
        if (client == null) {
            HttpUtil.$$$reportNull$$$0(8);
        }
        if (url == null) {
            HttpUtil.$$$reportNull$$$0(9);
        }
        URL urlObj = new URL(url);
        if (trustStore == null || !"https".equals(urlObj.getProtocol())) {
            return HttpUserAgent.addHeader(new GetMethod(url));
        }
        UserSecureProtocolSocketFactory factory = new UserSecureProtocolSocketFactory(SSLContextUtil.createUserSSLContext(trustStore));
        Protocol myHttps = new Protocol("https", (SecureProtocolSocketFactory)factory, HttpUtil.getPort(urlObj));
        client.getHostConfiguration().setHost(urlObj.getHost(), HttpUtil.getPort(urlObj), myHttps);
        return HttpUserAgent.addHeader(new GetMethod(urlObj.getPath()));
    }

    private static int getPort(URL url) {
        int origin = url.getPort();
        if (origin != -1) {
            return origin;
        }
        if ("https".equals(url.getProtocol())) {
            return 443;
        }
        return 80;
    }

    public static void configureProxy(@NotNull HttpClient client, @NotNull String proxyHost, int proxyPort, @Nullable SimpleCredentials proxyCredentials) {
        if (client == null) {
            HttpUtil.$$$reportNull$$$0(10);
        }
        if (proxyHost == null) {
            HttpUtil.$$$reportNull$$$0(11);
        }
        client.getHostConfiguration().setProxy(proxyHost, proxyPort);
        if (proxyCredentials != null) {
            client.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyCredentials.getUsername(), proxyCredentials.getPassword()));
            client.getParams().setAuthenticationPreemptive(true);
        }
    }

    public static String composeHttpErrorMessage(StatusLine status, String errorMessagePrefix) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(errorMessagePrefix).append(" Server status: ").append(status.getStatusCode());
        if (status.getReasonPhrase() != null && status.getReasonPhrase().length() > 0) {
            logMessage.append(" (").append(status.getReasonPhrase()).append(")");
        }
        return logMessage.toString();
    }

    public static void patchHttpConnectionParameters(@NotNull HttpConnectionManagerParams parametersToPatch) {
        if (parametersToPatch == null) {
            HttpUtil.$$$reportNull$$$0(12);
        }
        try {
            if (TeamCityProperties.getBooleanOrTrue("teamcity.httpClient.connection.patch")) {
                Object defaultValue;
                String optionValue;
                String ourName;
                if (SystemInfo.isWindows) {
                    parametersToPatch.setSendBufferSize(64000);
                    parametersToPatch.setReceiveBufferSize(64000);
                }
                for (String httpOption : HTTP_CLIENT_OPTIONS_INT_LIST) {
                    ourName = HTTP_CLIENT_OPTION_PREFIX + httpOption;
                    optionValue = TeamCityProperties.getProperty(ourName);
                    if (StringUtil.isEmpty((String)optionValue)) continue;
                    defaultValue = parametersToPatch.getParameter(httpOption);
                    try {
                        parametersToPatch.setIntParameter(httpOption, Integer.parseInt(optionValue));
                        LOG.debug("Overriding default HttpClient param " + httpOption + " value '" + defaultValue + "' with '" + optionValue + "' as defined via " + ourName + " configuration parameter");
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("Non-numeric or not 'int' value for " + ourName + " is specified: '" + optionValue + "'");
                    }
                }
                for (String httpOption : HTTP_CLIENT_OPTIONS_BOOLEAN_LIST) {
                    ourName = HTTP_CLIENT_OPTION_PREFIX + httpOption;
                    optionValue = TeamCityProperties.getProperty(ourName);
                    if (StringUtil.isEmpty((String)optionValue)) continue;
                    defaultValue = parametersToPatch.getParameter(httpOption);
                    parametersToPatch.setBooleanParameter(httpOption, Boolean.parseBoolean(optionValue));
                    LOG.debug("Overriding default HttpClient param " + httpOption + " value '" + defaultValue + "' with '" + optionValue + "' as defined via " + ourName + " configuration parameter");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error while processing HttpClient param overrides: " + e.toString(), (Throwable)e);
        }
    }

    @Nullable
    public static String getRedirectUrl(OptionsMethod method) {
        Header[] locationHeaders;
        int statusCode = method.getStatusCode();
        if (statusCode > 300 && statusCode < 400 && (locationHeaders = method.getResponseHeaders("Location")) != null && locationHeaders.length > 0) {
            return locationHeaders[0].getValue();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/http/HttpUtil";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyHost";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersToPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createHttpClient";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultiThreadedHttpConnectionManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/http/HttpUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "postMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "configureProxy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "patchHttpConnectionParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

