/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import jetbrains.buildServer.http.HttpUserAgent;
import jetbrains.buildServer.http.HttpUtil;
import jetbrains.buildServer.http.SimpleCredentials;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.util.Interruptable;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jetbrains.annotations.NotNull;

public class ServerStreamProvider
implements Interruptable {
    protected volatile HttpMethodBase myMethod;
    private final String myUri;
    private String myUserId;
    private String myPassword;
    private int myConnectionTimeout = 0;
    private boolean myUseProxy = false;
    private String myProxyHost = null;
    private int myProxyPort = -1;
    private SimpleCredentials myProxyCredentials;
    private volatile boolean myInterrupted = false;

    public ServerStreamProvider(String uri) {
        this.myUri = uri;
    }

    public void setCredentials(String userId, String password) {
        this.myUserId = userId;
        this.myPassword = password;
    }

    public void setProxySettings(boolean useProxy, String proxyHost, int proxyPort) {
        this.myUseProxy = useProxy;
        this.myProxyHost = proxyHost;
        this.myProxyPort = proxyPort;
    }

    public void setProxyCredentials(@NotNull SimpleCredentials credentials) {
        if (credentials == null) {
            ServerStreamProvider.$$$reportNull$$$0(0);
        }
        this.myProxyCredentials = credentials;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.myConnectionTimeout = connectionTimeout;
    }

    public void abort() {
        if (this.myMethod != null) {
            this.myMethod.abort();
            this.myMethod = null;
        }
    }

    public void dispose() {
        if (this.myMethod != null) {
            this.myMethod.releaseConnection();
            this.myMethod = null;
        }
    }

    public InputStream getStream() throws IOException {
        return this.getStream(null);
    }

    public InputStream getStream(String postData) throws IOException {
        return this.getStreamWithHeaders(postData).getInput();
    }

    public StreamWithHeaders getStreamWithHeaders() throws IOException {
        return this.getStreamWithHeaders(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamWithHeaders getStreamWithHeaders(String postData) throws IOException {
        UsernamePasswordCredentials cre = null;
        if (this.myUserId != null && this.myPassword != null) {
            cre = new UsernamePasswordCredentials(this.myUserId, this.myPassword);
        }
        HttpClient client = HttpUtil.createHttpClient(this.myConnectionTimeout);
        client.getParams().setAuthenticationPreemptive(true);
        HttpState state = new HttpState();
        state.setCredentials(AuthScope.ANY, (Credentials)cre);
        client.setState(state);
        if (this.myUseProxy) {
            HostConfiguration hostConfiguration = new HostConfiguration();
            hostConfiguration.setHost(this.myUri);
            client.setHostConfiguration(hostConfiguration);
            HttpUtil.configureProxy(client, this.myProxyHost, this.myProxyPort, this.myProxyCredentials);
        }
        String url = this.myUri;
        OptionsMethod opts = new OptionsMethod(this.myUri);
        HttpUserAgent.addHeader(opts);
        opts.setDoAuthentication(true);
        try {
            client.executeMethod((HttpMethod)opts);
            String redirectUrl = HttpUtil.getRedirectUrl(opts);
            if (redirectUrl != null) {
                Loggers.AGENT.info("Create patch request has been redirected to another URL: " + redirectUrl);
                url = redirectUrl;
            }
        }
        finally {
            opts.releaseConnection();
        }
        this.myMethod = postData != null ? new PostMethod(url) : new GetMethod(url);
        HttpUserAgent.addHeader(this.myMethod);
        this.myMethod.addRequestHeader(new Header("Accept-encoding", "gzip"));
        this.myMethod.setDoAuthentication(true);
        try {
            if (postData != null) {
                ((PostMethod)this.myMethod).setRequestEntity((RequestEntity)new StringRequestEntity(postData, null, "utf-8"));
            }
            client.executeMethod((HttpMethod)this.myMethod);
            StatusLine status = this.myMethod.getStatusLine();
            if (status.getStatusCode() != 200) {
                if (this.myMethod.getResponseHeader("Content-Type") != null && "text/plain".equals(this.myMethod.getResponseHeader("Content-Type").getValue())) {
                    throw new IOException("Failed to obtain stream from server: " + this.myMethod.getResponseBodyAsString());
                }
                throw new IOException(HttpUtil.composeHttpErrorMessage(status, "Failed to obtain stream from server."));
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            for (Header header : this.myMethod.getResponseHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
            return new StreamWithHeaders(this.doGetStream(this.myMethod), headers);
        }
        catch (IOException e) {
            this.myMethod.releaseConnection();
            this.myMethod = null;
            throw e;
        }
    }

    private InputStream doGetStream(HttpMethodBase method) throws IOException {
        Header contentTypeHeader = method.getResponseHeader("content-encoding");
        if (contentTypeHeader != null && "gzip".equals(contentTypeHeader.getValue())) {
            return new GZIPInputStream(this.wrapStream(method.getResponseBodyAsStream()));
        }
        return this.wrapStream(method.getResponseBodyAsStream());
    }

    private InputStream wrapStream(final @NotNull InputStream original) {
        if (original == null) {
            ServerStreamProvider.$$$reportNull$$$0(1);
        }
        return new InputStream(){

            @Override
            public int read() throws IOException {
                ServerStreamProvider.this.checkInterrupted();
                return original.read();
            }
        };
    }

    @Override
    public void interrupt() {
        this.myInterrupted = true;
        this.abort();
    }

    private void checkInterrupted() throws IOException {
        if (this.myInterrupted) {
            this.dispose();
            throw new InterruptedIOException("Operation interrupted");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/http/ServerStreamProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setProxyCredentials";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapStream";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class StreamWithHeaders {
        private final InputStream input;
        private final Map<String, String> headers;

        public StreamWithHeaders(InputStream input, Map<String, String> headers) {
            this.input = input;
            this.headers = headers;
        }

        public InputStream getInput() {
            return this.input;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

