/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.log;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class LogInitializationException
extends Exception {
    @NotNull
    private final List<File> checkedDirs;

    LogInitializationException(@NotNull List<File> checkedDirs) {
        if (checkedDirs == null) {
            LogInitializationException.$$$reportNull$$$0(0);
        }
        super("Unable to initialize logs. The logs directories are not accessible for writing.");
        this.checkedDirs = Collections.unmodifiableList(new ArrayList<File>(checkedDirs));
    }

    public LogInitializationException(@NotNull String message, @NotNull File logsDirectory) {
        if (message == null) {
            LogInitializationException.$$$reportNull$$$0(1);
        }
        if (logsDirectory == null) {
            LogInitializationException.$$$reportNull$$$0(2);
        }
        super("Unable to initialize logs. The log directory is not accessible for writing. Details: " + message);
        this.checkedDirs = Collections.singletonList(logsDirectory);
    }

    LogInitializationException(@NotNull LogInitializationException lie) {
        if (lie == null) {
            LogInitializationException.$$$reportNull$$$0(3);
        }
        super(lie.getMessage(), lie);
        this.checkedDirs = lie.checkedDirs;
    }

    @NotNull
    public List<File> getCheckedDirs() {
        List<File> list = this.checkedDirs;
        if (list == null) {
            LogInitializationException.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getMessage()).append('\n');
        b.append("Checked directories: ");
        for (File dir : this.checkedDirs) {
            b.append(dir.getAbsolutePath()).append(", ");
        }
        if (!this.checkedDirs.isEmpty()) {
            b.delete(b.length() - 2, b.length());
        }
        b.append('.');
        return b.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedDirs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logsDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lie";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/log/LogInitializationException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/log/LogInitializationException";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckedDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

