/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import jetbrains.buildServer.configuration.ChangeListener;
import jetbrains.buildServer.configuration.FileWatcher;
import jetbrains.buildServer.log.LogInitializationException;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.FileUtil;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogInitializer {
    private static boolean ourInitialized;
    private static com.intellij.openapi.diagnostic.Logger ourOwnLogger;
    @NonNls
    public static final String LOG4J_CONFIGURATION = "log4j.configuration";
    @NonNls
    public static final String TEAMCITY_LOGS_DIR_PROP = "teamcity_logs";
    @NonNls
    private static final String DEFAULT_LOGS_DIR_PATH = "../logs/";
    @NonNls
    public static final String TEAMCITY_SERVER_LOG4J_XML = "teamcity-server-log4j.xml";
    @NonNls
    public static final String TEAMCITY_AGENT_LOG4J_XML = "teamcity-agent-log4j.xml";
    public static final String MAIN_CATEGORY = "jetbrains.buildServer";
    private static final String MAIN_FILE_NAME = "teamcity-server.log";
    @Nullable
    private static File ourLogDir;
    @Nullable
    private static LogInitializationException ourInitializationException;
    private static volatile FileWatcher ourWatcher;

    public static void initServerLogging() {
        File confFile;
        if (ourInitialized) {
            return;
        }
        com.intellij.openapi.diagnostic.Logger logger = ourOwnLogger = TeamCityProperties.getBoolean("teamcity.startup.suppressLoggingBeforeLogInitialization") ? null : Loggers.STARTUP;
        if (TeamCityProperties.getBooleanOrTrue("teamcity.startup.updateLog4JConfig") && (confFile = LogInitializer.getLog4jConfigFile().myFile) != null && TEAMCITY_SERVER_LOG4J_XML.equals(confFile.getName())) {
            LogInitializer.copyResourceWithDistIgnoreErrors(Thread.currentThread().getContextClassLoader(), TEAMCITY_SERVER_LOG4J_XML, confFile);
        }
        LogConfigurator logConfigurator = LogInitializer.propertyConfigurator(true);
        LogConfigurator resourceConfigurator = LogInitializer.resourceConfigurator(TEAMCITY_SERVER_LOG4J_XML);
        LogInitializer.init(logConfigurator, resourceConfigurator);
        ourInitialized = true;
        Loggers.STARTUP.info("\n\n\n\n\n\n");
        Loggers.STARTUP.info("===========================================================");
        Loggers.STARTUP.info("Starting TeamCity server");
    }

    public static void shutdown() {
        if (ourWatcher != null) {
            ourWatcher.stop();
        }
    }

    public static void initAgentLogging() {
        File confFile;
        if (ourInitialized) {
            return;
        }
        ourOwnLogger = null;
        if (TeamCityProperties.getBooleanOrTrue("teamcity.startup.updateLog4JConfig") && (confFile = LogInitializer.getLog4jConfigFile().myFile) != null && TEAMCITY_AGENT_LOG4J_XML.equals(confFile.getName())) {
            LogInitializer.copyResourceWithDistIgnoreErrors(Thread.currentThread().getContextClassLoader(), TEAMCITY_AGENT_LOG4J_XML, confFile);
        }
        LogInitializer.init(LogInitializer.propertyConfigurator(true), LogInitializer.resourceConfigurator(TEAMCITY_AGENT_LOG4J_XML));
        ourInitialized = true;
        Loggers.SERVER.info("Starting TeamCity agent");
    }

    public static void init(LogConfigurator ... configurators) {
        if (configurators == null) {
            LogInitializer.$$$reportNull$$$0(0);
        }
        try {
            LogInitializer.initLogDir();
            for (LogConfigurator conf : configurators) {
                if (!conf.configure()) continue;
                return;
            }
        }
        catch (LogInitializationException lie) {
            LogInitializer.reportError("Could not initialize logging directory. Logging into the standard console output.");
            LogInitializer.removeAllAppenders();
            LogInitializer.addConsoleAppender();
        }
    }

    private static void copyResourceWithDistIgnoreErrors(ClassLoader classLoader, @NotNull String resourceName, @NotNull File outputFile) {
        if (resourceName == null) {
            LogInitializer.$$$reportNull$$$0(1);
        }
        if (outputFile == null) {
            LogInitializer.$$$reportNull$$$0(2);
        }
        try {
            File distFile = new File(outputFile.getParent(), outputFile.getName() + ".dist");
            if (!outputFile.exists() || FileUtils.contentEquals((File)outputFile, (File)distFile)) {
                LogInitializer.copyResourceIgnoreErrors(classLoader, resourceName, outputFile);
            }
            LogInitializer.copyResourceIgnoreErrors(classLoader, resourceName, distFile);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void copyResourceIgnoreErrors(ClassLoader classLoader, @NotNull String resourceName, @NotNull File outputFile) {
        if (resourceName == null) {
            LogInitializer.$$$reportNull$$$0(3);
        }
        if (outputFile == null) {
            LogInitializer.$$$reportNull$$$0(4);
        }
        try {
            InputStream asStream = classLoader.getResourceAsStream(resourceName);
            if (asStream != null) {
                FileUtil.writeViaTmpFile(outputFile, asStream, FileUtil.IOAction.DO_NOTHING);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static LogConfigurator fileConfigurator(final @NotNull File file, final boolean watchForChanges) {
        if (file == null) {
            LogInitializer.$$$reportNull$$$0(5);
        }
        return new LogConfigurator(){

            @Override
            public boolean configure() {
                if (!file.isFile()) {
                    return false;
                }
                LogInitializer.configureFromFile(file, watchForChanges);
                return true;
            }
        };
    }

    public static void reconfigureFromFile(@NotNull File configFile, @NotNull File logDir, boolean trackChanges) {
        File resolvedConfigFile;
        if (configFile == null) {
            LogInitializer.$$$reportNull$$$0(6);
        }
        if (logDir == null) {
            LogInitializer.$$$reportNull$$$0(7);
        }
        if (!(resolvedConfigFile = LogInitializer.resolvePathSafely(configFile)).isFile()) {
            throw new IllegalArgumentException("Logging configuration file \"" + resolvedConfigFile + "\" not found");
        }
        File resolvedLogDir = LogInitializer.resolvePathSafely(configFile);
        resolvedLogDir.mkdirs();
        try {
            LogInitializer.checkDirectoryIsWritable(resolvedConfigFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Logging directory \"" + resolvedLogDir + "\" is not writable: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Logging directory \"" + resolvedLogDir + "\" is not writable: " + e.getMessage());
        }
        LogInitializer.removeAllAppenders();
        LogManager.resetConfiguration();
        LogInitializer.setupLogsDirectoryProperty(resolvedLogDir);
        LogInitializer.configureFromFile(resolvedConfigFile, trackChanges);
    }

    private static void configureFromFile(final @NotNull File file, boolean trackChanges) {
        if (file == null) {
            LogInitializer.$$$reportNull$$$0(8);
        }
        if (trackChanges) {
            new DOMConfigurator().doConfigure(file.getAbsolutePath(), LogManager.getLoggerRepository());
            int secs = 10;
            ourWatcher = new FileWatcher(file);
            ourWatcher.setSleepingPeriod(10000L);
            ourWatcher.registerListener(new ChangeListener(){

                @Override
                public void changeOccured(String requestor) {
                    new DOMConfigurator().doConfigure(file.getAbsolutePath(), LogManager.getLoggerRepository());
                }
            });
            ourWatcher.start();
            System.out.println("Log4J configuration file " + file.getAbsolutePath() + " will be monitored with interval " + 10 + " seconds.");
        } else {
            DOMConfigurator.configure((String)file.getAbsolutePath());
        }
    }

    public static LogConfigurator resourceConfigurator(final String ... resources) {
        if (resources == null) {
            LogInitializer.$$$reportNull$$$0(9);
        }
        return new LogConfigurator(){

            @Override
            public boolean configure() {
                boolean configured = false;
                for (String res : resources) {
                    URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(res);
                    if (resourceUrl == null) continue;
                    DOMConfigurator.configure((URL)resourceUrl);
                    configured = true;
                }
                return configured;
            }
        };
    }

    @NotNull
    private static ConfFileSearchResult getLog4jConfigFile() {
        ConfFileSearchResult confFileSearchResult;
        block13: {
            File file;
            block11: {
                ConfFileSearchResult confFileSearchResult2;
                block12: {
                    String log4jUrl;
                    block9: {
                        ConfFileSearchResult confFileSearchResult3;
                        block10: {
                            log4jUrl = TeamCityProperties.getPropertyOrNull(LOG4J_CONFIGURATION);
                            if (log4jUrl == null) {
                                ConfFileSearchResult confFileSearchResult4 = new ConfFileSearchResult(null, false);
                                if (confFileSearchResult4 == null) {
                                    LogInitializer.$$$reportNull$$$0(10);
                                }
                                return confFileSearchResult4;
                            }
                            try {
                                URL url = new URL(log4jUrl);
                                file = new File(url.getPath());
                                if (file.isFile()) break block9;
                                confFileSearchResult3 = new ConfFileSearchResult("Specified log4j configuration file (" + log4jUrl + ") not found.", true);
                                if (confFileSearchResult3 != null) break block10;
                            }
                            catch (MalformedURLException e) {
                                file = new File(log4jUrl);
                                if (file.isFile()) {
                                    ConfFileSearchResult confFileSearchResult5 = new ConfFileSearchResult(file);
                                    if (confFileSearchResult5 == null) {
                                        LogInitializer.$$$reportNull$$$0(14);
                                    }
                                    return confFileSearchResult5;
                                }
                                ConfFileSearchResult confFileSearchResult6 = new ConfFileSearchResult("Specified log4j configuration file (" + log4jUrl + ") not found.", false);
                                if (confFileSearchResult6 == null) {
                                    LogInitializer.$$$reportNull$$$0(15);
                                }
                                return confFileSearchResult6;
                            }
                            LogInitializer.$$$reportNull$$$0(11);
                        }
                        return confFileSearchResult3;
                    }
                    if (LogInitializer.checkTeamCityLog4jConfig(file)) break block11;
                    confFileSearchResult2 = new ConfFileSearchResult("Specified log4j configuration file (" + log4jUrl + ") does not have TeamCity categories, file skipped.", false);
                    if (confFileSearchResult2 != null) break block12;
                    LogInitializer.$$$reportNull$$$0(12);
                }
                return confFileSearchResult2;
            }
            confFileSearchResult = new ConfFileSearchResult(file);
            if (confFileSearchResult != null) break block13;
            LogInitializer.$$$reportNull$$$0(13);
        }
        return confFileSearchResult;
    }

    public static LogConfigurator propertyConfigurator(final boolean watchForFileChanges) {
        return new LogConfigurator(){

            @Override
            public boolean configure() {
                ConfFileSearchResult fileSearchResult = LogInitializer.getLog4jConfigFile();
                if (fileSearchResult.myNeedReset) {
                    System.setProperty(LogInitializer.LOG4J_CONFIGURATION, "");
                }
                if (fileSearchResult.myErrorMessage != null) {
                    LogInitializer.reportError(fileSearchResult.myErrorMessage);
                }
                if (fileSearchResult.myFile == null) {
                    return false;
                }
                return LogInitializer.fileConfigurator(fileSearchResult.myFile, watchForFileChanges).configure();
            }
        };
    }

    private static boolean checkTeamCityLog4jConfig(File file) {
        try {
            String configTxt = new String(LogInitializer.loadTextFile(file));
            return configTxt.indexOf(MAIN_CATEGORY) != -1;
        }
        catch (IOException e) {
            LogInitializer.reportError("Failed to load log4j configuration file: " + file + ", error: " + e.toString());
            return false;
        }
    }

    private static char[] loadTextFile(@NotNull File file) throws IOException {
        if (file == null) {
            LogInitializer.$$$reportNull$$$0(16);
        }
        return FileUtil.loadFileText((File)file);
    }

    private static void reportError(@NotNull String text) {
        if (text == null) {
            LogInitializer.$$$reportNull$$$0(17);
        }
        System.err.println(text);
        if (ourOwnLogger != null) {
            try {
                ourOwnLogger.error(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void reportInfo(@NotNull String text) {
        if (text == null) {
            LogInitializer.$$$reportNull$$$0(18);
        }
        System.out.println(text);
        if (ourOwnLogger != null) {
            try {
                Loggers.SERVER.info(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void setupLogsDirectoryProperty(@NotNull File logsDirectory) {
        String logPath;
        if (logsDirectory == null) {
            LogInitializer.$$$reportNull$$$0(19);
        }
        if (ourLogDir == null || !ourLogDir.equals(logsDirectory)) {
            ourLogDir = logsDirectory;
            LogInitializer.reportInfo("Using logs directory \"" + logsDirectory.getAbsolutePath() + "\"");
        }
        if (!(logPath = ourLogDir.getAbsolutePath()).endsWith(File.separator)) {
            logPath = logPath + File.separator;
        }
        System.setProperty(TEAMCITY_LOGS_DIR_PROP, logPath);
    }

    @NotNull
    public static File getLogDir() throws LogInitializationException {
        if (ourLogDir == null) {
            if (ourInitializationException == null) {
                LogInitializer.initLogDir();
            } else {
                throw new LogInitializationException(ourInitializationException);
            }
        }
        assert (ourLogDir != null);
        File file = ourLogDir;
        if (file == null) {
            LogInitializer.$$$reportNull$$$0(20);
        }
        return file;
    }

    private static void initLogDir() throws LogInitializationException {
        String logsProperty = TeamCityProperties.getProperty(TEAMCITY_LOGS_DIR_PROP, DEFAULT_LOGS_DIR_PATH);
        File logsDirectory = LogInitializer.resolvePathSafely(new File(logsProperty));
        try {
            LogInitializer.tryToUseLogsDirectory(logsDirectory, "logs directory");
        }
        catch (LogInitializationException e) {
            ourInitializationException = e;
            throw ourInitializationException;
        }
        LogInitializer.setupLogsDirectoryProperty(logsDirectory);
    }

    @NotNull
    private static File resolvePathSafely(@NotNull File file) {
        File file2;
        if (file == null) {
            LogInitializer.$$$reportNull$$$0(21);
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            File file3 = file;
            if (file3 == null) {
                LogInitializer.$$$reportNull$$$0(23);
            }
            return file3;
        }
        if (file2 == null) {
            LogInitializer.$$$reportNull$$$0(22);
        }
        return file2;
    }

    private static void tryToUseLogsDirectory(File logsDirectory, String dirDescriptionInfix) throws LogInitializationException {
        logsDirectory.mkdirs();
        if (!logsDirectory.isDirectory()) {
            String message = "Failed to create the " + dirDescriptionInfix + " '" + LogInitializer.getCanonicalFile(logsDirectory) + "'";
            LogInitializer.reportError(message);
            throw new LogInitializationException(message, logsDirectory);
        }
        try {
            LogInitializer.checkDirectoryIsWritable(logsDirectory);
        }
        catch (IOException e) {
            String message = "The " + dirDescriptionInfix + " '" + LogInitializer.getCanonicalFile(logsDirectory) + "' is not writable: " + e.getMessage();
            LogInitializer.reportError(message);
            throw new LogInitializationException(message, logsDirectory);
        }
        catch (SecurityException e) {
            String message = "The " + dirDescriptionInfix + " '" + LogInitializer.getCanonicalFile(logsDirectory) + "' is not writable: " + e.getMessage();
            LogInitializer.reportError(message);
            throw new LogInitializationException(message, logsDirectory);
        }
        File serverLogFile = new File(logsDirectory, MAIN_FILE_NAME);
        if (serverLogFile.exists() && !serverLogFile.canWrite()) {
            String message = "The file '" + LogInitializer.getCanonicalFile(serverLogFile) + "' is not writable: Cannot open '" + serverLogFile.getAbsolutePath() + "' for writing";
            LogInitializer.reportError(message);
            throw new LogInitializationException(message, logsDirectory);
        }
    }

    private static File getCanonicalFile(File logsDirectory) {
        try {
            return logsDirectory.getCanonicalFile();
        }
        catch (Throwable e) {
            return logsDirectory.getAbsoluteFile();
        }
    }

    private static void checkDirectoryIsWritable(File dir) throws IOException {
        boolean deleted;
        File testFile = new File(dir, "testfile_" + System.currentTimeMillis() + ".txt");
        if (testFile.exists() && !(deleted = testFile.delete()) && testFile.exists()) {
            throw new IOException("Cannot delete file '" + testFile.getAbsolutePath() + "'");
        }
        LogInitializer.writeFileAndReportErrorSafe(testFile, "This file was created just to ensure that the directory is writable.\nNo problem to delete this file.\n");
        if (!testFile.exists() || !testFile.isFile()) {
            throw new IOException("Error creating file '" + testFile.getAbsolutePath() + "'");
        }
        if (!testFile.delete()) {
            throw new IOException("Cannot delete file '" + testFile.getAbsolutePath() + "'");
        }
    }

    private static void writeFileAndReportErrorSafe(@NotNull File testFile, @NotNull String text) throws IOException {
        if (testFile == null) {
            LogInitializer.$$$reportNull$$$0(24);
        }
        if (text == null) {
            LogInitializer.$$$reportNull$$$0(25);
        }
        try (FileWriter fileWriter = new FileWriter(testFile);){
            fileWriter.write(text);
        }
    }

    public static boolean isUnitTest() {
        return "yes".equals(System.getProperty("jetbrains.unit.test"));
    }

    public static void setUnitTest(boolean enable) {
        if (enable) {
            System.setProperty("jetbrains.unit.test", "yes");
            LogInitializer.resourceConfigurator("teamcity-tests-log4j.xml").configure();
            ourInitialized = true;
            ourOwnLogger = null;
        } else {
            System.setProperty("jetbrains.unit.test", "no");
        }
    }

    public static void addConsoleAppender() {
        for (Logger logger : LogInitializer.debugLoggers()) {
            logger.addAppender((Appender)LogInitializer.createConsoleAppender());
        }
        Logger.getLogger((String)"jetbrains.buildServer.buildTriggers.vcs").setAdditivity(false);
    }

    public static void removeAllAppenders() {
        for (Logger logger : LogInitializer.debugLoggers()) {
            logger.removeAllAppenders();
        }
    }

    private static Logger[] debugLoggers() {
        return new Logger[]{Logger.getRootLogger(), Logger.getLogger((String)"jetbrains.buildServer.buildTriggers.vcs"), Logger.getLogger((String)"jetbrains.buildServer.VCS")};
    }

    public static ConsoleAppender createConsoleAppender() {
        return new ConsoleAppender((Layout)new PatternLayout("[%d{ABSOLUTE}] %6p - %20.20c [%t] %m \n"));
    }

    @Deprecated
    public static void enableDebug() {
        Logger.getLogger((String)MAIN_CATEGORY).setLevel(Level.DEBUG);
        Loggers.VCS.setLevel(Level.DEBUG);
    }

    @Deprecated
    public static void disableDebug() {
        Logger.getLogger((String)MAIN_CATEGORY).setLevel(Level.INFO);
        Loggers.VCS.setLevel(Level.INFO);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurators";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 5: 
            case 8: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/log/LogInitializer";
                break;
            }
            case 17: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logsDirectory";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/log/LogInitializer";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog4jConfigFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDir";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePathSafely";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyResourceWithDistIgnoreErrors";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyResourceIgnoreErrors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileConfigurator";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reconfigureFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureFromFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resourceConfigurator";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadTextFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportInfo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupLogsDirectoryProperty";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolvePathSafely";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeFileAndReportErrorSafe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConfFileSearchResult {
        @Nullable
        final File myFile;
        @Nullable
        final String myErrorMessage;
        final boolean myNeedReset;

        public ConfFileSearchResult(@Nullable File file) {
            this.myFile = file;
            this.myErrorMessage = null;
            this.myNeedReset = false;
        }

        public ConfFileSearchResult(@Nullable String errorMessage, boolean needReset) {
            this.myFile = null;
            this.myErrorMessage = errorMessage;
            this.myNeedReset = needReset;
        }
    }

    public static interface LogConfigurator {
        public boolean configure();
    }
}

