/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.log;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import jetbrains.buildServer.log.Loggable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogUtil {
    private static final String NULL_OBJECT = "<null>";

    @NotNull
    public static String quote(@Nullable String text) {
        String string = "\"" + (text != null ? text : NULL_OBJECT) + "\"";
        if (string == null) {
            LogUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String describe(@Nullable Object o) {
        if (o == null) {
            if (NULL_OBJECT == null) {
                LogUtil.$$$reportNull$$$0(1);
            }
            return NULL_OBJECT;
        }
        if (o instanceof Loggable) {
            String description = ((Loggable)o).describe(false);
            if (description == null) {
                if (NULL_OBJECT == null) {
                    LogUtil.$$$reportNull$$$0(2);
                }
                return NULL_OBJECT;
            }
            String string = description;
            if (string == null) {
                LogUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = o.toString();
        if (string == null) {
            LogUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String describe(@Nullable Date date) {
        if (date == null) {
            if (NULL_OBJECT == null) {
                LogUtil.$$$reportNull$$$0(5);
            }
            return NULL_OBJECT;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
        df.setTimeZone(TimeZone.getDefault());
        String string = df.format(date);
        if (string == null) {
            LogUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static <T> String describe(@Nullable Collection<T> collection, @NotNull String separator, @NotNull String prefix, @NotNull String suffix, int limitItems) {
        if (separator == null) {
            LogUtil.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            LogUtil.$$$reportNull$$$0(8);
        }
        if (suffix == null) {
            LogUtil.$$$reportNull$$$0(9);
        }
        if (collection == null) {
            if (NULL_OBJECT == null) {
                LogUtil.$$$reportNull$$$0(10);
            }
            return NULL_OBJECT;
        }
        StringBuilder result = new StringBuilder();
        Iterator<T> it = collection.iterator();
        int countAdded = 0;
        while (it.hasNext() && countAdded < limitItems) {
            T item = it.next();
            if (item == null) continue;
            if (countAdded > 0) {
                result.append(separator);
            }
            result.append(prefix).append(item.toString()).append(suffix);
            ++countAdded;
        }
        if (it.hasNext()) {
            result.append(" ...(").append(collection.size()).append(" total)");
        }
        String string = result.toString();
        if (string == null) {
            LogUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/log/LogUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "quote";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/log/LogUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "describe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

