/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.BuildProblemData;
import jetbrains.buildServer.messages.BlockData;
import jetbrains.buildServer.messages.BuildMessage1;
import jetbrains.buildServer.messages.ComparisonFailedData;
import jetbrains.buildServer.messages.ErrorData;
import jetbrains.buildServer.messages.FlowData;
import jetbrains.buildServer.messages.IgnoredTestData;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.messages.TestFinishBlockData;
import jetbrains.buildServer.messages.TestMetadata;
import jetbrains.buildServer.messages.TestOutputData;
import jetbrains.buildServer.messages.TestProblemData;
import jetbrains.buildServer.messages.TestStartBlockData;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessagesInfo {
    public static final String MSG_FLOW = "Flow";
    public static final String MSG_FLOW_FINISHED = "FlowFinished";
    public static final String DEFAULT_FLOW_ID = "";
    public static final String TAG_INTERNAL = "tc:internal";
    public static final String TAG_SERVER = "tc:server";
    public static final String TAG_REST = "tc:rest";
    public static final String TAG_AS_IS = "tc:as_is";
    public static final String TAG_MSG_LINK = "tc:msglink";
    public static final String TAG_CHECKOUT_DIR = "tc:checkoutDir";
    public static final String CHECKOUT_DIRECTORY_MSG_PREFIX = "Checkout directory: ";
    public static final String AGENT_TIMEZONE_PREFIX = "Agent time zone: ";
    public static final String SOURCE_ID = "DefaultMessage";
    public static final String MSG_ERROR = "Error";
    public static final String MSG_TEXT = "Text";
    public static final String MSG_BUILD_FAILURE = "BuildFailureDescription";
    public static final String MSG_BLOCK_START = "BlockStart";
    public static final String MSG_BLOCK_END = "BlockEnd";
    public static final String MSG_PREPARATION_END_STAGE = "PreparationEndStage";
    public static final String MSG_PROGRESS_STAGE = "ProgressStage";
    public static final String MSG_TEST_IGNORED = "TestIgnored";
    public static final String MSG_TEST_OUTPUT = "TestOutput";
    public static final String MSG_TEST_FAILURE = "TestFailure";
    public static final String MSG_TEST_METADATA = "TestMetadata";
    public static final String MSG_TEST_RETRY = "TestRetry";
    public static final String MSG_TEST_NAVIGATION_INFO = "TestNavigationInfo";
    public static final String BLOCK_TYPE_BUILD = "Build";
    public static final String BLOCK_TYPE_MODULE = "$MODULE_BLOCK$";
    public static final String BLOCK_TYPE_PROGRESS = "$BUILD_PROGRESS$";
    public static final String BLOCK_TYPE_TEST = "$TEST_BLOCK$";
    public static final String BLOCK_TYPE_TEST_SUITE = "$TEST_SUITE$";
    public static final String BLOCK_TYPE_COMPILATION = "$COMPILATION_BLOCK$";
    public static final String BLOCK_TYPE_TARGET = "$TARGET_BLOCK$";
    public static final String BLOCK_TYPE_CHECKOUT = "checkout";
    public static final String BLOCK_TYPE_ARTIFACTS_RESOLVING = "agentResolvingArtifacts";
    public static final String BLOCK_TYPE_BUILD_STEP = "teamcity-build-step-type";
    public static final String MSG_BUILD_PROBLEM = "BuildProblem";
    public static final Set<String> ALWAYS_LOGGED_BLOCKS = new HashSet<String>(Arrays.asList("$BUILD_PROGRESS$", "$TEST_BLOCK$", "$TEST_SUITE$", "$COMPILATION_BLOCK$", "$TARGET_BLOCK$", "checkout", "agentResolvingArtifacts"));
    private static MessagesTimeService ourTimeService;

    private DefaultMessagesInfo() {
    }

    public static BuildMessage1 createBlockStart(String blockName, String blockType) {
        return DefaultMessagesInfo.createBlockStart(blockName, blockType, DefaultMessagesInfo.now());
    }

    public static BuildMessage1 createBlockStart(String blockName, String blockDescription, String blockType) {
        return DefaultMessagesInfo.createBlockStart(blockName, blockDescription, blockType, DefaultMessagesInfo.now());
    }

    public static void setMessagesTimeService(MessagesTimeService service) {
        ourTimeService = service;
    }

    public static void resetMessagesTimeService() {
        ourTimeService = new MessagesTimeService(){

            public Date getNow() {
                return new Date();
            }
        };
    }

    public static Date now() {
        return ourTimeService.getNow();
    }

    public static BuildMessage1 createBlockStart(String blockName, String blockType, Date timestamp) {
        return DefaultMessagesInfo.doCreateBlockStart(new BlockData(blockName, blockType), timestamp);
    }

    public static BuildMessage1 createBlockStart(String blockName, String blockDescription, String blockType, Date timestamp) {
        return DefaultMessagesInfo.doCreateBlockStart(new BlockData(blockName, blockType, blockDescription), timestamp);
    }

    private static BuildMessage1 doCreateBlockStart(BlockData blockData, Date timestamp) {
        return DefaultMessagesInfo.doCreateBlock(blockData, timestamp, MSG_BLOCK_START);
    }

    private static BuildMessage1 doCreateBlockEnd(BlockData blockData, Date timestamp) {
        return DefaultMessagesInfo.doCreateBlock(blockData, timestamp, MSG_BLOCK_END);
    }

    private static BuildMessage1 doCreateBlock(BlockData blockData, Date timestamp, String typeId) {
        return new BuildMessage1(SOURCE_ID, typeId, Status.NORMAL, timestamp, blockData);
    }

    public static BuildMessage1 createTestBlockStart(String blockName) {
        return DefaultMessagesInfo.createTestBlockStart(blockName, true, null);
    }

    public static BuildMessage1 createTestBlockStart(String blockName, boolean captureStandardOutput, Long startTimestamp) {
        return DefaultMessagesInfo.createTestBlockStart(blockName, captureStandardOutput, startTimestamp, null);
    }

    public static BuildMessage1 createTestBlockStart(String blockName, boolean captureStandardOutput, Long startTimestamp, String locationHint) {
        return DefaultMessagesInfo.doCreateBlockStart(new TestStartBlockData(blockName, BLOCK_TYPE_TEST, captureStandardOutput, startTimestamp, locationHint), DefaultMessagesInfo.now());
    }

    public static BuildMessage1 createTestSuiteStart(String blockName) {
        return DefaultMessagesInfo.createBlockStart(blockName, BLOCK_TYPE_TEST_SUITE);
    }

    public static BuildMessage1 createTestSuiteEnd(String blockName) {
        return DefaultMessagesInfo.createBlockEnd(blockName, BLOCK_TYPE_TEST_SUITE);
    }

    public static BuildMessage1 createCompilationBlockStart(String blockName) {
        return DefaultMessagesInfo.createBlockStart(blockName, BLOCK_TYPE_COMPILATION);
    }

    public static BuildMessage1 createBlockEnd(String blockName, String blockType) {
        return DefaultMessagesInfo.createBlockEnd(blockName, blockType, DefaultMessagesInfo.now());
    }

    public static BuildMessage1 createBlockEnd(String blockName, String blockType, Date timestamp) {
        return DefaultMessagesInfo.doCreateBlockEnd(new BlockData(blockName, blockType), timestamp);
    }

    public static BuildMessage1 createTestBlockEnd(String blockName, Integer testDuration, Long finishTimestamp) {
        return DefaultMessagesInfo.doCreateBlockEnd(new TestFinishBlockData(blockName, BLOCK_TYPE_TEST, testDuration, finishTimestamp), DefaultMessagesInfo.now());
    }

    public static BuildMessage1 createTestBlockEnd(String blockName) {
        return DefaultMessagesInfo.createTestBlockEnd(blockName, null, null);
    }

    public static BuildMessage1 createCompilationBlockEnd(String blockName) {
        return DefaultMessagesInfo.createBlockEnd(blockName, BLOCK_TYPE_COMPILATION);
    }

    public static BuildMessage1 createError(String message, String type, Throwable throwable) {
        return new BuildMessage1(SOURCE_ID, MSG_ERROR, Status.ERROR, DefaultMessagesInfo.now(), new ErrorData(throwable, message, type));
    }

    public static BuildMessage1 createError(Throwable throwable) {
        return DefaultMessagesInfo.createError(throwable, Status.ERROR);
    }

    public static BuildMessage1 createError(Throwable throwable, Status status) {
        return new BuildMessage1(SOURCE_ID, MSG_ERROR, status, DefaultMessagesInfo.now(), new ErrorData(throwable));
    }

    public static BuildMessage1 createError(String message, String stackTrace, Status status) {
        ErrorData value = new ErrorData(stackTrace, message, null);
        return new BuildMessage1(SOURCE_ID, MSG_ERROR, status, DefaultMessagesInfo.now(), value);
    }

    public static BuildMessage1 createError(Status status, ErrorData data) {
        return new BuildMessage1(SOURCE_ID, MSG_ERROR, status, DefaultMessagesInfo.now(), data);
    }

    public static BuildMessage1 createTextMessage(String message) {
        return DefaultMessagesInfo.createTextMessage(message, Status.NORMAL);
    }

    public static BuildMessage1 createTextMessage(String message, Status status) {
        return new BuildMessage1(SOURCE_ID, MSG_TEXT, status, DefaultMessagesInfo.now(), message);
    }

    public static BuildMessage1 createTextMessage(BuildMessage1 sourceMessage, String newText) {
        return DefaultMessagesInfo.createMessage(sourceMessage, newText);
    }

    public static BuildMessage1 createMessage(BuildMessage1 sourceMessage, Object newValue) {
        BuildMessage1 msg = new BuildMessage1(sourceMessage.getSourceId(), sourceMessage.getTypeId(), sourceMessage.getStatus(), sourceMessage.getTimestamp(), newValue, sourceMessage.getTags()).updateFlowId(sourceMessage.getFlowId());
        msg.setSequenceId(sourceMessage.getSequenceId());
        return msg;
    }

    public static BuildMessage1 createPreparationEndMessage(String message) {
        return new BuildMessage1(SOURCE_ID, MSG_PREPARATION_END_STAGE, Status.NORMAL, DefaultMessagesInfo.now(), message);
    }

    public static BuildMessage1 createProgressMessage(String message) {
        return new BuildMessage1(SOURCE_ID, MSG_PROGRESS_STAGE, Status.NORMAL, DefaultMessagesInfo.now(), message);
    }

    public static BuildMessage1 createBuildFailure(String message) {
        return new BuildMessage1(SOURCE_ID, MSG_BUILD_FAILURE, Status.FAILURE, DefaultMessagesInfo.now(), message);
    }

    public static BuildMessage1 createTestIgnoreMessage(String testName, String reason) {
        return new BuildMessage1(SOURCE_ID, MSG_TEST_IGNORED, Status.NORMAL, DefaultMessagesInfo.now(), new IgnoredTestData(testName, reason));
    }

    public static BuildMessage1 createTestFailure(String testName, Throwable th) {
        TestProblemData data = new TestProblemData(testName, th);
        return new BuildMessage1(SOURCE_ID, MSG_TEST_FAILURE, Status.FAILURE, DefaultMessagesInfo.now(), data);
    }

    public static BuildMessage1 createTestFailure(String testName, String message, String stackTrace) {
        TestProblemData data = new TestProblemData(testName, stackTrace, message);
        return new BuildMessage1(SOURCE_ID, MSG_TEST_FAILURE, Status.FAILURE, DefaultMessagesInfo.now(), data);
    }

    public static BuildMessage1 createComparisonFailed(String testName, Throwable th, String expected, String actual) {
        ComparisonFailedData data = new ComparisonFailedData(testName, th, expected, actual);
        return new BuildMessage1(SOURCE_ID, MSG_TEST_FAILURE, Status.FAILURE, DefaultMessagesInfo.now(), data);
    }

    public static BuildMessage1 createComparisonFailed(String testName, String th, String message, String expected, String actual) {
        ComparisonFailedData data = new ComparisonFailedData(testName, message, th, expected, actual);
        return new BuildMessage1(SOURCE_ID, MSG_TEST_FAILURE, Status.FAILURE, DefaultMessagesInfo.now(), data);
    }

    public static BuildMessage1 createTestStderr(String testName, String output) {
        return new BuildMessage1(SOURCE_ID, MSG_TEST_OUTPUT, Status.NORMAL, DefaultMessagesInfo.now(), new TestOutputData(testName, false, output));
    }

    public static BuildMessage1 createTestStdout(String testName, String output) {
        return new BuildMessage1(SOURCE_ID, MSG_TEST_OUTPUT, Status.NORMAL, DefaultMessagesInfo.now(), new TestOutputData(testName, true, output));
    }

    public static BuildMessage1 createFlowMessage(String flowId, String parentFlowId) {
        return new BuildMessage1(SOURCE_ID, MSG_FLOW, Status.NORMAL, new Date(), new FlowData(flowId, parentFlowId));
    }

    public static BuildMessage1 createFlowFinishedMessage(String flowId) {
        return new BuildMessage1(SOURCE_ID, MSG_FLOW_FINISHED, Status.NORMAL, new Date(), new FlowData(flowId, null));
    }

    public static BuildMessage1 createTestNavigationInfo(Map attributes) {
        return new BuildMessage1(SOURCE_ID, MSG_TEST_NAVIGATION_INFO, Status.NORMAL, new Date(), attributes);
    }

    public static BuildMessage1 createTestRetry(boolean enableTestRetry) {
        return new BuildMessage1(SOURCE_ID, MSG_TEST_RETRY, Status.NORMAL, new Date(), enableTestRetry);
    }

    public static BuildMessage1 debugMessage(String text) {
        return DefaultMessagesInfo.internalize(DefaultMessagesInfo.createTextMessage(text)).updateTags(TAG_AS_IS);
    }

    public static BuildMessage1 internalize(BuildMessage1 message) {
        return message.updateTags(TAG_INTERNAL);
    }

    public static BuildMessage1 addMessageLink(BuildMessage1 message1, Integer targetMessageIndex) {
        if (targetMessageIndex == null) {
            return message1;
        }
        return message1.updateTags(TAG_MSG_LINK.concat("=" + targetMessageIndex));
    }

    public static String getMessageLink(Collection<String> tags) {
        String prefix = "tc:msglink=";
        for (String tag : tags) {
            if (!tag.startsWith("tc:msglink=")) continue;
            return tag.substring("tc:msglink=".length());
        }
        return null;
    }

    public static BuildMessage1 createBuildProblemMessage(BuildProblemData buildProblem) {
        return new BuildMessage1(SOURCE_ID, MSG_BUILD_PROBLEM, Status.NORMAL, new Date(), buildProblem);
    }

    public static BuildMessage1 createCheckoutDirMessage(String checkoutDirPath) {
        String message = CHECKOUT_DIRECTORY_MSG_PREFIX + checkoutDirPath;
        return DefaultMessagesInfo.createTextMessage(message).updateTags(TAG_CHECKOUT_DIR);
    }

    @NotNull
    public static BuildMessage1 createTestMetadata(@NotNull TestMetadata metadata) {
        if (metadata == null) {
            DefaultMessagesInfo.$$$reportNull$$$0(0);
        }
        BuildMessage1 buildMessage1 = new BuildMessage1(SOURCE_ID, MSG_TEST_METADATA, Status.NORMAL, new Date(), metadata);
        if (buildMessage1 == null) {
            DefaultMessagesInfo.$$$reportNull$$$0(1);
        }
        return buildMessage1;
    }

    static {
        DefaultMessagesInfo.resetMessagesTimeService();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/messages/DefaultMessagesInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/messages/DefaultMessagesInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestMetadata";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface MessagesTimeService {
        public Date getNow();
    }
}

