/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.messages.ObjectSizeEstimate;

public class ErrorData
implements ObjectSizeEstimate {
    public static final String UPDATE_SOURCES_TYPE = "UPDATE_SOURCES";
    public static final String CHECKING_FOR_CHANGES_ERROR_TYPE = "CHECKING_FOR_CHANGES_ERROR";
    public static final String ARTIFACT_DEPENDENCY_ERROR_TYPE = "ARTIFACT_DEPENDENCY_ERROR";
    public static final String SNAPSHOT_DEPENDENCY_ERROR_TYPE = "SNAPSHOT_DEPENDENCY_ERROR";
    public static final String PREPARATION_FAILURE_TYPE = "PREPARATION_FAILURE_TYPE";
    public static final String DIRECTORY_CREATION_ERROR_TYPE = "DIRECTORY_CREATION_ERROR";
    public static final String BUILD_RUNNER_ERROR_TYPE = "BUILD_RUNNER_ERROR";
    public static final String UNKNOWN_TYPE = "UNKNOWN";
    public static final String SNAPSHOT_DEPENDENCY_ERROR_BUILD_PROCEEDS_TYPE = "SNAPSHOT_DEPENDENCY_ERROR_BUILD_PROCEEDS_TYPE";
    public static final Map TYPE_DESCRIPTIONS = new HashMap(){
        {
            this.put(ErrorData.UPDATE_SOURCES_TYPE, "Error while applying patch");
            this.put(ErrorData.CHECKING_FOR_CHANGES_ERROR_TYPE, "Unable to collect changes");
            this.put(ErrorData.ARTIFACT_DEPENDENCY_ERROR_TYPE, "Artifacts resolving failed");
            this.put(ErrorData.SNAPSHOT_DEPENDENCY_ERROR_TYPE, "Snapshot dependency failure");
            this.put(ErrorData.SNAPSHOT_DEPENDENCY_ERROR_BUILD_PROCEEDS_TYPE, "Snapshot dependency failure");
            this.put(ErrorData.PREPARATION_FAILURE_TYPE, "Failed to start build");
            this.put(ErrorData.DIRECTORY_CREATION_ERROR_TYPE, "Failed to create a directory");
            this.put(ErrorData.BUILD_RUNNER_ERROR_TYPE, "Cannot start build runner");
        }
    };
    public String stackTrace;
    public String localizedMessage;
    public String type = "UNKNOWN";
    private static final Set<String> myInternalErrors = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("UPDATE_SOURCES", "CHECKING_FOR_CHANGES_ERROR", "ARTIFACT_DEPENDENCY_ERROR", "SNAPSHOT_DEPENDENCY_ERROR", "PREPARATION_FAILURE_TYPE", "DIRECTORY_CREATION_ERROR", "BUILD_RUNNER_ERROR")));
    private static final Set<String> mySnapshotDependencyError = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SNAPSHOT_DEPENDENCY_ERROR", "SNAPSHOT_DEPENDENCY_ERROR_BUILD_PROCEEDS_TYPE")));

    public ErrorData(Throwable th) {
        this.stackTrace = ErrorData.toTrace(th);
        String msg = th.getLocalizedMessage();
        this.localizedMessage = msg != null ? th.getClass().getName() + ": " + msg : th.getClass().getName();
    }

    public ErrorData(Throwable th, String localizedMessage, String type) {
        this(ErrorData.toTrace(th), localizedMessage, type);
    }

    public ErrorData(String stackTrace, String localizedMessage, String type) {
        this.stackTrace = stackTrace;
        this.localizedMessage = localizedMessage;
        this.type = type != null ? type : UNKNOWN_TYPE;
    }

    private static String toTrace(Throwable th) {
        if (th == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        th.printStackTrace(writer);
        writer.close();
        return stringWriter.toString();
    }

    public boolean isInternalError() {
        return ErrorData.isInternalError(this.type);
    }

    public static boolean isInternalError(String type) {
        return myInternalErrors.contains(type);
    }

    public static boolean isSnapshotDependencyError(String type) {
        return mySnapshotDependencyError.contains(type);
    }

    public String toString() {
        return "ErrorData{type='" + this.type + '\'' + ", localizedMessage='" + this.localizedMessage + '\'' + ", stackTrace='" + this.stackTrace + '\'' + '}';
    }

    public long getEstimatedSize() {
        return this.stackTrace == null ? 0L : (this.stackTrace.length() + this.localizedMessage == null ? 0L : (long)(this.localizedMessage.length() + this.type.length()));
    }
}

