/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;

public class MemoryOptimizedXmlFriendlyReplacer
extends XmlFriendlyNameCoder {
    public String encodeNode(String name) {
        int finalCount = MemoryOptimizedXmlFriendlyReplacer.calcFinalEscapedStringCount(name);
        if (name.length() == finalCount) {
            return name;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '$') {
                resultChars[resultPos++] = 95;
                resultChars[resultPos++] = 45;
                continue;
            }
            if (c == '_') {
                resultChars[resultPos++] = 95;
                resultChars[resultPos++] = 95;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + name + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(String name) {
        int result = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '$') {
                result += 2;
                continue;
            }
            if (c == '_') {
                result += 2;
                continue;
            }
            ++result;
        }
        return result;
    }

    public String decodeNode(String name) {
        int finalCount = MemoryOptimizedXmlFriendlyReplacer.calcFinalUnescapedStringCount(name);
        int len = name.length();
        if (len == finalCount) {
            return name;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < len; ++i) {
            int c = name.charAt(i);
            if (c == 95 && i < len - 1) {
                char nextChar = name.charAt(i + 1);
                if (nextChar == '-') {
                    c = 36;
                    ++i;
                } else if (nextChar == '_') {
                    c = 95;
                    ++i;
                }
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect unescaping for '" + name + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalUnescapedStringCount(String name) {
        int result = 0;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char nextChar;
            char c = name.charAt(i);
            if (c == '_' && i < len - 1 && ((nextChar = name.charAt(i + 1)) == '-' || nextChar == '_')) {
                ++i;
            }
            ++result;
        }
        return result;
    }
}

