/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import java.math.BigDecimal;
import java.util.Arrays;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.messages.ObjectSizeEstimate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestMetadata
implements Loggable,
ObjectSizeEstimate {
    public static final String NUMBER_TYPE = "number";
    public static final String TEXT_TYPE = "text";
    public static final String AUTO_PREFIX = "teamcity.auto.name:";
    private final String myName;
    private final String myValue;
    private final String myType;
    private final BigDecimal myNumValue;
    private final String myTestName;

    public long getEstimatedSize() {
        return this.myTestName.length() + (this.myValue != null ? this.myValue.length() : 0) + (this.myType != null ? this.myType.length() : 0) + (this.myNumValue != null ? this.myNumValue.unscaledValue().bitCount() / 8 : 0) + this.myTestName.length();
    }

    public TestMetadata(@NotNull String testName, @NotNull String name, @NotNull String value) {
        if (testName == null) {
            TestMetadata.$$$reportNull$$$0(0);
        }
        if (name == null) {
            TestMetadata.$$$reportNull$$$0(1);
        }
        if (value == null) {
            TestMetadata.$$$reportNull$$$0(2);
        }
        this(testName, name, TEXT_TYPE, value);
    }

    public TestMetadata(@NotNull String testName, @NotNull String name, double numberValue) {
        if (testName == null) {
            TestMetadata.$$$reportNull$$$0(3);
        }
        if (name == null) {
            TestMetadata.$$$reportNull$$$0(4);
        }
        this(testName, name, NUMBER_TYPE, new BigDecimal(numberValue));
    }

    public TestMetadata(@NotNull String testName, @NotNull String name, String type, @NotNull String value) {
        if (testName == null) {
            TestMetadata.$$$reportNull$$$0(5);
        }
        if (name == null) {
            TestMetadata.$$$reportNull$$$0(6);
        }
        if (value == null) {
            TestMetadata.$$$reportNull$$$0(7);
        }
        this.myName = name;
        this.myType = type;
        this.myValue = value;
        this.myTestName = testName;
        this.myNumValue = null;
    }

    public TestMetadata(@NotNull String testName, @NotNull String name, @NotNull String type, BigDecimal numberValue) {
        if (testName == null) {
            TestMetadata.$$$reportNull$$$0(8);
        }
        if (name == null) {
            TestMetadata.$$$reportNull$$$0(9);
        }
        if (type == null) {
            TestMetadata.$$$reportNull$$$0(10);
        }
        this.myName = name;
        this.myType = type;
        this.myNumValue = numberValue;
        this.myTestName = testName;
        this.myValue = null;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            TestMetadata.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getType() {
        String string = this.myType;
        if (string == null) {
            TestMetadata.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public String getValue() {
        return this.myValue;
    }

    @Nullable
    public BigDecimal getNumValue() {
        return this.myNumValue;
    }

    @NotNull
    public String getTestName() {
        String string = this.myTestName;
        if (string == null) {
            TestMetadata.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean hasTestName() {
        return this.myTestName.length() > 0;
    }

    public String describeValue() {
        if (this.myValue != null) {
            return this.myValue;
        }
        return this.myNumValue == null ? "null" : this.myNumValue.toString();
    }

    public TestMetadata cloneWithAutoName(int autoNameIdx) {
        return this.myValue == null ? new TestMetadata(this.myTestName, AUTO_PREFIX + autoNameIdx, this.myType, this.myNumValue) : new TestMetadata(this.myTestName, AUTO_PREFIX + autoNameIdx, this.myType, this.myValue);
    }

    @NotNull
    public String describe(boolean verbose) {
        String string = verbose ? this.toString() : this.myName + "/" + this.myNumValue;
        if (string == null) {
            TestMetadata.$$$reportNull$$$0(14);
        }
        return string;
    }

    public String toString() {
        return "TestData{myKey='" + this.myName + '\'' + ", myType='" + this.myType + '\'' + ", myValue='" + this.myValue + '\'' + ", myNumValue=" + this.myNumValue + ", myTestName='" + this.myTestName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestMetadata that = (TestMetadata)o;
        return (this.myNumValue == null ? that.myNumValue == null : this.myNumValue.equals(that.myNumValue)) && this.myName.equals(that.myName) && this.myType.equals(that.myType) && this.myTestName.equals(that.myTestName) && (this.myValue == null ? that.myValue == null : this.myValue.equals(that.myValue));
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.myTestName, this.myName});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/messages/TestMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/messages/TestMetadata";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

