/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Queue;
import jetbrains.buildServer.messages.MemoryOptimizedXmlFriendlyReplacer;
import jetbrains.buildServer.messages.XStreamUtil;
import jetbrains.buildServer.messages.XStreamWrapper;
import org.xmlpull.mxp1.MXParserCachingStrings;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XStreamHolder {
    private final Queue<XStreamWrapper> myFreeXStream = new LinkedList<XStreamWrapper>();
    public static final String UTF_8 = "UTF-8";

    public XStream getXStream() {
        return this.getXStream(null);
    }

    public XStream getXStream(ClassLoader classLoader) {
        XStreamWrapper xs = this.getXStreamInternal();
        xs.setNewClassloader(classLoader);
        return xs;
    }

    public synchronized void releaseXStream(XStream xstream) {
        if (xstream instanceof XStreamWrapper) {
            XStreamWrapper wrapper = (XStreamWrapper)xstream;
            wrapper.revertClassloader();
            this.myFreeXStream.add(wrapper);
        }
    }

    protected void configureXStream(XStream xStream) {
    }

    private synchronized XStreamWrapper getXStreamInternal() {
        if (this.myFreeXStream.isEmpty()) {
            return this.createXStreamInstance();
        }
        return this.myFreeXStream.poll();
    }

    private XStreamWrapper createXStreamInstance() {
        XppDriver driver = new XppDriver((NameCoder)new MemoryOptimizedXmlFriendlyReplacer()){
            private MXParserCachingStrings myParser;
            private int myUsageCount;
            {
                this.myUsageCount = 0;
            }

            public HierarchicalStreamReader createReader(InputStream in) {
                try {
                    return this.createReader(new InputStreamReader(in, XStreamHolder.UTF_8));
                }
                catch (UnsupportedEncodingException e) {
                    return super.createReader(in);
                }
            }

            public HierarchicalStreamWriter createWriter(OutputStream out) {
                try {
                    return new CompactWriter((Writer)new OutputStreamWriter(out, XStreamHolder.UTF_8));
                }
                catch (UnsupportedEncodingException e) {
                    return new CompactWriter((Writer)new OutputStreamWriter(out));
                }
            }

            protected synchronized XmlPullParser createParser() throws XmlPullParserException {
                if (this.myParser != null && this.myUsageCount++ < 10000) {
                    return this.myParser;
                }
                XmlPullParser parser = super.createParser();
                if (parser instanceof MXParserCachingStrings) {
                    this.myParser = (MXParserCachingStrings)parser;
                }
                this.myUsageCount = 0;
                return parser;
            }
        };
        XStreamWrapper xStream = XStreamUtil.createXStreamInternal((HierarchicalStreamDriver)driver);
        this.configureXStream(xStream);
        return xStream;
    }
}

