/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import java.util.Set;
import jetbrains.buildServer.messages.BuildMessage1;
import jetbrains.buildServer.messages.DefaultMessagesInfo;
import jetbrains.buildServer.messages.TestOutputData;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.TextMessageProcessor;
import jetbrains.buildServer.util.CollectionsUtil;
import org.jetbrains.annotations.NotNull;

public class ServiceMessagesProcessor {
    private static final Set<String> ourTypesSupportingServiceMessages = CollectionsUtil.setOf("Text", "TestOutput");

    public static void processTextMessage(final @NotNull BuildMessage1 originalMessage, final @NotNull TextMessageProcessor processor) {
        Object value;
        if (originalMessage == null) {
            ServiceMessagesProcessor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            ServiceMessagesProcessor.$$$reportNull$$$0(1);
        }
        if ((value = originalMessage.getValue()) instanceof TestOutputData) {
            value = ((TestOutputData)value).text;
        }
        if (!ourTypesSupportingServiceMessages.contains(originalMessage.getTypeId()) || value == null || !(value instanceof String) || ((String)value).trim().length() == 0) {
            processor.processOriginalMessageIsNotTextMessage(originalMessage);
            return;
        }
        final String textValue = (String)value;
        ServiceMessage.parse((String)textValue, (ServiceMessageParserCallback)new ServiceMessageParserCallback(){

            public void regularText(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (textValue.length() != text.length()) {
                    BuildMessage1 partialOriginalMessage = ServiceMessagesProcessor.makeNewTextMessage(originalMessage, text);
                    processor.processText(partialOriginalMessage);
                } else {
                    processor.processText(originalMessage);
                }
            }

            public void serviceMessage(@NotNull ServiceMessage message) {
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                BuildMessage1 partialOriginalMessage = ServiceMessagesProcessor.makeNewTextMessage(originalMessage, message.asString());
                processor.processServiceMessage(message, partialOriginalMessage);
            }

            public void parseException(@NotNull ParseException parseException, @NotNull String text) {
                if (parseException == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(3);
                }
                BuildMessage1 partialOriginalMessage = ServiceMessagesProcessor.makeNewTextMessage(originalMessage, text);
                processor.processParseException(parseException, partialOriginalMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parseException";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "regularText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serviceMessage";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "parseException";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static BuildMessage1 makeNewTextMessage(@NotNull BuildMessage1 m, @NotNull String text) {
        BuildMessage1 newMessage;
        if (m == null) {
            ServiceMessagesProcessor.$$$reportNull$$$0(2);
        }
        if (text == null) {
            ServiceMessagesProcessor.$$$reportNull$$$0(3);
        }
        if (m.getTypeId().equals("TestOutput")) {
            TestOutputData data = (TestOutputData)m.getValue();
            newMessage = new BuildMessage1(m.getSourceId(), m.getTypeId(), m.getStatus(), m.getTimestamp(), new TestOutputData(data.testName, data.isStdOut, text), m.getTags()).updateFlowId(m.getFlowId());
        } else {
            newMessage = DefaultMessagesInfo.createTextMessage(m, text);
        }
        newMessage.setSequenceId(m.getSequenceId());
        BuildMessage1 buildMessage1 = newMessage;
        if (buildMessage1 == null) {
            ServiceMessagesProcessor.$$$reportNull$$$0(4);
        }
        return buildMessage1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMessage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNewTextMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processTextMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeNewTextMessage";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

