/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.metrics;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.Predicate;
import jetbrains.buildServer.util.TimeService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntervalStatistic {
    private final Period[] myPeriods;

    public IntervalStatistic(@NotNull TimeService timeService, @Nullable String periods) {
        if (timeService == null) {
            IntervalStatistic.$$$reportNull$$$0(0);
        }
        Config[] configs = new Configurations(periods).get();
        this.myPeriods = new Period[configs.length + 1];
        for (int i = 0; i < configs.length; ++i) {
            this.myPeriods[i] = new IntervalPeriod(configs[i].stepLength(), configs[i].period(), timeService);
        }
        this.myPeriods[configs.length] = new TotalPeriod(0L, timeService);
    }

    private static void compareLessAndSet(@NotNull AtomicReference<Long> ref, @NotNull Long val) {
        Long tmp;
        if (ref == null) {
            IntervalStatistic.$$$reportNull$$$0(1);
        }
        if (val == null) {
            IntervalStatistic.$$$reportNull$$$0(2);
        }
        while ((tmp = ref.get()) == null || tmp > val) {
            ref.compareAndSet(tmp, val);
        }
    }

    private static void compareGreaterAndSet(@NotNull AtomicReference<Long> ref, @NotNull Long val) {
        Long tmp;
        if (ref == null) {
            IntervalStatistic.$$$reportNull$$$0(3);
        }
        if (val == null) {
            IntervalStatistic.$$$reportNull$$$0(4);
        }
        while ((tmp = ref.get()) == null || tmp < val) {
            ref.compareAndSet(tmp, val);
        }
    }

    private static <T> void removeIf(@NotNull List<T> list, @NotNull Predicate<T> predicate) {
        if (list == null) {
            IntervalStatistic.$$$reportNull$$$0(5);
        }
        if (predicate == null) {
            IntervalStatistic.$$$reportNull$$$0(6);
        }
        if (list.size() == 0) {
            return;
        }
        ArrayList<T> removed = new ArrayList<T>(list.size());
        for (T element : list) {
            if (!predicate.apply(element)) continue;
            removed.add(element);
        }
        if (removed.size() != 0) {
            list.removeAll(removed);
            removed.size();
        }
    }

    public void add(long time, long amount) {
        for (Period period : this.myPeriods) {
            period.add(time, amount);
        }
    }

    public void add(long amount) {
        for (Period period : this.myPeriods) {
            period.add(amount);
        }
    }

    public List<Metric> get() {
        ArrayList<Metric> result = new ArrayList<Metric>(this.myPeriods.length);
        for (Period per : this.myPeriods) {
            result.add(new Metric(per.getPeriod(), per.getFirst(), per.getLast(), per.getValue()));
        }
        return result;
    }

    public void inc() {
        this.add(1L);
    }

    public void inc(long time) {
        this.add(time, 1L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeService";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/metrics/IntervalStatistic";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareLessAndSet";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compareGreaterAndSet";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeIf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Config
    implements Comparable<Config> {
        private static final int MAX_STEPS = 16;
        private final int myPeriod;
        private final int myStepLength;

        public Config(@NotNull String config) {
            if (config == null) {
                Config.$$$reportNull$$$0(0);
            }
            this.myPeriod = this.parse(config);
            this.myStepLength = (int)Math.floor((double)this.myPeriod / 15.0) + 1;
        }

        private int parse(@NotNull String s) {
            int length;
            if (s == null) {
                Config.$$$reportNull$$$0(1);
            }
            if (s.length() == 0) {
                return 0;
            }
            for (length = 0; length < s.length() && Character.isDigit(s.charAt(length)); ++length) {
            }
            int period = Integer.parseInt(s.substring(0, length));
            switch (s.charAt(s.length() - 1)) {
                case 'm': {
                    period *= 1;
                    break;
                }
                case 'h': {
                    period *= 60;
                    break;
                }
                case 'd': {
                    period *= 1440;
                    break;
                }
                case 'y': {
                    period *= 525600;
                    break;
                }
                default: {
                    period = 0;
                }
            }
            return period;
        }

        public int period() {
            return this.myPeriod;
        }

        public int stepLength() {
            return this.myStepLength;
        }

        @Override
        public int compareTo(@NotNull Config o) {
            if (o == null) {
                Config.$$$reportNull$$$0(2);
            }
            return this.myPeriod < o.period() ? -1 : (this.myPeriod == o.period() ? 0 : 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/metrics/IntervalStatistic$Config";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Configurations {
        private static final Pattern LIFETIME_DELIMITER = Pattern.compile(";");
        private final Config[] myConfigs;

        private Configurations(@Nullable String config) {
            if (config == null || config.length() == 0) {
                this.myConfigs = new Config[0];
                return;
            }
            TreeSet<Config> lifetimes = new TreeSet<Config>();
            for (String lifetime : LIFETIME_DELIMITER.split(config)) {
                Config conf;
                if (lifetime == null || (conf = new Config(lifetime.trim())).period() <= 0) continue;
                lifetimes.add(conf);
            }
            this.myConfigs = lifetimes.toArray(new Config[0]);
        }

        public Config[] get() {
            return this.myConfigs;
        }
    }

    private static class Step {
        private final long myTime;
        private final AtomicLong myAmount;

        public Step(long time) {
            this(time, 1L);
        }

        public Step(long time, long amount) {
            this.myTime = time;
            this.myAmount = new AtomicLong(amount);
        }

        public void inc() {
            this.inc(1L);
        }

        public void inc(long c) {
            this.myAmount.addAndGet(c);
        }

        public long time() {
            return this.myTime;
        }

        public long amount() {
            return this.myAmount.longValue();
        }
    }

    private static class IntervalPeriod
    implements Period {
        private final List<Step> mySteps;
        private final int myStep;
        private final int myPeriod;
        private final TimeService myTime;
        private final AtomicReference<Long> myLastAction;

        public IntervalPeriod(int step, int period, @NotNull TimeService timeService) {
            if (timeService == null) {
                IntervalPeriod.$$$reportNull$$$0(0);
            }
            this.mySteps = new CopyOnWriteArrayList<Step>();
            this.myLastAction = new AtomicReference();
            this.myStep = step;
            this.myPeriod = period;
            this.myTime = timeService;
        }

        @Nullable
        private static <T> T last(@NotNull List<T> list) {
            if (list == null) {
                IntervalPeriod.$$$reportNull$$$0(1);
            }
            if (list.size() == 0) {
                return null;
            }
            return list.get(list.size() - 1);
        }

        @Nullable
        private static <T> T first(@NotNull Iterable<T> iterable) {
            Iterator<T> iterator;
            if (iterable == null) {
                IntervalPeriod.$$$reportNull$$$0(2);
            }
            if ((iterator = iterable.iterator()).hasNext()) {
                return iterator.next();
            }
            return null;
        }

        @Override
        public boolean add(long amount) {
            return this.add(this.myTime.now(), amount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(long time, long amount) {
            long current = this.currentTime(time);
            Step last = IntervalPeriod.last(this.mySteps);
            if (last == null || last.time() < current) {
                List<Step> list = this.mySteps;
                synchronized (list) {
                    last = IntervalPeriod.last(this.mySteps);
                    if (last == null || last.time() < current) {
                        this.mySteps.add(new Step(current, amount));
                        final long minTime = this.minTime(time);
                        IntervalStatistic.removeIf(this.mySteps, new Predicate<Step>(){

                            @Override
                            public boolean apply(Step item) {
                                return item != null && item.time() < minTime;
                            }
                        });
                        IntervalStatistic.compareGreaterAndSet(this.myLastAction, time);
                        return true;
                    }
                }
            }
            IntervalStatistic.compareGreaterAndSet(this.myLastAction, time);
            if (last.time() == current) {
                last.inc(amount);
                return true;
            }
            return false;
        }

        @Override
        public int getPeriod() {
            return this.myPeriod;
        }

        @Override
        @Nullable
        public Date getFirst() {
            Step step = IntervalPeriod.first(this.mySteps);
            if (step != null) {
                return this.date(step.myTime);
            }
            return null;
        }

        @Override
        @Nullable
        public Date getLast() {
            Long lastAction = this.myLastAction.get();
            if (lastAction != null) {
                return new Date(lastAction);
            }
            return null;
        }

        @Override
        public long getValue() {
            long count = 0L;
            long minTime = this.minTime(this.myTime.now());
            for (Step step : this.mySteps) {
                if (step.time() < minTime) continue;
                count += step.amount();
            }
            return count;
        }

        private long currentTime(long time) {
            return time / 60000L / (long)this.myStep;
        }

        private long minTime(long time) {
            return (time / 60000L - (long)this.myPeriod) / (long)this.myStep;
        }

        private Date date(long time) {
            return new Date(time * (long)this.myStep * 60000L);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeService";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/metrics/IntervalStatistic$IntervalPeriod";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "last";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "first";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TotalPeriod
    implements Period {
        private final AtomicLong myAmount;
        private final TimeService myTime;
        private final AtomicReference<Long> myFirstAction;
        private final AtomicReference<Long> myLastAction;

        /*
         * WARNING - void declaration
         */
        private TotalPeriod(long amount, @NotNull TimeService timeService) {
            void time;
            if (timeService == null) {
                TotalPeriod.$$$reportNull$$$0(0);
            }
            this.myFirstAction = new AtomicReference();
            this.myLastAction = new AtomicReference();
            this.myAmount = new AtomicLong(amount);
            this.myTime = time;
        }

        @Override
        public boolean add(long amount) {
            return this.add(this.myTime.now(), amount);
        }

        @Override
        public boolean add(long time, long amount) {
            if (time == 0L) {
                return false;
            }
            this.myAmount.addAndGet(amount);
            IntervalStatistic.compareLessAndSet(this.myFirstAction, time);
            IntervalStatistic.compareGreaterAndSet(this.myLastAction, time);
            return true;
        }

        @Override
        public int getPeriod() {
            return 0;
        }

        @Override
        @Nullable
        public Date getFirst() {
            Long firstAction = this.myFirstAction.get();
            if (firstAction != null) {
                return new Date(firstAction);
            }
            return null;
        }

        @Override
        @Nullable
        public Date getLast() {
            Long lastAction = this.myLastAction.get();
            if (lastAction != null) {
                return new Date(lastAction);
            }
            return null;
        }

        @Override
        public long getValue() {
            return this.myAmount.longValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "time", "jetbrains/buildServer/metrics/IntervalStatistic$TotalPeriod", "<init>"));
        }
    }

    public static class Metric {
        private final Integer myPeriod;
        private final Date myFirst;
        private final Date myLast;
        private final Long myCount;

        public Metric(@NotNull Integer period, @Nullable Date first, @Nullable Date last, @NotNull Long count) {
            if (period == null) {
                Metric.$$$reportNull$$$0(0);
            }
            if (count == null) {
                Metric.$$$reportNull$$$0(1);
            }
            this.myPeriod = period;
            this.myFirst = first;
            this.myLast = last;
            this.myCount = count;
        }

        @NotNull
        public Integer getPeriod() {
            Integer n = this.myPeriod;
            if (n == null) {
                Metric.$$$reportNull$$$0(2);
            }
            return n;
        }

        @Nullable
        public Date getFirst() {
            return this.myFirst;
        }

        @Nullable
        public Date getLast() {
            return this.myLast;
        }

        @NotNull
        public Long getCount() {
            Long l = this.myCount;
            if (l == null) {
                Metric.$$$reportNull$$$0(3);
            }
            return l;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "period";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "count";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/metrics/IntervalStatistic$Metric";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/metrics/IntervalStatistic$Metric";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPeriod";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCount";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface Period {
        public boolean add(long var1);

        public boolean add(long var1, long var3);

        public int getPeriod();

        @Nullable
        public Date getFirst();

        @Nullable
        public Date getLast();

        public long getValue();
    }
}

