/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.serverSide.ControlDescription;
import jetbrains.buildServer.serverSide.Parameter;
import jetbrains.buildServer.util.StringPool;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class ParametersUtil {
    private ParametersUtil() {
    }

    @NotNull
    public static String toString(@NotNull ControlDescription controlDescription) {
        Map<String, String> parameterTypeArguments;
        if (controlDescription == null) {
            ParametersUtil.$$$reportNull$$$0(0);
        }
        if (!(parameterTypeArguments = controlDescription.getParameterTypeArguments()).isEmpty()) {
            String string = controlDescription.getParameterType() + ' ' + MapSerializerUtil.propertiesToString(parameterTypeArguments, (MapSerializerUtil.EscapeInfoProvider2)MapSerializerUtil.STD_ESCAPER2);
            if (string == null) {
                ParametersUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = controlDescription.getParameterType();
        if (string == null) {
            ParametersUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static ControlDescription toControlDescription(@NotNull String typeSpec) throws ParseException {
        ControlDescription controlDescription;
        if (typeSpec == null) {
            ParametersUtil.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)typeSpec)) {
            throw new ParseException("Parameter specification must not be empty", 0);
        }
        try {
            ServiceMessage parse = ServiceMessage.parseSimple((String)typeSpec, (boolean)false);
            if (parse.getArgument() != null && parse.getAttributes().isEmpty()) {
                throw new ParseException("Failed to parse parameter specification. Attribute without name is found", 0);
            }
            controlDescription = ParametersUtil.createControlDescription(parse.getMessageName(), parse.getAttributes());
        }
        catch (ParseException e) {
            throw new ParseException("Failed to parse parameter specification: " + e.getMessage(), e.getErrorOffset() - "##teamcity[".length());
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse parameter specification: " + e.toString(), 0);
        }
        if (controlDescription == null) {
            ParametersUtil.$$$reportNull$$$0(4);
        }
        return controlDescription;
    }

    @NotNull
    public static ControlDescription createControlDescription(@NotNull String type, @NotNull Map<String, String> attributes) {
        if (type == null) {
            ParametersUtil.$$$reportNull$$$0(5);
        }
        if (attributes == null) {
            ParametersUtil.$$$reportNull$$$0(6);
        }
        final String pooledType = StringPool.getFromPool(type);
        final LinkedHashMap<String, String> pooledAttributes = new LinkedHashMap<String, String>(attributes.size());
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            pooledAttributes.put(StringPool.getFromPool(e.getKey()), StringPool.getFromPool(e.getValue()));
        }
        ControlDescription controlDescription = new ControlDescription(){

            @Override
            @NotNull
            public String getParameterType() {
                String string = pooledType;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public Map<String, String> getParameterTypeArguments() {
                Map<String, String> map = Collections.unmodifiableMap(pooledAttributes);
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }

            public String toString() {
                return "id: " + pooledType + ", params: " + pooledAttributes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "jetbrains/buildServer/parameters/ParametersUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameterType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameterTypeArguments";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (controlDescription == null) {
            ParametersUtil.$$$reportNull$$$0(7);
        }
        return controlDescription;
    }

    @NotNull
    public static Map<String, String> toValuesMap(@NotNull Collection<Parameter> parameters) {
        if (parameters == null) {
            ParametersUtil.$$$reportNull$$$0(8);
        }
        HashMap<String, String> map = new HashMap<String, String>(parameters.size());
        for (Parameter parameter : parameters) {
            map.put(parameter.getName(), parameter.getValue());
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            ParametersUtil.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, Parameter> toParameterMap(@NotNull Collection<Parameter> parameters) {
        if (parameters == null) {
            ParametersUtil.$$$reportNull$$$0(10);
        }
        HashMap<String, Parameter> map = new HashMap<String, Parameter>(parameters.size());
        for (Parameter parameter : parameters) {
            map.put(parameter.getName(), parameter);
        }
        HashMap<String, Parameter> hashMap = map;
        if (hashMap == null) {
            ParametersUtil.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlDescription";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/parameters/ParametersUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/parameters/ParametersUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toControlDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createControlDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toValuesMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toParameterMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toControlDescription";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createControlDescription";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toValuesMap";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toParameterMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

