/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters;

import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ReferencesResolverUtil {
    private static final char REF_MARKER_CHAR = '%';
    private static final char NEW_LINE_SYMBOL = '\n';

    @NotNull
    public static String makeReference(@NotNull String propertyName) {
        if (propertyName == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(0);
        }
        String string = '%' + propertyName + '%';
        if (string == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void resolve(@NotNull String value, @NotNull ReferencesResolverListener listener) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(3);
        }
        if (value.length() <= 1) {
            listener.appendText(value);
            return;
        }
        int refStart = value.indexOf(37);
        if (refStart == -1) {
            listener.appendText(value);
            return;
        }
        if (refStart > 0) {
            listener.appendText(value.substring(0, refStart));
        }
        CharBuffer textBuf = new CharBuffer(value.length() - refStart);
        CharBuffer refBuf = new CharBuffer(value.length() - refStart);
        boolean refStarted = false;
        for (int idx = refStart; idx < value.length(); ++idx) {
            String refKey;
            int start = idx;
            while (idx < value.length() && value.charAt(idx) != '%' && value.charAt(idx) != '\n') {
                ++idx;
            }
            if (idx < value.length() && value.charAt(idx) == '\n') {
                if (refStarted) {
                    textBuf.append('%');
                }
                refStarted = false;
                textBuf.append(value, start, idx - start);
                textBuf.append('\n');
                continue;
            }
            if (idx > start) {
                if (refStarted) {
                    refBuf.append(value, start, idx - start);
                } else {
                    textBuf.append(value, start, idx - start);
                }
            }
            if (idx >= value.length()) break;
            if (!refStarted) {
                if (idx + 1 < value.length() && value.charAt(idx + 1) == '%') {
                    textBuf.append('%');
                    textBuf.append('%');
                    ++idx;
                    refStarted = false;
                } else if (idx + 2 < value.length()) {
                    refStarted = true;
                } else {
                    textBuf.append('%');
                    refStarted = false;
                }
            } else {
                refStarted = false;
            }
            if (!(refBuf.isEmpty() || refStarted || listener.appendReference(refKey = refBuf.flush()))) {
                if (ReferencesResolverUtil.isValidReference(refKey)) {
                    listener.appendText(String.valueOf('%'));
                    listener.appendText(refKey);
                    listener.appendText(String.valueOf('%'));
                } else {
                    listener.appendText(String.valueOf('%'));
                    listener.appendText(refKey);
                    if (idx + 1 < value.length() && value.charAt(idx + 1) != '%') {
                        --idx;
                    } else {
                        listener.appendText(String.valueOf('%'));
                    }
                }
            }
            if (textBuf.isEmpty() || !refStarted) continue;
            listener.appendText(textBuf.flush());
        }
        if (!refBuf.isEmpty()) {
            listener.appendText(String.valueOf('%'));
            listener.appendText(refBuf.flush());
        }
        if (!textBuf.isEmpty()) {
            listener.appendText(textBuf.flush());
        }
    }

    @NotNull
    public static String unescape(@NotNull String value) {
        int i;
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(4);
        }
        for (i = 0; i < value.length() && value.charAt(i) != '%'; ++i) {
        }
        if (i == value.length()) {
            String string = value;
            if (string == null) {
                ReferencesResolverUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        CharBuffer result = new CharBuffer(value.length());
        result.append(value, 0, i);
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c != '%') {
                result.append(c);
            } else if (i + 1 < value.length() && value.charAt(i + 1) == '%') {
                result.append(c);
                ++i;
            } else {
                result.append(c);
            }
            ++i;
        }
        String string = result.flush();
        if (string == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String escape(@NotNull String value) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(7);
        }
        if (value.indexOf(37) == -1) {
            String string = value;
            if (string == null) {
                ReferencesResolverUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '%') {
                sb.append('%');
            }
            sb.append(c);
        }
        String string = sb.toString();
        if (string == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static boolean containsReference(@NotNull String value) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(10);
        }
        return ReferencesResolverUtil.containsReference(value, new String[0], false);
    }

    public static boolean containsReference(@NotNull String value, final @NotNull String[] prefixes, final boolean allowAnyCharactersInReferenceName) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(11);
        }
        if (prefixes == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(12);
        }
        final boolean[] hasRefs = new boolean[]{false};
        ReferencesResolverUtil.resolve(value, new ReferencesResolverListener(){

            @Override
            public void appendText(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            public boolean appendReference(@NotNull String referenceKey) {
                if (referenceKey == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!allowAnyCharactersInReferenceName && !ReferencesResolverUtil.isValidReference(referenceKey)) {
                    return false;
                }
                boolean validRef = prefixes.length == 0;
                for (String prefix : prefixes) {
                    if (!referenceKey.startsWith(prefix)) continue;
                    validRef = true;
                    break;
                }
                if (validRef) {
                    hasRefs[0] = true;
                }
                return validRef;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceKey";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/parameters/ReferencesResolverUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return hasRefs[0];
    }

    public static boolean isReference(@NotNull String value) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(13);
        }
        final boolean[] containsText = new boolean[]{false};
        final int[] foundReferenceCount = new int[]{0};
        ReferencesResolverUtil.resolve(value.trim(), new ReferencesExtractor(false){

            @Override
            public void appendText(@NotNull String text) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.appendText(text);
                containsText[0] = true;
            }

            @Override
            public boolean appendReference(@NotNull String referenceKey) {
                boolean res;
                if (referenceKey == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (res = super.appendReference(referenceKey)) {
                    foundReferenceCount[0] = foundReferenceCount[0] + 1;
                }
                return res;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceKey";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/parameters/ReferencesResolverUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return !containsText[0] && foundReferenceCount[0] == 1;
    }

    public static boolean mayContainReference(@NotNull String value) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(14);
        }
        int numMarkers = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != '%' || ++numMarkers < 2) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<String> findParametersReferringToKey(@NotNull Map<String, String> parameters, @NotNull Collection<String> keys) {
        if (parameters == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(15);
        }
        if (keys == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(16);
        }
        HashSet<String> result = new HashSet<String>();
        Set<Map.Entry<String, String>> entries = parameters.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            Set<String> references = ReferencesResolverUtil.getReferences(entry.getValue());
            if (Collections.disjoint(references, keys)) continue;
            result.add(entry.getKey());
        }
        Set<String> set = Collections.unmodifiableSet(result);
        if (set == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(17);
        }
        return set;
    }

    public static Set<String> getReferences(@NotNull String value) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(18);
        }
        return ReferencesResolverUtil.getReferences(value, new String[0], false);
    }

    public static Set<String> getReferences(@NotNull String value, @NotNull String[] prefixes, boolean allowAnyCharactersInReferenceNames) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(19);
        }
        if (prefixes == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(20);
        }
        ReferencesExtractor referencesExtractor = new ReferencesExtractor(allowAnyCharactersInReferenceNames);
        ReferencesResolverUtil.resolve(value, referencesExtractor);
        Set<String> allReferences = referencesExtractor.getReferences();
        if (prefixes.length == 0) {
            return allReferences;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(allReferences.size());
        block0: for (String reference : allReferences) {
            for (String prefix : prefixes) {
                if (!reference.startsWith(prefix)) continue;
                result.add(reference);
                continue block0;
            }
        }
        return result;
    }

    @NotNull
    public static Pair<Boolean, String> getLastElement(@NotNull String value) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(21);
        }
        Pair<Boolean, String> pair = ReferencesResolverUtil.getLastElement(value, new String[0], false);
        if (pair == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(22);
        }
        return pair;
    }

    @NotNull
    public static Pair<Boolean, String> getLastElement(@NotNull String value, final @NotNull String[] prefixes, final boolean allowAnyCharactersInReferenceName) {
        if (value == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(23);
        }
        if (prefixes == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(24);
        }
        final boolean[] lastType = new boolean[1];
        final String[] lastValue = new String[1];
        ReferencesResolverUtil.resolve(value, new ReferencesResolverListener(){

            @Override
            public void appendText(@NotNull String text) {
                if (text == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!lastType[0] && lastValue[0] != null) {
                    lastValue[0] = lastValue[0] + text;
                } else {
                    lastType[0] = false;
                    lastValue[0] = text;
                }
            }

            @Override
            public boolean appendReference(@NotNull String referenceKey) {
                if (referenceKey == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!allowAnyCharactersInReferenceName && !ReferencesResolverUtil.isValidReference(referenceKey)) {
                    return false;
                }
                boolean validRef = prefixes.length == 0;
                for (String prefix : prefixes) {
                    if (!referenceKey.startsWith(prefix)) continue;
                    validRef = true;
                    break;
                }
                if (validRef) {
                    lastType[0] = true;
                    lastValue[0] = referenceKey;
                }
                return validRef;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceKey";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/parameters/ReferencesResolverUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Pair pair = Pair.create((Object)lastType[0], (Object)lastValue[0]);
        if (pair == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(25);
        }
        return pair;
    }

    public static boolean isValidReference(@NotNull String ref) {
        if (ref == null) {
            ReferencesResolverUtil.$$$reportNull$$$0(26);
        }
        if (ref.length() == 0) {
            return false;
        }
        if (ref.indexOf(32) != -1) {
            return false;
        }
        if (ref.startsWith("system.") || ref.startsWith("env.")) {
            return true;
        }
        if (!ReferencesResolverUtil.isASCIILetter(ref.charAt(0))) {
            return false;
        }
        for (int i = 0; i < ref.length(); ++i) {
            char ch = ref.charAt(i);
            if (ReferencesResolverUtil.isASCIILetter(ch) || ReferencesResolverUtil.isNumber(ch) || ch == '_' || ch == '.' || ch == '-' || ch == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean isASCIILetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/parameters/ReferencesResolverUtil";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/parameters/ReferencesResolverUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "makeReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findParametersReferringToKey";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeReference";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 22: 
            case 25: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsReference";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mayContainReference";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findParametersReferringToKey";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLastElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isValidReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CharBuffer {
        private final char[] myBuf;
        private int myPos;

        public CharBuffer(int length) {
            this.myBuf = new char[length];
            this.myPos = 0;
        }

        public void append(char[] src, int startPos, int len) {
            System.arraycopy(src, startPos, this.myBuf, this.myPos, len);
            this.myPos += len;
        }

        public void append(String src, int startPos, int len) {
            src.getChars(startPos, startPos + len, this.myBuf, this.myPos);
            this.myPos += len;
        }

        public void append(char c) {
            this.myBuf[this.myPos++] = c;
        }

        public boolean isEmpty() {
            return this.myPos == 0;
        }

        public String flush() {
            try {
                String string = new String(this.myBuf, 0, this.myPos);
                return string;
            }
            finally {
                this.myPos = 0;
            }
        }
    }

    private static class ReferencesExtractor
    implements ReferencesResolverListener {
        private final Set<String> myReferences = new LinkedHashSet<String>();
        private final boolean myAllowAnyCharactersInReferenceNames;

        private ReferencesExtractor(boolean allowAnyCharactersInReferenceNames) {
            this.myAllowAnyCharactersInReferenceNames = allowAnyCharactersInReferenceNames;
        }

        @Override
        public void appendText(@NotNull String text) {
            if (text == null) {
                ReferencesExtractor.$$$reportNull$$$0(0);
            }
        }

        @Override
        public boolean appendReference(@NotNull String referenceKey) {
            if (referenceKey == null) {
                ReferencesExtractor.$$$reportNull$$$0(1);
            }
            if (!this.myAllowAnyCharactersInReferenceNames && !ReferencesResolverUtil.isValidReference(referenceKey)) {
                return false;
            }
            this.myReferences.add(referenceKey);
            return true;
        }

        public Set<String> getReferences() {
            return this.myReferences;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceKey";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/parameters/ReferencesResolverUtil$ReferencesExtractor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ReferencesResolverListener {
        public void appendText(@NotNull String var1);

        public boolean appendReference(@NotNull String var1);
    }
}

