/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.Map;
import jetbrains.buildServer.parameters.MapParametersProvider;
import jetbrains.buildServer.parameters.ParametersProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LazyCopyMapParametersProvider
implements MapParametersProvider {
    private final ParametersProvider mySource;
    private final MapParametersProvider myDestination;
    private boolean myCopied;

    LazyCopyMapParametersProvider(@NotNull ParametersProvider source, @NotNull MapParametersProvider destination) {
        if (source == null) {
            LazyCopyMapParametersProvider.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            LazyCopyMapParametersProvider.$$$reportNull$$$0(1);
        }
        this.mySource = source;
        this.myDestination = destination;
    }

    @Override
    public void put(@NotNull String key, @NotNull String value) {
        if (key == null) {
            LazyCopyMapParametersProvider.$$$reportNull$$$0(2);
        }
        if (value == null) {
            LazyCopyMapParametersProvider.$$$reportNull$$$0(3);
        }
        this.copy();
        this.myDestination.put(key, value);
    }

    @Override
    @Nullable
    public String remove(@NotNull String key) {
        if (key == null) {
            LazyCopyMapParametersProvider.$$$reportNull$$$0(4);
        }
        this.copy();
        return this.myDestination.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<String, String> fromMap) {
        if (fromMap == null) {
            LazyCopyMapParametersProvider.$$$reportNull$$$0(5);
        }
        this.copy();
        this.myDestination.putAll(fromMap);
    }

    @Override
    @Nullable
    public String get(@NotNull String key) {
        if (key == null) {
            LazyCopyMapParametersProvider.$$$reportNull$$$0(6);
        }
        return this.myCopied ? this.myDestination.get(key) : this.mySource.get(key);
    }

    @Override
    public int size() {
        this.copy();
        return this.myDestination.size();
    }

    @Override
    public Map<String, String> getAll() {
        this.copy();
        return this.myDestination.getAll();
    }

    private void copy() {
        if (this.myCopied) {
            return;
        }
        this.myDestination.putAll(this.mySource.getAll());
        this.myCopied = true;
    }

    public String toString() {
        return super.toString() + (this.myCopied ? " (destination: " + this.myDestination.toString() : " (source: " + this.mySource.toString()) + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromMap";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/parameters/impl/LazyCopyMapParametersProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "putAll";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

