/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.parameters.MapParametersProvider;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.parameters.impl.CompositeParametersProviderImpl;
import jetbrains.buildServer.parameters.impl.LazyCopyMapParametersProvider;
import jetbrains.buildServer.parameters.impl.ProcessingResultImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametersInOut {
    private final String myName;
    private final MapParametersProvider myPartlyResolved;
    private final MapParametersProvider myFullyResolved;
    private final MapParametersProvider myUnresolved;
    private final ParametersProvider myNotFullyResolved;

    public ParametersInOut(@NotNull String name, @NotNull ParametersProvider original, @NotNull jetbrains.buildServer.parameters.impl.ParametersProviderFactory factory) {
        if (name == null) {
            ParametersInOut.$$$reportNull$$$0(0);
        }
        if (original == null) {
            ParametersInOut.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            ParametersInOut.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myPartlyResolved = factory.getParametersProvider();
        this.myFullyResolved = factory.getParametersProvider();
        this.myUnresolved = new LazyCopyMapParametersProvider(original, factory.getParametersProvider());
        CompositeParametersProviderImpl notFullyResolved = new CompositeParametersProviderImpl();
        notFullyResolved.appendParametersProvider(this.myPartlyResolved);
        notFullyResolved.appendParametersProvider(this.myUnresolved);
        this.myNotFullyResolved = notFullyResolved;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public ParametersProvider getUnresolved() {
        MapParametersProvider mapParametersProvider = this.myUnresolved;
        if (mapParametersProvider == null) {
            ParametersInOut.$$$reportNull$$$0(3);
        }
        return mapParametersProvider;
    }

    @NotNull
    public ParametersProvider getFullyResolved() {
        MapParametersProvider mapParametersProvider = this.myFullyResolved;
        if (mapParametersProvider == null) {
            ParametersInOut.$$$reportNull$$$0(4);
        }
        return mapParametersProvider;
    }

    @NotNull
    public ParametersProvider getPartlyResolved() {
        MapParametersProvider mapParametersProvider = this.myPartlyResolved;
        if (mapParametersProvider == null) {
            ParametersInOut.$$$reportNull$$$0(5);
        }
        return mapParametersProvider;
    }

    @NotNull
    public ParametersProvider getNotFullyResolved() {
        ParametersProvider parametersProvider = this.myNotFullyResolved;
        if (parametersProvider == null) {
            ParametersInOut.$$$reportNull$$$0(6);
        }
        return parametersProvider;
    }

    int resolveParametersInSinglePass(@NotNull ParametersProvider dictionary, @NotNull ParameterResolver processor, @Nullable StopPredicate stop) {
        if (dictionary == null) {
            ParametersInOut.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            ParametersInOut.$$$reportNull$$$0(8);
        }
        int resolvedCount = 0;
        for (Map.Entry<String, String> parameter : this.getNotFullyResolved().getAll().entrySet()) {
            String key = parameter.getKey();
            String value = parameter.getValue();
            assert (key != null) : "Parameter has null key. Value='" + value + "'";
            assert (value != null) : "Parameter with key='" + key + "'has null value.";
            ProcessingResult evalResult = processor.resolve(key, value, dictionary);
            if (evalResult.isFullyResolved()) {
                this.markAsFullyResolved(key, evalResult.getResult());
                ++resolvedCount;
                if (stop == null || !stop.call()) continue;
                break;
            }
            if (!evalResult.isModified()) continue;
            this.markAsPartlyResolved(key, evalResult.getResult());
        }
        return resolvedCount;
    }

    void resolvingFinished() {
        for (MapParametersProvider provider : Arrays.asList(this.myFullyResolved, this.myPartlyResolved, this.myUnresolved)) {
            HashMap<String, String> allParams = new HashMap<String, String>(provider.getAll());
            for (Map.Entry entry : allParams.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null) continue;
                entry.setValue(ReferencesResolverUtil.unescape(value));
            }
            provider.putAll(allParams);
        }
    }

    public void markAsFullyResolved(@NotNull String key, @NotNull String resolvedValue) {
        if (key == null) {
            ParametersInOut.$$$reportNull$$$0(9);
        }
        if (resolvedValue == null) {
            ParametersInOut.$$$reportNull$$$0(10);
        }
        this.myFullyResolved.put(key, resolvedValue);
        this.myUnresolved.remove(key);
        this.myPartlyResolved.remove(key);
    }

    public void markAsPartlyResolved(@NotNull String key, @NotNull String partlyResolvedValue) {
        if (key == null) {
            ParametersInOut.$$$reportNull$$$0(11);
        }
        if (partlyResolvedValue == null) {
            ParametersInOut.$$$reportNull$$$0(12);
        }
        this.myPartlyResolved.put(key, partlyResolvedValue);
        this.myUnresolved.remove(key);
    }

    @NotNull
    public ParametersProvider getAllParameters() {
        CompositeParametersProviderImpl result = new CompositeParametersProviderImpl();
        result.appendParametersProvider(this.myFullyResolved);
        result.appendParametersProvider(this.myPartlyResolved);
        result.appendParametersProvider(this.myUnresolved);
        CompositeParametersProviderImpl compositeParametersProviderImpl = result;
        if (compositeParametersProviderImpl == null) {
            ParametersInOut.$$$reportNull$$$0(13);
        }
        return compositeParametersProviderImpl;
    }

    @NotNull
    public ProcessingResult createProcessingResult(@NotNull String key, @NotNull String origValue) {
        String resultValue;
        if (key == null) {
            ParametersInOut.$$$reportNull$$$0(14);
        }
        if (origValue == null) {
            ParametersInOut.$$$reportNull$$$0(15);
        }
        if ((resultValue = this.myFullyResolved.get(key)) == null) {
            String partlyResolved = this.myPartlyResolved.get(key);
            if (partlyResolved == null) {
                partlyResolved = this.myUnresolved.get(key);
            }
            assert (partlyResolved != null);
            ProcessingResultImpl processingResultImpl = new ProcessingResultImpl(partlyResolved, !origValue.equals(partlyResolved), false);
            if (processingResultImpl == null) {
                ParametersInOut.$$$reportNull$$$0(16);
            }
            return processingResultImpl;
        }
        ProcessingResultImpl processingResultImpl = new ProcessingResultImpl(resultValue, !origValue.equals(resultValue), true);
        if (processingResultImpl == null) {
            ParametersInOut.$$$reportNull$$$0(17);
        }
        return processingResultImpl;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("name: ").append(this.getName()).append(",  ");
        result.append("unresolved: ").append(this.getUnresolved()).append(",  ");
        result.append("partly resolved: ").append(this.getPartlyResolved());
        result.append("fully resolved: ").append(this.getFullyResolved());
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/parameters/impl/ParametersInOut";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partlyResolvedValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/parameters/impl/ParametersInOut";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolved";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullyResolved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartlyResolved";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFullyResolved";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllParameters";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessingResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveParametersInSinglePass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "markAsFullyResolved";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "markAsPartlyResolved";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createProcessingResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface StopPredicate {
        public boolean call();
    }

    @Deprecated
    public static interface ParametersProviderFactory
    extends jetbrains.buildServer.parameters.impl.ParametersProviderFactory {
    }
}

