/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.impl.ChainResolver;
import jetbrains.buildServer.parameters.impl.CompositeParametersProviderImpl;
import jetbrains.buildServer.parameters.impl.ParametersInOut;
import jetbrains.buildServer.parameters.impl.ReferenceResolver;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametersInOutList {
    @NotNull
    private final List<ParametersInOut> myList = new ArrayList<ParametersInOut>();
    private boolean myUsePerParameterPredicate = false;

    public void addParameters(@NotNull ParametersInOut parametersInOut) {
        if (parametersInOut == null) {
            ParametersInOutList.$$$reportNull$$$0(0);
        }
        this.myList.add(parametersInOut);
    }

    void setUsePerParameterPredicate(boolean usePerParameterPredicate) {
        this.myUsePerParameterPredicate = usePerParameterPredicate;
    }

    public void resolveParameters(@NotNull ParameterResolver resolver, @Nullable String resultName) {
        if (resolver == null) {
            ParametersInOutList.$$$reportNull$$$0(1);
        }
        this.performProcessing(resolver, this.fullyResolvedConsideringUnresolved(), resultName, false);
        this.performProcessing(resolver, this.allFullyResolved(), resultName, false);
        this.performProcessing(resolver, this.allFullyResolvedAndPartiallyResolved(), resultName, true);
        ParameterResolver customResolver = this.createCustomInvalidRefsResolver(resolver);
        this.performProcessing(customResolver, this.allFullyResolved(), resultName, false);
        for (ParametersInOut paramList : this.myList) {
            if (resultName != null && !paramList.getName().equals(resultName)) continue;
            paramList.resolvingFinished();
        }
    }

    private ParameterResolver createCustomInvalidRefsResolver(ParameterResolver currentResolver) {
        ReferenceResolver invalidRefsResolver = new ReferenceResolver(true);
        if (currentResolver instanceof ChainResolver) {
            List<ParameterResolver> resolvers = ((ChainResolver)currentResolver).getResolvers();
            ChainResolver result = new ChainResolver();
            for (ParameterResolver resolver : resolvers) {
                if (resolver instanceof ReferenceResolver) {
                    result.append(invalidRefsResolver);
                    continue;
                }
                result.append(resolver);
            }
            return result;
        }
        if (currentResolver instanceof ReferenceResolver) {
            return invalidRefsResolver;
        }
        ChainResolver chainResolver = new ChainResolver();
        chainResolver.append(invalidRefsResolver);
        chainResolver.append(currentResolver);
        return chainResolver;
    }

    private void performProcessing(@NotNull ParameterResolver resolver, @NotNull ParametersProvider dictionary, @Nullable String resultName, boolean runAtLeastTwice) {
        if (resolver == null) {
            ParametersInOutList.$$$reportNull$$$0(2);
        }
        if (dictionary == null) {
            ParametersInOutList.$$$reportNull$$$0(3);
        }
        ParametersInOut.StopPredicate stop = this.getStopPredicate(resultName);
        while (!this.isAllResolved(resultName)) {
            int resolvedInSinglePass = 0;
            for (ParametersInOut params : this.myList) {
                resolvedInSinglePass += params.resolveParametersInSinglePass(dictionary, resolver, stop);
            }
            if (resolvedInSinglePass != 0) continue;
            if (!runAtLeastTwice) break;
            runAtLeastTwice = false;
        }
    }

    @Nullable
    private ParametersInOut.StopPredicate getStopPredicate(final String resultName) {
        boolean usePredicate = TeamCityProperties.getBooleanOrTrue("teamcity.parameterResolve.usePerParameterPredicate");
        if (!usePredicate) {
            return null;
        }
        if (!this.myUsePerParameterPredicate) {
            return null;
        }
        return new ParametersInOut.StopPredicate(){

            @Override
            public boolean call() {
                return ParametersInOutList.this.isAllResolved(resultName);
            }
        };
    }

    private boolean isAllResolved(@Nullable String resultName) {
        for (ParametersInOut parametersInOut : this.myList) {
            if (resultName != null && !parametersInOut.getName().equals(resultName) || parametersInOut.getNotFullyResolved().size() <= 0) continue;
            return false;
        }
        return true;
    }

    private ParametersProvider allFullyResolved() {
        CompositeParametersProviderImpl result = new CompositeParametersProviderImpl();
        for (ParametersInOut parametersInOut : this.myList) {
            result.appendParametersProvider(parametersInOut.getFullyResolved());
        }
        return result;
    }

    private ParametersProvider allFullyResolvedAndPartiallyResolved() {
        CompositeParametersProviderImpl result = new CompositeParametersProviderImpl();
        for (ParametersInOut parametersInOut : this.myList) {
            result.appendParametersProvider(parametersInOut.getFullyResolved());
            result.appendParametersProvider(parametersInOut.getPartlyResolved());
        }
        return result;
    }

    private ParametersProvider fullyResolvedConsideringUnresolved() {
        return new ParametersProvider(){

            @Override
            public String get(@NotNull String key) {
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (ParametersInOut parametersInOut : ParametersInOutList.this.myList) {
                    String parameter = parametersInOut.getFullyResolved().get(key);
                    if (parameter != null) {
                        return parameter;
                    }
                    if (parametersInOut.getNotFullyResolved().get(key) == null) continue;
                    return null;
                }
                return null;
            }

            @Override
            public int size() {
                return this.getAll().size();
            }

            @Override
            public Map<String, String> getAll() {
                HashMap<String, String> result = new HashMap<String, String>();
                CompositeParametersProviderImpl excluded = new CompositeParametersProviderImpl();
                for (ParametersInOut parametersInOut : ParametersInOutList.this.myList) {
                    ParametersInOutList.addFiltered(result, parametersInOut.getFullyResolved().getAll(), excluded);
                    excluded.appendParametersProvider(parametersInOut.getNotFullyResolved());
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/ParametersInOutList$2", "get"));
            }
        };
    }

    private static void addFiltered(Map<String, String> to, Map<String, String> from, ParametersProvider toExclude) {
        for (Map.Entry<String, String> parameter : from.entrySet()) {
            String key = parameter.getKey();
            if (to.get(key) != null || toExclude.get(key) != null) continue;
            to.put(key, parameter.getValue());
        }
    }

    public String toString() {
        return super.toString() + " (" + this.myList.toString() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersInOut";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/parameters/impl/ParametersInOutList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveParameters";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performProcessing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

