/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.requirements;

import java.util.Map;
import jetbrains.buildServer.requirements.RequirementQualifier;
import jetbrains.buildServer.requirements.RequirementType;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Requirement {
    private final String myId;
    private final String myPropertyName;
    private final String myPropertyValue;
    private final RequirementType myType;

    public Requirement(@NotNull String propertyName, @Nullable String propertyValue, @NotNull RequirementType type) {
        if (propertyName == null) {
            Requirement.$$$reportNull$$$0(0);
        }
        if (type == null) {
            Requirement.$$$reportNull$$$0(1);
        }
        this.myPropertyName = propertyName;
        this.myPropertyValue = propertyValue;
        this.myType = type;
        this.myId = null;
    }

    public Requirement(@NotNull String id, @NotNull String propertyName, @Nullable String propertyValue, @NotNull RequirementType type) {
        if (id == null) {
            Requirement.$$$reportNull$$$0(2);
        }
        if (propertyName == null) {
            Requirement.$$$reportNull$$$0(3);
        }
        if (type == null) {
            Requirement.$$$reportNull$$$0(4);
        }
        this.myId = id;
        this.myPropertyName = propertyName;
        this.myPropertyValue = propertyValue;
        this.myType = type;
    }

    public final boolean match(@NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
        if (properties == null) {
            Requirement.$$$reportNull$$$0(5);
        }
        RequirementQualifier qualifier = RequirementQualifier.getQualifierFor(this);
        return qualifier.match(this, properties, ignoreCaseForEnv);
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            Requirement.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    @NotNull
    public RequirementType getType() {
        RequirementType requirementType = this.myType;
        if (requirementType == null) {
            Requirement.$$$reportNull$$$0(7);
        }
        return requirementType;
    }

    @Nullable
    public String getPropertyValue() {
        return this.myPropertyValue;
    }

    public String getUserDescription() {
        return this.getPropertyName() + " " + this.getType().getDisplayName() + (this.getType().isParameterRequired() ? " " + StringUtil.emptyIfNull(this.getPropertyValue()) : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Requirement req = (Requirement)o;
        if (!this.myPropertyName.equals(req.myPropertyName)) {
            return false;
        }
        if (!this.myType.equals((Object)req.myType)) {
            return false;
        }
        if (this.myPropertyValue != null ? !this.myPropertyValue.equals(req.myPropertyValue) : req.myPropertyValue != null) {
            return false;
        }
        return this.myId != null ? this.myId.equals(req.myId) : req.myId == null;
    }

    public boolean isSimilarTo(Requirement req) {
        if (this == req) {
            return true;
        }
        if (req == null) {
            return false;
        }
        if (!this.myPropertyName.equals(req.myPropertyName)) {
            return false;
        }
        if (this.myPropertyValue != null ? !this.myPropertyValue.equals(req.myPropertyValue) : req.myPropertyValue != null) {
            return false;
        }
        return this.myType.equals((Object)req.myType);
    }

    public int hashCode() {
        int result = this.myPropertyName.hashCode();
        result = 29 * result + (this.myPropertyValue != null ? this.myPropertyValue.hashCode() : 0);
        result = 29 * result + this.myType.hashCode();
        if (null != this.myId) {
            result = 29 * result + this.myId.hashCode();
        }
        return result;
    }

    public Requirement newPropertyName(String newName) {
        return new Requirement(newName, this.getPropertyValue(), this.getType());
    }

    public String toString() {
        return String.format("Requirement {id = %s, %s %s %s}", this.getId(), this.myPropertyName, this.myType.getDisplayName(), null == this.myPropertyValue ? "" : this.myPropertyValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/requirements/Requirement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/requirements/Requirement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

