/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.requirements;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.requirements.Requirement;
import jetbrains.buildServer.requirements.RequirementMatcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RequirementQualifier {
    EXACT{

        @Override
        @NotNull
        public RequirementMatcher createRequirementMatcher(@NotNull Requirement requirement) {
            String name;
            if (requirement == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((name = requirement.getPropertyName()).startsWith(RequirementQualifier.EXACT_QUALIFIER)) {
                requirement = RequirementQualifier.copyRequirementWithNewName(requirement, name.substring(RequirementQualifier.EXACT_QUALIFIER.length()));
            }
            final RequirementMatcher matcher = requirement.getType().createRequirementMatcher(requirement);
            RequirementMatcher requirementMatcher = new RequirementMatcher(){

                @Override
                public boolean match(@NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
                    if (properties == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return matcher.match(properties, ignoreCaseForEnv);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/requirements/RequirementQualifier$1$1", "match"));
                }
            };
            if (requirementMatcher == null) {
                1.$$$reportNull$$$0(1);
            }
            return requirementMatcher;
        }

        @Override
        public boolean matchRequirement(Requirement requirement) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requirement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/requirements/RequirementQualifier$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/requirements/RequirementQualifier$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequirementMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createRequirementMatcher";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    EXISTS{

        @Override
        @NotNull
        public RequirementMatcher createRequirementMatcher(final @NotNull Requirement requirement) {
            RequirementMatcher requirementMatcher;
            block5: {
                if (requirement == null) {
                    2.$$$reportNull$$$0(0);
                }
                String key = RequirementQualifier.splitKey(requirement.getPropertyName(), RequirementQualifier.EXISTS_QUALIFIER);
                assert (key != null);
                try {
                    final Pattern keyPattern = Pattern.compile(key);
                    requirementMatcher = new RequirementMatcher(){

                        @Override
                        public boolean match(@NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
                            if (properties == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            for (String prop : properties.keySet()) {
                                Requirement patchedRequirement;
                                if (!keyPattern.matcher(prop).matches() || !(patchedRequirement = RequirementQualifier.copyRequirementWithNewName(requirement, prop)).getType().match(patchedRequirement, properties, ignoreCaseForEnv)) continue;
                                return true;
                            }
                            return false;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/requirements/RequirementQualifier$2$1", "match"));
                        }
                    };
                    if (requirementMatcher != null) break block5;
                }
                catch (PatternSyntaxException e) {
                    Loggers.SERVER.warn("Invalid regexp " + key + ": " + e.toString());
                    RequirementMatcher requirementMatcher2 = new RequirementMatcher(){

                        @Override
                        public boolean match(@NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
                            if (properties == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return false;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/requirements/RequirementQualifier$2$2", "match"));
                        }
                    };
                    if (requirementMatcher2 == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return requirementMatcher2;
                }
                2.$$$reportNull$$$0(1);
            }
            return requirementMatcher;
        }

        @Override
        public boolean matchRequirement(Requirement requirement) {
            String name = requirement.getPropertyName();
            return name.startsWith(RequirementQualifier.EXISTS_QUALIFIER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requirement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/requirements/RequirementQualifier$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/requirements/RequirementQualifier$2";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequirementMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createRequirementMatcher";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    ANY{

        @Override
        @NotNull
        public RequirementMatcher createRequirementMatcher(final @NotNull Requirement requirement) {
            RequirementMatcher requirementMatcher;
            block5: {
                if (requirement == null) {
                    3.$$$reportNull$$$0(0);
                }
                String key = RequirementQualifier.splitKey(requirement.getPropertyName(), RequirementQualifier.ANY_QUALIFIER);
                assert (key != null);
                try {
                    final Pattern keyPattern = Pattern.compile(key);
                    requirementMatcher = new RequirementMatcher(){

                        @Override
                        public boolean match(@NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
                            if (properties == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            for (String prop : properties.keySet()) {
                                Requirement patchedRequirement;
                                if (!keyPattern.matcher(prop).matches() || (patchedRequirement = RequirementQualifier.copyRequirementWithNewName(requirement, prop)).getType().match(patchedRequirement, properties, ignoreCaseForEnv)) continue;
                                return false;
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/requirements/RequirementQualifier$3$1", "match"));
                        }
                    };
                    if (requirementMatcher != null) break block5;
                }
                catch (PatternSyntaxException e) {
                    Loggers.SERVER.warn("Invalid regexp " + key + ": " + e.toString());
                    RequirementMatcher requirementMatcher2 = new RequirementMatcher(){

                        @Override
                        public boolean match(@NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
                            if (properties == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return false;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/requirements/RequirementQualifier$3$2", "match"));
                        }
                    };
                    if (requirementMatcher2 == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return requirementMatcher2;
                }
                3.$$$reportNull$$$0(1);
            }
            return requirementMatcher;
        }

        @Override
        public boolean matchRequirement(Requirement requirement) {
            String name = requirement.getPropertyName();
            return name.startsWith(RequirementQualifier.ANY_QUALIFIER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requirement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/requirements/RequirementQualifier$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/requirements/RequirementQualifier$3";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequirementMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createRequirementMatcher";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NonNls
    public static final String SPLITTER = "=>";
    @NonNls
    public static final String ANY_QUALIFIER = "Any=>";
    @NonNls
    public static final String EXISTS_QUALIFIER = "Exists=>";
    @NonNls
    public static final String EXACT_QUALIFIER = "Exact=>";

    public boolean match(Requirement requirement, Map<String, String> properties, boolean ignoreCaseForEnv) {
        return this.createRequirementMatcher(requirement).match(properties, ignoreCaseForEnv);
    }

    @NotNull
    public abstract RequirementMatcher createRequirementMatcher(@NotNull Requirement var1);

    public abstract boolean matchRequirement(Requirement var1);

    private static Requirement copyRequirementWithNewName(Requirement requirement, String newName) {
        return new Requirement(newName, requirement.getPropertyValue(), requirement.getType());
    }

    @Nullable
    private static String splitKey(String key, String qualifier) {
        if (!key.startsWith(qualifier)) {
            return null;
        }
        return key.substring(qualifier.length());
    }

    @NotNull
    public static RequirementQualifier getQualifierFor(Requirement requirement) {
        for (RequirementQualifier qualifier : RequirementQualifier.values()) {
            if (!qualifier.matchRequirement(requirement)) continue;
            RequirementQualifier requirementQualifier = qualifier;
            if (requirementQualifier == null) {
                RequirementQualifier.$$$reportNull$$$0(0);
            }
            return requirementQualifier;
        }
        RequirementQualifier requirementQualifier = EXACT;
        if (requirementQualifier == null) {
            RequirementQualifier.$$$reportNull$$$0(1);
        }
        return requirementQualifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementQualifier", "getQualifierFor"));
    }
}

