/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.requirements;

import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.requirements.Requirement;
import jetbrains.buildServer.requirements.RequirementType;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequirementRegistry {
    private final Map<String, RequirementType> myRequirementTypes = new HashMap<String, RequirementType>();
    private static final RequirementRegistry ourInstance = new RequirementRegistry();

    public static RequirementRegistry getRegistry() {
        return ourInstance;
    }

    public void register(RequirementType requirementType) {
        this.myRequirementTypes.put(requirementType.getName(), requirementType);
    }

    @Nullable
    public RequirementType getType(@NotNull String typeName) {
        if (typeName == null) {
            RequirementRegistry.$$$reportNull$$$0(0);
        }
        return this.myRequirementTypes.get(typeName);
    }

    @Nullable
    public Requirement read(@NotNull Element element) {
        String name;
        if (element == null) {
            RequirementRegistry.$$$reportNull$$$0(1);
        }
        if ((name = element.getName()) != null && this.myRequirementTypes.containsKey(name)) {
            RequirementType requirementType = this.myRequirementTypes.get(name);
            return requirementType.readFrom(element);
        }
        return null;
    }

    static {
        for (RequirementType reqType : RequirementType.ALL_REQUIREMENT_TYPES) {
            RequirementRegistry.getRegistry().register(reqType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/requirements/RequirementRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

