/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.requirements;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.requirements.Requirement;
import jetbrains.buildServer.requirements.RequirementMatcher;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.VersionComparatorUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RequirementType {
    EXISTS("exists", "exists", false, true){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return value != null;
                }
            };
            if (valueMatcher == null) {
                1.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        @Override
        public boolean isParameterRequired() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$1", "createMatcher"));
        }
    }
    ,
    NOT_EXISTS("not-exists", "does not exist", false, true){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return value == null;
                }
            };
            if (valueMatcher == null) {
                2.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        @Override
        public boolean isParameterRequired() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$2", "createMatcher"));
        }
    }
    ,
    EQUALS("equals", "equals", true, true){

        @Override
        @NotNull
        public ValueMatcher createMatcher(final String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return requirementParameter.equals(value);
                }
            };
            if (valueMatcher == null) {
                3.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        @Override
        public boolean isParameterCanBeEmpty() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$3", "createMatcher"));
        }
    }
    ,
    DOES_NOT_EQUAL("does-not-equal", "does not equal", false, true){

        @Override
        @NotNull
        public ValueMatcher createMatcher(final String requirementParameter) {
            if (requirementParameter.length() == 0) {
                ValueMatcher valueMatcher = new ValueMatcher(){

                    @Override
                    public boolean matchValue(String value) {
                        return !StringUtil.isEmpty((String)value);
                    }
                };
                if (valueMatcher == null) {
                    4.$$$reportNull$$$0(0);
                }
                return valueMatcher;
            }
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return !requirementParameter.equals(value);
                }
            };
            if (valueMatcher == null) {
                4.$$$reportNull$$$0(1);
            }
            return valueMatcher;
        }

        @Override
        public boolean isParameterCanBeEmpty() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$4", "createMatcher"));
        }
    }
    ,
    MORE_THAN("more-than", "is more than", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            final double compareTo = Double.parseDouble(requirementParameter);
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return Double.parseDouble(value) > compareTo;
                }
            };
            if (valueMatcher == null) {
                5.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$5", "createMatcher"));
        }
    }
    ,
    NO_MORE_THAN("no-more-than", "is not more than", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            final double compareTo = Double.parseDouble(requirementParameter);
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return Double.parseDouble(value) <= compareTo;
                }
            };
            if (valueMatcher == null) {
                6.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$6", "createMatcher"));
        }
    }
    ,
    LESS_THAN("less-than", "is less than", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            final double compareTo = Double.parseDouble(requirementParameter);
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return Double.parseDouble(value) < compareTo;
                }
            };
            if (valueMatcher == null) {
                7.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$7", "createMatcher"));
        }
    }
    ,
    NO_LESS_THAN("no-less-than", "is not less than", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            final double compareTo = Double.parseDouble(requirementParameter);
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return Double.parseDouble(value) >= compareTo;
                }
            };
            if (valueMatcher == null) {
                8.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$8", "createMatcher"));
        }
    }
    ,
    STARTS_WITH("starts-with", "starts with", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(final String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return value.startsWith(requirementParameter);
                }
            };
            if (valueMatcher == null) {
                9.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$9", "createMatcher"));
        }
    }
    ,
    CONTAINS("contains", "contains", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(final String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return value.indexOf(requirementParameter) >= 0;
                }
            };
            if (valueMatcher == null) {
                10.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$10", "createMatcher"));
        }
    }
    ,
    DOES_NOT_CONTAIN("does-not-contain", "does not contain", false, true){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            final ValueMatcher containsMatcher = CONTAINS.createMatcher(requirementParameter);
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return value == null || !containsMatcher.matchValue(value);
                }
            };
            if (valueMatcher == null) {
                11.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$11", "createMatcher"));
        }
    }
    ,
    ENDS_WITH("ends-with", "ends with", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(final String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return value.endsWith(requirementParameter);
                }
            };
            if (valueMatcher == null) {
                12.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$12", "createMatcher"));
        }
    }
    ,
    MATCHES("matches", "matches", true, true){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            ValueMatcher valueMatcher;
            block3: {
                try {
                    final Pattern pattern = Pattern.compile(requirementParameter);
                    valueMatcher = new ValueMatcher(){

                        @Override
                        public boolean matchValue(String value) {
                            return pattern.matcher(value).matches();
                        }
                    };
                    if (valueMatcher != null) break block3;
                }
                catch (PatternSyntaxException e) {
                    Loggers.SERVER.warn("Invalid regexp " + requirementParameter + ": " + e.toString());
                    ValueMatcher valueMatcher2 = new ValueMatcher(){

                        @Override
                        public boolean matchValue(String value) {
                            return false;
                        }
                    };
                    if (valueMatcher2 == null) {
                        13.$$$reportNull$$$0(1);
                    }
                    return valueMatcher2;
                }
                13.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$13", "createMatcher"));
        }
    }
    ,
    DOES_NOT_MATCH("does-not-match", "does not match", false, true){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            final ValueMatcher matchesMatcher = MATCHES.createMatcher(requirementParameter);
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return value == null || !matchesMatcher.matchValue(value);
                }
            };
            if (valueMatcher == null) {
                14.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$14", "createMatcher"));
        }
    }
    ,
    VER_MORE_THAN("ver-more-than", "version is more than", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(final String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return VersionComparatorUtil.compare(value, requirementParameter) > 0;
                }
            };
            if (valueMatcher == null) {
                15.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$15", "createMatcher"));
        }
    }
    ,
    VER_NO_MORE_THAN("ver-no-more-than", "version is not more than", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(final String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return VersionComparatorUtil.compare(value, requirementParameter) <= 0;
                }
            };
            if (valueMatcher == null) {
                16.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$16", "createMatcher"));
        }
    }
    ,
    VER_LESS_THAN("ver-less-than", "version is less than", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(final String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return VersionComparatorUtil.compare(value, requirementParameter) < 0;
                }
            };
            if (valueMatcher == null) {
                17.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$17", "createMatcher"));
        }
    }
    ,
    VER_NO_LESS_THAN("ver-no-less-than", "version is not less than", true, false){

        @Override
        @NotNull
        public ValueMatcher createMatcher(final String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return VersionComparatorUtil.compare(value, requirementParameter) >= 0;
                }
            };
            if (valueMatcher == null) {
                18.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$18", "createMatcher"));
        }
    }
    ,
    ANY("any", "any value (parameter is not required)", false, true){

        @Override
        @NotNull
        public ValueMatcher createMatcher(String requirementParameter) {
            ValueMatcher valueMatcher = new ValueMatcher(){

                @Override
                public boolean matchValue(String value) {
                    return true;
                }
            };
            if (valueMatcher == null) {
                19.$$$reportNull$$$0(0);
            }
            return valueMatcher;
        }

        @Override
        public boolean isParameterRequired() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/requirements/RequirementType$19", "createMatcher"));
        }
    };

    private final String myName;
    private final String myDisplayName;
    private final boolean myValueRequired;
    private final boolean myValueCanBeEmpty;
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    public static final List<RequirementType> ALL_REQUIREMENT_TYPES;

    private RequirementType(String name, String displayName, boolean valueRequired, boolean valueCanBeEmpty) {
        this.myName = name;
        this.myDisplayName = displayName;
        this.myValueRequired = valueRequired;
        this.myValueCanBeEmpty = valueCanBeEmpty;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public final String getName() {
        return this.myName;
    }

    @Nullable
    public Requirement readFrom(Element xmlElement) {
        String propName = xmlElement.getAttributeValue(NAME);
        String propValue = xmlElement.getAttributeValue(VALUE);
        if (propName == null) {
            return null;
        }
        if (this.isParameterRequired() && propValue == null) {
            return null;
        }
        return this.readInternal(propName, propValue);
    }

    public void writeTo(Element xmlElement, Requirement requirementParameter) {
        Element contentElement = new Element(this.getName());
        xmlElement.addContent((Content)contentElement);
        if (requirementParameter.getId() != null) {
            contentElement.setAttribute(ID, requirementParameter.getId());
        }
        contentElement.setAttribute(NAME, requirementParameter.getPropertyName());
        if (this.isParameterRequired()) {
            contentElement.setAttribute(VALUE, requirementParameter.getPropertyValue());
        }
    }

    @Nullable
    public static RequirementType findByName(String name) {
        for (RequirementType rt : ALL_REQUIREMENT_TYPES) {
            if (!rt.getName().equals(name)) continue;
            return rt;
        }
        return null;
    }

    protected Requirement readInternal(String propName, String propValue) {
        return new Requirement(propName, propValue, this);
    }

    public boolean isParameterRequired() {
        return true;
    }

    public boolean isParameterCanBeEmpty() {
        return !this.isParameterRequired();
    }

    public boolean isActualValueRequired() {
        return this.myValueRequired;
    }

    public boolean isActualValueCanBeEmpty() {
        return this.myValueCanBeEmpty;
    }

    public boolean matchValues(String requirementParameter, String actualValue) {
        return this.createMatcher(requirementParameter).matchValue(actualValue);
    }

    @NotNull
    protected abstract ValueMatcher createMatcher(String var1);

    @NotNull
    public RequirementMatcher createRequirementMatcher(final @NotNull Requirement requirement) {
        RequirementMatcher requirementMatcher;
        block7: {
            String reqParam;
            block6: {
                RequirementMatcher requirementMatcher2;
                if (requirement == null) {
                    RequirementType.$$$reportNull$$$0(0);
                }
                try {
                    reqParam = requirement.getPropertyValue();
                    if (this.checkRequirementParameter(reqParam)) break block6;
                    requirementMatcher2 = this.nothingMatched();
                }
                catch (Exception e) {
                    RequirementMatcher requirementMatcher3 = this.nothingMatched();
                    if (requirementMatcher3 == null) {
                        RequirementType.$$$reportNull$$$0(3);
                    }
                    return requirementMatcher3;
                }
                if (requirementMatcher2 == null) {
                    RequirementType.$$$reportNull$$$0(1);
                }
                return requirementMatcher2;
            }
            final ValueMatcher matcher = this.createMatcher(reqParam);
            requirementMatcher = new RequirementMatcher(){

                @Override
                public boolean match(@NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
                    if (properties == null) {
                        20.$$$reportNull$$$0(0);
                    }
                    try {
                        String value;
                        PropDesc propDesc = RequirementType.getProp(requirement.getPropertyName(), properties, ignoreCaseForEnv);
                        if (RequirementType.this.isActualValueRequired() && (propDesc == null || propDesc.myValue == null)) {
                            return false;
                        }
                        String string = value = propDesc == null ? null : propDesc.myValue;
                        if (!(RequirementType.this.isActualValueCanBeEmpty() || value != null && value.length() != 0)) {
                            return false;
                        }
                        return matcher.matchValue(value);
                    }
                    catch (Exception e) {
                        return false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/requirements/RequirementType$20", "match"));
                }
            };
            if (requirementMatcher != null) break block7;
            RequirementType.$$$reportNull$$$0(2);
        }
        return requirementMatcher;
    }

    @NotNull
    private RequirementMatcher nothingMatched() {
        RequirementMatcher requirementMatcher = new RequirementMatcher(){

            @Override
            public boolean match(@NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
                if (properties == null) {
                    21.$$$reportNull$$$0(0);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/requirements/RequirementType$21", "match"));
            }
        };
        if (requirementMatcher == null) {
            RequirementType.$$$reportNull$$$0(4);
        }
        return requirementMatcher;
    }

    public boolean match(@NotNull Requirement requirement, @NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
        if (requirement == null) {
            RequirementType.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            RequirementType.$$$reportNull$$$0(6);
        }
        return this.createRequirementMatcher(requirement).match(properties, ignoreCaseForEnv);
    }

    private boolean checkRequirementParameter(String reqValue) {
        if (this.isParameterRequired() && reqValue == null) {
            return false;
        }
        return this.isParameterCanBeEmpty() || reqValue != null && reqValue.length() != 0;
    }

    @Nullable
    private static PropDesc getProp(@NotNull String propName, @NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
        if (propName == null) {
            RequirementType.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            RequirementType.$$$reportNull$$$0(8);
        }
        PropDesc result = null;
        String value = properties.get(propName);
        if (value != null) {
            return new PropDesc(propName, value);
        }
        if (ignoreCaseForEnv && propName.startsWith("env.")) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith("env.") || key.compareToIgnoreCase(propName) != 0) continue;
                result = new PropDesc(key, entry.getValue());
                break;
            }
        }
        return result;
    }

    static {
        ALL_REQUIREMENT_TYPES = Arrays.asList(RequirementType.class.getEnumConstants());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/requirements/RequirementType";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/requirements/RequirementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequirementMatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "nothingMatched";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRequirementMatcher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface ValueMatcher {
        public boolean matchValue(String var1);
    }

    private static class PropDesc {
        @NotNull
        public final String myName;
        @Nullable
        public final String myValue;

        private PropDesc(@NotNull String name, @Nullable String value) {
            if (name == null) {
                PropDesc.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myValue = value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RequirementType.NAME, "jetbrains/buildServer/requirements/RequirementType$PropDesc", "<init>"));
        }
    }
}

