/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.runner;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jetbrains.buildServer.RunBuildException;
import jetbrains.buildServer.agent.AgentRuntimeProperties;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.PropertiesUtil;
import org.jetbrains.annotations.NotNull;

public class BuildFileRunnerUtil {
    private static final Logger LOG = Logger.getInstance((String)BuildFileRunnerUtil.class.getName());

    private BuildFileRunnerUtil() {
    }

    public static boolean isCustomBuildFileUsed(Map<String, String> runParameters) {
        return PropertiesUtil.getBoolean(runParameters.get("use-custom-build-file"));
    }

    @NotNull
    public static File getBuildFile(@NotNull Map<String, String> runParameters) throws RunBuildException {
        if (runParameters == null) {
            BuildFileRunnerUtil.$$$reportNull$$$0(0);
        }
        boolean useCustomBuildFile = BuildFileRunnerUtil.isCustomBuildFileUsed(runParameters);
        File checkoutDir = new File(AgentRuntimeProperties.getCheckoutDir(runParameters));
        if (useCustomBuildFile) {
            File file;
            String buildFileContent = runParameters.get("build-file");
            if (PropertiesUtil.isEmptyOrNull(buildFileContent)) {
                throw new RunBuildException("Build file content is not specified. Please review build configuration settings and check whether build file is correct.");
            }
            try {
                File tempFile = File.createTempFile("build", null, checkoutDir);
                FileUtil.writeFile(tempFile, buildFileContent);
                file = tempFile;
            }
            catch (IOException e) {
                LOG.error("Failed to create build file in the directory: " + checkoutDir);
                throw new RuntimeException(e);
            }
            if (file == null) {
                BuildFileRunnerUtil.$$$reportNull$$$0(1);
            }
            return file;
        }
        String buildFilePath = runParameters.get("build-file-path");
        if (PropertiesUtil.isEmptyOrNull(buildFilePath)) {
            throw new RunBuildException("Build file path is not specified. Please review build configuration settings and check the build file path parameter.");
        }
        File buildFile = FileUtil.resolvePath(checkoutDir, buildFilePath);
        if (!buildFile.isFile()) {
            throw new RunBuildException("Cannot find build file by path specified in build configuration settings: '" + buildFile.getAbsolutePath() + "' (absolute path on agent). Please check that specified path is correct.");
        }
        File file = buildFile;
        if (file == null) {
            BuildFileRunnerUtil.$$$reportNull$$$0(2);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/runner/BuildFileRunnerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/runner/BuildFileRunnerUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuildFile";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

