/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.configuration.FileWatcher;
import jetbrains.buildServer.serverSide.BasePropertiesModel;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWatchingPropertiesModel
extends BasePropertiesModel {
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "internal.properties";
    private static final String REREAD_INTERVAL_MS_PROPERTY = "teamcity.internal.properties.reread.interval.ms";
    @NotNull
    private final AtomicReference<Map<String, String>> myProperties;
    @NotNull
    private final File myPropertiesFile;
    @NotNull
    private final FileWatcher ourFileWatcher;
    @Nullable
    private volatile PropertiesUpdatedListener myPropertiesUpdatedListener;

    @Deprecated
    public FileWatchingPropertiesModel(@NotNull File propertiesFile) {
        if (propertiesFile == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(0);
        }
        this(propertiesFile, true);
    }

    protected FileWatchingPropertiesModel(@NotNull File propertiesFile, boolean updateProperties) {
        if (propertiesFile == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(1);
        }
        this.myProperties = new AtomicReference(Collections.emptyMap());
        this.myPropertiesUpdatedListener = null;
        this.myPropertiesFile = propertiesFile;
        this.ourFileWatcher = new FileWatcher(this.myPropertiesFile);
        this.ourFileWatcher.registerListener(requestor -> this.readAndUpdateProperties());
        if (updateProperties) {
            this.readAndUpdateProperties();
        }
    }

    @NotNull
    public static FileWatchingPropertiesModel fromProperties(@NotNull File propertiesFile) {
        if (propertiesFile == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(2);
        }
        FileWatchingPropertiesModel fileWatchingPropertiesModel = new FileWatchingPropertiesModel(propertiesFile, true);
        if (fileWatchingPropertiesModel == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(3);
        }
        return fileWatchingPropertiesModel;
    }

    @Override
    @NotNull
    public Map<String, String> getUserDefinedProperties() {
        Map<String, String> map = this.myProperties.get();
        if (map == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public FileWatcher getFileWatcher() {
        FileWatcher fileWatcher = this.ourFileWatcher;
        if (fileWatcher == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(5);
        }
        return fileWatcher;
    }

    public void setFileWatcherSleepingPeriod(long currentSleepingInterval) {
        this.ourFileWatcher.setSleepingPeriod(currentSleepingInterval);
    }

    public void stopFileWatching() {
        this.ourFileWatcher.stop();
    }

    public void startFileWatching() {
        this.ourFileWatcher.start();
    }

    public void forceReloadProperties() {
        this.readAndUpdateProperties();
    }

    @NotNull
    public File getWatchingFilePath() {
        File file = this.myPropertiesFile.getAbsoluteFile();
        if (file == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(6);
        }
        return file;
    }

    void setPropertiesUpdatedListener(@NotNull PropertiesUpdatedListener propertiesUpdatedListener) {
        if (propertiesUpdatedListener == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(7);
        }
        this.myPropertiesUpdatedListener = propertiesUpdatedListener;
    }

    private void setProperties(@NotNull Map<String, String> newProperties) {
        Map<String, String> oldProperties;
        if (newProperties == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(8);
        }
        if (!(oldProperties = this.myProperties.getAndSet(newProperties)).equals(newProperties)) {
            this.onPropertiesUpdated();
        }
    }

    private void onPropertiesUpdated() {
        PropertiesUpdatedListener propertiesUpdatedListener = this.myPropertiesUpdatedListener;
        if (propertiesUpdatedListener != null) {
            propertiesUpdatedListener.onPropertiesUpdated();
        }
    }

    private long getCurrentSleepingInterval() {
        long defaultValue = 10000L;
        this.storeDefaultValue(REREAD_INTERVAL_MS_PROPERTY, Long.toString(defaultValue));
        String result = this.getPropertyOrNull(REREAD_INTERVAL_MS_PROPERTY);
        try {
            if (StringUtil.isEmptyOrSpaces((String)result)) {
                return defaultValue;
            }
            long value = Long.parseLong(result.trim());
            if (value < 0L) {
                return defaultValue;
            }
            return value;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private void readAndUpdateProperties() {
        try {
            if (!this.myPropertiesFile.exists()) {
                if (this.myPropertiesFile.getParentFile().exists()) {
                    this.setProperties(Collections.emptyMap());
                }
                return;
            }
            this.setProperties(FileWatchingPropertiesModel.propertiesToMap(this.readProperties(5)));
            long currentSleepingInterval = this.getCurrentSleepingInterval();
            if (this.ourFileWatcher.getSleepingPeriod() != currentSleepingInterval) {
                this.setFileWatcherSleepingPeriod(currentSleepingInterval);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to read " + this.myPropertiesFile + " file: " + e.getMessage());
        }
    }

    @NotNull
    private Properties readProperties(int maxAttempts) throws IOException {
        int attempt = 1;
        while (true) {
            Properties properties;
            try {
                properties = this.readProperties();
            }
            catch (IOException ioException) {
                if (attempt >= maxAttempts) {
                    throw ioException;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw ioException;
                }
                ++attempt;
                continue;
            }
            if (properties == null) {
                FileWatchingPropertiesModel.$$$reportNull$$$0(9);
            }
            return properties;
        }
    }

    @NotNull
    private Properties readProperties() throws IOException {
        Properties properties = new Properties();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.myPropertiesFile));
        try {
            properties.load(input);
        }
        finally {
            FileUtil.close(input);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            FileWatchingPropertiesModel.$$$reportNull$$$0(10);
        }
        return properties2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/FileWatchingPropertiesModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesUpdatedListener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/FileWatchingPropertiesModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileWatcher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchingFilePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromProperties";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPropertiesUpdatedListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface PropertiesUpdatedListener {
        public void onPropertiesUpdated();
    }
}

