/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import jetbrains.buildServer.serverSide.ControlDescription;
import jetbrains.buildServer.serverSide.Parameter;
import jetbrains.buildServer.serverSide.ParameterTypeBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReadOnlyAwareParameterType<T>
implements ParameterTypeBase<T> {
    public static final String READONLY_PARAMETER_ARG = "readOnly";
    public static final String DEFAULT_PARAMETER_ARG = "default";

    @Override
    @NotNull
    public String describe(@NotNull ControlDescription controlDescription) {
        if (controlDescription == null) {
            ReadOnlyAwareParameterType.$$$reportNull$$$0(0);
        }
        if (ReadOnlyAwareParameterType.isReadOnlyParameter(controlDescription)) {
            if ("read-only" == null) {
                ReadOnlyAwareParameterType.$$$reportNull$$$0(1);
            }
            return "read-only";
        }
        if ("" == null) {
            ReadOnlyAwareParameterType.$$$reportNull$$$0(2);
        }
        return "";
    }

    @Override
    @Nullable
    public String validate(@NotNull String value, @Nullable ControlDescription controlDescription) {
        String def;
        if (value == null) {
            ReadOnlyAwareParameterType.$$$reportNull$$$0(3);
        }
        if (ReadOnlyAwareParameterType.isReadOnlyParameter(controlDescription) && (def = controlDescription.getParameterTypeArguments().get(DEFAULT_PARAMETER_ARG)) != null && !value.equals(def)) {
            return "Value should be " + def;
        }
        return null;
    }

    public static boolean isReadOnlyParameter(@Nullable ControlDescription controlDescription) {
        return controlDescription != null && Boolean.parseBoolean(controlDescription.getParameterTypeArguments().get(READONLY_PARAMETER_ARG));
    }

    public static boolean isReadOnlyParameter(@NotNull Parameter parameter) {
        if (parameter == null) {
            ReadOnlyAwareParameterType.$$$reportNull$$$0(4);
        }
        return ReadOnlyAwareParameterType.isReadOnlyParameter(parameter.getControlDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlDescription";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/ReadOnlyAwareParameterType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/ReadOnlyAwareParameterType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "describe";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReadOnlyParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

