/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.PropertiesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartupConfiguration {
    private static final String CONFIGURATION_FILE_PATH_PROPERTY = "teamcity.configuration.path";
    private static final String CONFIGURATION_FILE_PATH_ENV = "TEAMCITY_CONFIGURATION_PATH";
    private static final String DEFAULT_CONFIGURATION_FILE_PATH = "../conf/teamcity-startup.properties";
    public static final String TEAMCITY_INSTALLATION_COMPLETED = "teamcity.installation.completed";
    public static final String ONE_TIME_SUPER_USER_TOKEN = "teamcity.oneTimeSuperUserToken";
    @Nullable
    private static File myFile;
    @Nullable
    private static String myFileCanonicalPath;
    @Nullable
    private static Properties myProperties;

    private static void initUsingEnvVar() {
        String configurationFilePath = (String)ObjectUtils.chooseNotNull((Object)System.getenv(CONFIGURATION_FILE_PATH_ENV), (Object)System.getProperty(CONFIGURATION_FILE_PATH_PROPERTY));
        StartupConfiguration.init(configurationFilePath != null ? new File(configurationFilePath) : null);
    }

    public static synchronized void init(@Nullable File configFile) {
        boolean log;
        boolean bl = log = !Boolean.getBoolean("teamcity.startup.suppressLoggingBeforeLogInitialization");
        if (configFile != null) {
            StartupConfiguration.initFromFile(configFile, false);
            if (log) {
                Loggers.STARTUP.info("Path to the startup configuration file: " + configFile.getAbsolutePath());
            }
        } else {
            File defaultConfigFile = new File(DEFAULT_CONFIGURATION_FILE_PATH);
            StartupConfiguration.initFromFile(defaultConfigFile, true);
            if (defaultConfigFile.exists() && log) {
                Loggers.STARTUP.info("Using startup configuration file at the default location: " + defaultConfigFile.getAbsolutePath());
            }
        }
    }

    private static synchronized void initFromFile(@NotNull File configFile, boolean useExistingFilesOnly) {
        if (configFile == null) {
            StartupConfiguration.$$$reportNull$$$0(0);
        }
        try {
            if (useExistingFilesOnly && !configFile.exists()) {
                return;
            }
            boolean canCreate = FileUtil.ensureCanCreateFile((File)configFile);
            if (canCreate) {
                myFile = configFile;
                myFileCanonicalPath = myFile.getCanonicalPath();
                myProperties = PropertiesUtil.loadProperties(configFile);
            } else {
                Loggers.STARTUP.warn("Unable to create startup configuration file '" + configFile.getAbsolutePath() + "'");
            }
        }
        catch (IOException e) {
            Loggers.STARTUP.warn("Error while processing file: " + configFile.getAbsolutePath(), (Throwable)e);
            myFile = null;
            myProperties = null;
            myFileCanonicalPath = null;
        }
    }

    @Nullable
    public static synchronized String getProperty(@NotNull String key) {
        if (key == null) {
            StartupConfiguration.$$$reportNull$$$0(1);
        }
        return myProperties != null ? myProperties.getProperty(key) : null;
    }

    @NotNull
    public static Properties getFinalSystemProperties() {
        Properties systemProps = new Properties();
        systemProps.putAll((Map<?, ?>)System.getProperties());
        Properties properties = myProperties;
        if (properties != null) {
            systemProps.putAll((Map<?, ?>)myProperties);
        }
        Properties properties2 = systemProps;
        if (properties2 == null) {
            StartupConfiguration.$$$reportNull$$$0(2);
        }
        return properties2;
    }

    public static synchronized boolean canSave() {
        return myFile != null && myProperties != null;
    }

    public static synchronized void saveProperty(@NotNull String key, @NotNull String value) throws IOException {
        if (key == null) {
            StartupConfiguration.$$$reportNull$$$0(3);
        }
        if (value == null) {
            StartupConfiguration.$$$reportNull$$$0(4);
        }
        if (!StartupConfiguration.canSave()) {
            throw new IllegalStateException("Startup properties can't be saved");
        }
        assert (myProperties != null);
        assert (myFile != null);
        if (myFile.createNewFile()) {
            Loggers.STARTUP.info("Startup configuration file is created: " + myFile.getAbsolutePath());
        }
        myProperties.put(key, value);
        PropertiesUtil.storeProperties(myProperties, myFile, null);
    }

    public static synchronized void removeProperty(@NotNull String key) throws IOException {
        if (key == null) {
            StartupConfiguration.$$$reportNull$$$0(5);
        }
        if (!StartupConfiguration.canSave()) {
            throw new IllegalStateException("Startup properties can't be saved");
        }
        assert (myProperties != null);
        assert (myFile != null);
        if (myFile.exists() && myProperties.remove(key) != null) {
            PropertiesUtil.storeProperties(myProperties, myFile, null);
        }
    }

    public static synchronized String getLocation() {
        return myFileCanonicalPath;
    }

    @NotNull
    public static String getDescription() {
        String string = myFile != null ? "startup configuration from '" + myFileCanonicalPath + "' file" : "<startup configuration was not set>";
        if (string == null) {
            StartupConfiguration.$$$reportNull$$$0(6);
        }
        return string;
    }

    static {
        StartupConfiguration.initUsingEnvVar();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/StartupConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/StartupConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalSystemProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initFromFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

