/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import com.intellij.openapi.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.serverSide.BasePropertiesModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamCityProperties {
    private static final Model NULL_MODEL;
    @NotNull
    private static volatile Model ourModel;

    public static boolean getBoolean(@NotNull String key) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(0);
        }
        return Boolean.parseBoolean(TeamCityProperties.getProperty(key, "false").trim());
    }

    public static boolean getBooleanOrTrue(@NotNull String key) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(1);
        }
        return Boolean.parseBoolean(TeamCityProperties.getProperty(key, "true").trim());
    }

    public static int getInteger(@NotNull String key) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(2);
        }
        return TeamCityProperties.getInteger(key, 0);
    }

    public static long getIntervalMilliseconds(@NotNull String key, long defaultMillis) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(3);
        }
        Model model = TeamCityProperties.getModel();
        model.storeDefaultValue(key, Long.toString(defaultMillis));
        String millisStr1 = model.getPropertyOrNull(key);
        if (millisStr1 != null) {
            try {
                return Long.parseLong(millisStr1.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        model.storeDefaultValue(key + ".millis", Long.toString(defaultMillis));
        String millisStr2 = model.getPropertyOrNull(key + ".millis");
        if (millisStr2 != null) {
            try {
                return Long.parseLong(millisStr2.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        model.storeDefaultValue(key + ".seconds", Long.toString(TimeUnit.MILLISECONDS.toSeconds(defaultMillis)));
        String secondsStr = model.getPropertyOrNull(key + ".seconds");
        if (secondsStr != null) {
            try {
                return TimeUnit.SECONDS.toMillis(Long.parseLong(secondsStr.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        model.storeDefaultValue(key + ".minutes", Long.toString(TimeUnit.MILLISECONDS.toMinutes(defaultMillis)));
        String minutesStr = model.getPropertyOrNull(key + ".minutes");
        if (minutesStr != null) {
            try {
                return TimeUnit.MINUTES.toMillis(Long.parseLong(minutesStr.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        model.storeDefaultValue(key + ".hours", Long.toString(TimeUnit.MILLISECONDS.toHours(defaultMillis)));
        String hoursStr = model.getPropertyOrNull(key + ".hours");
        if (hoursStr != null) {
            try {
                return TimeUnit.HOURS.toMillis(Long.parseLong(hoursStr.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultMillis;
    }

    public static int getInteger(@NotNull String key, int defaultValue) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(4);
        }
        Model model = TeamCityProperties.getModel();
        model.storeDefaultValue(key, Integer.toString(defaultValue));
        String result = model.getPropertyOrNull(key);
        try {
            return result != null ? Integer.parseInt(result.trim()) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float getFloat(@NotNull String key) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(5);
        }
        return TeamCityProperties.getFloat(key, 0.0f);
    }

    public static float getFloat(@NotNull String key, float defaultValue) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(6);
        }
        Model model = TeamCityProperties.getModel();
        model.storeDefaultValue(key, Float.toString(defaultValue));
        String result = model.getPropertyOrNull(key);
        try {
            return result != null ? Float.parseFloat(result.trim()) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLong(@NotNull String key) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(7);
        }
        return TeamCityProperties.getLong(key, 0L);
    }

    public static long getLong(@NotNull String key, long defaultValue) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(8);
        }
        Model model = TeamCityProperties.getModel();
        model.storeDefaultValue(key, Long.toString(defaultValue));
        String result = model.getPropertyOrNull(key);
        try {
            return result != null ? Long.parseLong(result.trim()) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static String getProperty(@NotNull String key) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(9);
        }
        String string = TeamCityProperties.getProperty(key, "");
        if (string == null) {
            TeamCityProperties.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static String getPropertyOrNull(@NotNull String key) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(11);
        }
        Model model = TeamCityProperties.getModel();
        model.storeDefaultValue(key, null);
        return model.getPropertyOrNull(key);
    }

    @Nullable
    public static String getPropertyOrNull(@NotNull String key, @Nullable String defaultValue) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(12);
        }
        Model model = TeamCityProperties.getModel();
        model.storeDefaultValue(key, defaultValue);
        String result = model.getPropertyOrNull(key);
        return result != null ? result : defaultValue;
    }

    @NotNull
    public static String getProperty(@NotNull String key, @NotNull String defaultValue) {
        if (key == null) {
            TeamCityProperties.$$$reportNull$$$0(13);
        }
        if (defaultValue == null) {
            TeamCityProperties.$$$reportNull$$$0(14);
        }
        Model model = TeamCityProperties.getModel();
        model.storeDefaultValue(key, defaultValue);
        String result = model.getPropertyOrNull(key);
        String string = result != null ? result : defaultValue;
        if (string == null) {
            TeamCityProperties.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static Map<String, String> getPropertiesWithPrefix(@NotNull String keyPrefix) {
        if (keyPrefix == null) {
            TeamCityProperties.$$$reportNull$$$0(16);
        }
        HashMap<String, String> res = new HashMap<String, String>();
        Model model = TeamCityProperties.getModel();
        for (String string : model.getUserDefinedProperties().keySet()) {
            if (!string.startsWith(keyPrefix)) continue;
            model.storeDefaultValue(string, null);
            res.put(string, model.getPropertyOrNull(string));
        }
        for (Map.Entry entry : model.getSystemProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith(keyPrefix) || res.containsKey(entry.getKey())) continue;
            res.put((String)entry.getKey(), (String)entry.getValue());
        }
        HashMap<String, String> hashMap = res;
        if (hashMap == null) {
            TeamCityProperties.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @Deprecated
    @NotNull
    public static Pair<Properties, Properties> getAllProperties() {
        Model model = TeamCityProperties.getModel();
        Properties userProperties = new Properties();
        userProperties.putAll(model.getUserDefinedProperties());
        Properties systemProperties = new Properties();
        systemProperties.putAll(model.getSystemProperties());
        Pair pair = new Pair((Object)userProperties, (Object)systemProperties);
        if (pair == null) {
            TeamCityProperties.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @NotNull
    public static Model getModel() {
        Model model = ourModel;
        if (model == null) {
            TeamCityProperties.$$$reportNull$$$0(19);
        }
        return model;
    }

    public static boolean isInitialized() {
        return ourModel != NULL_MODEL;
    }

    protected static void setModel(@NotNull Model model) {
        if (model == null) {
            TeamCityProperties.$$$reportNull$$$0(20);
        }
        ourModel = model;
    }

    static {
        ourModel = NULL_MODEL = new NullModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/TeamCityProperties";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPrefix";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/TeamCityProperties";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperty";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesWithPrefix";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProperties";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanOrTrue";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInteger";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntervalMilliseconds";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFloat";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLong";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyOrNull";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesWithPrefix";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NullModel
    implements Model {
        private NullModel() {
        }

        @Override
        @Nullable
        public String getPropertyOrNull(@NotNull String key) {
            if (key == null) {
                NullModel.$$$reportNull$$$0(0);
            }
            this.warnIncorrectUsage(key);
            return System.getProperty(key);
        }

        @Override
        public void storeDefaultValue(@NotNull String key, @Nullable String defaultValue) {
            if (key == null) {
                NullModel.$$$reportNull$$$0(1);
            }
            System.out.println("Attempt to store a default value of TeamCity internal property before initialization!");
        }

        @Override
        @NotNull
        public Map<String, String> getSystemProperties() {
            this.warnIncorrectUsage(null);
            Map<String, String> map = BasePropertiesModel.propertiesToMap(System.getProperties());
            if (map == null) {
                NullModel.$$$reportNull$$$0(2);
            }
            return map;
        }

        @Override
        @NotNull
        public Map<String, String> getUserDefinedProperties() {
            this.warnIncorrectUsage(null);
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                NullModel.$$$reportNull$$$0(3);
            }
            return map;
        }

        private void warnIncorrectUsage(@Nullable String propertyName) {
            String baseMessage = propertyName != null ? "Attempt to read TeamCity internal property \"" + propertyName + "\" before initialization! Default value is used." : "Attempt to read TeamCity internal properties before initialization!";
            try {
                String ourClassName = TeamCityProperties.class.getName();
                boolean foundSelf = false;
                for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                    if (ourClassName.equals(element.getClassName())) {
                        foundSelf = true;
                        continue;
                    }
                    if (!foundSelf) continue;
                    System.out.println(baseMessage + " Callee: " + element);
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println(baseMessage);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/serverSide/TeamCityProperties$NullModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/serverSide/TeamCityProperties$NullModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSystemProperties";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserDefinedProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPropertyOrNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "storeDefaultValue";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Model {
        @Nullable
        public String getPropertyOrNull(@NotNull String var1);

        public void storeDefaultValue(@NotNull String var1, @Nullable String var2);

        @NotNull
        public Map<String, String> getSystemProperties();

        @NotNull
        public Map<String, String> getUserDefinedProperties();
    }
}

