/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.crypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class EncryptUtil {
    private static final Logger LOG = Logger.getLogger(EncryptUtil.class);
    private static final String scrambePrefix = "scrambled:";
    private static String myScrambledEmptyString;
    private static final byte[] data;
    private static final String oldScrambledPrefix = "zxx";

    public static String md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return EncryptUtil.toHex(md.digest(str.getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn((Object)("Failed to obtain MD5 algorithm: " + e.toString()));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.toString(), (Throwable)e);
        }
        return str;
    }

    public static String toHex(byte[] bytes) {
        return new String(Hex.encodeHex((byte[])bytes));
    }

    public static byte[] fromHex(String hex) {
        try {
            return Hex.decodeHex((char[])hex.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    private static String unscrambleValue(String scrambled, byte[] secretKey) throws CannotBeUnscrambledException {
        if (!EncryptUtil.canBeScrambled(scrambled)) {
            throw new CannotBeUnscrambledException();
        }
        String toDecrypt = scrambled.substring(oldScrambledPrefix.length());
        try {
            String result = new String(EncryptUtil.encryptOrDecrypt(2, EncryptUtil.fromHex(toDecrypt), secretKey), "UTF-8");
            if (result.length() != 0 || EncryptUtil.scrambledEmptyString().equals(scrambled)) {
                return result;
            }
            throw new CannotBeUnscrambledException();
        }
        catch (Throwable e) {
            throw new CannotBeUnscrambledException(e.toString());
        }
    }

    public static boolean isScrambled(String scrambled) {
        return scrambled.startsWith(scrambePrefix) || EncryptUtil.isScrambledByOldStrategy(scrambled);
    }

    private static boolean isScrambledByOldStrategy(String scrambled) {
        if (!EncryptUtil.canBeScrambled(scrambled)) {
            return false;
        }
        try {
            EncryptUtil.unscrambleValue(scrambled, data);
            return true;
        }
        catch (CannotBeUnscrambledException e) {
            return false;
        }
    }

    private static boolean canBeScrambled(String scrambled) {
        return scrambled.startsWith(oldScrambledPrefix) && (scrambled.length() - oldScrambledPrefix.length()) % 2 == 0;
    }

    private static synchronized String scrambledEmptyString() {
        if (myScrambledEmptyString != null) {
            return myScrambledEmptyString;
        }
        myScrambledEmptyString = EncryptUtil.scrambleValue("");
        return myScrambledEmptyString;
    }

    public static String unscramble(String scrambled) throws IllegalArgumentException {
        if (scrambled.startsWith(scrambePrefix)) {
            return new String(Base64.decodeBase64((String)scrambled.substring(scrambePrefix.length())), Charset.forName("UTF-8"));
        }
        try {
            return EncryptUtil.unscrambleValue(scrambled, data);
        }
        catch (CannotBeUnscrambledException e) {
            throw new IllegalArgumentException("Cannot unscramble the specified string");
        }
    }

    @Deprecated
    public static String scrambleValue(String value) {
        try {
            return oldScrambledPrefix + EncryptUtil.toHex(EncryptUtil.encryptOrDecrypt(1, value.getBytes("UTF-8"), data));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String scramble(@NotNull String value) {
        if (value == null) {
            EncryptUtil.$$$reportNull$$$0(0);
        }
        return scrambePrefix + Base64.encodeBase64String((byte[])value.getBytes(Charset.forName("UTF-8")));
    }

    private static byte[] encryptOrDecrypt(int mode, byte[] bytes, byte[] secretKey) throws InvalidKeyException, IOException {
        Cipher cipher = EncryptUtil.getCipher(mode, secretKey);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, cipher);
        ((OutputStream)cOut).write(bytes);
        ((OutputStream)cOut).close();
        return bOut.toByteArray();
    }

    private static Cipher getCipher(int mode, byte[] secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("DESede");
            cipher.init(mode, EncryptUtil.getKey(secretKey));
            return cipher;
        }
        catch (Throwable e) {
            throw new RuntimeException("DES-EDE encryption is not supported by this Java installation", e);
        }
    }

    private static SecretKey getKey(byte[] secretKey) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            return keyFactory.generateSecret(new DESedeKeySpec(secretKey));
        }
        catch (Throwable e) {
            throw new RuntimeException("DES-EDE encryption is not supported by this Java installation", e);
        }
    }

    static {
        data = new byte[]{61, 22, 11, 57, 110, 89, -20, -1, 0, 99, 111, -120, 55, 4, -9, 10, 11, 45, 71, -89, 21, -99, 54, 51};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/serverSide/crypt/EncryptUtil", "scramble"));
    }

    private static class CannotBeUnscrambledException
    extends Exception {
        private CannotBeUnscrambledException() {
        }

        private CannotBeUnscrambledException(String message) {
            super(message);
        }
    }
}

