/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.vcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import jetbrains.buildServer.vcs.IncludeRule;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsRootEntry;
import org.jetbrains.annotations.NotNull;

public class CheckedOutDir
implements Comparable<CheckedOutDir> {
    private final VcsRoot myRoot;
    private final IncludeRule myRule;

    public CheckedOutDir(VcsRoot root, IncludeRule rule) {
        this.myRoot = root;
        this.myRule = rule;
    }

    public VcsRoot getRoot() {
        return this.myRoot;
    }

    public IncludeRule getRule() {
        return this.myRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckedOutDir that = (CheckedOutDir)o;
        return this.myRoot.getId() == that.myRoot.getId() && this.myRule.equals(that.myRule);
    }

    public int hashCode() {
        int result = (int)this.myRoot.getId();
        result = 31 * result + this.myRule.hashCode();
        return result;
    }

    @NotNull
    public static List<CheckedOutDir> createListFor(@NotNull List<? extends VcsRootEntry> entries) {
        if (entries == null) {
            CheckedOutDir.$$$reportNull$$$0(0);
        }
        ArrayList<CheckedOutDir> result = new ArrayList<CheckedOutDir>();
        for (VcsRootEntry vcsRootEntry : entries) {
            for (IncludeRule includeRule : vcsRootEntry.getCheckoutRules().getIncludeRules()) {
                result.add(new CheckedOutDir(vcsRootEntry.getVcsRoot(), includeRule));
            }
        }
        ArrayList<CheckedOutDir> arrayList = result;
        if (arrayList == null) {
            CheckedOutDir.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<CheckedOutDir> findCheckedOutDirsByPath(@NotNull String path, @NotNull List<? extends VcsRootEntry> entries) {
        if (path == null) {
            CheckedOutDir.$$$reportNull$$$0(2);
        }
        if (entries == null) {
            CheckedOutDir.$$$reportNull$$$0(3);
        }
        LinkedHashSet<CheckedOutDir> result = new LinkedHashSet<CheckedOutDir>();
        ArrayList<CheckedOutDir> checkedOutDirs = new ArrayList<CheckedOutDir>(CheckedOutDir.createListFor(entries));
        Collections.sort(checkedOutDirs, new Comparator<CheckedOutDir>(){

            @Override
            public int compare(CheckedOutDir o1, CheckedOutDir o2) {
                return -o1.getRule().getTo().compareTo(o2.getRule().getTo());
            }
        });
        for (CheckedOutDir checkedOutDir : checkedOutDirs) {
            String dirToCheckOutTo = checkedOutDir.getRule().getTo();
            if (!path.startsWith(dirToCheckOutTo)) continue;
            result.add(checkedOutDir);
        }
        ArrayList<CheckedOutDir> arrayList = new ArrayList<CheckedOutDir>(result);
        if (arrayList == null) {
            CheckedOutDir.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    public int compareTo(CheckedOutDir o) {
        return this.getRule().getTo().compareTo(o.getRule().getTo());
    }

    public String toString() {
        return "CheckedOutDir{myRoot=" + this.myRoot + ", myRule=" + this.myRule + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/vcs/CheckedOutDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/vcs/CheckedOutDir";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createListFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findCheckedOutDirsByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createListFor";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCheckedOutDirsByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

