/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.ssl.TeamCityTrustedSslCertificate;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.XmlUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.utils.Charsets;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public final class TeamCityTrustedSslCertificateUtil {
    private TeamCityTrustedSslCertificateUtil() {
        throw new IllegalStateException();
    }

    public static String serialize(@NotNull TeamCityTrustedSslCertificate[] certificates) throws IOException {
        if (certificates == null) {
            TeamCityTrustedSslCertificateUtil.$$$reportNull$$$0(0);
        }
        Element rootElement = new Element("ssl-certificates");
        Document document = new Document(rootElement);
        for (TeamCityTrustedSslCertificate certificate : certificates) {
            Element cert = new Element("ssl-certificate");
            Element name = new Element("name");
            name.addContent(Base64.encodeBase64String((byte[])certificate.getName().getBytes(Charsets.UTF_8)));
            cert.addContent(name);
            Element data = new Element("data");
            data.addContent(Base64.encodeBase64String((byte[])certificate.getPemData()));
            cert.addContent(data);
            rootElement.addContent(cert);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        XmlUtil.saveDocument(document, bos);
        return bos.toString("UTF-8");
    }

    public static TeamCityTrustedSslCertificate[] deserialize(@NotNull String serialized) throws JDOMException, IOException {
        if (serialized == null) {
            TeamCityTrustedSslCertificateUtil.$$$reportNull$$$0(1);
        }
        byte[] code = serialized.getBytes(Charsets.UTF_8);
        Document document = FileUtil.parseDocument(new ByteArrayInputStream(code), false).getDocument();
        ArrayList<TeamCityTrustedSslCertificate> result = new ArrayList<TeamCityTrustedSslCertificate>();
        Element rootElement = document.getRootElement();
        List certs = rootElement.getChildren();
        if (certs == null || certs.size() == 0) {
            return new TeamCityTrustedSslCertificate[0];
        }
        for (Object cert : certs) {
            Element certEl;
            Element nameCh;
            if (!(cert instanceof Element) || (nameCh = (certEl = (Element)cert).getChild("name")) == null) continue;
            String name = new String(Base64.decodeBase64((String)nameCh.getValue()), Charsets.UTF_8);
            Element dataCh = certEl.getChild("data");
            if (dataCh == null) continue;
            byte[] data = Base64.decodeBase64((String)dataCh.getValue());
            result.add(new TeamCityTrustedSslCertificate(name, data));
        }
        return result.toArray(new TeamCityTrustedSslCertificate[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificates";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/ssl/TeamCityTrustedSslCertificateUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

