/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jetbrains.buildServer.Used;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.tools.ToolMetadata;
import jetbrains.buildServer.tools.ToolMetadataType;
import jetbrains.buildServer.tools.ToolType;
import jetbrains.buildServer.tools.ToolVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolVersionReference {
    public static final String TOOL_PARAMETER_PREFIX = "teamcity.tool.";
    public static final String TOOL_DEFAULT_REFERENCE_POSTFIX = ".DEFAULT";
    public static final String TOOL_AUTO_REFERENCE_POSTFIX = ".AUTO";
    private static final ToolMetadata EmptyMetadata = new EmptyMetadata();
    public static final ToolVersionReference CUSTOM = new ToolVersionReference("custom", "custom", "<Custom>", EmptyMetadata);
    public static final ToolVersionReference NOT_SPECIFIED = new ToolVersionReference("not-specified", "Not specified", EmptyMetadata);
    @NotNull
    private final String myPropertyName;
    @NotNull
    private final String myDisplayName;
    @NotNull
    private final String myReference;
    @NotNull
    private final ToolMetadata myMetadata;

    private ToolVersionReference(@NotNull String propertyName, @NotNull String displayName, @NotNull ToolMetadata metadata) {
        if (propertyName == null) {
            ToolVersionReference.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            ToolVersionReference.$$$reportNull$$$0(1);
        }
        if (metadata == null) {
            ToolVersionReference.$$$reportNull$$$0(2);
        }
        this(propertyName, ReferencesResolverUtil.makeReference(propertyName), displayName, metadata);
    }

    private ToolVersionReference(@NotNull String propertyName, @NotNull String reference, @NotNull String displayName, @NotNull ToolMetadata metadata) {
        if (propertyName == null) {
            ToolVersionReference.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            ToolVersionReference.$$$reportNull$$$0(4);
        }
        if (displayName == null) {
            ToolVersionReference.$$$reportNull$$$0(5);
        }
        if (metadata == null) {
            ToolVersionReference.$$$reportNull$$$0(6);
        }
        this.myPropertyName = propertyName;
        this.myReference = reference;
        this.myDisplayName = displayName;
        this.myMetadata = metadata;
    }

    public static boolean isToolReference(@Nullable String value) {
        return value != null && ToolVersionReference.getResolvedToolReferenceParams(value).size() == 1;
    }

    @NotNull
    public static ToolVersionReference getDefaultToolReference(@NotNull ToolVersion defaultToolVersion) {
        if (defaultToolVersion == null) {
            ToolVersionReference.$$$reportNull$$$0(7);
        }
        ToolVersionReference toolVersionReference = new ToolVersionReference(TOOL_PARAMETER_PREFIX + defaultToolVersion.getType().getType() + TOOL_DEFAULT_REFERENCE_POSTFIX, "<Default (" + defaultToolVersion.getVersion() + ")>", new CompositeMetadata(defaultToolVersion));
        if (toolVersionReference == null) {
            ToolVersionReference.$$$reportNull$$$0(8);
        }
        return toolVersionReference;
    }

    @NotNull
    public static ToolVersionReference getAutoToolReference(String toolType) {
        ToolVersionReference toolVersionReference = new ToolVersionReference(TOOL_PARAMETER_PREFIX + toolType + TOOL_AUTO_REFERENCE_POSTFIX, "<Auto>", EmptyMetadata);
        if (toolVersionReference == null) {
            ToolVersionReference.$$$reportNull$$$0(9);
        }
        return toolVersionReference;
    }

    @NotNull
    @Used(value="plugins")
    public static ToolVersionReference getDefaultToolReference(String toolType) {
        ToolVersionReference toolVersionReference = new ToolVersionReference(TOOL_PARAMETER_PREFIX + toolType + TOOL_DEFAULT_REFERENCE_POSTFIX, "", EmptyMetadata);
        if (toolVersionReference == null) {
            ToolVersionReference.$$$reportNull$$$0(10);
        }
        return toolVersionReference;
    }

    @NotNull
    public static ToolVersionReference getToolReference(@NotNull ToolVersion toolVersion) {
        if (toolVersion == null) {
            ToolVersionReference.$$$reportNull$$$0(11);
        }
        ToolVersionReference toolVersionReference = new ToolVersionReference(TOOL_PARAMETER_PREFIX + toolVersion.getId(), toolVersion.getVersion(), new CompositeMetadata(toolVersion));
        if (toolVersionReference == null) {
            ToolVersionReference.$$$reportNull$$$0(12);
        }
        return toolVersionReference;
    }

    @NotNull
    public static ToolVersionReference getBundledToolReference(@NotNull ToolVersion toolVersion) {
        if (toolVersion == null) {
            ToolVersionReference.$$$reportNull$$$0(13);
        }
        ToolVersionReference toolVersionReference = new ToolVersionReference(TOOL_PARAMETER_PREFIX + toolVersion.getId(), "<Bundled (" + toolVersion.getVersion() + ")>", new CompositeMetadata(toolVersion));
        if (toolVersionReference == null) {
            ToolVersionReference.$$$reportNull$$$0(14);
        }
        return toolVersionReference;
    }

    @NotNull
    public static ToolVersionReference getNotInstalledToolReference(@NotNull String toolVersionId) {
        if (toolVersionId == null) {
            ToolVersionReference.$$$reportNull$$$0(15);
        }
        ToolVersionReference toolVersionReference = new ToolVersionReference(TOOL_PARAMETER_PREFIX + toolVersionId, "Not Installed: " + toolVersionId, EmptyMetadata);
        if (toolVersionReference == null) {
            ToolVersionReference.$$$reportNull$$$0(16);
        }
        return toolVersionReference;
    }

    public static boolean isAutoToolReference(@NotNull String value) {
        List<String> resolvedToolReferenceParams;
        if (value == null) {
            ToolVersionReference.$$$reportNull$$$0(17);
        }
        if ((resolvedToolReferenceParams = ToolVersionReference.getResolvedToolReferenceParams(value)).size() != 1) {
            return false;
        }
        String resolvedToolRefParam = resolvedToolReferenceParams.get(0);
        return resolvedToolRefParam.startsWith(TOOL_PARAMETER_PREFIX) && resolvedToolRefParam.endsWith(TOOL_AUTO_REFERENCE_POSTFIX);
    }

    @NotNull
    public static String getAutoToolId(@NotNull ToolType toolType) {
        if (toolType == null) {
            ToolVersionReference.$$$reportNull$$$0(18);
        }
        String string = ToolVersionReference.getAutoToolId(toolType.getType());
        if (string == null) {
            ToolVersionReference.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String getAutoToolId(@NotNull String toolType) {
        if (toolType == null) {
            ToolVersionReference.$$$reportNull$$$0(20);
        }
        String string = "?" + toolType + TOOL_AUTO_REFERENCE_POSTFIX;
        if (string == null) {
            ToolVersionReference.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static boolean isAutoToolId(@NotNull String toolType, @NotNull String toolId) {
        if (toolType == null) {
            ToolVersionReference.$$$reportNull$$$0(22);
        }
        if (toolId == null) {
            ToolVersionReference.$$$reportNull$$$0(23);
        }
        return ToolVersionReference.getAutoToolId(toolType).equals(toolId);
    }

    public static boolean isDefaultToolReference(@NotNull String value) {
        List<String> resolvedToolReferenceParams;
        if (value == null) {
            ToolVersionReference.$$$reportNull$$$0(24);
        }
        if ((resolvedToolReferenceParams = ToolVersionReference.getResolvedToolReferenceParams(value)).size() != 1) {
            return false;
        }
        String resolvedToolRefParam = resolvedToolReferenceParams.get(0);
        return resolvedToolRefParam.startsWith(TOOL_PARAMETER_PREFIX) && resolvedToolRefParam.endsWith(TOOL_DEFAULT_REFERENCE_POSTFIX);
    }

    @Used(value="plugins")
    @Nullable
    public static String getToolVersionOfType(@NotNull String toolType, @NotNull String value) {
        String prefix;
        List<String> resolvedToolReferenceParams;
        if (toolType == null) {
            ToolVersionReference.$$$reportNull$$$0(25);
        }
        if (value == null) {
            ToolVersionReference.$$$reportNull$$$0(26);
        }
        if ((resolvedToolReferenceParams = ToolVersionReference.getResolvedToolReferenceParams(value)).size() != 1) {
            return null;
        }
        String resolvedToolRefParam = resolvedToolReferenceParams.get(0);
        if (!resolvedToolRefParam.startsWith(prefix = TOOL_PARAMETER_PREFIX + toolType)) {
            return null;
        }
        return resolvedToolRefParam.substring(prefix.length() + 1);
    }

    @Nullable
    public static String resolveToolId(@NotNull String value) {
        List<String> resolvedToolReferenceParams;
        if (value == null) {
            ToolVersionReference.$$$reportNull$$$0(27);
        }
        if ((resolvedToolReferenceParams = ToolVersionReference.getResolvedToolReferenceParams(value)).size() != 1) {
            return null;
        }
        String resolvedToolRefParam = resolvedToolReferenceParams.get(0);
        if (!resolvedToolRefParam.startsWith(TOOL_PARAMETER_PREFIX)) {
            return null;
        }
        return resolvedToolRefParam.substring(TOOL_PARAMETER_PREFIX.length());
    }

    @NotNull
    public String getReference() {
        String string = this.myReference;
        if (string == null) {
            ToolVersionReference.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            ToolVersionReference.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    public String getNotes() {
        return this.myMetadata.tryGetMatadata(ToolMetadataType.Notes);
    }

    public String getPropertyName() {
        return this.myPropertyName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolVersionReference that = (ToolVersionReference)o;
        return this.myPropertyName.equals(that.myPropertyName);
    }

    public int hashCode() {
        return this.myPropertyName.hashCode();
    }

    private static List<String> getResolvedToolReferenceParams(@NotNull String value) {
        if (value == null) {
            ToolVersionReference.$$$reportNull$$$0(30);
        }
        final boolean[] containsText = new boolean[]{false};
        final int[] foundReferenceCount = new int[]{0};
        final ArrayList referenceKeyFound = new ArrayList();
        ReferencesResolverUtil.resolve(value.trim(), new ReferencesResolverUtil.ReferencesResolverListener(){

            @Override
            public void appendText(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                containsText[0] = true;
            }

            @Override
            public boolean appendReference(@NotNull String referenceKey) {
                if (referenceKey == null) {
                    1.$$$reportNull$$$0(1);
                }
                foundReferenceCount[0] = foundReferenceCount[0] + 1;
                referenceKeyFound.add(referenceKey);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceKey";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/tools/ToolVersionReference$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return containsText[0] ? Collections.emptyList() : referenceKeyFound;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultToolVersion";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/tools/ToolVersionReference";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolVersion";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolVersionId";
                break;
            }
            case 17: 
            case 24: 
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/tools/ToolVersionReference";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultToolReference";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoToolReference";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolReference";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledToolReference";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInstalledToolReference";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoToolId";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultToolReference";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 29: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getToolReference";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundledToolReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNotInstalledToolReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAutoToolReference";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAutoToolId";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAutoToolId";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultToolReference";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getToolVersionOfType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveToolId";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedToolReferenceParams";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompositeMetadata
    implements ToolMetadata {
        @NotNull
        private final ToolVersion myToolVersion;

        public CompositeMetadata(@NotNull ToolVersion toolVersion) {
            if (toolVersion == null) {
                CompositeMetadata.$$$reportNull$$$0(0);
            }
            this.myToolVersion = toolVersion;
        }

        @Override
        @Nullable
        public String tryGetMatadata(ToolMetadataType type) {
            String metadataInfo = null;
            if (this.myToolVersion instanceof ToolMetadata && (metadataInfo = ((ToolMetadata)((Object)this.myToolVersion)).tryGetMatadata(type)) != null) {
                return metadataInfo;
            }
            if (this.myToolVersion.getType() instanceof ToolMetadata) {
                metadataInfo = ((ToolMetadata)((Object)this.myToolVersion.getType())).tryGetMatadata(type);
            }
            return metadataInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolVersion", "jetbrains/buildServer/tools/ToolVersionReference$CompositeMetadata", "<init>"));
        }
    }

    private static class EmptyMetadata
    implements ToolMetadata {
        private EmptyMetadata() {
        }

        @Override
        @Nullable
        public String tryGetMatadata(ToolMetadataType type) {
            return null;
        }
    }
}

