/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.util.DoubleKeyMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDoubleKeyMap<Key1, Key2, Value>
implements DoubleKeyMap<Key1, Key2, Value> {
    protected final Map<Key1, Map<Key2, Value>> myMapByKey1;
    protected final Map<Key2, Map<Key1, Value>> myMapByKey2;
    protected int mySize;

    protected AbstractDoubleKeyMap(@NotNull Map<Key1, Map<Key2, Value>> mapByKey1, @NotNull Map<Key2, Map<Key1, Value>> mapByKey2) {
        if (mapByKey1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(0);
        }
        if (mapByKey2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(1);
        }
        this.myMapByKey1 = mapByKey1;
        this.myMapByKey2 = mapByKey2;
        this.mySize = 0;
    }

    @Override
    @Nullable
    public Value put(@NotNull Key1 k1, @NotNull Key2 k2, @Nullable Value v) {
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(2);
        }
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(3);
        }
        Value previous1 = AbstractDoubleKeyMap.putToDoubleMap(this.myMapByKey1, k1, k2, v);
        Value previous2 = AbstractDoubleKeyMap.putToDoubleMap(this.myMapByKey2, k2, k1, v);
        assert (previous1 == previous2);
        if (previous1 == null) {
            ++this.mySize;
        }
        return previous1;
    }

    @Override
    public void putAllForKey1(@NotNull Key1 k1, @NotNull Map<Key2, Value> map) {
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(4);
        }
        if (map == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(5);
        }
        Map<Key2, Value> innerMap = AbstractDoubleKeyMap.getOrCreate(this.myMapByKey1, k1);
        innerMap.putAll(map);
        int added = AbstractDoubleKeyMap.putMap(this.myMapByKey2, k1, map);
        this.mySize += added;
    }

    @Override
    public void putAllForKey2(@NotNull Key2 k2, @NotNull Map<Key1, Value> map) {
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(6);
        }
        if (map == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(7);
        }
        Map<Key1, Value> innerMap = AbstractDoubleKeyMap.getOrCreate(this.myMapByKey2, k2);
        innerMap.putAll(map);
        int added = AbstractDoubleKeyMap.putMap(this.myMapByKey1, k2, map);
        this.mySize += added;
    }

    @Override
    public void putAll(@NotNull DoubleKeyMap<Key1, Key2, Value> map) {
        if (map == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(8);
        }
        Set<Map.Entry<Key1, Map<Key2, Value>>> entries = map.entrySet();
        for (Map.Entry<Key1, Map<Key2, Value>> entry : entries) {
            Key1 key1 = entry.getKey();
            Map<Key2, Value> value = entry.getValue();
            for (Map.Entry<Key2, Value> innerEntry : value.entrySet()) {
                this.put(key1, innerEntry.getKey(), innerEntry.getValue());
            }
        }
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean isEmpty() {
        return this.mySize == 0;
    }

    @Override
    @Nullable
    public Value get(@NotNull Key1 k1, @NotNull Key2 k2) {
        Map<Key2, Value> map;
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(9);
        }
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(10);
        }
        return (map = this.myMapByKey1.get(k1)) != null ? (Value)map.get(k2) : null;
    }

    @Override
    @NotNull
    public Map<Key2, Value> getAllByKey1(@NotNull Key1 k1) {
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(11);
        }
        Map<Key2, Value> map = AbstractDoubleKeyMap.notNullize(this.myMapByKey1.get(k1));
        if (map == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(12);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<Key1, Value> getAllByKey2(@NotNull Key2 k2) {
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(13);
        }
        Map<Key1, Value> map = AbstractDoubleKeyMap.notNullize(this.myMapByKey2.get(k2));
        if (map == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(14);
        }
        return map;
    }

    @Override
    public boolean contains(@NotNull Key1 k1, @NotNull Key2 k2) {
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(15);
        }
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(16);
        }
        return AbstractDoubleKeyMap.notNullize(this.myMapByKey1.get(k1)).containsKey(k2);
    }

    @Override
    public boolean containsAnyByKey1(@NotNull Key1 k1) {
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(17);
        }
        return this.myMapByKey1.containsKey(k1);
    }

    @Override
    public boolean containsAnyByKey2(@NotNull Key2 k2) {
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(18);
        }
        return this.myMapByKey2.containsKey(k2);
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key1, Map<Key2, Value>>> entrySet() {
        Set<Map.Entry<Key1, Map<Key2, Value>>> set = this.myMapByKey1.entrySet();
        if (set == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(19);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key2, Value>> entrySetByKey1(@NotNull Key1 k1) {
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(20);
        }
        Set<Map.Entry<Key2, Value>> set = AbstractDoubleKeyMap.notNullize(this.myMapByKey1.get(k1)).entrySet();
        if (set == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(21);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key1, Value>> entrySetByKey2(@NotNull Key2 k2) {
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(22);
        }
        Set<Map.Entry<Key1, Value>> set = AbstractDoubleKeyMap.notNullize(this.myMapByKey2.get(k2)).entrySet();
        if (set == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(23);
        }
        return set;
    }

    @Override
    @NotNull
    public Map<Key1, Set<Key2>> keys() {
        HashMap<Key1, Set<Key2>> result = new HashMap<Key1, Set<Key2>>();
        for (Map.Entry<Key1, Map<Key2, Value>> entry : this.myMapByKey1.entrySet()) {
            Key1 key1 = entry.getKey();
            Set<Key2> keys2 = entry.getValue().keySet();
            result.put(key1, keys2);
        }
        HashMap<Key1, Set<Key2>> hashMap = result;
        if (hashMap == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public Set<Key2> keySet1(@NotNull Key1 k1) {
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(25);
        }
        Set<Key2> set = this.getAllByKey1(k1).keySet();
        if (set == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(26);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Key1> keySet2(@NotNull Key2 k2) {
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(27);
        }
        Set<Key1> set = this.getAllByKey2(k2).keySet();
        if (set == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(28);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<Value> values() {
        ArrayList<Value> result = new ArrayList<Value>();
        Collection<Map<Key2, Value>> mapCollection = this.myMapByKey1.values();
        for (Map<Key2, Value> map : mapCollection) {
            result.addAll(map.values());
        }
        ArrayList<Value> arrayList = result;
        if (arrayList == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<Value> valuesByKey1(@NotNull Key1 k1) {
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(30);
        }
        Collection<Value> collection = this.getAllByKey1(k1).values();
        if (collection == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(31);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<Value> valuesByKey2(@NotNull Key2 k2) {
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(32);
        }
        Collection<Value> collection = this.getAllByKey2(k2).values();
        if (collection == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(33);
        }
        return collection;
    }

    @Override
    @Nullable
    public Value remove(@NotNull Key1 k1, @NotNull Key2 k2) {
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(34);
        }
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(35);
        }
        Value value1 = AbstractDoubleKeyMap.notNullize(this.myMapByKey1.get(k1)).remove(k2);
        Value value2 = AbstractDoubleKeyMap.notNullize(this.myMapByKey2.get(k2)).remove(k1);
        assert (value1 == value2);
        if (value1 != null) {
            --this.mySize;
        }
        return value1;
    }

    @Override
    @Nullable
    public Map<Key2, Value> removeAllByKey1(@NotNull Key1 k1) {
        Map<Key2, Value> map;
        if (k1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(36);
        }
        if ((map = this.myMapByKey1.remove(k1)) != null) {
            AbstractDoubleKeyMap.removeKeyForAll(this.myMapByKey2, k1, map.keySet());
            this.mySize -= map.size();
        }
        return map;
    }

    @Override
    @Nullable
    public Map<Key1, Value> removeAllByKey2(@NotNull Key2 k2) {
        Map<Key1, Value> map;
        if (k2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(37);
        }
        if ((map = this.myMapByKey2.remove(k2)) != null) {
            AbstractDoubleKeyMap.removeKeyForAll(this.myMapByKey1, k2, map.keySet());
            this.mySize -= map.size();
        }
        return map;
    }

    @Override
    public void removeAll(@NotNull Collection<Key1> keys1, @NotNull Collection<Key2> keys2) {
        if (keys1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(38);
        }
        if (keys2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(39);
        }
        AbstractDoubleKeyMap.removeForAllKeys(this.myMapByKey1, keys1, keys2);
        AbstractDoubleKeyMap.removeForAllKeys(this.myMapByKey2, keys2, keys1);
        this.recalculateSize();
    }

    @Override
    public void clear() {
        this.myMapByKey1.clear();
        this.myMapByKey2.clear();
        this.mySize = 0;
    }

    protected void recalculateSize() {
        this.mySize = 0;
        for (Map<Key2, Value> map : this.myMapByKey1.values()) {
            this.mySize += map.size();
        }
    }

    @NotNull
    private static <TK1, TK2, TV> Map<TK2, TV> getOrCreate(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull TK1 key) {
        Map<TK2, TV> map;
        if (doubleMap == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(40);
        }
        if (key == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(41);
        }
        if ((map = doubleMap.get(key)) == null) {
            map = new HashMap<TK2, TV>();
            doubleMap.put(key, map);
        }
        Map<TK2, TV> map2 = map;
        if (map2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(42);
        }
        return map2;
    }

    @Nullable
    private static <TK1, TK2, TV> TV putToDoubleMap(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull TK1 key1, @NotNull TK2 key2, @Nullable TV value) {
        if (doubleMap == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(43);
        }
        if (key1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(44);
        }
        if (key2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(45);
        }
        Map<TK2, TV> map = AbstractDoubleKeyMap.getOrCreate(doubleMap, key1);
        return map.put(key2, value);
    }

    private static <TK1, TK2, TV> int putMap(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull TK2 key, @NotNull Map<TK1, TV> map) {
        if (doubleMap == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(46);
        }
        if (key == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(47);
        }
        if (map == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(48);
        }
        int added = 0;
        for (Map.Entry<TK1, TV> entry : map.entrySet()) {
            TV value;
            TK1 key1 = entry.getKey();
            TV previous = AbstractDoubleKeyMap.putToDoubleMap(doubleMap, key1, key, value = entry.getValue());
            if (previous != null) continue;
            ++added;
        }
        return added;
    }

    @NotNull
    private static <TK, TV> Map<TK, TV> notNullize(@Nullable Map<TK, TV> map) {
        Map<Object, Object> map2 = map != null ? map : Collections.emptyMap();
        if (map2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(49);
        }
        return map2;
    }

    private static <TK1, TK2, TV> void removeKeyForAll(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull TK2 key2, @NotNull Set<TK1> keys) {
        if (doubleMap == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(50);
        }
        if (key2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(51);
        }
        if (keys == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(52);
        }
        for (TK1 key1 : keys) {
            AbstractDoubleKeyMap.notNullize(doubleMap.get(key1)).remove(key2);
        }
    }

    private static <TK1, TK2, TV> void removeForAllKeys(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull Collection<TK1> keys1, @NotNull Collection<TK2> keys2) {
        if (doubleMap == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(53);
        }
        if (keys1 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(54);
        }
        if (keys2 == null) {
            AbstractDoubleKeyMap.$$$reportNull$$$0(55);
        }
        for (TK1 key1 : keys1) {
            Map<TK2, TV> map = doubleMap.get(key1);
            if (map == null) continue;
            for (TK2 key2 : keys2) {
                map.remove(key2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapByKey1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapByKey2";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 20: 
            case 25: 
            case 30: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k1";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 22: 
            case 27: 
            case 32: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/AbstractDoubleKeyMap";
                break;
            }
            case 38: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys1";
                break;
            }
            case 39: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys2";
                break;
            }
            case 40: 
            case 43: 
            case 46: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubleMap";
                break;
            }
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key1";
                break;
            }
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key2";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/AbstractDoubleKeyMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllByKey1";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllByKey2";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySetByKey1";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySetByKey2";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet1";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet2";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "valuesByKey1";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "valuesByKey2";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putAllForKey1";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putAllForKey2";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllByKey1";
                break;
            }
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 49: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllByKey2";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyByKey1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyByKey2";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "entrySetByKey1";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "entrySetByKey2";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "keySet1";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "keySet2";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "valuesByKey1";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "valuesByKey2";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeAllByKey1";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeAllByKey2";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "putToDoubleMap";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "putMap";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removeKeyForAll";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "removeForAllKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

