/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipException;
import jetbrains.buildServer.util.ArchiveUtil;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Predicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class ApacheZipSlipAwareZipFile
extends ZipFile {
    public ApacheZipSlipAwareZipFile(File f) throws IOException {
        super(f);
    }

    public ApacheZipSlipAwareZipFile(String name) throws IOException {
        super(name);
    }

    public ApacheZipSlipAwareZipFile(String name, String encoding) throws IOException {
        super(name, encoding);
    }

    public ApacheZipSlipAwareZipFile(File f, String encoding) throws IOException {
        super(f, encoding);
    }

    public ApacheZipSlipAwareZipFile(File f, String encoding, boolean useUnicodeExtraFields) throws IOException {
        super(f, encoding, useUnicodeExtraFields);
    }

    private Enumeration<ZipArchiveEntry> filter(@NotNull Enumeration<ZipArchiveEntry> enumeration) {
        if (enumeration == null) {
            ApacheZipSlipAwareZipFile.$$$reportNull$$$0(0);
        }
        return new CollectionsUtil.FilteringEnumeration<ZipArchiveEntry>(enumeration, new Predicate<ZipArchiveEntry>(){

            @Override
            public boolean apply(ZipArchiveEntry item) {
                return item == null || ArchiveUtil.isNameAllowed(item.getName());
            }
        });
    }

    public Enumeration<ZipArchiveEntry> getEntries() {
        return this.filter(super.getEntries());
    }

    public Enumeration<ZipArchiveEntry> getEntriesInPhysicalOrder() {
        return this.filter(super.getEntriesInPhysicalOrder());
    }

    public ZipArchiveEntry getEntry(String name) {
        return ArchiveUtil.isNameAllowed(name) ? super.getEntry(name) : null;
    }

    public Iterable<ZipArchiveEntry> getEntries(String name) {
        return new CollectionsUtil.FilteringIterable<ZipArchiveEntry>(super.getEntries(name), new Predicate<ZipArchiveEntry>(){

            @Override
            public boolean apply(ZipArchiveEntry item) {
                return ApacheZipSlipAwareZipFile.this.isAllowed(item);
            }
        });
    }

    public Iterable<ZipArchiveEntry> getEntriesInPhysicalOrder(String name) {
        return new CollectionsUtil.FilteringIterable<ZipArchiveEntry>(super.getEntriesInPhysicalOrder(name), new Predicate<ZipArchiveEntry>(){

            @Override
            public boolean apply(ZipArchiveEntry item) {
                return ApacheZipSlipAwareZipFile.this.isAllowed(item);
            }
        });
    }

    public boolean canReadEntryData(ZipArchiveEntry ze) {
        return this.isAllowed(ze) && super.canReadEntryData(ze);
    }

    public InputStream getInputStream(ZipArchiveEntry ze) throws IOException, ZipException {
        return this.isAllowed(ze) ? super.getInputStream(ze) : null;
    }

    public String getUnixSymlink(ZipArchiveEntry entry) throws IOException {
        return this.isAllowed(entry) ? super.getUnixSymlink(entry) : null;
    }

    private boolean isAllowed(ZipArchiveEntry entry) {
        return entry == null || ArchiveUtil.isNameAllowed(entry.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumeration", "jetbrains/buildServer/util/ApacheZipSlipAwareZipFile", "filter"));
    }
}

