/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.PathUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.ApacheZipSlipAwareArchiveInputStream;
import jetbrains.buildServer.util.ArchiveType;
import jetbrains.buildServer.util.BaseArchiveUtil;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.util.ZipSlipAwareZipInputStream;
import jetbrains.buildServer.util.impl.FileAware;
import jetbrains.buildServer.util.impl.SevenZArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveUtil
extends BaseArchiveUtil {
    public static final String DEFAULT_ZIP_ENCODING = "cp437";
    public static final String ARCHIVE_PATH_SEPARATOR = "!/";
    public static final Pattern ARCHIVE_PATH_SEP_PATTERN = Pattern.compile("!/", 16);
    private static final Logger LOG = Logger.getInstance((String)ArchiveUtil.class.getName());
    private static final String GZ = ".gz";

    @NotNull
    public static ArchiveType getArchiveType(@NotNull String name) {
        if (name == null) {
            ArchiveUtil.$$$reportNull$$$0(0);
        }
        if ((name = name.toLowerCase()).endsWith(".zip") || name.endsWith(".nupkg") || name.endsWith(".snupkg") || name.endsWith(".sit")) {
            ArchiveType archiveType = ArchiveType.ZIP;
            if (archiveType == null) {
                ArchiveUtil.$$$reportNull$$$0(1);
            }
            return archiveType;
        }
        if (name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".ear") || name.endsWith(".apk")) {
            ArchiveType archiveType = ArchiveType.JAR;
            if (archiveType == null) {
                ArchiveUtil.$$$reportNull$$$0(2);
            }
            return archiveType;
        }
        if (name.endsWith(".tar.gz") || name.endsWith(".tgz") || name.endsWith(".tar.gzip")) {
            ArchiveType archiveType = ArchiveType.TAR_GZ;
            if (archiveType == null) {
                ArchiveUtil.$$$reportNull$$$0(3);
            }
            return archiveType;
        }
        if (name.endsWith(".tar")) {
            ArchiveType archiveType = ArchiveType.TAR;
            if (archiveType == null) {
                ArchiveUtil.$$$reportNull$$$0(4);
            }
            return archiveType;
        }
        if (name.endsWith(".7z")) {
            ArchiveType archiveType = ArchiveType.SEVEN_Z;
            if (archiveType == null) {
                ArchiveUtil.$$$reportNull$$$0(5);
            }
            return archiveType;
        }
        ArchiveType archiveType = ArchiveType.NOT_ARCHIVE;
        if (archiveType == null) {
            ArchiveUtil.$$$reportNull$$$0(6);
        }
        return archiveType;
    }

    @Nullable
    public static ArchiveInputStream getArchiveInputStream(@NotNull ArchiveType archiveType, @NotNull InputStream inputStream) throws IOException {
        if (archiveType == null) {
            ArchiveUtil.$$$reportNull$$$0(7);
        }
        if (inputStream == null) {
            ArchiveUtil.$$$reportNull$$$0(8);
        }
        if (archiveType == ArchiveType.SEVEN_Z) {
            if (inputStream instanceof FileAware) {
                return new ApacheZipSlipAwareArchiveInputStream(new SevenZArchiveInputStream(((FileAware)((Object)inputStream)).getFile()));
            }
            return null;
        }
        return archiveType == ArchiveType.ZIP ? new ApacheZipSlipAwareArchiveInputStream((ArchiveInputStream)new ZipArchiveInputStream(inputStream, DEFAULT_ZIP_ENCODING, true)) : (archiveType == ArchiveType.JAR ? new ApacheZipSlipAwareArchiveInputStream((ArchiveInputStream)new JarArchiveInputStream(inputStream)) : (archiveType == ArchiveType.TAR_GZ ? new ApacheZipSlipAwareArchiveInputStream((ArchiveInputStream)new TarArchiveInputStream((InputStream)new GZIPInputStream(inputStream), "UTF-8")) : (archiveType == ArchiveType.TAR ? new ApacheZipSlipAwareArchiveInputStream((ArchiveInputStream)new TarArchiveInputStream(inputStream, "UTF-8")) : null)));
    }

    @Nullable
    public static ArchiveInputStream getArchiveInputStream(@NotNull String name, @NotNull InputStream inputStream) throws IOException {
        if (name == null) {
            ArchiveUtil.$$$reportNull$$$0(9);
        }
        if (inputStream == null) {
            ArchiveUtil.$$$reportNull$$$0(10);
        }
        return ArchiveUtil.getArchiveInputStream(ArchiveUtil.getArchiveType(name), inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unpackZip(@NotNull File zip, @NotNull String pathPrefix, @NotNull File targetDir) {
        if (zip == null) {
            ArchiveUtil.$$$reportNull$$$0(11);
        }
        if (pathPrefix == null) {
            ArchiveUtil.$$$reportNull$$$0(12);
        }
        if (targetDir == null) {
            ArchiveUtil.$$$reportNull$$$0(13);
        }
        LOG.debug("Unpacking zip " + zip.getAbsolutePath() + "!" + pathPrefix + " to " + targetDir.getAbsolutePath());
        ZipSlipAwareZipInputStream file = null;
        try {
            file = new ZipSlipAwareZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            ArchiveUtil.unpackZip(file, targetDir, pathPrefix);
        }
        catch (IOException e) {
            boolean bl;
            try {
                LOG.warnAndDebugDetails("Failed to unpack zip " + zip.getAbsolutePath() + "!" + pathPrefix + " to " + targetDir.getAbsolutePath(), (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtil.close(file);
                throw throwable;
            }
            FileUtil.close(file);
            return bl;
        }
        FileUtil.close(file);
        return true;
    }

    public static boolean unpackZip(@NotNull File zip, @NotNull File targetDir) {
        if (zip == null) {
            ArchiveUtil.$$$reportNull$$$0(14);
        }
        if (targetDir == null) {
            ArchiveUtil.$$$reportNull$$$0(15);
        }
        return ArchiveUtil.unpackZip(zip, "", targetDir);
    }

    @Deprecated
    public static boolean unpackZip(@NotNull ZipInputStream input, @NotNull File targetDir) {
        if (input == null) {
            ArchiveUtil.$$$reportNull$$$0(16);
        }
        if (targetDir == null) {
            ArchiveUtil.$$$reportNull$$$0(17);
        }
        if (!(input instanceof ZipSlipAwareZipInputStream)) {
            LOG.warn("Unsafe usage of ArchiveUtil.unpackZip");
        }
        try {
            ArchiveUtil.unpackZip(input, targetDir, "");
        }
        catch (IOException e) {
            LOG.warnAndDebugDetails("Failed to unpack zip input stream to " + targetDir.getAbsolutePath(), (Throwable)e);
            return false;
        }
        return true;
    }

    private static void unpackZip(@NotNull ZipInputStream file, @NotNull File targetDir, @NotNull String pathPrefix) throws IOException {
        ZipEntry ze;
        if (file == null) {
            ArchiveUtil.$$$reportNull$$$0(18);
        }
        if (targetDir == null) {
            ArchiveUtil.$$$reportNull$$$0(19);
        }
        if (pathPrefix == null) {
            ArchiveUtil.$$$reportNull$$$0(20);
        }
        while ((ze = file.getNextEntry()) != null) {
            if (!ze.getName().startsWith(pathPrefix)) continue;
            ArchiveUtil.saveEntry(targetDir, file, ze, pathPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void saveEntry(@NotNull File parentDir, @NotNull InputStream zf, @NotNull ZipEntry entry, @NotNull String pathPrefix) throws IOException {
        String relativePath;
        if (parentDir == null) {
            ArchiveUtil.$$$reportNull$$$0(21);
        }
        if (zf == null) {
            ArchiveUtil.$$$reportNull$$$0(22);
        }
        if (entry == null) {
            ArchiveUtil.$$$reportNull$$$0(23);
        }
        if (pathPrefix == null) {
            ArchiveUtil.$$$reportNull$$$0(24);
        }
        if ((relativePath = entry.getName().substring(pathPrefix.length())).startsWith("/") || relativePath.startsWith("\\")) {
            relativePath = relativePath.substring(1);
        }
        File file = new File(parentDir, relativePath);
        LOG.debug("Extracting zip entry \"" + entry.getName() + "\" to \"" + file.getAbsolutePath() + "\"");
        FileUtil.createParentDirs((File)file);
        if (entry.isDirectory()) {
            file.mkdirs();
            return;
        }
        if (file.exists()) {
            FileUtil.delete(file);
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        try {
            TCStreamUtil.writeBinary(new BufferedInputStream(zf), bos);
            bos.flush();
        }
        catch (Throwable throwable) {
            FileUtil.closeAll(bos);
            throw throwable;
        }
        FileUtil.closeAll(bos);
    }

    public static boolean packZip(@NotNull File destFile, @NotNull Collection<File> sourceFiles) throws FileNotFoundException {
        if (destFile == null) {
            ArchiveUtil.$$$reportNull$$$0(25);
        }
        if (sourceFiles == null) {
            ArchiveUtil.$$$reportNull$$$0(26);
        }
        return ArchiveUtil.packZip(destFile, null, sourceFiles);
    }

    public static boolean packZip(@NotNull File destFile, @Nullable FilenameFilter filter, @NotNull Collection<File> sourceFiles) throws FileNotFoundException {
        if (destFile == null) {
            ArchiveUtil.$$$reportNull$$$0(27);
        }
        if (sourceFiles == null) {
            ArchiveUtil.$$$reportNull$$$0(28);
        }
        LOG.debug("Packing " + sourceFiles.size() + " file" + (sourceFiles.size() == 1 ? "" : "s") + " to " + destFile.getAbsolutePath());
        return ArchiveUtil.packZip(new FileOutputStream(destFile), filter, sourceFiles);
    }

    public static boolean packZip(@NotNull OutputStream destStream, @NotNull Collection<File> sourceFiles) {
        if (destStream == null) {
            ArchiveUtil.$$$reportNull$$$0(29);
        }
        if (sourceFiles == null) {
            ArchiveUtil.$$$reportNull$$$0(30);
        }
        return ArchiveUtil.packZip(destStream, null, sourceFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean packZip(@NotNull OutputStream destStream, @Nullable FilenameFilter filter, @NotNull Collection<File> sourceFiles) {
        boolean bl;
        block9: {
            if (destStream == null) {
                ArchiveUtil.$$$reportNull$$$0(31);
            }
            if (sourceFiles == null) {
                ArchiveUtil.$$$reportNull$$$0(32);
            }
            ZipOutputStream outputStream = null;
            try {
                outputStream = new ZipOutputStream(destStream);
                for (File file : sourceFiles) {
                    ArchiveUtil.packToZip(file, filter, outputStream, false);
                }
                bl = true;
                if (outputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    LOG.warn("Failed to pack " + sourceFiles.size() + " file" + (sourceFiles.size() == 1 ? "" : "s"));
                    return false;
                }
            }
            outputStream.close();
        }
        return bl;
    }

    public static boolean packZip(@NotNull File root, @NotNull ZipOutputStream output) {
        if (root == null) {
            ArchiveUtil.$$$reportNull$$$0(33);
        }
        if (output == null) {
            ArchiveUtil.$$$reportNull$$$0(34);
        }
        return ArchiveUtil.packZip(root, null, output);
    }

    public static boolean packZip(@NotNull File root, @Nullable FilenameFilter filter, @NotNull ZipOutputStream output) {
        if (root == null) {
            ArchiveUtil.$$$reportNull$$$0(35);
        }
        if (output == null) {
            ArchiveUtil.$$$reportNull$$$0(36);
        }
        return ArchiveUtil.packToZip(root, filter, output, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean packToZip(@NotNull File root, @Nullable FilenameFilter filter, @NotNull ZipOutputStream output, boolean closeZip) {
        if (root == null) {
            ArchiveUtil.$$$reportNull$$$0(37);
        }
        if (output == null) {
            ArchiveUtil.$$$reportNull$$$0(38);
        }
        try {
            byte[] buffer = new byte[TeamCityProperties.getInteger("teamcity.archiveUtil.bufferSize", 65536)];
            try {
                ArchiveUtil.traverseAndWrite(root, filter, output, new StringBuilder(), true, buffer);
            }
            finally {
                if (closeZip) {
                    output.close();
                }
            }
        }
        catch (IOException e) {
            LOG.warnAndDebugDetails("Failed to pack " + root + " to zip", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traverseAndWrite(@NotNull File file, @Nullable FilenameFilter filter, @NotNull ZipOutputStream output, @NotNull StringBuilder pathBuilder, boolean isFirst, @NotNull byte[] buffer) throws IOException {
        if (file == null) {
            ArchiveUtil.$$$reportNull$$$0(39);
        }
        if (output == null) {
            ArchiveUtil.$$$reportNull$$$0(40);
        }
        if (pathBuilder == null) {
            ArchiveUtil.$$$reportNull$$$0(41);
        }
        if (buffer == null) {
            ArchiveUtil.$$$reportNull$$$0(42);
        }
        if (!isFirst || file.isFile()) {
            pathBuilder.append(file.getName());
            if (!file.isFile()) {
                pathBuilder.append('/');
            }
        }
        if (file.isFile()) {
            String path = pathBuilder.toString();
            ZipEntry zipEntry = new ZipEntry(path);
            zipEntry.setTime(file.lastModified());
            output.putNextEntry(zipEntry);
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                int read;
                do {
                    read = ((InputStream)input).read(buffer);
                    output.write(buffer, 0, Math.max(read, 0));
                } while (read == buffer.length);
            }
            catch (IOException e) {
                LOG.warnAndDebugDetails("Failed to pack " + file.getAbsolutePath() + " to zip (error: " + e.getMessage() + ")", (Throwable)e);
            }
            finally {
                ((InputStream)input).close();
                output.closeEntry();
            }
        } else {
            File[] files;
            File[] fileArray = files = filter == null ? file.listFiles() : file.listFiles(filter);
            if (files != null) {
                int length = pathBuilder.length();
                for (File innerFile : files) {
                    ArchiveUtil.traverseAndWrite(innerFile, filter, output, pathBuilder, false, buffer);
                    pathBuilder.setLength(length);
                }
            }
        }
    }

    public static void packStream(@NotNull OutputStream out, @NotNull InputStream in) throws IOException {
        if (out == null) {
            ArchiveUtil.$$$reportNull$$$0(43);
        }
        if (in == null) {
            ArchiveUtil.$$$reportNull$$$0(44);
        }
        GZIPOutputStream gz = new GZIPOutputStream(out);
        try {
            StreamUtil.copyStreamContent((InputStream)in, (OutputStream)gz);
        }
        finally {
            gz.finish();
        }
    }

    public static void unpackStream(@NotNull OutputStream out, @NotNull InputStream in) throws IOException {
        if (out == null) {
            ArchiveUtil.$$$reportNull$$$0(45);
        }
        if (in == null) {
            ArchiveUtil.$$$reportNull$$$0(46);
        }
        StreamUtil.copyStreamContent((InputStream)new GZIPInputStream(in), (OutputStream)out);
    }

    @Nullable
    public static byte[] packBytes(@Nullable byte[] unpacked) {
        try {
            if (unpacked == null) {
                return null;
            }
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ArchiveUtil.packStream(bas, new ByteArrayInputStream(unpacked));
            return bas.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pack bytes", e);
        }
    }

    @Nullable
    public static byte[] unpackBytes(@Nullable byte[] packed) {
        try {
            if (packed == null) {
                return null;
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream(packed.length);
            ArchiveUtil.unpackStream(result, new ByteArrayInputStream(packed));
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to unpack bytes", e);
        }
    }

    @Nullable
    public static InputStream extractEntry(@NotNull ZipInputStream input, @NotNull String path) throws IOException {
        ZipEntry entry;
        if (input == null) {
            ArchiveUtil.$$$reportNull$$$0(47);
        }
        if (path == null) {
            ArchiveUtil.$$$reportNull$$$0(48);
        }
        while ((entry = input.getNextEntry()) != null) {
            if (!entry.getName().equals(path)) continue;
            return input;
        }
        return null;
    }

    @NotNull
    public static File getPackedFile(@NotNull File file) {
        if (file == null) {
            ArchiveUtil.$$$reportNull$$$0(49);
        }
        File parentFile = file.getParentFile();
        String packedFileName = ArchiveUtil.getPackedFileName(file.getName());
        File file2 = parentFile != null ? new File(parentFile, packedFileName) : new File(packedFileName);
        if (file2 == null) {
            ArchiveUtil.$$$reportNull$$$0(50);
        }
        return file2;
    }

    @NotNull
    public static String getPackedFileName(@NotNull String fileName) {
        if (fileName == null) {
            ArchiveUtil.$$$reportNull$$$0(51);
        }
        String string = fileName + GZ;
        if (string == null) {
            ArchiveUtil.$$$reportNull$$$0(52);
        }
        return string;
    }

    public static boolean isPackedFile(@NotNull File file) {
        if (file == null) {
            ArchiveUtil.$$$reportNull$$$0(53);
        }
        return ArchiveUtil.isPackedFileName(file.getName());
    }

    public static boolean isPackedFileName(@NotNull String fileName) {
        if (fileName == null) {
            ArchiveUtil.$$$reportNull$$$0(54);
        }
        return fileName.endsWith(GZ);
    }

    @NotNull
    public static File packFile(@NotNull File srcFile) throws IOException {
        if (srcFile == null) {
            ArchiveUtil.$$$reportNull$$$0(55);
        }
        File packedFile = ArchiveUtil.getPackedFile(srcFile);
        ArchiveUtil.packFileTo(packedFile, srcFile);
        File file = packedFile;
        if (file == null) {
            ArchiveUtil.$$$reportNull$$$0(56);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packFileTo(@NotNull File dstFile, @NotNull File srcFile) throws IOException {
        if (dstFile == null) {
            ArchiveUtil.$$$reportNull$$$0(57);
        }
        if (srcFile == null) {
            ArchiveUtil.$$$reportNull$$$0(58);
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(srcFile);
            output = new FileOutputStream(dstFile);
            ArchiveUtil.packStream(output, input);
        }
        catch (Throwable throwable) {
            FileUtil.close(input);
            FileUtil.close(output);
            throw throwable;
        }
        FileUtil.close(input);
        FileUtil.close(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipContainsEntry(File zip, String relativePath) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        try {
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (!relativePath.equals(zipEntry.getName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Collection<ArchivedFileInfo> getArchivedFolderEntries(@NotNull ArchiveFileDescriptor archive, @NotNull String innerPathToFolder) throws IOException {
        Object entry;
        ArchiveEntryToArchivedFileInfoConverter converter;
        String segment;
        ArchiveInputStream stream;
        block15: {
            if (archive == null) {
                ArchiveUtil.$$$reportNull$$$0(59);
            }
            if (innerPathToFolder == null) {
                ArchiveUtil.$$$reportNull$$$0(60);
            }
            LinkedList<String> segments = new LinkedList<String>(ArchiveUtil.splitByArchivePathSeparator(innerPathToFolder, true));
            InputStream archiveInputStream = archive.getInputStream();
            ArrayList<InputStream> toClose = new ArrayList<InputStream>();
            toClose.add(archiveInputStream);
            stream = ArchiveUtil.getArchiveInputStream(archive.getName(), archiveInputStream);
            while (true) {
                if (stream == null) {
                    throw new FileNotFoundException("File " + innerPathToFolder + " not found in " + archive.toString() + ": archive not supported");
                }
                toClose.add((InputStream)stream);
                segment = StringUtil.removeLeadingSlash(StringUtil.convertAndCollapseSlashes((String)segments.poll()));
                if (segments.isEmpty()) {
                    converter = new ArchiveEntryToArchivedFileInfoConverter();
                    entry = stream.getNextEntry();
                    break block15;
                }
                ArchiveEntry entry2 = ArchiveUtil.positionArchivedPath(stream, segment);
                if (entry2 == null) {
                    throw new FileNotFoundException("File " + innerPathToFolder + " not found in " + archive.toString());
                }
                String name = StringUtil.convertAndCollapseSlashes(entry2.getName());
                stream = ArchiveUtil.getArchiveInputStream(name, (InputStream)new BufferedInputStream((InputStream)stream));
            }
            finally {
                Collections.reverse(toClose);
                Iterator iterator = toClose.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                    }
                    Closeable closeable = (Closeable)iterator.next();
                    FileUtil.close(closeable);
                }
            }
        }
        while (entry != null) {
            String string;
            String name = StringUtil.removeLeadingSlash(StringUtil.convertAndCollapseSlashes(entry.getName()));
            if (!ArchiveUtil.equalsIgnoringTLSlashes(innerPathToFolder, name) && name.startsWith(segment) && !StringUtil.isEmptyOrSpaces((String)(string = StringUtil.removeLeadingAndTailingSlash(name.substring(segment.length()))))) {
                converter.add(string, (ArchiveEntry)entry);
            }
            entry = stream.getNextEntry();
        }
        entry = converter.convert();
        Object object = entry;
        if (object == null) {
            ArchiveUtil.$$$reportNull$$$0(61);
        }
        return object;
    }

    @NotNull
    public static List<String> splitByArchivePathSeparator(@NotNull String path, boolean withEmptyLast) {
        if (path == null) {
            ArchiveUtil.$$$reportNull$$$0(62);
        }
        LinkedList<String> list = new LinkedList<String>(Arrays.asList(ARCHIVE_PATH_SEP_PATTERN.split(path)));
        if (withEmptyLast && path.endsWith(ARCHIVE_PATH_SEPARATOR)) {
            list.add("");
        }
        LinkedList<String> linkedList = list;
        if (linkedList == null) {
            ArchiveUtil.$$$reportNull$$$0(63);
        }
        return linkedList;
    }

    @Nullable
    private static ArchiveEntry positionArchivedPath(@NotNull ArchiveInputStream stream, @NotNull String path) throws IOException {
        if (stream == null) {
            ArchiveUtil.$$$reportNull$$$0(64);
        }
        if (path == null) {
            ArchiveUtil.$$$reportNull$$$0(65);
        }
        ArchiveEntry entry = stream.getNextEntry();
        while (entry != null) {
            String name = StringUtil.convertAndCollapseSlashes(entry.getName());
            if (ArchiveUtil.equalsIgnoringTLSlashes(name, path)) {
                return entry;
            }
            entry = stream.getNextEntry();
        }
        return null;
    }

    private static boolean equalsIgnoringTLSlashes(@NotNull String a, @NotNull String b) {
        if (a == null) {
            ArchiveUtil.$$$reportNull$$$0(66);
        }
        if (b == null) {
            ArchiveUtil.$$$reportNull$$$0(67);
        }
        a = StringUtil.removeLeadingAndTailingSlash(a);
        b = StringUtil.removeLeadingAndTailingSlash(b);
        return a.equals(b);
    }

    public static <T> T doInArchive(@NotNull ArchiveFileDescriptor archive, @NotNull String path, final @NotNull DoInArchiveHandler<T> callback) throws IOException {
        if (archive == null) {
            ArchiveUtil.$$$reportNull$$$0(68);
        }
        if (path == null) {
            ArchiveUtil.$$$reportNull$$$0(69);
        }
        if (callback == null) {
            ArchiveUtil.$$$reportNull$$$0(70);
        }
        return ArchiveUtil.doInArchive(archive, path, new DoInArchiveHandler2<T>(){

            @Override
            public T found(@NotNull ArchiveEntry entry, @NotNull ArchiveInputStream stream, @NotNull Deque<Closeable> shouldBeManuallyClosed) throws IOException {
                if (entry == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (stream == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (shouldBeManuallyClosed == null) {
                    1.$$$reportNull$$$0(2);
                }
                return callback.found(entry, stream);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "entry";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "stream";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "shouldBeManuallyClosed";
                        break;
                    }
                }
                objectArray[1] = "jetbrains/buildServer/util/ArchiveUtil$1";
                objectArray[2] = "found";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true);
    }

    public static <T> T doInArchive(@NotNull ArchiveFileDescriptor archive, @NotNull String path, @NotNull DoInArchiveHandler2<T> callable) throws IOException {
        if (archive == null) {
            ArchiveUtil.$$$reportNull$$$0(71);
        }
        if (path == null) {
            ArchiveUtil.$$$reportNull$$$0(72);
        }
        if (callable == null) {
            ArchiveUtil.$$$reportNull$$$0(73);
        }
        return ArchiveUtil.doInArchive(archive, path, callable, false);
    }

    private static <T> T doInArchive(@NotNull ArchiveFileDescriptor archive, @NotNull String path, @NotNull DoInArchiveHandler2<T> callable, boolean shouldCloseStreamsOnReturn) throws IOException {
        if (archive == null) {
            ArchiveUtil.$$$reportNull$$$0(74);
        }
        if (path == null) {
            ArchiveUtil.$$$reportNull$$$0(75);
        }
        if (callable == null) {
            ArchiveUtil.$$$reportNull$$$0(76);
        }
        LinkedList<String> segments = new LinkedList<String>(ArchiveUtil.splitByArchivePathSeparator(path, false));
        InputStream artifactStream = archive.getInputStream();
        boolean closeRequired = true;
        LinkedList<Closeable> toClose = new LinkedList<Closeable>();
        toClose.push(artifactStream);
        try {
            ArchiveInputStream stream = ArchiveUtil.getArchiveInputStream(archive.getName(), artifactStream);
            while (true) {
                if (stream == null) {
                    throw new FileNotFoundException("File " + path + " not found in " + archive.toString() + ": archive not supported");
                }
                toClose.push((Closeable)stream);
                String segment = StringUtil.convertAndCollapseSlashes((String)segments.poll());
                ArchiveEntry entry = ArchiveUtil.positionArchivedPath(stream, segment);
                if (entry == null) {
                    throw new FileNotFoundException("File " + path + " not found in " + archive.toString());
                }
                String found = StringUtil.convertAndCollapseSlashes(entry.getName());
                if (segments.isEmpty()) {
                    T result = callable.found(entry, stream, toClose);
                    if (!shouldCloseStreamsOnReturn) {
                        closeRequired = false;
                    }
                    T t = result;
                    return t;
                }
                stream = ArchiveUtil.getArchiveInputStream(found, (InputStream)new BufferedInputStream((InputStream)stream));
            }
        }
        finally {
            if (closeRequired) {
                while (!toClose.isEmpty()) {
                    FileUtil.close((Closeable)toClose.pop());
                }
            }
        }
    }

    @NotNull
    public static String getParentPath(@NotNull String path) {
        if (path == null) {
            ArchiveUtil.$$$reportNull$$$0(77);
        }
        path = StringUtil.convertAndCollapseSlashes(path);
        String parent = PathUtil.getParentPath((String)(path = StringUtil.removeTailingSlash(path)));
        if (parent.endsWith("!")) {
            String string = parent.substring(0, parent.length() - 1);
            if (string == null) {
                ArchiveUtil.$$$reportNull$$$0(78);
            }
            return string;
        }
        String string = parent;
        if (string == null) {
            ArchiveUtil.$$$reportNull$$$0(79);
        }
        return string;
    }

    public static boolean isNameAllowed(@Nullable String entryName) {
        return entryName == null || !entryName.startsWith("../") && !entryName.contains("/../");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 50: 
            case 52: 
            case 56: 
            case 61: 
            case 63: 
            case 78: 
            case 79: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 50: 
            case 52: 
            case 56: 
            case 61: 
            case 63: 
            case 78: 
            case 79: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 50: 
            case 52: 
            case 56: 
            case 61: 
            case 63: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/ArchiveUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveType";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 12: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPrefix";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 16: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 18: 
            case 39: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zf";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destFile";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destStream";
                break;
            }
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBuilder";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 48: 
            case 62: 
            case 65: 
            case 69: 
            case 72: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 59: 
            case 68: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerPathToFolder";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/ArchiveUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchiveType";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackedFile";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackedFileName";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "packFile";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchivedFolderEntries";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByArchivePathSeparator";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getArchiveType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 50: 
            case 52: 
            case 56: 
            case 61: 
            case 63: 
            case 78: 
            case 79: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArchiveInputStream";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unpackZip";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "saveEntry";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "packZip";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "packToZip";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "traverseAndWrite";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "packStream";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "unpackStream";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "extractEntry";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getPackedFile";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getPackedFileName";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isPackedFile";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isPackedFileName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "packFile";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "packFileTo";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getArchivedFolderEntries";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "splitByArchivePathSeparator";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "positionArchivedPath";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "equalsIgnoringTLSlashes";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "doInArchive";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 50: 
            case 52: 
            case 56: 
            case 61: 
            case 63: 
            case 78: 
            case 79: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArchiveEntryToArchivedFileInfoConverter {
        private final Map<String, ArchiveEntry> myMap = new LinkedHashMap<String, ArchiveEntry>();

        private ArchiveEntryToArchivedFileInfoConverter() {
        }

        public void add(@NotNull String name, @NotNull ArchiveEntry entry) {
            if (name == null) {
                ArchiveEntryToArchivedFileInfoConverter.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ArchiveEntryToArchivedFileInfoConverter.$$$reportNull$$$0(1);
            }
            if ((name = StringUtil.removeLeadingAndTailingSlash(name)).contains("/")) {
                this.myMap.put(name.substring(0, name.indexOf(47)), null);
            } else {
                this.myMap.put(name, entry);
            }
        }

        @NotNull
        public Collection<ArchivedFileInfo> convert() {
            List<ArchivedFileInfo> list = CollectionsUtil.convertCollection(this.myMap.entrySet(), new Converter<ArchivedFileInfo, Map.Entry<String, ArchiveEntry>>(){

                @Override
                public ArchivedFileInfo createFrom(@NotNull Map.Entry<String, ArchiveEntry> source) {
                    boolean isDirectory;
                    long timestamp;
                    long size;
                    if (source == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String name = source.getKey();
                    ArchiveEntry value = source.getValue();
                    if (value != null) {
                        ArchiveEntry entry = value;
                        size = entry.getSize();
                        timestamp = entry.getLastModifiedDate() != null ? entry.getLastModifiedDate().getTime() : -1L;
                        isDirectory = entry.isDirectory();
                    } else {
                        size = -1L;
                        timestamp = 0L;
                        isDirectory = true;
                    }
                    return new ArchivedFileInfo(name, size, timestamp, isDirectory);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/util/ArchiveUtil$ArchiveEntryToArchivedFileInfoConverter$1", "createFrom"));
                }
            });
            if (list == null) {
                ArchiveEntryToArchivedFileInfoConverter.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/ArchiveUtil$ArchiveEntryToArchivedFileInfoConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/ArchiveUtil$ArchiveEntryToArchivedFileInfoConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ArchivedFileInfo {
        public static final long SIZE_UNKNOWN = -1L;
        private final String myName;
        private final long mySize;
        private final long myTimestamp;
        private final boolean myIsDirectory;

        /*
         * WARNING - void declaration
         */
        public ArchivedFileInfo(@NotNull String name, long size, long timestamp, boolean bl) {
            void isDirectory;
            if (name == null) {
                ArchivedFileInfo.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.mySize = size;
            this.myTimestamp = timestamp;
            this.myIsDirectory = isDirectory;
        }

        public String getName() {
            return this.myName;
        }

        public long getSize() {
            return this.mySize;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        public boolean isDirectory() {
            return this.myIsDirectory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/ArchiveUtil$ArchivedFileInfo", "<init>"));
        }
    }

    public static interface DoInArchiveHandler2<T> {
        public T found(@NotNull ArchiveEntry var1, @NotNull ArchiveInputStream var2, @NotNull Deque<Closeable> var3) throws IOException;
    }

    public static interface DoInArchiveHandler<T> {
        public T found(@NotNull ArchiveEntry var1, @NotNull ArchiveInputStream var2) throws IOException;
    }

    public static interface ArchiveFileDescriptor {
        public InputStream getInputStream() throws IOException;

        public String getName();

        public String toString();
    }
}

