/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NotNull;

public class CloseAwareInputStream
extends InputStream {
    @NotNull
    private final InputStream myDelegate;
    @NotNull
    private final AtomicBoolean myIsClosed;

    public CloseAwareInputStream(@NotNull InputStream delegate) {
        if (delegate == null) {
            CloseAwareInputStream.$$$reportNull$$$0(0);
        }
        this.myDelegate = delegate;
        this.myIsClosed = new AtomicBoolean(false);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.myDelegate.skip(n);
    }

    @Override
    public int read() throws IOException {
        return this.myDelegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.myDelegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.myDelegate.read(b, off, len);
    }

    @Override
    public void close() {
        if (this.myIsClosed.compareAndSet(false, true)) {
            this.doClose();
        }
    }

    protected void doClose() {
        FileUtil.close(this.myDelegate);
    }

    @Override
    public int available() throws IOException {
        return this.myDelegate.available();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "jetbrains/buildServer/util/CloseAwareInputStream", "<init>"));
    }
}

