/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.Predicate;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionsUtil {
    public static final Filter ACCEPT_ALL = data -> true;
    public static final Converter SAME = source -> source;

    @NotNull
    public static <T> Filter<T> acceptAllFilter() {
        Filter<Object> filter = data -> true;
        if (filter == null) {
            CollectionsUtil.$$$reportNull$$$0(0);
        }
        return filter;
    }

    private CollectionsUtil() {
    }

    @NotNull
    public static <T> Set<T> flatten(@NotNull Collection<Pair<T, T>> data) {
        if (data == null) {
            CollectionsUtil.$$$reportNull$$$0(1);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Pair<T, T> pair : data) {
            set.add(pair.first);
            set.add(pair.second);
        }
        HashSet<Object> hashSet = set;
        if (hashSet == null) {
            CollectionsUtil.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    public static <T> Set<T> flatten(@NotNull Map<T, T> data) {
        if (data == null) {
            CollectionsUtil.$$$reportNull$$$0(3);
        }
        HashSet<T> set = new HashSet<T>();
        set.addAll(data.keySet());
        set.addAll(data.values());
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            CollectionsUtil.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    public static <ResultType, SourceType> List<ResultType> filterAndConvertCollection(Collection<? extends SourceType> source, @NotNull Converter<ResultType, SourceType> converter, @NotNull Filter<SourceType> filter) {
        if (converter == null) {
            CollectionsUtil.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            CollectionsUtil.$$$reportNull$$$0(6);
        }
        return CollectionsUtil.filterAndConvertCollection(source, converter, filter);
    }

    public static <ResultType, SourceType> List<ResultType> filterAndConvertCollection(Iterable<? extends SourceType> source, @NotNull Converter<ResultType, SourceType> converter, @NotNull Filter<SourceType> filter) {
        List result;
        if (converter == null) {
            CollectionsUtil.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            CollectionsUtil.$$$reportNull$$$0(8);
        }
        return (result = (List)CollectionsUtil.filterAndConvertCollection(source, new ArrayList(), converter, filter)) == null ? null : Collections.unmodifiableList(result);
    }

    public static <ResultType, ResultCollection extends Collection<ResultType>, SourceType> ResultCollection filterAndConvertCollection(Iterable<? extends SourceType> source, @NotNull ResultCollection collection, @NotNull Converter<ResultType, SourceType> converter, @NotNull Filter<SourceType> filter) {
        if (collection == null) {
            CollectionsUtil.$$$reportNull$$$0(9);
        }
        if (converter == null) {
            CollectionsUtil.$$$reportNull$$$0(10);
        }
        if (filter == null) {
            CollectionsUtil.$$$reportNull$$$0(11);
        }
        if (source == null) {
            return null;
        }
        for (SourceType o : source) {
            if (!filter.accept(o)) continue;
            Object newO = null;
            if (o != null) {
                newO = converter.createFrom(o);
            }
            collection.add(newO);
        }
        return collection;
    }

    public static <T> Collection<T> join(Collection<T> ... a) {
        int size = 0;
        for (Collection<T> collection : a) {
            size += collection.size();
        }
        ArrayList<T> union = new ArrayList<T>(size);
        for (Collection<T> collection : a) {
            union.addAll(collection);
        }
        return union;
    }

    public static <T> Collection<T> join(@NotNull Collection<T> a, @NotNull Collection<T> b) {
        if (a == null) {
            CollectionsUtil.$$$reportNull$$$0(12);
        }
        if (b == null) {
            CollectionsUtil.$$$reportNull$$$0(13);
        }
        ArrayList<T> list = new ArrayList<T>(a.size() + b.size());
        list.addAll(a);
        list.addAll(b);
        return list;
    }

    public static <T> Collection<T> join(@NotNull Collection<T> a, @NotNull Collection<T> b, @NotNull Collection<T> c) {
        if (a == null) {
            CollectionsUtil.$$$reportNull$$$0(14);
        }
        if (b == null) {
            CollectionsUtil.$$$reportNull$$$0(15);
        }
        if (c == null) {
            CollectionsUtil.$$$reportNull$$$0(16);
        }
        ArrayList<T> list = new ArrayList<T>(a.size() + b.size() + c.size());
        list.addAll(a);
        list.addAll(b);
        list.addAll(c);
        return list;
    }

    public static <SourceType> List<SourceType> filterCollection(Collection<? extends SourceType> source, Filter<SourceType> filter) {
        return CollectionsUtil.filterCollection(source, filter);
    }

    public static <SourceType> List<SourceType> filterCollection(Iterable<? extends SourceType> source, Filter<SourceType> filter) {
        return CollectionsUtil.filterAndConvertCollection(source, SAME, filter);
    }

    public static <ResultType, SourceType> List<ResultType> convertCollection(Collection<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        return CollectionsUtil.filterAndConvertCollection(source, converter, CollectionsUtil.acceptAllFilter());
    }

    public static <ResultType, SourceType> List<ResultType> convertCollection(Iterable<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        return CollectionsUtil.filterAndConvertCollection(source, converter, CollectionsUtil.acceptAllFilter());
    }

    public static <ResultType, SourceType> Set<ResultType> convertSet(Collection<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        return CollectionsUtil.convertSet(source, converter);
    }

    public static <ResultType, SourceType> Set<ResultType> convertSet(Iterable<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        Set result = CollectionsUtil.filterAndConvertCollection(source, new HashSet(), converter, CollectionsUtil.acceptAllFilter());
        return result != null ? Collections.unmodifiableSet(result) : null;
    }

    public static <SourceType> List<SourceType> collectUniqueObjectList(List<SourceType> list) {
        return new ArrayList<SourceType>(new LinkedHashSet<SourceType>(list));
    }

    @Nullable
    public static <T> T findFirst(Iterable<T> list, Filter<? super T> filter) {
        for (T element : list) {
            if (!filter.accept(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean contains(Iterable<T> iterable, Filter<? super T> filter) {
        return CollectionsUtil.findFirst(iterable, filter) != null;
    }

    public static <T extends Comparable<T>> void insertWithSorting(@NotNull T o, @NotNull List<T> list) {
        if (o == null) {
            CollectionsUtil.$$$reportNull$$$0(17);
        }
        if (list == null) {
            CollectionsUtil.$$$reportNull$$$0(18);
        }
        int invertedInsertion = Collections.binarySearch(list, o);
        int index = CollectionsUtil.calcInsertion(invertedInsertion);
        list.add(index, o);
    }

    public static <T> void insertWithSorting(@NotNull T o, @NotNull List<T> list, @NotNull Comparator<T> comp) {
        if (o == null) {
            CollectionsUtil.$$$reportNull$$$0(19);
        }
        if (list == null) {
            CollectionsUtil.$$$reportNull$$$0(20);
        }
        if (comp == null) {
            CollectionsUtil.$$$reportNull$$$0(21);
        }
        int invertedInsertion = Collections.binarySearch(list, o, comp);
        int index = CollectionsUtil.calcInsertion(invertedInsertion);
        list.add(index, o);
    }

    private static int calcInsertion(int insertionPoint) {
        return insertionPoint > -1 ? insertionPoint : -insertionPoint - 1;
    }

    @NotNull
    public static String to_s(@NotNull Collection c) {
        if (c == null) {
            CollectionsUtil.$$$reportNull$$$0(22);
        }
        StringBuilder sb = new StringBuilder();
        if (!c.isEmpty()) {
            for (Object o : c) {
                sb.append("\r\n");
                sb.append(o);
            }
        }
        String string = sb.toString();
        if (string == null) {
            CollectionsUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static <T> List<List<T>> split(@NotNull List<T> toSplit, int numParts) {
        if (toSplit == null) {
            CollectionsUtil.$$$reportNull$$$0(24);
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (toSplit.size() <= numParts) {
            result.add(toSplit);
            ArrayList<List<T>> arrayList = result;
            if (arrayList == null) {
                CollectionsUtil.$$$reportNull$$$0(25);
            }
            return arrayList;
        }
        int lastIdx = 0;
        int step = toSplit.size() / numParts;
        if (toSplit.size() % numParts > 0) {
            ++step;
        }
        for (int i = 0; i < numParts; ++i) {
            int fromIdx = lastIdx;
            int toIdx = Math.min(fromIdx + step, toSplit.size());
            List<T> subList = toSplit.subList(fromIdx, toIdx);
            result.add(subList);
            lastIdx = toIdx;
            int leftItems = toSplit.size() - lastIdx;
            int leftParts = numParts - i - 1;
            if (leftParts <= 0) continue;
            step = leftItems / leftParts;
        }
        ArrayList<List<T>> arrayList = result;
        if (arrayList == null) {
            CollectionsUtil.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    public static void retainMatched(@Nullable Collection<String> stringCollection, @NotNull Pattern pattern) {
        if (pattern == null) {
            CollectionsUtil.$$$reportNull$$$0(27);
        }
        if (stringCollection == null || stringCollection.isEmpty()) {
            return;
        }
        stringCollection.removeIf(s -> !pattern.matcher((CharSequence)s).matches());
    }

    @NotNull
    public static <T> Set<T> minus(Collection<T> minuend, @NotNull Collection<T> subtrahend) {
        Set<Object> subtrahendSet;
        if (subtrahend == null) {
            CollectionsUtil.$$$reportNull$$$0(28);
        }
        if (minuend == null || minuend.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                CollectionsUtil.$$$reportNull$$$0(29);
            }
            return set;
        }
        if (subtrahend.isEmpty()) {
            HashSet<T> hashSet = new HashSet<T>(minuend);
            if (hashSet == null) {
                CollectionsUtil.$$$reportNull$$$0(30);
            }
            return hashSet;
        }
        Set<Object> set = subtrahendSet = subtrahend instanceof Set ? (Set<Object>)subtrahend : new HashSet<T>(subtrahend);
        if (minuend instanceof SortedSet) {
            SortedSet<T> sortedSet = CollectionsUtil.minus((SortedSet)minuend, subtrahendSet);
            if (sortedSet == null) {
                CollectionsUtil.$$$reportNull$$$0(31);
            }
            return sortedSet;
        }
        Set set2 = minuend.stream().filter(item -> !subtrahendSet.contains(item)).collect(Collectors.toSet());
        if (set2 == null) {
            CollectionsUtil.$$$reportNull$$$0(32);
        }
        return set2;
    }

    @NotNull
    public static <T> SortedSet<T> minus(@NotNull SortedSet<T> minuend, @NotNull Set<T> subtrahend) {
        if (minuend == null) {
            CollectionsUtil.$$$reportNull$$$0(33);
        }
        if (subtrahend == null) {
            CollectionsUtil.$$$reportNull$$$0(34);
        }
        TreeSet<T> remainder = new TreeSet<T>(minuend.comparator());
        minuend.stream().filter(item -> !subtrahend.contains(item)).forEach(remainder::add);
        TreeSet<T> treeSet = remainder;
        if (treeSet == null) {
            CollectionsUtil.$$$reportNull$$$0(35);
        }
        return treeSet;
    }

    @NotNull
    public static <T> Set<T> intersect(@Nullable Collection<T> set1, @Nullable Collection<T> set2) {
        if (set1 == null || set1.isEmpty() || set2 == null || set2.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                CollectionsUtil.$$$reportNull$$$0(36);
            }
            return set;
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(Math.min(set1.size(), set2.size()));
        for (T item : set1) {
            if (!set2.contains(item)) continue;
            result.add(item);
        }
        LinkedHashSet<T> linkedHashSet = result;
        if (linkedHashSet == null) {
            CollectionsUtil.$$$reportNull$$$0(37);
        }
        return linkedHashSet;
    }

    public static <T extends Comparable<? super T>> boolean sortedListsIntersect(@NotNull List<T> list1, @NotNull List<T> list2) {
        int insPoint;
        int searchRes;
        Comparable list2_0;
        if (list1 == null) {
            CollectionsUtil.$$$reportNull$$$0(38);
        }
        if (list2 == null) {
            CollectionsUtil.$$$reportNull$$$0(39);
        }
        if (list1.isEmpty() || list2.isEmpty()) {
            return false;
        }
        int list1FromIdx = 0;
        int list1ToIdx = list1.size() - 1;
        int list2FromIdx = 0;
        int list2ToIdx = list2.size() - 1;
        Comparable list1_0 = (Comparable)list1.get(0);
        int res = list1_0.compareTo(list2_0 = (Comparable)list2.get(0));
        if (res == 0) {
            return true;
        }
        if (res > 0) {
            searchRes = Collections.binarySearch(list2, list1_0);
            if (searchRes >= 0) {
                return true;
            }
            insPoint = -(searchRes + 1);
            if (insPoint >= list2.size()) {
                return false;
            }
            list2FromIdx = insPoint;
        } else {
            searchRes = Collections.binarySearch(list1, list2_0);
            if (searchRes >= 0) {
                return true;
            }
            insPoint = -(searchRes + 1);
            if (insPoint >= list1.size()) {
                return false;
            }
            list1FromIdx = insPoint;
        }
        Comparable list1_last = (Comparable)list1.get(list1.size() - 1);
        Comparable list2_last = (Comparable)list2.get(list2.size() - 1);
        res = list1_last.compareTo(list2_last);
        if (res == 0) {
            return true;
        }
        if (res > 0) {
            searchRes = Collections.binarySearch(list1, list2_last);
            if (searchRes >= 0) {
                return true;
            }
            insPoint = -(searchRes + 1);
            if (insPoint == 0) {
                return false;
            }
            if (insPoint < list1.size()) {
                list1ToIdx = insPoint;
            }
        } else {
            searchRes = Collections.binarySearch(list2, list1_last);
            if (searchRes >= 0) {
                return true;
            }
            insPoint = -(searchRes + 1);
            if (insPoint == 0) {
                return false;
            }
            if (insPoint < list2.size()) {
                list2ToIdx = insPoint;
            }
        }
        List<T> _list1 = list1.subList(list1FromIdx, list1ToIdx + 1);
        List<T> _list2 = list2.subList(list2FromIdx, list2ToIdx + 1);
        if (_list2.size() < _list1.size()) {
            List<T> tmp = _list2;
            _list2 = _list1;
            _list1 = tmp;
        }
        int fromIdx = 0;
        int toIdx = _list2.size();
        for (Comparable obj : _list1) {
            List<T> subList = _list2.subList(fromIdx, toIdx);
            int searchRes2 = Collections.binarySearch(subList, obj);
            if (searchRes2 >= 0) {
                return true;
            }
            int insPoint2 = -(searchRes2 + 1) + fromIdx;
            if (insPoint2 >= _list2.size()) {
                return false;
            }
            fromIdx = insPoint2;
        }
        return false;
    }

    @NotNull
    public static <T, Coll extends Iterable<T>> Coll removeNulls(@NotNull Coll collection) {
        if (collection == null) {
            CollectionsUtil.$$$reportNull$$$0(40);
        }
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        Coll Coll = collection;
        if (Coll == null) {
            CollectionsUtil.$$$reportNull$$$0(41);
        }
        return Coll;
    }

    @NotNull
    public static <T> List<T> filterNulls(@NotNull Collection<T> collection) {
        if (collection == null) {
            CollectionsUtil.$$$reportNull$$$0(42);
        }
        ArrayList<T> result = new ArrayList<T>(collection.size());
        for (T element : collection) {
            if (element == null) continue;
            result.add(element);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            CollectionsUtil.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @NotNull
    public static <Result, Source> List<Result> convertAndFilterNulls(@NotNull Iterable<Source> source, @NotNull Converter<Result, Source> converter) {
        if (source == null) {
            CollectionsUtil.$$$reportNull$$$0(44);
        }
        if (converter == null) {
            CollectionsUtil.$$$reportNull$$$0(45);
        }
        List<Result> list = CollectionsUtil.filterNulls(CollectionsUtil.convertCollection(source, converter));
        if (list == null) {
            CollectionsUtil.$$$reportNull$$$0(46);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NotNull
    public static <T> Collection<T> unite(Collection<? extends T> ... col) {
        void var5_8;
        if (col == null) {
            CollectionsUtil.$$$reportNull$$$0(47);
        }
        int size = 0;
        for (Collection<T> collection : col) {
            size += collection.size();
        }
        ArrayList<? extends T> union = new ArrayList<T>(size);
        Collection<? extends T>[] collectionArray = col;
        int n = collectionArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            Collection<? extends T> collection = collectionArray[var5_8];
            union.addAll(collection);
            ++var5_8;
        }
        ArrayList<? extends T> arrayList = union;
        if (arrayList == null) {
            CollectionsUtil.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    public static <T, Q> List<T> applyOrder(@NotNull Q[] sortedIds, @NotNull List<T> allElements, @NotNull Map<Q, T> idToElementMap) {
        if (sortedIds == null) {
            CollectionsUtil.$$$reportNull$$$0(49);
        }
        if (allElements == null) {
            CollectionsUtil.$$$reportNull$$$0(50);
        }
        if (idToElementMap == null) {
            CollectionsUtil.$$$reportNull$$$0(51);
        }
        ArrayList<T> newOrder = new ArrayList<T>();
        HashSet<T> newOrderSet = new HashSet<T>();
        for (Q id : sortedIds) {
            T elem = idToElementMap.get(id);
            if (elem == null || !newOrderSet.add(elem)) continue;
            newOrder.add(elem);
        }
        int newOrderIdx = 0;
        ArrayList<T> result = new ArrayList<T>(allElements);
        for (int i = 0; i < result.size(); ++i) {
            Object item = result.get(i);
            if (newOrderIdx >= newOrder.size() || !newOrderSet.contains(item)) continue;
            result.set(i, newOrder.get(newOrderIdx++));
        }
        return result;
    }

    @NotNull
    public static <T> Map<T, T> asMap(T ... args) {
        if (args == null) {
            CollectionsUtil.$$$reportNull$$$0(52);
        }
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("The number of arguments must be even");
        }
        LinkedHashMap<T, T> result = new LinkedHashMap<T, T>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            result.put(args[i], args[i + 1]);
        }
        LinkedHashMap<T, T> linkedHashMap = result;
        if (linkedHashMap == null) {
            CollectionsUtil.$$$reportNull$$$0(53);
        }
        return linkedHashMap;
    }

    @NotNull
    public static <T> Set<T> setOf(T ... args) {
        if (args == null) {
            CollectionsUtil.$$$reportNull$$$0(54);
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(args));
        if (hashSet == null) {
            CollectionsUtil.$$$reportNull$$$0(55);
        }
        return hashSet;
    }

    public static <T> void removeDuplicates(@NotNull Collection<T> collection) {
        if (collection == null) {
            CollectionsUtil.$$$reportNull$$$0(56);
        }
        HashSet<T> set = new HashSet<T>(collection);
        collection.clear();
        collection.addAll(set);
    }

    @NotNull
    public static <T> Collection<T> removeDuplicatesPreservingOrder(@NotNull Collection<T> collection) {
        if (collection == null) {
            CollectionsUtil.$$$reportNull$$$0(57);
        }
        if (collection instanceof Set || collection.isEmpty()) {
            Collection<T> collection2 = collection;
            if (collection2 == null) {
                CollectionsUtil.$$$reportNull$$$0(58);
            }
            return collection2;
        }
        HashSet set = new HashSet(collection);
        if (set.size() == collection.size()) {
            Collection<T> collection3 = collection;
            if (collection3 == null) {
                CollectionsUtil.$$$reportNull$$$0(59);
            }
            return collection3;
        }
        ArrayList<Object> result = collection instanceof ArrayList ? (ArrayList<Object>)collection : new ArrayList<T>(collection);
        result.removeIf(t -> !set.remove(t));
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            CollectionsUtil.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    public static <T> int binarySearch(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            CollectionsUtil.$$$reportNull$$$0(61);
        }
        if (condition == null) {
            CollectionsUtil.$$$reportNull$$$0(62);
        }
        int falseIndex = 0;
        int trueIndex = list.size();
        while (falseIndex < trueIndex) {
            int midIndex = falseIndex + trueIndex >> 1;
            if (condition.value(list.get(midIndex))) {
                trueIndex = midIndex;
                continue;
            }
            falseIndex = midIndex + 1;
        }
        return trueIndex;
    }

    @NotNull
    public static <T> Iterator<T> toTypedIterator(final @NotNull Class<T> clazz, final @NotNull Iterator data) {
        if (clazz == null) {
            CollectionsUtil.$$$reportNull$$$0(63);
        }
        if (data == null) {
            CollectionsUtil.$$$reportNull$$$0(64);
        }
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return data.hasNext();
            }

            @Override
            public T next() {
                return clazz.cast(data.next());
            }

            @Override
            public void remove() {
                data.remove();
            }
        };
        if (iterator == null) {
            CollectionsUtil.$$$reportNull$$$0(65);
        }
        return iterator;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMapByKeys(@NotNull Map<K, V> map, @NotNull Filter<K> filter) {
        if (map == null) {
            CollectionsUtil.$$$reportNull$$$0(66);
        }
        if (filter == null) {
            CollectionsUtil.$$$reportNull$$$0(67);
        }
        Map<K, V> map2 = CollectionsUtil.filterMap(map, filter, CollectionsUtil.acceptAllFilter());
        if (map2 == null) {
            CollectionsUtil.$$$reportNull$$$0(68);
        }
        return map2;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMapByValues(@NotNull Map<K, V> map, @NotNull Filter<V> filter) {
        if (map == null) {
            CollectionsUtil.$$$reportNull$$$0(69);
        }
        if (filter == null) {
            CollectionsUtil.$$$reportNull$$$0(70);
        }
        Map<K, V> map2 = CollectionsUtil.filterMap(map, CollectionsUtil.acceptAllFilter(), filter);
        if (map2 == null) {
            CollectionsUtil.$$$reportNull$$$0(71);
        }
        return map2;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMap(@NotNull Map<K, V> map, @NotNull Filter<K> keyFilter, @NotNull Filter<V> valueFilter) {
        if (map == null) {
            CollectionsUtil.$$$reportNull$$$0(72);
        }
        if (keyFilter == null) {
            CollectionsUtil.$$$reportNull$$$0(73);
        }
        if (valueFilter == null) {
            CollectionsUtil.$$$reportNull$$$0(74);
        }
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> kv : map.entrySet()) {
            V value = kv.getValue();
            K key = kv.getKey();
            if (!keyFilter.accept(key) || value == null || !valueFilter.accept(value)) continue;
            result.put(key, value);
        }
        LinkedHashMap<K, V> linkedHashMap = result;
        if (linkedHashMap == null) {
            CollectionsUtil.$$$reportNull$$$0(75);
        }
        return linkedHashMap;
    }

    public static <K, V> int count(@NotNull Map<K, V> map, @NotNull Filter<K> keyFilter, @NotNull Filter<V> valueFilter) {
        if (map == null) {
            CollectionsUtil.$$$reportNull$$$0(76);
        }
        if (keyFilter == null) {
            CollectionsUtil.$$$reportNull$$$0(77);
        }
        if (valueFilter == null) {
            CollectionsUtil.$$$reportNull$$$0(78);
        }
        int count = 0;
        for (Map.Entry<K, V> kv : map.entrySet()) {
            if (!keyFilter.accept(kv.getKey()) || !valueFilter.accept(kv.getValue())) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public static <K, V> Map<K, List<V>> groupBy(@NotNull Collection<V> collection, @NotNull Converter<K, V> converter) {
        if (collection == null) {
            CollectionsUtil.$$$reportNull$$$0(79);
        }
        if (converter == null) {
            CollectionsUtil.$$$reportNull$$$0(80);
        }
        LinkedHashMap<Object, List> result = new LinkedHashMap<Object, List>();
        for (V v : collection) {
            Object converted = v != null ? (Object)converter.createFrom(v) : null;
            result.computeIfAbsent(converted, c -> new ArrayList()).add(v);
        }
        LinkedHashMap<Object, List> linkedHashMap = result;
        if (linkedHashMap == null) {
            CollectionsUtil.$$$reportNull$$$0(81);
        }
        return linkedHashMap;
    }

    public static <K, V, K2, V2> void convertMap(@NotNull Map<? extends K, ? extends V> source, @NotNull Map<? super K2, ? super V2> target, @NotNull Converter<K2, K> keyConverter, @NotNull Converter<V2, V> valueConverter) {
        if (source == null) {
            CollectionsUtil.$$$reportNull$$$0(82);
        }
        if (target == null) {
            CollectionsUtil.$$$reportNull$$$0(83);
        }
        if (keyConverter == null) {
            CollectionsUtil.$$$reportNull$$$0(84);
        }
        if (valueConverter == null) {
            CollectionsUtil.$$$reportNull$$$0(85);
        }
        for (Map.Entry<K, V> e : source.entrySet()) {
            K ks = e.getKey();
            V vs = e.getValue();
            target.put(ks != null ? (Object)keyConverter.createFrom(ks) : null, vs != null ? (Object)valueConverter.createFrom(vs) : null);
        }
    }

    public static <T> T[] toArray(@NotNull Collection<T> collection, @NotNull Class<T> clazz) {
        if (collection == null) {
            CollectionsUtil.$$$reportNull$$$0(86);
        }
        if (clazz == null) {
            CollectionsUtil.$$$reportNull$$$0(87);
        }
        int n = collection.size();
        Object[] array = (Object[])Array.newInstance(clazz, n);
        int k = 0;
        for (T item : collection) {
            if (k >= n) break;
            array[k] = item;
            ++k;
        }
        return array;
    }

    public static String[] toStringArray(@NotNull Collection<String> strings) {
        if (strings == null) {
            CollectionsUtil.$$$reportNull$$$0(88);
        }
        return CollectionsUtil.toArray(strings, String.class);
    }

    @NotNull
    public static <T> List<T> ensureModifiable(@NotNull List<T> items) {
        if (items == null) {
            CollectionsUtil.$$$reportNull$$$0(89);
        }
        if (!(items instanceof ArrayList)) {
            items = new ArrayList<T>(items);
        }
        List<T> list = items;
        if (list == null) {
            CollectionsUtil.$$$reportNull$$$0(90);
        }
        return list;
    }

    @NotNull
    public static <T> ArrayList<T> toArrayList(@NotNull Collection<T> items) {
        if (items == null) {
            CollectionsUtil.$$$reportNull$$$0(91);
        }
        if (!(items instanceof ArrayList)) {
            items = new ArrayList<T>(items);
        }
        ArrayList arrayList = (ArrayList)items;
        if (arrayList == null) {
            CollectionsUtil.$$$reportNull$$$0(92);
        }
        return arrayList;
    }

    public static <K, V> Map<K, V> emptyHashMapIfNull(Map<K, V> map) {
        return map != null ? map : new HashMap();
    }

    public static <T> boolean addIfNotNull(@NotNull Collection<T> collection, @Nullable T object) {
        if (collection == null) {
            CollectionsUtil.$$$reportNull$$$0(93);
        }
        return object != null && collection.add(object);
    }

    @NotNull
    public static <T> Iterable<T> reversed(@NotNull List<T> list) {
        if (list == null) {
            CollectionsUtil.$$$reportNull$$$0(94);
        }
        ReverseIterable<T> reverseIterable = new ReverseIterable<T>(list);
        if (reverseIterable == null) {
            CollectionsUtil.$$$reportNull$$$0(95);
        }
        return reverseIterable;
    }

    public static <T extends Enum<T>> EnumSet<T> copyOf(@NotNull Class<T> type, @NotNull Collection<T> from) {
        if (type == null) {
            CollectionsUtil.$$$reportNull$$$0(96);
        }
        if (from == null) {
            CollectionsUtil.$$$reportNull$$$0(97);
        }
        EnumSet<T> ts = EnumSet.noneOf(type);
        ts.addAll(from);
        return ts;
    }

    @NotNull
    public static <K, E> Map<K, Set<E>> unmodifiable(@NotNull Map<K, Set<E>> map) {
        if (map == null) {
            CollectionsUtil.$$$reportNull$$$0(98);
        }
        LinkedHashMap<K, Set<E>> copyMap = new LinkedHashMap<K, Set<E>>();
        for (Map.Entry<K, Set<E>> entry : map.entrySet()) {
            copyMap.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        Map map2 = Collections.unmodifiableMap(copyMap);
        if (map2 == null) {
            CollectionsUtil.$$$reportNull$$$0(99);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/CollectionsUtil";
                break;
            }
            case 1: 
            case 3: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 45: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: 
            case 40: 
            case 42: 
            case 56: 
            case 57: 
            case 79: 
            case 86: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 18: 
            case 20: 
            case 61: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSplit";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtrahend";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minuend";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 44: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedIds";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElements";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToElementMap";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 63: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 66: 
            case 69: 
            case 72: 
            case 76: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 73: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 74: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFilter";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConverter";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConverter";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptAllFilter";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/CollectionsUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "to_s";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "intersect";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNulls";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNulls";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAndFilterNulls";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "unite";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "asMap";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "setOf";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesPreservingOrder";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "toTypedIterator";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMapByKeys";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMapByValues";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMap";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureModifiable";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "toArrayList";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "reversed";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterAndConvertCollection";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertWithSorting";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "to_s";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "retainMatched";
                break;
            }
            case 28: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sortedListsIntersect";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeNulls";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "filterNulls";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "convertAndFilterNulls";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "unite";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "applyOrder";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "asMap";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setOf";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesPreservingOrder";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "binarySearch";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "toTypedIterator";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "filterMapByKeys";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "filterMapByValues";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "filterMap";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "convertMap";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "toStringArray";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "ensureModifiable";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "toArrayList";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "reversed";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "copyOf";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FilteringIterator<T>
    implements Iterator<T> {
        @NotNull
        private final Iterator<T> myIterator;
        @NotNull
        private final Predicate<T> myFilter;
        @Nullable
        private T myNext;
        private boolean myNextAvailable;

        public FilteringIterator(@NotNull Iterator<T> iterator, @NotNull Predicate<T> filter) {
            if (iterator == null) {
                FilteringIterator.$$$reportNull$$$0(0);
            }
            if (filter == null) {
                FilteringIterator.$$$reportNull$$$0(1);
            }
            this.myNextAvailable = false;
            this.myIterator = iterator;
            this.myFilter = filter;
            this.myNext = null;
        }

        private boolean ensureNext(boolean check) {
            T next;
            if (this.myNextAvailable) {
                return true;
            }
            do {
                if (!check || this.myIterator.hasNext()) continue;
                this.myNextAvailable = false;
                return false;
            } while (!this.myFilter.apply(next = this.myIterator.next()));
            this.myNext = next;
            this.myNextAvailable = true;
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.ensureNext(true);
        }

        @Override
        public T next() {
            this.ensureNext(false);
            this.myNextAvailable = false;
            return this.myNext;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "iterator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/util/CollectionsUtil$FilteringIterator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FilteringEnumeration<T>
    implements Enumeration<T> {
        private final FilteringIterator<T> myFilteringIterator;

        public FilteringEnumeration(@NotNull Enumeration<? extends T> enumeration, @NotNull Predicate<T> filter) {
            if (enumeration == null) {
                FilteringEnumeration.$$$reportNull$$$0(0);
            }
            if (filter == null) {
                FilteringEnumeration.$$$reportNull$$$0(1);
            }
            this.myFilteringIterator = new FilteringIterator<T>(new EnumerationIteratorAdaptor<T>(enumeration), filter);
        }

        @Override
        public boolean hasMoreElements() {
            return this.myFilteringIterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.myFilteringIterator.next();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "enumeration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/util/CollectionsUtil$FilteringEnumeration";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class EnumerationIteratorAdaptor<T>
    implements Iterator<T> {
        @NotNull
        private final Enumeration<? extends T> myEnumeration;

        public EnumerationIteratorAdaptor(@NotNull Enumeration<? extends T> enumeration) {
            if (enumeration == null) {
                EnumerationIteratorAdaptor.$$$reportNull$$$0(0);
            }
            this.myEnumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.myEnumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.myEnumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumeration", "jetbrains/buildServer/util/CollectionsUtil$EnumerationIteratorAdaptor", "<init>"));
        }
    }

    public static class FilteringIterable<T>
    implements Iterable<T> {
        @NotNull
        private final Iterable<T> myIterable;
        @NotNull
        private final Predicate<T> myFilter;

        public FilteringIterable(@NotNull Iterable<T> iterable, @NotNull Predicate<T> filter) {
            if (iterable == null) {
                FilteringIterable.$$$reportNull$$$0(0);
            }
            if (filter == null) {
                FilteringIterable.$$$reportNull$$$0(1);
            }
            this.myIterable = iterable;
            this.myFilter = filter;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            FilteringIterator<T> filteringIterator = new FilteringIterator<T>(this.myIterable.iterator(), this.myFilter);
            if (filteringIterator == null) {
                FilteringIterable.$$$reportNull$$$0(2);
            }
            return filteringIterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/CollectionsUtil$FilteringIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/CollectionsUtil$FilteringIterable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReverseIterable<T>
    implements Iterable<T> {
        private final List<T> myList;

        ReverseIterable(@NotNull List<T> list) {
            if (list == null) {
                ReverseIterable.$$$reportNull$$$0(0);
            }
            this.myList = list;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            final ListIterator<T> myListIterator = this.myList.listIterator(this.myList.size());
            Iterator iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return myListIterator.hasPrevious();
                }

                @Override
                public T next() {
                    return myListIterator.previous();
                }

                @Override
                public void remove() {
                    throw new IllegalArgumentException("Shouldn't be used");
                }
            };
            if (iterator == null) {
                ReverseIterable.$$$reportNull$$$0(1);
            }
            return iterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/CollectionsUtil$ReverseIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/CollectionsUtil$ReverseIterable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

