/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Dates {
    public static final String DEFAULT_DATE_FORMAT = "dd MMM yy HH:mm";
    public static final int JAN = 0;
    public static final int FEB = 1;
    public static final int MAR = 2;
    public static final int APR = 3;
    public static final int MAY = 4;
    public static final int JUN = 5;
    public static final int JUL = 6;
    public static final int AUG = 7;
    public static final int SEP = 8;
    public static final int OCT = 9;
    public static final int NOV = 10;
    public static final int DEC = 11;
    private static final String DEFAULT_TIME_ZONE = "Europe/Prague";
    public static final long ONE_SECOND = TimeUnit.SECONDS.toMillis(1L);
    public static final long ONE_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    public static final long ONE_HOUR = TimeUnit.HOURS.toMillis(1L);
    public static final long ONE_DAY = TimeUnit.DAYS.toMillis(1L);
    public static final long ONE_WEEK = TimeUnit.DAYS.toMillis(7L);
    private static final SimpleDateFormat formalDateFormatter = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
    private static final SimpleDateFormat formalTimeFormatter = new SimpleDateFormat("yyyyMMdd.HHmmss", Locale.ENGLISH);

    public static Date makeDate(int year, int month, int day) {
        return Dates.makeDate(year, month, day, Calendar.getInstance(TimeZone.getTimeZone(DEFAULT_TIME_ZONE)));
    }

    public static long seconds(double num) {
        return (long)(num * 1000.0);
    }

    public static long minutes(double num) {
        return (long)(num * 60.0 * 1000.0);
    }

    public static long hours(double num) {
        return (long)(num * 60.0 * 60.0 * 1000.0);
    }

    public static long days(double num) {
        return (long)(num * 24.0 * 60.0 * 60.0 * 1000.0);
    }

    public static Date after(Date date, long timeMs) {
        return new Date(date.getTime() + timeMs);
    }

    public static Date before(Date date, long timeMs) {
        return new Date(date.getTime() - timeMs);
    }

    public static Date afterNow(long timeMs) {
        return new Date(System.currentTimeMillis() + timeMs);
    }

    public static Date beforeNow(long timeMs) {
        return new Date(System.currentTimeMillis() - timeMs);
    }

    public static Date makeDate(int year, int month, int day, Calendar calendar) {
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static Date now() {
        return new Date();
    }

    public static Date today() {
        return Dates.truncateTime(new Date());
    }

    public static Date tomorrow() {
        return Dates.truncateTime(Dates.daysAfterNow(1));
    }

    public static Date yesterday() {
        return Dates.truncateTime(Dates.daysBeforeNow(1));
    }

    public static Date after(Date date) {
        return Dates.after(date, 1L);
    }

    public static Date before(Date date) {
        return Dates.before(date, 1L);
    }

    public static Date makeDate(int year, int month, int day, int hour, int minute, int second, String timeZone) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (timeZone != null) {
            calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        calendar.set(year, month - 1, day, hour, minute, second);
        return calendar.getTime();
    }

    public static boolean isBeforeWithError(Date before, Date after, long allowedError) {
        long afterTime;
        long beforeTime = before.getTime();
        return beforeTime < (afterTime = after.getTime()) - allowedError;
    }

    public static Date daysBeforeNow(int days) {
        return Dates.daysBefore(Dates.now(), days);
    }

    public static Date daysAfterNow(int days) {
        return Dates.daysAfter(Dates.now(), days);
    }

    public static Date daysBefore(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, -days);
        return c.getTime();
    }

    public static Date daysAfter(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return c.getTime();
    }

    public static Date truncateTime(Date dateAndTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateAndTime);
        Dates.truncateCalendar(calendar);
        return calendar.getTime();
    }

    public static void truncateCalendar(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void truncateCalendarToEndOfDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
    }

    public static boolean isDayChanged(@NotNull Date date1, @NotNull Date date2) {
        if (date1 == null) {
            Dates.$$$reportNull$$$0(0);
        }
        if (date2 == null) {
            Dates.$$$reportNull$$$0(1);
        }
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        return !Dates.isSameDay(cal1, cal2);
    }

    public static String formatInterval(Date from, Date to, @NotNull TimeZone tz) {
        if (tz == null) {
            Dates.$$$reportNull$$$0(2);
        }
        if (from == null) {
            throw new NullPointerException("'From' date cannot be null");
        }
        if (to == null) {
            return Dates.formatDate(from, "dd MMM HH:mm", tz) + " - ???";
        }
        if (Dates.isDayChanged(from, to)) {
            return Dates.formatDate(from, "dd MMM HH:mm", tz) + " - " + Dates.formatDate(to, "dd MMM HH:mm", tz);
        }
        return Dates.formatDate(from, "dd MMM HH:mm", tz) + " - " + Dates.formatDate(to, "HH:mm", tz);
    }

    public static String formatDate(Date date, String format) {
        return Dates.formatDate(date, format, TimeZone.getDefault());
    }

    @NotNull
    public static String formatDate(@NotNull Date date, @NotNull String pattern, @NotNull TimeZone tz) {
        if (date == null) {
            Dates.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            Dates.$$$reportNull$$$0(4);
        }
        if (tz == null) {
            Dates.$$$reportNull$$$0(5);
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern, Locale.ENGLISH);
        df.setTimeZone(tz);
        String string = df.format(date);
        if (string == null) {
            Dates.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static String convertDateToFormalString(Date date) {
        return date != null ? formalDateFormatter.format(date) : "";
    }

    public static String convertTimeToFormalString(Date time) {
        return time != null ? formalTimeFormatter.format(time) : "";
    }

    public static boolean isSameDay(@NotNull Calendar cal1, @NotNull Calendar cal2) {
        if (cal1 == null) {
            Dates.$$$reportNull$$$0(7);
        }
        if (cal2 == null) {
            Dates.$$$reportNull$$$0(8);
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static int daysBetween(@NotNull Date startDate, @NotNull Date endDate) {
        if (startDate == null) {
            Dates.$$$reportNull$$$0(9);
        }
        if (endDate == null) {
            Dates.$$$reportNull$$$0(10);
        }
        Calendar end = Calendar.getInstance();
        end.setTime(Dates.truncateTime(endDate));
        Calendar start = Calendar.getInstance();
        start.setTime(Dates.truncateTime(startDate));
        if (start.equals(end)) {
            return 0;
        }
        if (start.after(end)) {
            throw new IllegalArgumentException("Start date cannot be after the end date");
        }
        int days = 0;
        do {
            start.add(5, 1);
            ++days;
        } while (!start.equals(end) && !start.after(end));
        return days;
    }

    @NotNull
    public static Date toStandardDate(@NotNull Date date) {
        if (date == null) {
            Dates.$$$reportNull$$$0(11);
        }
        Date date2 = new Date(date.getTime());
        if (date2 == null) {
            Dates.$$$reportNull$$$0(12);
        }
        return date2;
    }

    public static TimeZone[] getSortedTimeZones() {
        TimeZone[] result = Dates.getFilteredTimeZones();
        final long currentTime = System.currentTimeMillis();
        Comparator<TimeZone> c = new Comparator<TimeZone>(){

            @Override
            public int compare(TimeZone o1, TimeZone o2) {
                return o1.getOffset(currentTime) - o2.getOffset(currentTime);
            }
        };
        Arrays.sort(result, c);
        return result;
    }

    private static TimeZone[] getFilteredTimeZones() {
        String[] ids = TimeZone.getAvailableIDs();
        ArrayList<TimeZone> zones = new ArrayList<TimeZone>(ids.length);
        TimeZone serverTZ = TimeZone.getDefault();
        boolean added = false;
        for (String id : ids) {
            if (!id.contains("/") || id.contains("GMT") || id.indexOf(47) != id.lastIndexOf(47) || id.contains("SystemV")) continue;
            TimeZone timeZone = TimeZone.getTimeZone(id);
            if (serverTZ.equals(timeZone)) {
                added = true;
            }
            zones.add(timeZone);
        }
        if (!added) {
            zones.add(serverTZ);
        }
        return zones.toArray(new TimeZone[zones.size()]);
    }

    @NotNull
    public static String formatNanos(long nanos) {
        StringBuilder sb = new StringBuilder();
        long seconds = TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS);
        long millis = TimeUnit.MILLISECONDS.convert(nanos -= TimeUnit.NANOSECONDS.convert(seconds, TimeUnit.SECONDS), TimeUnit.NANOSECONDS);
        long micros = TimeUnit.MICROSECONDS.convert(nanos -= TimeUnit.NANOSECONDS.convert(millis, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS);
        nanos -= TimeUnit.NANOSECONDS.convert(micros, TimeUnit.MICROSECONDS);
        if (seconds != 0L) {
            sb.append(seconds).append("s");
        }
        if (millis != 0L) {
            sb.append(millis).append("ms");
        }
        if (micros != 0L) {
            sb.append(micros).append("us");
        }
        if (nanos != 0L) {
            sb.append(nanos).append("ns");
        }
        String string = sb.toString();
        if (string == null) {
            Dates.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static String formatTimeZoneLong(@NotNull TimeZone tz) {
        if (tz == null) {
            Dates.$$$reportNull$$$0(14);
        }
        return Dates.formatTimeZoneID(tz) + " (" + Dates.formatTimeZoneUTCOffset(tz) + ')';
    }

    public static String formatTimeZoneID(@NotNull TimeZone tz) {
        if (tz == null) {
            Dates.$$$reportNull$$$0(15);
        }
        return tz.getDisplayName(false, 0) + ' ' + tz.getID().replace('_', ' ');
    }

    @NotNull
    public static String getTimeZoneDescription(@Nullable String timeZone) {
        String string = timeZone == null ? "Server Time Zone - " + Dates.formatTimeZoneID(TimeZone.getDefault()) : Dates.formatTimeZoneID(TimeZone.getTimeZone(timeZone));
        if (string == null) {
            Dates.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static String formatTimeZoneUTCOffset() {
        return Dates.formatTimeZoneUTCOffset(TimeZone.getDefault());
    }

    public static String formatTimeZoneUTCOffset(@NotNull TimeZone tz) {
        if (tz == null) {
            Dates.$$$reportNull$$$0(17);
        }
        int currentOffset = tz.getOffset(System.currentTimeMillis());
        int low = Math.abs(currentOffset / 60000 % 60);
        int high = Math.abs(currentOffset / 3600000);
        return "UTC" + (currentOffset >= 0 ? (char)'+' : '-') + high + (low > 0 ? ":" + (low < 10 ? "0" + low : Integer.valueOf(low)) : "");
    }

    public static boolean isValidTimeZoneID(@NotNull String tzID) {
        if (tzID == null) {
            Dates.$$$reportNull$$$0(18);
        }
        for (String tz : TimeZone.getAvailableIDs()) {
            if (!tz.equals(tzID)) continue;
            return true;
        }
        return false;
    }

    public static Calendar translateFromTimeZone(Calendar initDate, TimeZone timeZone) {
        if (timeZone == null) {
            return initDate;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(initDate.getTimeInMillis());
        c.get(10);
        return c;
    }

    public static Calendar transletoToTimeZone(Calendar initDate, TimeZone timeZone) {
        if (timeZone == null) {
            return initDate;
        }
        Calendar c = Calendar.getInstance(timeZone);
        c.setTimeInMillis(initDate.getTimeInMillis());
        c.get(10);
        return c;
    }

    public static Calendar copy(Calendar to, Calendar from) {
        to.set(from.get(1), from.get(2), from.get(5), from.get(11), from.get(12), from.get(13));
        to.set(14, from.get(14));
        return to;
    }

    public static SimpleDateFormat getSimpleFileDateFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date2";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tz";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/Dates";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cal1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cal2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endDate";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tzID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/Dates";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toStandardDate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatNanos";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeZoneDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDayChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formatInterval";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatDate";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSameDay";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "daysBetween";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toStandardDate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatTimeZoneLong";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatTimeZoneID";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "formatTimeZoneUTCOffset";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isValidTimeZoneID";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

