/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.NamedThreadUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.util.TimePrinter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagnosticUtil {
    public static final String FILE_DATE_FORMAT = "yyyy-MM-dd_HH.mm.ss";
    public static final String THREAD_DUMP_PREFIX = "threadDump";
    public static final String THREAD_DUMP_EXTENSION = ".txt";
    public static final String TC_TOTAL_MEMORY_USAGE_KEY = "TC_TOTAL_MEMORY_USAGE_KEY";
    public static final String THREAD_DUMP_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    @NonNls
    private static final String EOL = System.getProperty("line.separator");
    public static final String DIR_PREFIX = "threadDumps-";
    @Nullable
    private static Method ourGetProcessCpuLoad;
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";

    public static void threadDumpToStream(final @NotNull PrintStream out) {
        if (out == null) {
            DiagnosticUtil.$$$reportNull$$$0(0);
        }
        DiagnosticUtil.threadDumpInternal(new Printer(){

            @Override
            public void println(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                out.println(text);
            }

            @Override
            public void println() {
                out.println();
            }

            @Override
            public void print(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                out.print(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "text";
                objectArray2[1] = "jetbrains/buildServer/util/DiagnosticUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "println";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new ThreadDumpData());
    }

    public static void threadDumpToStream(final @NotNull PrintWriter out) {
        if (out == null) {
            DiagnosticUtil.$$$reportNull$$$0(1);
        }
        DiagnosticUtil.threadDumpInternal(new Printer(){

            @Override
            public void println(@NotNull String text) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                out.println(text);
            }

            @Override
            public void println() {
                out.println();
            }

            @Override
            public void print(@NotNull String text) {
                if (text == null) {
                    2.$$$reportNull$$$0(1);
                }
                out.print(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "text";
                objectArray2[1] = "jetbrains/buildServer/util/DiagnosticUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "println";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new ThreadDumpData());
    }

    public static void threadDumpToStream(final @NotNull PrintWriter out, @NotNull ThreadDumpData threadDumpData) {
        if (out == null) {
            DiagnosticUtil.$$$reportNull$$$0(2);
        }
        if (threadDumpData == null) {
            DiagnosticUtil.$$$reportNull$$$0(3);
        }
        DiagnosticUtil.threadDumpInternal(new Printer(){

            @Override
            public void println(@NotNull String text) {
                if (text == null) {
                    3.$$$reportNull$$$0(0);
                }
                out.println(text);
            }

            @Override
            public void println() {
                out.println();
            }

            @Override
            public void print(@NotNull String text) {
                if (text == null) {
                    3.$$$reportNull$$$0(1);
                }
                out.print(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "text";
                objectArray2[1] = "jetbrains/buildServer/util/DiagnosticUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "println";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, threadDumpData);
    }

    public static File threadDumpToDirectory(@Nullable File dir, @Nullable String suffix, @NotNull ThreadDumpData data) {
        if (data == null) {
            DiagnosticUtil.$$$reportNull$$$0(4);
        }
        if (dir != null && !dir.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory: " + dir.getAbsolutePath());
        }
        return DiagnosticUtil.threadDumpToFile(DiagnosticUtil.getDiagnosticFile(dir, StringUtil.isEmpty((String)suffix) ? THREAD_DUMP_PREFIX : suffix, THREAD_DUMP_EXTENSION), data);
    }

    public static File threadDumpToDirectory(@Nullable File dir, @NotNull ThreadDumpData data) {
        if (data == null) {
            DiagnosticUtil.$$$reportNull$$$0(5);
        }
        return DiagnosticUtil.threadDumpToDirectory(dir, null, data);
    }

    public static File threadDumpToFile(@NotNull File file, @NotNull ThreadDumpData data) {
        if (file == null) {
            DiagnosticUtil.$$$reportNull$$$0(6);
        }
        if (data == null) {
            DiagnosticUtil.$$$reportNull$$$0(7);
        }
        String dump = DiagnosticUtil.threadDumpToString(data);
        FileUtil.writeFile(file, dump);
        return file;
    }

    public static File writeThreadDump(@NotNull File baseDir, @NotNull String threadDump) {
        if (baseDir == null) {
            DiagnosticUtil.$$$reportNull$$$0(8);
        }
        if (threadDump == null) {
            DiagnosticUtil.$$$reportNull$$$0(9);
        }
        File diagnosticFile = DiagnosticUtil.getDiagnosticFile(baseDir, THREAD_DUMP_PREFIX, THREAD_DUMP_EXTENSION);
        FileUtil.writeFile(diagnosticFile, threadDump);
        return diagnosticFile;
    }

    public static File getAutomaticThreadDumpsSubdirectory(@NotNull File baseDir) throws IOException {
        File dir;
        if (baseDir == null) {
            DiagnosticUtil.$$$reportNull$$$0(10);
        }
        if (!(dir = new File(baseDir, Dates.getSimpleFileDateFormatter().format(Dates.now()))).exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir.getAbsolutePath());
        }
        return dir;
    }

    public static File getDiagnosticFile(@Nullable File baseDir, @NotNull String suffix, @NotNull String ext) {
        if (suffix == null) {
            DiagnosticUtil.$$$reportNull$$$0(11);
        }
        if (ext == null) {
            DiagnosticUtil.$$$reportNull$$$0(12);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(FILE_DATE_FORMAT);
        File parentDir = baseDir == null ? new File(".") : baseDir;
        return new File(parentDir, sdf.format(Dates.now()) + "-" + suffix + ext).getAbsoluteFile();
    }

    @NotNull
    public static String threadDumpToString() {
        String string = DiagnosticUtil.threadDumpToString(new ThreadDumpData());
        if (string == null) {
            DiagnosticUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String threadDumpToString(@NotNull ThreadDumpData data) {
        if (data == null) {
            DiagnosticUtil.$$$reportNull$$$0(14);
        }
        final StringBuilder sb = new StringBuilder();
        DiagnosticUtil.threadDumpInternal(new Printer(){

            @Override
            public void println(@NotNull String text) {
                if (text == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.print(text);
                this.println();
            }

            @Override
            public void println() {
                sb.append("\n");
            }

            @Override
            public void print(@NotNull String text) {
                if (text == null) {
                    4.$$$reportNull$$$0(1);
                }
                sb.append(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "text";
                objectArray2[1] = "jetbrains/buildServer/util/DiagnosticUtil$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "println";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, data);
        String string = sb.toString();
        if (string == null) {
            DiagnosticUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static void threadDumpInternal(Printer out, @NotNull ThreadDumpData data) {
        if (data == null) {
            DiagnosticUtil.$$$reportNull$$$0(16);
        }
        if (!StringUtil.isEmpty((String)data.getSummary())) {
            out.println(data.getSummary());
            out.println();
        }
        if (!StringUtil.isEmpty((String)data.getHeader())) {
            out.println(data.getHeader());
            out.println();
        }
        if (!StringUtil.isEmpty((String)data.getAdditionalData())) {
            out.println(data.getAdditionalData());
            out.println();
        }
        Date startTime = Dates.now();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        HashMap<Long, String> threadNames = new HashMap<Long, String>();
        for (Thread thread : map.keySet()) {
            threadNames.put(thread.getId(), thread.getName());
        }
        HashMap<Long, Thread.State> threadStates = new HashMap<Long, Thread.State>();
        for (Thread thread : map.keySet()) {
            threadStates.put(thread.getId(), thread.getState());
        }
        HashMap<Long, ThreadInfo> hashMap = new HashMap<Long, ThreadInfo>();
        ThreadMXBean bean = DiagnosticUtil.getThreadsBean();
        if (bean != null) {
            for (Thread thread : map.keySet()) {
                hashMap.put(thread.getId(), bean.getThreadInfo(thread.getId()));
            }
        }
        long currentThreadId = Thread.currentThread().getId();
        DiagnosticUtil.printHeader(out, startTime);
        for (Map.Entry<Thread, StackTraceElement[]> e : map.entrySet()) {
            ThreadGroup group;
            StackTraceElement[] el = e.getValue();
            Thread t = e.getKey();
            long threadId = t.getId();
            if (currentThreadId == threadId) continue;
            out.print(MessageFormat.format("\"{0}\" ", threadNames.get(threadId)));
            if (t.isDaemon()) {
                out.print("daemon ");
            }
            if ((group = t.getThreadGroup()) != null) {
                out.print(MessageFormat.format("group=\"{0}\" ", group.getName()));
            }
            out.print("prio=" + t.getPriority() + " ");
            out.print("tid=" + threadId + " ");
            out.print("nid=" + threadId + " ");
            Thread.State state = (Thread.State)((Object)threadStates.get(t.getId()));
            if (state == Thread.State.RUNNABLE) {
                out.print("runnable ");
            }
            if (state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING) {
                out.print("waiting ");
            }
            if (state == Thread.State.BLOCKED) {
                out.print("blocked ");
            }
            DiagnosticUtil.writeThreadAllocatedBytes(t, out);
            DiagnosticUtil.writeLocksInfo((ThreadInfo)hashMap.get(threadId), out);
            DiagnosticUtil.writeThreadState(state, out);
            out.println();
            for (StackTraceElement line : el) {
                out.println("    at " + line);
            }
            out.println();
        }
        out.println();
        DiagnosticUtil.printMemoryUsage(out);
        out.println();
        DiagnosticUtil.printCpuUsage(out, data, startTime);
        out.println();
        out.println("Dump taken in " + TimePrinter.createMillisecondsFormatter().formatTime(Dates.now().getTime() - startTime.getTime()));
    }

    private static void writeThreadAllocatedBytes(@NotNull Thread thread, @NotNull Printer out) {
        if (thread == null) {
            DiagnosticUtil.$$$reportNull$$$0(17);
        }
        if (out == null) {
            DiagnosticUtil.$$$reportNull$$$0(18);
        }
        long[] stats = NamedThreadUtil.getThreadStatistics(thread);
        long now = System.nanoTime();
        if (stats == null) {
            return;
        }
        if ((stats[0] > 0L || stats[1] > 0L) && stats[0] != stats[4]) {
            out.print(String.format("[mem alloc: %s, cpu time: %s ms (since last name update: %s), total mem alloc: %s, total cpu time: %s ms]", StringUtil.formatFileSize(stats[0]), Float.valueOf((float)stats[1] / 1000.0f / 1000.0f), stats[2] > 0L ? (now - stats[2]) / 1000000L + "ms ago" : "never", StringUtil.formatFileSize(stats[4]), Float.valueOf((float)stats[5] / 1000.0f / 1000.0f)));
        } else if (stats[4] > 0L || stats[5] > 0L) {
            out.print("[total mem alloc: " + StringUtil.formatFileSize(stats[4]) + ", cpu time: " + (float)stats[5] / 1000.0f / 1000.0f + " ms]");
        }
    }

    public static void printMemoryUsage(Printer out) {
        out.println("Memory usage:");
        List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
        long totalUsed = 0L;
        long totalMax = 0L;
        String prefix = "   ";
        for (MemoryPoolMXBean pool : memPools) {
            MemoryUsage usage = pool.getUsage();
            StringBuilder line = new StringBuilder();
            line.append("   ").append(pool.getName()).append(": ");
            line.append("used = ").append(StringUtil.formatFileSize(usage.getUsed())).append(" ");
            line.append("committed = ").append(StringUtil.formatFileSize(usage.getCommitted())).append(" ");
            line.append("max = ").append(StringUtil.formatFileSize(usage.getMax())).append(" ");
            line.append(DiagnosticUtil.percent(usage.getUsed(), usage.getMax()));
            out.println(line.toString());
            totalUsed += usage.getUsed();
            totalMax += usage.getMax();
        }
        out.println("   Total: used = " + StringUtil.formatFileSize(totalUsed) + " max = " + StringUtil.formatFileSize(totalMax) + " " + DiagnosticUtil.percent(totalUsed, totalMax));
    }

    public static void printCpuUsage(Printer out, ThreadDumpData data) {
        DiagnosticUtil.printCpuUsage(out, data, new Date());
    }

    public static void printCpuUsage(Printer out, ThreadDumpData data, Date currentTime) {
        String javaProcessCpu;
        String currentCpuUsage;
        out.println("CPU statistics:");
        out.println("   Available processors = " + data.getNumberOfProcessors());
        String systemLoadAverage = data.getSystemLoad();
        if (systemLoadAverage != null) {
            out.println("   Load average (1m) = " + systemLoadAverage);
        }
        if ((currentCpuUsage = data.getCpuUsage()) != null) {
            out.println("   Overall CPU usage = " + currentCpuUsage);
        }
        if ((javaProcessCpu = data.getJavaProcessCPULoad()) != null) {
            out.println("   TeamCity process CPU usage = " + javaProcessCpu);
        }
        if (data.getLastGcTime() > 0L) {
            out.println();
            TimePrinter millisecondsFormatter = TimePrinter.createMillisecondsFormatter();
            out.println(String.format("Last full GC was finished %s ago, took %s, freed %s", millisecondsFormatter.formatTime(currentTime.getTime() - data.getLastGcTime()), millisecondsFormatter.formatTime(data.getLastGcDuration()), StringUtil.formatFileSize(data.getLastGcEfficiency())));
            if (data.getMinuteGcDuration() >= 0L && data.getMinuteGcEfficiency() >= 0L && data.getMinuteGcCount() > 1L) {
                out.println(String.format("In previous 1 minute full GC was fired %s times, consuming %s and freeing %s in total", data.getMinuteGcCount(), millisecondsFormatter.formatTime(data.getMinuteGcDuration()), StringUtil.formatFileSize(data.getMinuteGcEfficiency())));
            }
        }
    }

    private static double getJavaProcessCpuUsage(OperatingSystemMXBean os) {
        if (ourGetProcessCpuLoad != null) {
            try {
                return (Double)ourGetProcessCpuLoad.invoke((Object)os, new Object[0]);
            }
            catch (Exception e) {
                ourGetProcessCpuLoad = null;
            }
        }
        return -1.0;
    }

    @NotNull
    public static MemoryUsage getHeapMemoryUsage() {
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memBean.getHeapMemoryUsage();
        if (memoryUsage == null) {
            DiagnosticUtil.$$$reportNull$$$0(19);
        }
        return memoryUsage;
    }

    @Nullable
    public static MemoryUsage getPermGenPoolMemoryUsage() {
        for (MemoryPoolMXBean bean : DiagnosticUtil.getMemoryUsageBeans()) {
            if (!DiagnosticUtil.isPermGenPool(bean.getName())) continue;
            return bean.getUsage();
        }
        return null;
    }

    public static boolean isPermGenPool(String name) {
        return name.contains("Perm") || "class storage".equals(name);
    }

    public static List<MemoryPoolMXBean> getMemoryUsageBeans() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    private static String percent(long used, long max) {
        String percentStr = "";
        if (max > 0L) {
            percentStr = "used/max = " + DiagnosticUtil.percent((double)used / (double)max);
        }
        return percentStr;
    }

    private static String percent(double val) {
        return String.format(Locale.ENGLISH, "%.2f%%", val * 100.0);
    }

    private static void printHeader(@NotNull Printer out, @NotNull Date time) {
        if (out == null) {
            DiagnosticUtil.$$$reportNull$$$0(20);
        }
        if (time == null) {
            DiagnosticUtil.$$$reportNull$$$0(21);
        }
        out.println(DiagnosticUtil.getThreadDumpDateFormat().format(time));
        out.println(MessageFormat.format("Full thread dump {0} ({1} {2}):", System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.info")));
        out.println();
    }

    private static ThreadMXBean getThreadsBean() {
        try {
            return ManagementFactory.getThreadMXBean();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void writeLocksInfo(@Nullable ThreadInfo info, Printer ps) {
        if (info == null) {
            return;
        }
        String lock = info.getLockName();
        String lockOwner = info.getLockOwnerName();
        if (lock != null && lockOwner != null) {
            ps.println(MessageFormat.format("on {0}", lock));
            ps.print(MessageFormat.format("   by \"{0}\"", lockOwner));
        }
    }

    private static void writeThreadState(@Nullable Thread.State state, Printer ps) {
        ps.println();
        ps.print("   java.lang.Thread.State: " + state.name());
    }

    public static long getMaxPoolSize(String key) {
        if (TC_TOTAL_MEMORY_USAGE_KEY.equals(key)) {
            return DiagnosticUtil.getHeapMemoryUsage().getMax();
        }
        for (MemoryPoolMXBean bean : DiagnosticUtil.getMemoryUsageBeans()) {
            if (!bean.getName().equals(key)) continue;
            return bean.getUsage().getMax();
        }
        return -1L;
    }

    @NotNull
    public static StringBuilder appendCurrentThreadStacktrace(@NotNull StringBuilder sb) {
        if (sb == null) {
            DiagnosticUtil.$$$reportNull$$$0(22);
        }
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < trace.length; ++i) {
            sb.append("\tat ").append(trace[i]).append(EOL);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DiagnosticUtil.$$$reportNull$$$0(23);
        }
        return stringBuilder;
    }

    public static SimpleDateFormat getThreadDumpDateFormat() {
        return new SimpleDateFormat(THREAD_DUMP_DATE_PATTERN);
    }

    public static boolean memoryDumpAvailable() {
        try {
            return DiagnosticUtil.getHotspotMBean() != null;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    @NotNull
    public static File memoryDump(@Nullable File hprofDir) throws Exception {
        File hprof = new File(hprofDir, "memoryDump-" + new SimpleDateFormat(FILE_DATE_FORMAT).format(Dates.now()) + ".hprof");
        Object mxBean = DiagnosticUtil.getHotspotMBean();
        if (mxBean == null) {
            throw new RuntimeException("Can't create HotSpotDiagnosticMXBean");
        }
        if (!hprof.exists()) {
            Method dumpHeap = mxBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
            boolean runFullGcBeforeMemoryDump = TeamCityProperties.getBoolean("teamcity.diagnostics.memoryDump.afterFullGC");
            dumpHeap.invoke(mxBean, hprof.getAbsolutePath(), runFullGcBeforeMemoryDump);
        }
        File file = hprof;
        if (file == null) {
            DiagnosticUtil.$$$reportNull$$$0(24);
        }
        return file;
    }

    @NotNull
    public static File memoryDump(@Nullable File dir, boolean zip, @NotNull String requestorData, @NotNull Logger logger) throws Exception {
        File file;
        if (requestorData == null) {
            DiagnosticUtil.$$$reportNull$$$0(25);
        }
        if (logger == null) {
            DiagnosticUtil.$$$reportNull$$$0(26);
        }
        long startTime = System.nanoTime();
        try {
            File result = zip ? DiagnosticUtil.memoryDumpZipped(dir) : DiagnosticUtil.memoryDump(dir);
            logger.info("Memory dump saved to file \"" + result.getAbsolutePath() + "\" in " + TimePrinter.createMillisecondsFormatter().formatTime(TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS)) + "; requested " + requestorData);
            file = result;
        }
        catch (Exception e) {
            logger.warnAndDebugDetails("Error taking/saving memory dump" + (dir != null ? " into directory \"" + dir.getAbsolutePath() + "\"" : "") + " in " + TimePrinter.createMillisecondsFormatter().formatTime(TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS)) + "; requested " + requestorData + ": " + ExceptionUtil.getDisplayMessage(e), (Throwable)e);
            throw e;
        }
        if (file == null) {
            DiagnosticUtil.$$$reportNull$$$0(27);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File memoryDumpZipped(@Nullable File dir) throws Exception {
        File hprof = DiagnosticUtil.memoryDump(dir);
        File zippedHprof = new File(hprof.getAbsolutePath() + ".gz");
        File zippedHprofTemp = new File(hprof.getAbsolutePath() + ".gz.temp");
        BufferedInputStream fis = null;
        GZIPOutputStream os = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(hprof));
            os = new GZIPOutputStream(new FileOutputStream(zippedHprofTemp));
            TCStreamUtil.writeBinary(fis, os);
        }
        catch (Throwable throwable) {
            FileUtil.close(os);
            FileUtil.close(fis);
            FileUtil.delete(hprof);
            throw throwable;
        }
        FileUtil.close(os);
        FileUtil.close(fis);
        FileUtil.delete(hprof);
        FileUtil.renameAndReportErrors(zippedHprofTemp, zippedHprof);
        File file = zippedHprof;
        if (file == null) {
            DiagnosticUtil.$$$reportNull$$$0(28);
        }
        return file;
    }

    @NotNull
    public static List<String> getJVMArgs() {
        List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (list == null) {
            DiagnosticUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public static String getJVMArgsString() {
        List<String> jvmArgs = DiagnosticUtil.getJVMArgs();
        StringBuilder builder = new StringBuilder();
        for (String arg : jvmArgs) {
            builder.append(arg).append(" ");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        String string = builder.toString();
        if (string == null) {
            DiagnosticUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    public static String getUser() {
        return System.getProperty("user.name");
    }

    public static String getJavaDetails() {
        return "Java: " + DiagnosticUtil.getJVMDiagnosticString() + "; JVM parameters: " + DiagnosticUtil.getJVMArgsString();
    }

    @NotNull
    public static String getJVMDiagnosticString() {
        StringBuilder result = new StringBuilder();
        result.append(SystemInfo.JAVA_VERSION).append(", ");
        result.append(DiagnosticUtil.getJVMName());
        result.append(" (").append(System.getProperty("java.vm.version")).append(", ");
        String vmInfo = System.getProperty("java.vm.info");
        if (!StringUtil.isEmpty((String)vmInfo)) {
            result.append(StringUtil.replace((String)StringUtil.replace((String)vmInfo, (String)"\n", (String)", "), (String)"\r", (String)""));
        }
        result.append("), ");
        result.append(System.getProperty("java.runtime.name")).append(" (").append(SystemInfo.JAVA_RUNTIME_VERSION).append("), ");
        result.append(System.getProperty("java.vm.vendor"));
        String string = result.toString();
        if (string == null) {
            DiagnosticUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String getJVMName() {
        String vmName = System.getProperty("java.vm.name");
        String bitness = System.getProperty("sun.arch.data.model");
        if (bitness != null && !vmName.contains(bitness)) {
            String string = vmName + " (" + bitness + " bit)";
            if (string == null) {
                DiagnosticUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = vmName;
        if (string == null) {
            DiagnosticUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String getOsEnvironmentDetails() {
        String string = "OS: " + System.getProperty("os.name") + ", version " + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ", Current user: " + DiagnosticUtil.getUser() + ", Time zone: " + DiagnosticUtil.getFriendlyTimeZone();
        if (string == null) {
            DiagnosticUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    public static String getFriendlyTimeZone() {
        String timeZone = null;
        try {
            timeZone = new SimpleDateFormat("z ('UTC'XXX)").format(Dates.now());
        }
        catch (Exception e1) {
            try {
                return new SimpleDateFormat("z").format(Dates.now());
            }
            catch (Exception e2) {
                return "<not detected>";
            }
        }
        if (timeZone.startsWith("UTC (")) {
            return "UTC";
        }
        if (timeZone.endsWith(" (UTCZ)")) {
            return timeZone.substring(0, timeZone.length() - "Z)".length()) + ")";
        }
        return timeZone;
    }

    @Nullable
    private static Object getHotspotMBean() throws UnsupportedOperationException {
        try {
            final Class<?> hotSpotMxBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Set<ObjectName> s = server.queryNames(new ObjectName(DiagnosticUtil.HOTSPOT_BEAN_NAME), null);
                    Iterator<ObjectName> itr = s.iterator();
                    if (itr.hasNext()) {
                        ObjectName name = itr.next();
                        return ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), hotSpotMxBeanClass);
                    }
                    return null;
                }
            });
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    static {
        try {
            ourGetProcessCpuLoad = ManagementFactory.getOperatingSystemMXBean().getClass().getMethod("getProcessCpuLoad", new Class[0]);
            if (ourGetProcessCpuLoad != null && !ourGetProcessCpuLoad.isAccessible()) {
                ourGetProcessCpuLoad.setAccessible(true);
            }
        }
        catch (Exception ignore) {
            ourGetProcessCpuLoad = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadDumpData";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = THREAD_DUMP_PREFIX;
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/DiagnosticUtil";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestorData";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/DiagnosticUtil";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "threadDumpToString";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapMemoryUsage";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "appendCurrentThreadStacktrace";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "memoryDump";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "memoryDumpZipped";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMArgs";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMArgsString";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMDiagnosticString";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getOsEnvironmentDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "threadDumpToStream";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "threadDumpToDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "threadDumpToFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeThreadDump";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAutomaticThreadDumpsSubdirectory";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDiagnosticFile";
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "threadDumpToString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "threadDumpInternal";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeThreadAllocatedBytes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "printHeader";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendCurrentThreadStacktrace";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "memoryDump";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ThreadDumpData {
        @Nullable
        private final String myNumberOfProcessors;
        @Nullable
        private final String mySystemLoad;
        @Nullable
        private final String myJavaProcessLoad;
        @Nullable
        private final String myCpuUsage;
        private final long myLastGcTime;
        private final long myLastGcEfficiency;
        private final long myLastGcDuration;
        private final long myMinuteGcCount;
        private final long myMinuteGcEfficiency;
        private final long myMinuteGcDuration;
        @Nullable
        private String mySummary;
        @Nullable
        private String myAdditionalData;
        @Nullable
        private String myHeader;

        public ThreadDumpData() {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            int availableProcessors = os.getAvailableProcessors();
            double javaProcessCpuUsage = DiagnosticUtil.getJavaProcessCpuUsage(os);
            this.myJavaProcessLoad = javaProcessCpuUsage >= 0.0 ? DiagnosticUtil.percent(javaProcessCpuUsage) : null;
            double systemLoadAverage = os.getSystemLoadAverage();
            this.mySystemLoad = systemLoadAverage >= 0.0 ? String.format(Locale.ENGLISH, "%.2f", systemLoadAverage) : null;
            this.myCpuUsage = null;
            this.myNumberOfProcessors = Integer.toString(availableProcessors);
            this.myLastGcTime = -1L;
            this.myLastGcEfficiency = -1L;
            this.myLastGcDuration = -1L;
            this.myMinuteGcCount = -1L;
            this.myMinuteGcEfficiency = -1L;
            this.myMinuteGcDuration = -1L;
        }

        public ThreadDumpData(int numberOfProcessors, float javaProcessLoad, float systemLoad, float cpuUsage, long lastGcTime, long lastGcEfficiency, long lastGcDuration, long minuteGcCount, long minutesGcEfficiency, long minuteGcDuration) {
            this.myJavaProcessLoad = javaProcessLoad >= 0.0f ? DiagnosticUtil.percent(javaProcessLoad) : null;
            this.mySystemLoad = systemLoad >= 0.0f ? String.format(Locale.ENGLISH, "%.2f", Float.valueOf(systemLoad)) : null;
            this.myCpuUsage = cpuUsage >= 0.0f ? DiagnosticUtil.percent(cpuUsage) : null;
            this.myNumberOfProcessors = Integer.toString(numberOfProcessors);
            this.myLastGcTime = lastGcTime;
            this.myLastGcEfficiency = lastGcEfficiency;
            this.myLastGcDuration = lastGcDuration;
            this.myMinuteGcCount = minuteGcCount;
            this.myMinuteGcEfficiency = minutesGcEfficiency;
            this.myMinuteGcDuration = minuteGcDuration;
        }

        @Nullable
        public String getSystemLoad() {
            return this.mySystemLoad;
        }

        @Nullable
        public String getJavaProcessCPULoad() {
            return this.myJavaProcessLoad;
        }

        @Nullable
        public String getCpuUsage() {
            return this.myCpuUsage;
        }

        @Nullable
        public String getNumberOfProcessors() {
            return this.myNumberOfProcessors;
        }

        public long getLastGcTime() {
            return this.myLastGcTime;
        }

        public long getLastGcEfficiency() {
            return this.myLastGcEfficiency;
        }

        public long getLastGcDuration() {
            return this.myLastGcDuration;
        }

        public long getMinuteGcCount() {
            return this.myMinuteGcCount;
        }

        public long getMinuteGcEfficiency() {
            return this.myMinuteGcEfficiency;
        }

        public long getMinuteGcDuration() {
            return this.myMinuteGcDuration;
        }

        @Nullable
        public String getSummary() {
            return this.mySummary;
        }

        @Nullable
        public String getAdditionalData() {
            return this.myAdditionalData;
        }

        @NotNull
        public ThreadDumpData withSummary(@Nullable String summary) {
            this.mySummary = summary;
            ThreadDumpData threadDumpData = this;
            if (threadDumpData == null) {
                ThreadDumpData.$$$reportNull$$$0(0);
            }
            return threadDumpData;
        }

        @NotNull
        public ThreadDumpData withAdditionalData(@Nullable String additionalData) {
            this.myAdditionalData = additionalData;
            ThreadDumpData threadDumpData = this;
            if (threadDumpData == null) {
                ThreadDumpData.$$$reportNull$$$0(1);
            }
            return threadDumpData;
        }

        @NotNull
        public ThreadDumpData withHeader(@NotNull String header) {
            if (header == null) {
                ThreadDumpData.$$$reportNull$$$0(2);
            }
            this.myHeader = header;
            ThreadDumpData threadDumpData = this;
            if (threadDumpData == null) {
                ThreadDumpData.$$$reportNull$$$0(3);
            }
            return threadDumpData;
        }

        @Nullable
        public String getHeader() {
            return this.myHeader;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/DiagnosticUtil$ThreadDumpData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "header";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withSummary";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAdditionalData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/DiagnosticUtil$ThreadDumpData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withHeader";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withHeader";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Printer {
        public void println(@NotNull String var1);

        public void println();

        public void print(@NotNull String var1);
    }
}

