/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.EventDispatcherHandlers;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TimePrinter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance((String)EventDispatcher.class.getName());
    private static final long THRESHOLD = 10000L;
    private final T myMulticaster;
    @NotNull
    private final EventDispatcherHandlers<T> myHandlers;
    @NotNull
    private final Class<T> myListenerClass;
    @Nullable
    private volatile Map<Method, List<T>> myMethodsToCall;
    @NotNull
    private final List<EventDispatcher<?>> myParentDispatchers;
    @Nullable
    private ErrorHandler myErrorHandler;
    public static final ErrorHandler DEFAULT_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void handle(Throwable e) {
            String logLevel = TeamCityProperties.getProperty("teamcity.eventDispatcher.defaultErrorHandler.logLevel", "WARN");
            if ("ERROR".equals(logLevel)) {
                LOG.error("Error in event handler: " + e.toString(), e);
            } else {
                LOG.warnAndDebugDetails("Error in event handler", e);
            }
        }
    };

    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(0);
        }
        return new EventDispatcher<T>(listenerClass);
    }

    protected EventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(1);
        }
        this.myMethodsToCall = null;
        this.myParentDispatchers = new CopyOnWriteArrayList();
        this.myErrorHandler = DEFAULT_ERROR_HANDLER;
        this.myHandlers = new EventDispatcherHandlers<T>(listenerClass);
        this.myListenerClass = listenerClass;
        InvocationHandler handler = new InvocationHandler(){

            @Override
            @NonNls
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return EventDispatcher.this.dispatch(proxy, method, args);
            }
        };
        this.myMulticaster = (EventListener)listenerClass.cast(Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler));
    }

    public T getMulticaster() {
        return this.myMulticaster;
    }

    @Nullable
    public ErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    public void setErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.myErrorHandler = errorHandler;
    }

    public void clearErrorHandler() {
        this.myErrorHandler = null;
    }

    protected Object dispatch(Object proxy, final Method method, final Object[] args) {
        if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return "Multicaster";
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
            return null;
        }
        long startTimeTotal = System.nanoTime();
        final List<T> listeners = this.getCachedListeners().get(method);
        if (listeners == null) {
            return null;
        }
        final String methodDetails = method.getDeclaringClass().getSimpleName() + "." + method.getName();
        NamedThreadFactory.executeWithNewThreadName("Processing " + StringUtil.withPlural(listeners.size(), "listener") + " for " + method.getName(), new Runnable(){

            @Override
            public void run() {
                for (EventListener listener : listeners) {
                    try {
                        long startTime = System.nanoTime();
                        method.invoke((Object)listener, args);
                        long elapsedMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                        if (elapsedMillis < EventDispatcher.this.getLogThresholdMs(listener.getClass())) continue;
                        LOG.info("Event listener took " + TimePrinter.createMillisecondsFormatter().formatTime(elapsedMillis) + " to complete. Method " + methodDetails + " in listener " + listener.getClass().getName());
                    }
                    catch (AbstractMethodError e) {
                        LOG.debug("Method " + methodDetails + " is not implemented in " + listener.getClass().getName() + ". Consider updating the plugin for newer TeamCity API");
                    }
                    catch (Throwable e) {
                        Throwable error;
                        Throwable throwable = error = e.getCause() != null ? e.getCause() : e;
                        if (error instanceof AbstractMethodError) {
                            LOG.debug("Method " + methodDetails + " is not implemented in " + listener.getClass().getName() + ". Consider updating the plugin for newer TeamCity API");
                            continue;
                        }
                        ErrorHandler eh = EventDispatcher.this.myErrorHandler;
                        if (eh == null) {
                            ExceptionUtil.rethrowAsRuntimeException(error);
                        }
                        eh.handle(new WrapException("Error calling method " + methodDetails + " for listener " + listener.getClass().getName(), error));
                    }
                }
            }
        });
        long elapsedMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimeTotal, TimeUnit.NANOSECONDS);
        if (listeners.size() > 1 && elapsedMillis >= TeamCityProperties.getLong("teamcity.event.total.logProcessingThreshold.ms", 30000L)) {
            LOG.info("Event listeners (" + listeners.size() + ") took " + TimePrinter.createMillisecondsFormatter().formatTime(elapsedMillis) + " to complete for method " + methodDetails);
        }
        return null;
    }

    private long getLogThresholdMs(@NotNull Class clazz) {
        String ignorePrefix;
        if (clazz == null) {
            EventDispatcher.$$$reportNull$$$0(2);
        }
        if ((ignorePrefix = TeamCityProperties.getPropertyOrNull("teamcity.event.listener.logProcessingThreshold.ignorePrefix")) != null && clazz.getName().startsWith(ignorePrefix)) {
            return Long.MAX_VALUE;
        }
        return TeamCityProperties.getLong("teamcity.event.listener.logProcessingThreshold.ms", 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Map<Method, List<T>> getCachedListeners() {
        Map<Method, List<T>> methodsToCall = this.myMethodsToCall;
        if (methodsToCall != null) {
            Map<Method, List<T>> map = methodsToCall;
            if (map != null) return map;
            EventDispatcher.$$$reportNull$$$0(3);
            return map;
        }
        EventDispatcher eventDispatcher = this;
        // MONITORENTER : eventDispatcher
        methodsToCall = this.myMethodsToCall;
        if (methodsToCall != null) {
            Map<Method, List<T>> map = methodsToCall;
            // MONITOREXIT : eventDispatcher
            if (map != null) return map;
            EventDispatcher.$$$reportNull$$$0(4);
            return map;
        }
        this.myMethodsToCall = this.myHandlers.serialize();
        // MONITOREXIT : eventDispatcher
        if (this.myMethodsToCall != null) return this.myMethodsToCall;
        EventDispatcher.$$$reportNull$$$0(5);
        return this.myMethodsToCall;
    }

    public synchronized void addListener(@NotNull T listener) {
        if (listener == null) {
            EventDispatcher.$$$reportNull$$$0(6);
        }
        this.myHandlers.addListener(listener, false);
        this.resetListenersCache();
        for (EventDispatcher<?> parentDispatcher : this.myParentDispatchers) {
            super.addListenerPrivate((EventListener)listener);
        }
    }

    private synchronized void addListenerPrivate(EventListener listener) {
        this.myHandlers.addListener(listener, true);
        this.resetListenersCache();
        for (EventDispatcher<?> parentDispatcher : this.myParentDispatchers) {
            super.addListenerPrivate(listener);
        }
    }

    private void resetListenersCache() {
        this.myMethodsToCall = null;
    }

    public synchronized void removeListener(@NotNull T listener) {
        if (listener == null) {
            EventDispatcher.$$$reportNull$$$0(7);
        }
        this.myHandlers.removeListener(listener);
        this.resetListenersCache();
        for (EventDispatcher<?> parentDispatcher : this.myParentDispatchers) {
            super.removeListenerPrivate((EventListener)listener);
        }
    }

    private synchronized void removeListenerPrivate(EventListener listener) {
        this.myHandlers.removeListener(listener);
        this.resetListenersCache();
        for (EventDispatcher<?> parentDispatcher : this.myParentDispatchers) {
            super.removeListenerPrivate(listener);
        }
    }

    @NotNull
    public synchronized List<T> getListeners() {
        List<EventListener> listenersPrivate = this.getAllListeners();
        ArrayList<EventListener> res = new ArrayList<EventListener>(listenersPrivate.size());
        for (EventListener t : listenersPrivate) {
            if (!this.myListenerClass.isAssignableFrom(t.getClass())) continue;
            res.add(t);
        }
        ArrayList<EventListener> arrayList = res;
        if (arrayList == null) {
            EventDispatcher.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public synchronized List<EventListener> getAllListeners() {
        List<EventListener> list = this.myHandlers.getListeners();
        if (list == null) {
            EventDispatcher.$$$reportNull$$$0(9);
        }
        return list;
    }

    public synchronized boolean hasListeners() {
        return this.myHandlers.hasListeners();
    }

    public synchronized void dispose() {
        for (EventDispatcher<?> parentDispatcher : this.myParentDispatchers) {
            for (EventListener listener : this.getAllListeners()) {
                super.removeListenerPrivate(listener);
            }
        }
        this.myHandlers.clear();
        this.resetListenersCache();
    }

    public void attachParentDispatcher(@NotNull EventDispatcher<?> parentDispatcher) {
        if (parentDispatcher == null) {
            EventDispatcher.$$$reportNull$$$0(10);
        }
        this.myParentDispatchers.add(parentDispatcher);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/EventDispatcher";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDispatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/EventDispatcher";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedListeners";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLogThresholdMs";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "attachParentDispatcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WrapException
    extends Throwable {
        @NotNull
        private final String myMessage;

        public WrapException(@NotNull String message, @NotNull Throwable originalError) {
            if (message == null) {
                WrapException.$$$reportNull$$$0(0);
            }
            if (originalError == null) {
                WrapException.$$$reportNull$$$0(1);
            }
            super(message, originalError);
            this.myMessage = message;
        }

        @Override
        public String toString() {
            return this.myMessage + ": " + this.getCause().toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalError";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/util/EventDispatcher$WrapException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ErrorHandler {
        public void handle(Throwable var1);
    }
}

