/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.DevelopmentMode;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.EventListenerAdapter;
import jetbrains.buildServer.util.positioning.PositionAware;
import jetbrains.buildServer.util.positioning.PositionAwareSortedCollection;
import jetbrains.buildServer.util.positioning.PositionConstraint;
import jetbrains.buildServer.util.positioning.PositionConstraintAware;
import org.jetbrains.annotations.NotNull;

public class EventDispatcherHandlers<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance((String)EventDispatcher.class.getName());
    private final Method[] myListenerMethods;
    private final PositionAwareSortedCollection<T> myListeners = new PositionAwareSortedCollection();
    private final Map<Class<? extends EventListener>, int[]> myTypeToMethodsCache = new HashMap<Class<? extends EventListener>, int[]>();

    public EventDispatcherHandlers(Class<T> listenerClass) {
        this.myListenerMethods = listenerClass.getMethods();
    }

    public void addListener(@NotNull T listener, boolean ignoreEmpty) {
        if (listener == null) {
            EventDispatcherHandlers.$$$reportNull$$$0(0);
        }
        this.myListeners.add(listener, listener instanceof PositionAware ? ((PositionAware)listener).getOrderId() : listener.getClass().getName(), listener instanceof PositionConstraintAware ? ((PositionConstraintAware)listener).getConstraint() : PositionConstraint.UNDEFINED);
        this.updateMethodsCache(listener.getClass(), ignoreEmpty);
    }

    private void updateMethodsCache(@NotNull Class<? extends EventListener> actualClass, boolean ignoreEmpty) {
        if (actualClass == null) {
            EventDispatcherHandlers.$$$reportNull$$$0(1);
        }
        if (this.myTypeToMethodsCache.containsKey(actualClass)) {
            return;
        }
        HashSet<Method> actualClassMethods = new HashSet<Method>();
        for (Method m : actualClass.getMethods()) {
            if (this.isEventAdapter(m.getDeclaringClass())) continue;
            actualClassMethods.add(m);
        }
        int[] positions = new int[this.myListenerMethods.length];
        int idx = 0;
        int totalNumberOfMethods = this.myListenerMethods.length;
        for (int i = 0; i < totalNumberOfMethods; ++i) {
            Method method = this.myListenerMethods[i];
            if (!this.isMethodImplemented(method, actualClassMethods)) continue;
            positions[idx++] = i;
        }
        if (idx == 0) {
            if (ignoreEmpty) {
                return;
            }
            if (DevelopmentMode.isEnabled || LogInitializer.isUnitTest()) {
                throw new RuntimeException("Listener " + actualClass + " does not contain any non-empty event listening method implementations. Check there are some overridden methods or this class is not annotated with " + EventListenerAdapter.class + ".");
            }
            LOG.warn("Listener " + actualClass + " does not contain any non-empty event listening method implementations. Check there are some overridden methods or this class is not annotated with " + EventListenerAdapter.class + ".");
        }
        this.myTypeToMethodsCache.put(actualClass, Arrays.copyOf(positions, idx));
    }

    public void removeListener(@NotNull T listener) {
        if (listener == null) {
            EventDispatcherHandlers.$$$reportNull$$$0(2);
        }
        if (this.myListeners.remove(listener)) {
            for (EventListener t : this.myListeners.getSorted()) {
                if (t.getClass() != listener.getClass()) continue;
                return;
            }
            this.myTypeToMethodsCache.remove(listener.getClass());
        }
    }

    @NotNull
    public List<T> getListeners() {
        List<T> list = this.myListeners.getSorted();
        if (list == null) {
            EventDispatcherHandlers.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Map<Method, List<T>> serialize() {
        List<T> listeners = this.myListeners.getSorted();
        HashMap<Method, List<T>> result = new HashMap<Method, List<T>>(this.myListenerMethods.length, 0.999f);
        for (int i = 0; i < listeners.size(); ++i) {
            EventListener l = (EventListener)listeners.get(i);
            int[] positions = this.myTypeToMethodsCache.get(l.getClass());
            if (positions == null) continue;
            for (int j = 0; j < positions.length; ++j) {
                Method m = this.myListenerMethods[positions[j]];
                ArrayList<EventListener> methodListeners = (ArrayList<EventListener>)result.get(m);
                if (methodListeners == null) {
                    methodListeners = new ArrayList<EventListener>();
                    result.put(m, methodListeners);
                }
                methodListeners.add(l);
            }
        }
        HashMap<Method, List<T>> hashMap = result;
        if (hashMap == null) {
            EventDispatcherHandlers.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private boolean isMethodImplemented(@NotNull Method method, @NotNull Set<Method> actualClassMethods) {
        if (method == null) {
            EventDispatcherHandlers.$$$reportNull$$$0(5);
        }
        if (actualClassMethods == null) {
            EventDispatcherHandlers.$$$reportNull$$$0(6);
        }
        for (Method m : actualClassMethods) {
            if (!m.getName().equals(method.getName()) || !Arrays.equals(m.getParameterTypes(), method.getParameterTypes()) || !m.getReturnType().equals(method.getReturnType())) continue;
            return true;
        }
        return false;
    }

    private boolean isEventAdapter(Class<?> declaringClass) {
        return declaringClass.isAnnotationPresent(EventListenerAdapter.class);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    public void clear() {
        this.myListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/EventDispatcherHandlers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualClassMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/EventDispatcherHandlers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateMethodsCache";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMethodImplemented";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

