/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.HashSet;
import jetbrains.buildServer.util.NamedThreadFactory;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    public static Runnable catchAll(final @NotNull String actionName, final @NotNull Runnable action) {
        if (actionName == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        if (action == null) {
            ExceptionUtil.$$$reportNull$$$0(1);
        }
        return new Runnable(){

            @Override
            public void run() {
                try {
                    NamedThreadFactory.executeWithNewThreadName(actionName, action);
                }
                catch (Throwable t) {
                    try {
                        com.intellij.openapi.diagnostic.Logger.getInstance((String)action.getClass().getName()).error("Failed to execute " + actionName + ". " + t.toString(), t);
                    }
                    catch (Throwable tt) {
                        try {
                            t.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            tt.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        };
    }

    @Contract(value="_ -> fail")
    public static void rethrowAsRuntimeException(@NotNull Throwable t) throws RuntimeException {
        if (t == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static void dumpStacktrace(@NotNull StringBuilder stringBuffer, @NotNull Throwable exception) {
        StackTraceElement[] trace;
        if (stringBuffer == null) {
            ExceptionUtil.$$$reportNull$$$0(3);
        }
        if (exception == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        String exceptionStr = exception.toString();
        stringBuffer.append(exceptionStr);
        if (!exceptionStr.endsWith("\n")) {
            stringBuffer.append('\n');
        }
        for (StackTraceElement entry : trace = exception.getStackTrace()) {
            stringBuffer.append("\tat ").append(entry.toString()).append('\n');
        }
        Throwable caused = exception.getCause();
        if (caused != null && caused != exception) {
            stringBuffer.append("caused by: ");
            ExceptionUtil.dumpStacktrace(stringBuffer, caused);
        }
    }

    @Deprecated
    public static void log(@NotNull Logger log, @NotNull String prefixMessage, @NotNull Throwable e) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        if (prefixMessage == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        log.warn((Object)ExceptionUtil.createWarningMessage(prefixMessage, e));
        log.debug((Object)e.getMessage(), e);
    }

    @Deprecated
    public static void log(@NotNull com.intellij.openapi.diagnostic.Logger log, @NotNull String prefixMessage, @NotNull Throwable e) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        if (prefixMessage == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        log.warnAndDebugDetails(prefixMessage, e);
    }

    @NotNull
    private static String createWarningMessage(@NotNull String prefixMessage, @NotNull Throwable e) {
        if (prefixMessage == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(12);
        }
        String string = prefixMessage + ": " + e.getClass().getName() + ": " + e.getMessage();
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public static <T extends Throwable> T getCause(@Nullable Throwable e, @NotNull Class<T> clazz) {
        if (clazz == null) {
            ExceptionUtil.$$$reportNull$$$0(14);
        }
        if (e == null) {
            return null;
        }
        HashSet<Throwable> visitedCauses = new HashSet<Throwable>();
        Throwable cause = e;
        do {
            if (clazz.isInstance(cause)) {
                return (T)cause;
            }
            visitedCauses.add(cause);
        } while ((cause = cause.getCause()) != null && !visitedCauses.contains(cause));
        return null;
    }

    @NotNull
    public static String getDisplayMessage(@NotNull Throwable t) {
        Throwable cause;
        String message;
        if (t == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        if ((message = (cause = ExceptionUtil.getMostInternalCause(t)).getMessage()) == null) {
            message = cause.getClass().getSimpleName();
        }
        String string = message.trim();
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static Throwable getMostInternalCause(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        HashSet<Throwable> visitedCauses = new HashSet<Throwable>();
        visitedCauses.add(e);
        Throwable cause = e;
        while (true) {
            Throwable causeCause;
            if ((causeCause = cause.getCause()) == null || visitedCauses.contains(causeCause)) {
                Throwable throwable = cause;
                if (throwable == null) {
                    ExceptionUtil.$$$reportNull$$$0(18);
                }
                return throwable;
            }
            visitedCauses.add(causeCause);
            cause = causeCause;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringBuffer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMessage";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/ExceptionUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/ExceptionUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createWarningMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayMessage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMostInternalCause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "catchAll";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rethrowAsRuntimeException";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dumpStacktrace";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createWarningMessage";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCause";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMessage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMostInternalCause";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

