/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.Predicate;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.util.ThreadUtil;
import jetbrains.buildServer.util.XMLParser;
import jetbrains.buildServer.util.XmlUtil;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil
extends com.intellij.openapi.util.io.FileUtil {
    private static final Logger LOG;
    public static final FileFilter ACCEPT_ALL_FILES_FILTER;
    public static final String DIST_SUFFIX = ".dist";
    private static final Pattern FIX_DIRECTORY_NAME_PATTERN;
    private static final Pattern FIX_DIRECTORY_NAME_PATTERN_ALLOW_UNICODE;
    private static final String BAD_DIRECTORY_NAME_PATTERN;
    private static final Comparator<File> FILE_COMPARATOR;
    private static final File[] ourEmptyFilesArray;
    private static final Method IO_FILE_SET_EXECUTABLE_METHOD;
    private static final Method IO_FILE_TO_PATH_METHOD;
    private static final Method NIO_FILE_FILES_IS_SYMBOLIC_LINK_METHOD;
    private static final Method IO_FILE_GET_USABLE_SPACE;

    @NotNull
    public static List<String> readFile(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(0);
        }
        List<String> list = FileUtil.readFileImpl(file, null);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<String> readFile(@NotNull File file, @NotNull String encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(2);
        }
        if (encoding == null) {
            FileUtil.$$$reportNull$$$0(3);
        }
        List<String> list = FileUtil.readFileImpl(file, encoding);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<String> readFileImpl(@NotNull File file, @Nullable String encoding) throws IOException {
        List<String> list;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(5);
        }
        try (FileInputStream is = new FileInputStream(file);){
            String text = encoding == null ? StreamUtil.readText((InputStream)is) : StreamUtil.readText((InputStream)is, (String)encoding);
            List<String> list2 = Arrays.asList(text.split("\\r?\\n"));
            list = list2;
        }
        if (list == null) {
            FileUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static String readText(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(7);
        }
        byte[] data = Files.readAllBytes(file.toPath());
        return new String(data);
    }

    public static String readText(@NotNull File file, @NotNull String encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(8);
        }
        if (encoding == null) {
            FileUtil.$$$reportNull$$$0(9);
        }
        byte[] data = Files.readAllBytes(file.toPath());
        return new String(data, encoding);
    }

    @Deprecated
    public static void writeFile(@NotNull File file, @NotNull String text) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(10);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(11);
        }
        try {
            FileUtil.writeFileAndReportErrors(file, text);
        }
        catch (IOException e) {
            LOG.warn(e.toString());
            LOG.debug(e.toString(), (Throwable)e);
        }
    }

    public static void writeFileAndReportErrors(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(12);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(13);
        }
        try (BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));){
            fileWriter.write(text);
        }
    }

    public static void writeFile(@NotNull File file, @NotNull String text, @NotNull Charset charset) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(14);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(15);
        }
        if (charset == null) {
            FileUtil.$$$reportNull$$$0(16);
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));){
            writer.write(text);
        }
    }

    public static void writeFile(@NotNull File file, @NotNull String text, @NotNull String encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(17);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(18);
        }
        if (encoding == null) {
            FileUtil.$$$reportNull$$$0(19);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));){
            writer.write(text);
        }
    }

    public static void readXmlFile(@NotNull File file, @NotNull Processor p) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(20);
        }
        if (p == null) {
            FileUtil.$$$reportNull$$$0(21);
        }
        if (file.exists()) {
            try {
                FileUtil.getProcessedDocument(file, p);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    private static Document getProcessedDocument(@NotNull File file, @NotNull Processor p) throws JDOMException, IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(22);
        }
        if (p == null) {
            FileUtil.$$$reportNull$$$0(23);
        }
        Document document = FileUtil.parseDocument(file).getDocument();
        p.process(document.getRootElement());
        Document document2 = document;
        if (document2 == null) {
            FileUtil.$$$reportNull$$$0(24);
        }
        return document2;
    }

    @NotNull
    public static Element parseDocument(@NotNull File file) throws JDOMException, IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(25);
        }
        Element element = FileUtil.parseDocument(file, false);
        if (element == null) {
            FileUtil.$$$reportNull$$$0(26);
        }
        return element;
    }

    @NotNull
    public static Element parseDocument(@NotNull File file, boolean validate) throws JDOMException, IOException {
        Element element;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(27);
        }
        boolean validateFinal = validate;
        try {
            element = NamedThreadFactory.executeWithNewThreadNameFuncThrow("Parsing file '" + file.getAbsolutePath() + "'", () -> XMLParser.parseWithSAXBuilder(arg -> arg.build(file).getRootElement(), validateFinal));
        }
        catch (JDOMException e) {
            throw new JDOMException("Could not parse file '" + file.getAbsolutePath() + "'", (Throwable)e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Unknown exception: " + e, e);
        }
        if (element == null) {
            FileUtil.$$$reportNull$$$0(28);
        }
        return element;
    }

    public static Element parseDocument(@NotNull InputStream input, boolean validate) throws JDOMException, IOException {
        if (input == null) {
            FileUtil.$$$reportNull$$$0(29);
        }
        return XMLParser.parseWithSAXBuilder(arg -> arg.build(input).getRootElement(), validate);
    }

    public static Element parseDocument(@NotNull Reader input, boolean validate) throws JDOMException, IOException {
        if (input == null) {
            FileUtil.$$$reportNull$$$0(30);
        }
        return XMLParser.parseWithSAXBuilder(arg -> arg.build(input).getRootElement(), validate);
    }

    public static void processXmlFile(@NotNull File file, @NotNull Processor processor) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(31);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(32);
        }
        if (file.exists()) {
            try {
                FileUtil.saveDocument(FileUtil.getProcessedDocument(file, processor), file);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void saveDocument(@NotNull Document document, @NotNull File file) throws IOException {
        if (document == null) {
            FileUtil.$$$reportNull$$$0(33);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(34);
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
            XmlUtil.saveDocument(document, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String getFilesSignature(@NotNull Collection<File> _files) {
        if (_files == null) {
            FileUtil.$$$reportNull$$$0(35);
        }
        ArrayList<File> files = new ArrayList<File>(_files);
        files.sort(Comparator.comparing(File::getName));
        int hash = 0;
        byte[] bytes = new byte[8192];
        for (File file : files) {
            if (file.isDirectory()) continue;
            try {
                hash = 31 * hash + 1;
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                try {
                    int count;
                    do {
                        count = ((InputStream)is).read(bytes, 0, bytes.length);
                        for (int i = 0; i < count; ++i) {
                            hash = 31 * hash + bytes[i];
                        }
                    } while (count >= 0);
                }
                finally {
                    FileUtil.close(is);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(file.getAbsolutePath() + ": " + hash);
        }
        String s = Integer.toHexString(hash);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature of the files  : " + s);
        }
        String string = s;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public static File createTempDirectory(String prefix, String suffix, File in) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix, in);
        tempFile.delete();
        tempFile.mkdir();
        File file = tempFile;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(37);
        }
        return file;
    }

    public static File createTempDirectory(@NonNls String prefix, @NonNls String suffix) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix);
        file.delete();
        file.mkdir();
        return file;
    }

    public static File createTempFile(@NonNls File dir, @NonNls String prefix, @NonNls String suffix, boolean create) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix, dir);
        file.delete();
        if (create) {
            file.createNewFile();
        }
        return file;
    }

    public static File createTempFile(@NonNls String prefix, @NonNls String suffix) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix);
        file.delete();
        file.createNewFile();
        return file;
    }

    private static File doCreateTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.doCreateTempFile(prefix, suffix, new File(FileUtil.getTempDirectory()));
    }

    private static File doCreateTempFile(String prefix, String suffix, File dir) throws IOException {
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        int exceptionsCount = 0;
        while (true) {
            try {
                return File.createTempFile(prefix, suffix, dir).getCanonicalFile();
            }
            catch (IOException e) {
                if (++exceptionsCount >= 100) {
                    throw new IOException("Error creating temporary file '" + prefix + "<random>" + suffix + "' in " + (dir != null ? "directory '" + dir.getAbsolutePath() + "'" : "default directory") + " (multiple attempts): " + e.getMessage(), e);
                }
                try {
                    if (dir == null || dir.exists()) continue;
                    dir.mkdirs();
                }
                catch (Exception exception) {
                }
                continue;
            }
            break;
        }
    }

    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    @NotNull
    public static File getFileInSameDir(@NotNull File origFile, String neededFileName) {
        File parent;
        if (origFile == null) {
            FileUtil.$$$reportNull$$$0(38);
        }
        File file = (parent = origFile.getParentFile()) != null ? new File(parent, neededFileName) : new File(neededFileName);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(39);
        }
        return file;
    }

    public static boolean moveDirWithContent(File fromDir, File to, ErrorReporter reporter) {
        if (!to.exists() && FileUtil.rename(fromDir, to, reporter)) {
            return true;
        }
        if (to.isFile()) {
            reporter.error("cannot copy contents of '" + fromDir.getAbsolutePath() + "' to existing file '" + to.getAbsolutePath() + "'");
            return false;
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            reporter.error("cannot get directory contents of '" + fromDir.getAbsolutePath() + "'");
            return false;
        }
        boolean success = true;
        for (File fromFile : files) {
            File toFile = new File(to, fromFile.getName());
            success = fromFile.isDirectory() ? success && FileUtil.moveDirWithContent(fromFile, toFile, reporter) : success && FileUtil.rename(fromFile, toFile, reporter);
        }
        fromDir.delete();
        return success;
    }

    public static boolean rename(File from, File to, ErrorReporter reporter) {
        try {
            if (from.isDirectory()) {
                FileUtil.createParentDirs((File)to);
                return from.renameTo(to);
            }
            FileUtil.rename((File)from, (File)to);
            return true;
        }
        catch (IOException e) {
            reporter.error(e.getLocalizedMessage() + ": cannot rename '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'");
            LOG.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeViaTmpFile(@NotNull File targetFile, @NotNull InputStream content, @NotNull IOAction beforeWriteAction) throws IOException {
        if (targetFile == null) {
            FileUtil.$$$reportNull$$$0(40);
        }
        if (content == null) {
            FileUtil.$$$reportNull$$$0(41);
        }
        if (beforeWriteAction == null) {
            FileUtil.$$$reportNull$$$0(42);
        }
        FileOutputStream tmpFileStream = null;
        File tmpFile = new File(targetFile.getParent(), targetFile.getName() + ".new");
        try {
            targetFile.getParentFile().mkdirs();
            tmpFile.delete();
            tmpFileStream = new FileOutputStream(tmpFile);
            TCStreamUtil.writeBinary(content, tmpFileStream);
            tmpFileStream.flush();
        }
        catch (Throwable throwable) {
            FileUtil.closeAll(tmpFileStream, content);
            throw throwable;
        }
        FileUtil.closeAll(tmpFileStream, content);
        beforeWriteAction.run();
        FileUtil.rename((File)tmpFile, (File)targetFile);
    }

    public static void renameAndReportErrors(@NotNull File oldName, @NotNull File newName) throws IOException, SecurityException {
        boolean renamedSuccessfully;
        if (oldName == null) {
            FileUtil.$$$reportNull$$$0(43);
        }
        if (newName == null) {
            FileUtil.$$$reportNull$$$0(44);
        }
        if (!(renamedSuccessfully = oldName.renameTo(newName))) {
            throw new IOException("Failed to rename \"" + oldName + "\" to \"" + newName + "\". The File.renameTo() returned false.");
        }
    }

    public static boolean sameButDifferInCase(@NotNull File file1, @NotNull File file2) {
        if (file1 == null) {
            FileUtil.$$$reportNull$$$0(45);
        }
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(46);
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            return false;
        }
        File dir1 = file1.getParentFile();
        File dir2 = file2.getParentFile();
        String name1 = file1.getName();
        String name2 = file2.getName();
        return dir1.equals(dir2) && StringUtil.differCaseOnly(name1, name2);
    }

    @NotNull
    public static File renameFileNameOnly(@NotNull File file, @NotNull String newName) throws IOException, SecurityException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(47);
        }
        if (newName == null) {
            FileUtil.$$$reportNull$$$0(48);
        }
        if (!file.exists()) {
            throw new IOException("cannot rename \"" + file + "\" to \"" + newName + "\": the source file doesn't exist");
        }
        File dir = file.getParentFile();
        File newFile = new File(dir, newName);
        if (newName.contains("/") || newName.contains("\\")) {
            newFile = newFile.getCanonicalFile();
        }
        if (newFile.exists()) {
            throw new IOException("cannot rename \"" + file + "\" to \"" + newName + "\": the destination file already exists");
        }
        boolean renamed = file.renameTo(newFile);
        if (!renamed) {
            throw new IOException("cannot rename \"" + file + "\" to \"" + newName + "\": the method File.rename() returned false");
        }
        File file2 = newFile;
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(49);
        }
        return file2;
    }

    @NotNull
    public static File resolvePath(@NotNull File baseDir, @NotNull String path) {
        File pathFile;
        if (baseDir == null) {
            FileUtil.$$$reportNull$$$0(50);
        }
        if (path == null) {
            FileUtil.$$$reportNull$$$0(51);
        }
        if ((pathFile = new File(path)).isAbsolute()) {
            File file = pathFile;
            if (file == null) {
                FileUtil.$$$reportNull$$$0(52);
            }
            return file;
        }
        File rawFile = new File(baseDir, path);
        if (baseDir.getPath().startsWith("\\\\")) {
            File file = rawFile;
            if (file == null) {
                FileUtil.$$$reportNull$$$0(53);
            }
            return file;
        }
        File file = new File(rawFile.toURI().normalize().getPath());
        if (file == null) {
            FileUtil.$$$reportNull$$$0(54);
        }
        return file;
    }

    @Deprecated
    public static void copyResource(@NotNull String resourceName, @NotNull File outputFile) {
        if (resourceName == null) {
            FileUtil.$$$reportNull$$$0(55);
        }
        if (outputFile == null) {
            FileUtil.$$$reportNull$$$0(56);
        }
        FileUtil.copyResource(FileUtil.class, resourceName, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) {
        if (clazz == null) {
            FileUtil.$$$reportNull$$$0(57);
        }
        if (resourceName == null) {
            FileUtil.$$$reportNull$$$0(58);
        }
        if (outputFile == null) {
            FileUtil.$$$reportNull$$$0(59);
        }
        InputStream asStream = null;
        FileOutputStream outputStream = null;
        try {
            asStream = clazz.getResourceAsStream(resourceName);
            if (asStream != null) {
                outputStream = new FileOutputStream(outputFile);
                StreamUtil.copyStreamContent((InputStream)asStream, (OutputStream)outputStream);
            } else {
                LOG.warn("Failed to copy resource " + resourceName + " from class " + clazz.getName() + ", resource not found");
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to copy resource " + resourceName + " from class " + clazz.getName() + ", due to the error: " + t.getMessage());
        }
        finally {
            if (asStream != null) {
                try {
                    asStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    public static void copyResourceIfNotExists(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) {
        if (clazz == null) {
            FileUtil.$$$reportNull$$$0(60);
        }
        if (resourceName == null) {
            FileUtil.$$$reportNull$$$0(61);
        }
        if (outputFile == null) {
            FileUtil.$$$reportNull$$$0(62);
        }
        if (!outputFile.exists()) {
            FileUtil.copyResource(clazz, resourceName, outputFile);
        }
    }

    public static void copyResourceWithDist(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) {
        if (clazz == null) {
            FileUtil.$$$reportNull$$$0(63);
        }
        if (resourceName == null) {
            FileUtil.$$$reportNull$$$0(64);
        }
        if (outputFile == null) {
            FileUtil.$$$reportNull$$$0(65);
        }
        try {
            File distFile = new File(outputFile.getParent(), outputFile.getName() + DIST_SUFFIX);
            if (!outputFile.exists() || distFile.exists() && FileUtil.readText(outputFile).equals(FileUtil.readText(distFile))) {
                FileUtil.copyResource(clazz, resourceName, outputFile);
            }
            FileUtil.copyResource(clazz, resourceName, distFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    public static String readResourceAsString(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull Charset charset) throws IOException {
        InputStream rcStream;
        if (clazz == null) {
            FileUtil.$$$reportNull$$$0(66);
        }
        if (resourceName == null) {
            FileUtil.$$$reportNull$$$0(67);
        }
        if (charset == null) {
            FileUtil.$$$reportNull$$$0(68);
        }
        if ((rcStream = clazz.getResourceAsStream(resourceName)) == null) {
            return null;
        }
        try {
            try (InputStreamReader rdr = new InputStreamReader(rcStream, charset);){
                String string = StreamUtil.readTextFrom((Reader)rdr);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            rcStream.close();
        }
    }

    public static void copyStreams(InputStream is, OutputStream os) throws IOException {
        TCStreamUtil.writeBinary(is, os);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFilePart(@NotNull File sourceFile, long offset, long length, @NotNull OutputStream outputStream) throws IOException {
        void destination;
        if (sourceFile == null) {
            FileUtil.$$$reportNull$$$0(69);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(70);
        }
        FileUtil.copyStreamRangeAndClose(new BufferedInputStream(new FileInputStream(sourceFile)), offset, length, (OutputStream)destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void copyStreamRangeAndClose(@NotNull InputStream source, long offset, long length, @NotNull OutputStream outputStream) throws IOException {
        if (source == null) {
            FileUtil.$$$reportNull$$$0(71);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(72);
        }
        try {
            void destination;
            TCStreamUtil.skip(source, offset);
            TCStreamUtil.writeBinary(source, length, (OutputStream)destination);
        }
        finally {
            FileUtil.close(source);
        }
    }

    public static void close(@Nullable Closeable e) {
        if (e != null) {
            try {
                e.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(@Nullable ZipFile e) {
        if (e != null) {
            try {
                e.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeAll(Closeable ... toClose) {
        if (toClose == null) {
            FileUtil.$$$reportNull$$$0(73);
        }
        for (Closeable e : toClose) {
            if (e == null) continue;
            try {
                e.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static List<File> getSubDirectories(@NotNull File root) {
        File[] files;
        if (root == null) {
            FileUtil.$$$reportNull$$$0(74);
        }
        List<Object> list = (files = root.listFiles(File::isDirectory)) == null ? Collections.emptyList() : Arrays.asList(files);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(75);
        }
        return list;
    }

    @NotNull
    public static File createDir(@NotNull File dir) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(76);
        }
        if (!(dir.isDirectory() || dir.mkdirs() || dir.isDirectory())) {
            throw new IOException("Failed to create directory: " + dir.getAbsolutePath());
        }
        File file = dir;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(77);
        }
        return file;
    }

    public static File createEmptyDir(@NotNull File dir) throws IOException {
        Object[] files;
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(78);
        }
        if (dir.exists() && (files = dir.listFiles()) != null && files.length > 0) {
            FileUtil.delete(dir);
        }
        FileUtil.createDir(dir);
        files = dir.listFiles();
        if (files != null && files.length > 0) {
            throw new IOException("Failed to clear directory: " + dir.getAbsolutePath() + ". The following files can't be removed: " + Arrays.toString(files));
        }
        return dir;
    }

    public static long getTotalDirectorySize(@Nullable File dir) {
        return FileUtil.getTotalDirectorySize(dir, false);
    }

    public static long getTotalDirectorySize(@Nullable File dir, boolean recursively) {
        if (dir == null) {
            return 0L;
        }
        if (recursively) {
            long[] size = new long[]{0L};
            com.intellij.openapi.util.io.FileUtil.processFilesRecursively((File)dir, file -> {
                if (file.isFile()) {
                    size[0] = size[0] + file.length();
                }
                return true;
            });
            return size[0];
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return 0L;
        }
        long size = 0L;
        for (File file2 : files) {
            if (!file2.isFile()) continue;
            size += file2.length();
        }
        return size;
    }

    public static boolean deleteIfEmpty(@NotNull File dir) {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(79);
        }
        if (dir.exists() && FileUtil.isEmptyDir(dir)) {
            return FileUtil.delete(dir);
        }
        return false;
    }

    public static Set<File> delete(@NotNull File fileOrDirectory, int numAttempts) {
        if (fileOrDirectory == null) {
            FileUtil.$$$reportNull$$$0(80);
        }
        return FileUtil.delete(fileOrDirectory, ACCEPT_ALL_FILES_FILTER, numAttempts);
    }

    @Deprecated
    public static void symlinkAwareDelete(@NotNull File fileOrDirectory) {
        if (fileOrDirectory == null) {
            FileUtil.$$$reportNull$$$0(81);
        }
        FileUtil.delete(fileOrDirectory, ACCEPT_ALL_FILES_FILTER, 10);
    }

    @Deprecated
    public static void symlinkAwareDelete(@NotNull File fileOrDirectory, @NotNull FileFilter fileFilter, int numAttempts) {
        if (fileOrDirectory == null) {
            FileUtil.$$$reportNull$$$0(82);
        }
        if (fileFilter == null) {
            FileUtil.$$$reportNull$$$0(83);
        }
        FileUtil.delete(fileOrDirectory, fileFilter, numAttempts);
    }

    @NotNull
    public static Set<File> delete(@NotNull File fileOrDirectory, @NotNull FileFilter fileFilter, int numAttempts) {
        if (fileOrDirectory == null) {
            FileUtil.$$$reportNull$$$0(84);
        }
        if (fileFilter == null) {
            FileUtil.$$$reportNull$$$0(85);
        }
        Set<File> set = FileUtil.delete(fileOrDirectory, fileFilter, numAttempts, null);
        if (set == null) {
            FileUtil.$$$reportNull$$$0(86);
        }
        return set;
    }

    @NotNull
    public static Set<File> delete(@NotNull File fileOrDirectory, @NotNull FileFilter fileFilter, int numAttempts, @Nullable FilesDeleteListener deleteListener) {
        File parent;
        if (fileOrDirectory == null) {
            FileUtil.$$$reportNull$$$0(87);
        }
        if (fileFilter == null) {
            FileUtil.$$$reportNull$$$0(88);
        }
        boolean isUnix = SystemInfo.isUnix;
        boolean atLeastOneFileFilteredOutByFilter = false;
        if (isUnix && !fileOrDirectory.isFile() && !fileOrDirectory.isDirectory() && !fileOrDirectory.exists() && (parent = fileOrDirectory.getParentFile()) != null) {
            Boolean canListCheck = FileUtil.canListFilesInDirectory(parent);
            if (Boolean.FALSE.equals(canListCheck)) {
                LOG.warn("Cannot delete '" + fileOrDirectory.getAbsolutePath() + "' no access on containing directory");
                Set<File> set = Collections.emptySet();
                if (set == null) {
                    FileUtil.$$$reportNull$$$0(89);
                }
                return set;
            }
            if (Boolean.TRUE.equals(canListCheck)) {
                Set<File> set = Collections.singleton(fileOrDirectory);
                if (set == null) {
                    FileUtil.$$$reportNull$$$0(90);
                }
                return set;
            }
        }
        HashSet<File> visited = new HashSet<File>();
        HashSet<File> removed = new HashSet<File>();
        LinkedList<File> toRemove = new LinkedList<File>();
        toRemove.add(fileOrDirectory);
        while (!toRemove.isEmpty()) {
            File next = (File)toRemove.peek();
            boolean acceptedByFilter = fileFilter.accept(next);
            boolean nextIsDirectory = next.isDirectory();
            if (visited.add(next) && acceptedByFilter && nextIsDirectory && !FileUtil.isSymlink(next)) {
                File[] files = next.listFiles();
                if (isUnix && files == null) {
                    next.setReadable(true);
                    files = next.listFiles();
                }
                if (files != null) {
                    boolean hasSomethingToRemove = false;
                    for (File file : files) {
                        if (visited.contains(file)) continue;
                        toRemove.addFirst(file);
                        hasSomethingToRemove = true;
                    }
                    if (files.length > 0 && hasSomethingToRemove) {
                        if (!isUnix || FileUtil.isCanExecute(next)) continue;
                        next.setExecutable(true);
                        continue;
                    }
                    if (files.length > 0) {
                        toRemove.remove(next);
                        continue;
                    }
                }
            }
            boolean fileRemoved = false;
            if (acceptedByFilter) {
                long fileSize = 0L;
                if (deleteListener != null && !nextIsDirectory) {
                    fileSize = next.length();
                }
                for (int i = 0; i < numAttempts; ++i) {
                    boolean deleted = next.delete();
                    if (deleted || !next.exists()) {
                        if (deleted && deleteListener != null && fileSize > 0L) {
                            deleteListener.fileDeleted(FileUtil.getRelativePath((File)fileOrDirectory, (File)next), fileSize, nextIsDirectory);
                        }
                        removed.add(next);
                        visited.remove(next);
                        fileRemoved = true;
                        break;
                    }
                    if (isUnix && i == 0) {
                        File parent2;
                        if (next == fileOrDirectory || (parent2 = next.getParentFile()).canWrite()) continue;
                        parent2.setWritable(true);
                        continue;
                    }
                    ThreadUtil.sleep(10L);
                }
            }
            toRemove.remove(next);
            if (fileRemoved) continue;
            for (File parentFile = next.getParentFile(); parentFile != null && toRemove.remove(parentFile); parentFile = parentFile.getParentFile()) {
            }
            if (acceptedByFilter) {
                LOG.warn("Cannot delete " + (nextIsDirectory ? "directory" : "file") + " '" + next.getAbsolutePath() + "'");
                continue;
            }
            atLeastOneFileFilteredOutByFilter = true;
        }
        if (isUnix && fileOrDirectory.exists()) {
            File parent3 = fileOrDirectory.getParentFile();
            if (parent3 != null && !parent3.canWrite()) {
                LOG.warn("Cannot delete '" + fileOrDirectory.getAbsolutePath() + "' no write access on containing directory");
            } else if (fileOrDirectory.isDirectory() && !atLeastOneFileFilteredOutByFilter) {
                LOG.warn("Cannot delete directory '" + fileOrDirectory.getAbsolutePath() + "' even after fixing permissions");
            }
        }
        HashSet<File> hashSet = removed;
        if (hashSet == null) {
            FileUtil.$$$reportNull$$$0(91);
        }
        return hashSet;
    }

    private static boolean isCanExecute(@NotNull File file) {
        boolean canExecute;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(92);
        }
        try {
            canExecute = file.canExecute();
        }
        catch (SecurityException e) {
            canExecute = false;
        }
        return canExecute;
    }

    @Nullable
    private static Boolean canListFilesInDirectory(@NotNull File dir) {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(93);
        }
        while (dir != null) {
            if (dir.exists()) {
                return FileUtil.isCanExecute(dir);
            }
            dir = dir.getParentFile();
        }
        return null;
    }

    public static boolean delete(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(94);
        }
        return FileUtil.delete(file, ACCEPT_ALL_FILES_FILTER, 10).contains(file);
    }

    public static Collection<File> deleteFiles(@NotNull Collection<File> filesToDelete) {
        if (filesToDelete == null) {
            FileUtil.$$$reportNull$$$0(95);
        }
        ArrayList<File> remainder = new ArrayList<File>(filesToDelete);
        boolean repeat = true;
        for (int attempts = 3; repeat && attempts > 0; --attempts) {
            repeat = false;
            Iterator it = remainder.iterator();
            while (it.hasNext()) {
                File fileToDelete = (File)it.next();
                if (fileToDelete.exists()) {
                    if (!fileToDelete.isFile()) continue;
                    boolean deleted = fileToDelete.delete();
                    if (deleted) {
                        it.remove();
                        continue;
                    }
                    repeat = true;
                    continue;
                }
                it.remove();
            }
            if (!repeat) continue;
            ThreadUtil.sleep(25L);
        }
        return remainder;
    }

    public static boolean isEmptyDir(@NotNull File dir) {
        File[] files;
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(96);
        }
        if ((files = dir.listFiles()) == null && dir.isDirectory()) {
            return false;
        }
        return files == null || files.length == 0;
    }

    public static boolean isReadonly(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(97);
        }
        if (file.isDirectory()) {
            return false;
        }
        return !file.canWrite();
    }

    @NotNull
    public static String fixDirectoryName(@NotNull String name) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(98);
        }
        String string = FIX_DIRECTORY_NAME_PATTERN.matcher(FileUtil.fixDots(name)).replaceAll("_");
        if (string == null) {
            FileUtil.$$$reportNull$$$0(99);
        }
        return string;
    }

    @NotNull
    public static String fixDirectoryNameAllowUnicode(String name) {
        String string = FIX_DIRECTORY_NAME_PATTERN_ALLOW_UNICODE.matcher(FileUtil.fixDots(name)).replaceAll("_");
        if (string == null) {
            FileUtil.$$$reportNull$$$0(100);
        }
        return string;
    }

    @NotNull
    private static String fixDots(@NotNull String name) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(101);
        }
        if (name.equals("..")) {
            if ("__" == null) {
                FileUtil.$$$reportNull$$$0(102);
            }
            return "__";
        }
        if (name.equals(".")) {
            if ("_" == null) {
                FileUtil.$$$reportNull$$$0(103);
            }
            return "_";
        }
        if (name.endsWith("..")) {
            String string = name.substring(0, name.length() - 2) + "__";
            if (string == null) {
                FileUtil.$$$reportNull$$$0(104);
            }
            return string;
        }
        if (name.endsWith(".")) {
            String string = name.substring(0, name.length() - 1) + "_";
            if (string == null) {
                FileUtil.$$$reportNull$$$0(105);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(106);
        }
        return string;
    }

    public static boolean isBadDirectoryName(@NotNull String name) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(107);
        }
        return name.matches(BAD_DIRECTORY_NAME_PATTERN);
    }

    @NotNull
    public static String normalizeSeparator(@NotNull String filePath) {
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(108);
        }
        StringBuilder result = new StringBuilder(filePath.length());
        for (int i = 0; i < filePath.length(); ++i) {
            char c = filePath.charAt(i);
            result.append(c == '/' || c == '\\' ? File.separatorChar : c);
        }
        String string = result.toString();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(109);
        }
        return string;
    }

    @NotNull
    public static String normalizeRelativePath(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(110);
        }
        String string = new PathNormalizer(path, false).invoke();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(111);
        }
        return string;
    }

    @NotNull
    public static String normalizeAbsolutePath(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(112);
        }
        if (new File(path).isAbsolute()) {
            String string = FileUtil.normalizeSeparator(new PathNormalizer(path, true).invoke());
            if (string == null) {
                FileUtil.$$$reportNull$$$0(113);
            }
            return string;
        }
        throw new IllegalArgumentException("Path must be absolute " + path);
    }

    public static void sortFiles(@NotNull File[] files) {
        if (files == null) {
            FileUtil.$$$reportNull$$$0(114);
        }
        Arrays.sort(files, FILE_COMPARATOR);
    }

    @Nullable
    public static File getCommonParentFile(@NotNull File file1, @NotNull File file2) {
        File parentCandidate;
        if (file1 == null) {
            FileUtil.$$$reportNull$$$0(115);
        }
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(116);
        }
        for (parentCandidate = file1; parentCandidate != null && !file2.getAbsolutePath().startsWith(parentCandidate.getAbsolutePath()); parentCandidate = parentCandidate.getParentFile()) {
        }
        return parentCandidate;
    }

    @Deprecated
    @NotNull
    public static String getCommonParent(@NotNull String firstUrl, @NotNull String secondUrl) {
        char c2;
        char c1;
        int i;
        if (firstUrl == null) {
            FileUtil.$$$reportNull$$$0(117);
        }
        if (secondUrl == null) {
            FileUtil.$$$reportNull$$$0(118);
        }
        StringBuilder result = new StringBuilder();
        StringBuffer nextPathElem = new StringBuffer();
        boolean addSeparator = false;
        char separatorChar = '/';
        for (i = 0; i < firstUrl.length() && i < secondUrl.length() && (c1 = firstUrl.charAt(i)) == (c2 = secondUrl.charAt(i)); ++i) {
            if (FileUtil.isFileSeparator(c1) || FileUtil.isFileSeparator(c2)) {
                if (addSeparator) {
                    result.append(separatorChar);
                }
                if (nextPathElem.length() > 0) {
                    result.append(nextPathElem);
                    nextPathElem = new StringBuffer();
                    addSeparator = true;
                    separatorChar = c1;
                    continue;
                }
                if (addSeparator) {
                    result.append(separatorChar);
                    addSeparator = false;
                    separatorChar = '/';
                    continue;
                }
                addSeparator = true;
                separatorChar = c1;
                continue;
            }
            nextPathElem.append(c1);
        }
        if ((i == firstUrl.length() || i == secondUrl.length()) && nextPathElem.length() > 0) {
            if (result.length() > 0 || addSeparator) {
                result.append(separatorChar);
            }
            result.append(nextPathElem);
        }
        if (addSeparator) {
            result.append(separatorChar);
        }
        String string = result.toString();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(119);
        }
        return string;
    }

    public static boolean isFileSeparator(char c1) {
        return c1 == '\\' || c1 == '/';
    }

    @NotNull
    public static File getCanonicalFile(@NotNull File file) {
        File file2;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(120);
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException e) {
            File file3 = file.getAbsoluteFile();
            if (file3 == null) {
                FileUtil.$$$reportNull$$$0(122);
            }
            return file3;
        }
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(121);
        }
        return file2;
    }

    public static void checkTmpDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpDir.isDirectory() && !tmpDir.mkdirs()) {
            throw new IllegalStateException("\n\n\nUnable to access temp directory " + tmpDir.getAbsolutePath() + "\n\n\n");
        }
    }

    @Nullable
    public static File findFile(@NotNull FileFilter filter, File ... directories) {
        Collection<File> found;
        if (filter == null) {
            FileUtil.$$$reportNull$$$0(123);
        }
        if (directories == null) {
            FileUtil.$$$reportNull$$$0(124);
        }
        if ((found = FileUtil.doFindFiles(filter, directories, true)).isEmpty()) {
            return null;
        }
        return found.iterator().next();
    }

    @NotNull
    public static Collection<File> findFiles(@NotNull FileFilter filter, File ... directories) {
        if (filter == null) {
            FileUtil.$$$reportNull$$$0(125);
        }
        if (directories == null) {
            FileUtil.$$$reportNull$$$0(126);
        }
        Collection<File> collection = FileUtil.doFindFiles(filter, directories, false);
        if (collection == null) {
            FileUtil.$$$reportNull$$$0(127);
        }
        return collection;
    }

    @NotNull
    private static Collection<File> doFindFiles(@NotNull FileFilter filter, @NotNull File[] directories, boolean stopOnFirstMatch) {
        if (filter == null) {
            FileUtil.$$$reportNull$$$0(128);
        }
        if (directories == null) {
            FileUtil.$$$reportNull$$$0(129);
        }
        HashSet<File> found = new HashSet<File>();
        HashSet<File> processed = new HashSet<File>();
        LinkedList<File> directoriesToSearch = new LinkedList<File>();
        for (File dir : directories) {
            File absDir = dir.getAbsoluteFile();
            if (!processed.add(absDir)) continue;
            directoriesToSearch.offer(absDir);
        }
        while (!directoriesToSearch.isEmpty()) {
            File nextDir = (File)directoriesToSearch.poll();
            File[] files = nextDir.listFiles();
            if (files == null || files.length == 0) continue;
            for (File file : files) {
                File absFile = file.getAbsoluteFile();
                boolean isDir = absFile.isDirectory();
                if (isDir && processed.add(absFile)) {
                    directoriesToSearch.offer(file);
                }
                if (isDir || !filter.accept(absFile)) continue;
                if (stopOnFirstMatch) {
                    Set<File> set = Collections.singleton(absFile);
                    if (set == null) {
                        FileUtil.$$$reportNull$$$0(130);
                    }
                    return set;
                }
                found.add(absFile);
            }
        }
        HashSet<File> hashSet = found;
        if (hashSet == null) {
            FileUtil.$$$reportNull$$$0(131);
        }
        return hashSet;
    }

    public static <C extends Collection<String>> C listFilesRecursively(@NotNull File dir, @NotNull String prefix, boolean includeDirs, int depthLimit, @Nullable Predicate<File> predicate, @NotNull C collection) {
        File[] children;
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(132);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(133);
        }
        if (collection == null) {
            FileUtil.$$$reportNull$$$0(134);
        }
        if ((children = dir.listFiles()) != null) {
            for (File child : children) {
                String name;
                if (child == null || (name = child.getName()).equals(".") || name.equals("..") || predicate != null && !predicate.apply(child)) continue;
                String entry = prefix + name;
                if (child.isDirectory()) {
                    if (includeDirs) {
                        collection.add((String)entry);
                    }
                    if (depthLimit <= 0) continue;
                    FileUtil.listFilesRecursively(child, entry + '/', includeDirs, depthLimit - 1, predicate, collection);
                    continue;
                }
                collection.add((String)(prefix + name));
            }
        }
        return collection;
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory, @NotNull FilenameFilter filter) {
        File[] result;
        if (directory == null) {
            FileUtil.$$$reportNull$$$0(135);
        }
        if (filter == null) {
            FileUtil.$$$reportNull$$$0(136);
        }
        File[] fileArray = (result = directory.listFiles(filter)) != null ? result : ourEmptyFilesArray;
        if (fileArray == null) {
            FileUtil.$$$reportNull$$$0(137);
        }
        return fileArray;
    }

    @Nullable
    public static Long getFreeSpace(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(138);
        }
        if (!file.exists()) {
            return null;
        }
        if (IO_FILE_GET_USABLE_SPACE != null) {
            try {
                Long result = (Long)IO_FILE_GET_USABLE_SPACE.invoke((Object)file, new Object[0]);
                if (result > 0L) {
                    return result;
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to compute free space using Java API for directory: " + file + ", error: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            return FileUtil.getFreeSpaceBytesSafe(file);
        }
        catch (Exception e) {
            LOG.warn("Failed to compute free space using command line utilities for directory: " + file + ", error: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static Long getFreeSpaceKB(@NotNull File dir) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(139);
        }
        return FileUtil.freeSpaceKb(dir);
    }

    public static long freeSpaceKb(@NotNull String path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(140);
        }
        return FileUtil.freeSpaceKb(new File(path));
    }

    private static long freeSpaceKb(@NotNull File path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(141);
        }
        if (SystemInfo.isWindows) {
            return FileUtil.freeSpaceWindows(path.getCanonicalPath()) / 1024L;
        }
        return FileUtil.freeSpaceUnix(path.getCanonicalPath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long freeSpaceUnix(@NotNull String path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(142);
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        String[] cmdAttribs = new String[]{"df", "-k", path};
        List<String> lines = FileUtil.performCommand(cmdAttribs, 3);
        if (lines.size() < 2) {
            throw new IOException("Command line 'df' did not return info as expected for path '" + path + "'- response was " + lines);
        }
        String line2 = lines.get(1);
        StringTokenizer tok = new StringTokenizer(line2, " ");
        if (tok.countTokens() < 4) {
            if (tok.countTokens() != 1 || lines.size() < 3) throw new IOException("Command line 'df' did not return data as expected for path '" + path + "'- check path is valid");
            String line3 = lines.get(2);
            tok = new StringTokenizer(line3, " ");
        } else {
            tok.nextToken();
        }
        tok.nextToken();
        tok.nextToken();
        String freeSpace = tok.nextToken();
        return FileUtil.parseBytes(freeSpace, path);
    }

    private static long parseBytes(String freeSpace, String path) throws IOException {
        try {
            long bytes = Long.parseLong(freeSpace);
            if (bytes < 0L) {
                throw new IOException("Command line 'df' did not find free space in response for path '" + path + "'- check path is valid");
            }
            return bytes;
        }
        catch (NumberFormatException ex) {
            throw new IOException("Command line 'df' did not return numeric data as expected for path '" + path + "'- check path is valid");
        }
    }

    private static long freeSpaceWindows(@NotNull String path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(143);
        }
        String[] cmdAttribs = new String[]{"cmd.exe", "/C", "dir", "/-c", path};
        List<String> lines = FileUtil.performCommand(cmdAttribs, Integer.MAX_VALUE);
        for (int i = lines.size() - 1; i >= 0; --i) {
            String line = lines.get(i);
            if (line.isEmpty()) continue;
            return FileUtil.parseDir(line, path);
        }
        throw new IOException("Command line 'dir /-c' did not return any info for path '" + path + "'");
    }

    private static long parseDir(String line, String path) throws IOException {
        char c;
        int j;
        int bytesStart = 0;
        int bytesEnd = 0;
        for (j = line.length() - 1; j >= 0; --j) {
            c = line.charAt(j);
            if (!Character.isDigit(c)) continue;
            bytesEnd = j + 1;
            break;
        }
        while (j >= 0) {
            c = line.charAt(j);
            if (!Character.isDigit(c) && c != ',' && c != '.') {
                bytesStart = j + 1;
                break;
            }
            --j;
        }
        if (j < 0) {
            throw new IOException("Command line 'dir /-c' did not return valid info for path '" + path + "'");
        }
        StringBuilder buf = new StringBuilder(line.substring(bytesStart, bytesEnd));
        for (int k = 0; k < buf.length(); ++k) {
            if (buf.charAt(k) != ',' && buf.charAt(k) != '.') continue;
            buf.deleteCharAt(k--);
        }
        return FileUtil.parseBytes(buf.toString(), path);
    }

    private static Process openProcess(String[] cmdAttribs) throws IOException {
        return Runtime.getRuntime().exec(cmdAttribs);
    }

    private static List<String> performCommand(String[] cmdAttribs, int max) throws IOException {
        ArrayList<String> arrayList;
        ArrayList<String> lines = new ArrayList<String>(20);
        Process proc = null;
        InputStream in = null;
        OutputStream out = null;
        InputStream err = null;
        BufferedReader inr = null;
        try {
            proc = FileUtil.openProcess(cmdAttribs);
            in = proc.getInputStream();
            out = proc.getOutputStream();
            err = proc.getErrorStream();
            inr = new BufferedReader(new InputStreamReader(in));
            String line = inr.readLine();
            while (line != null && lines.size() < max) {
                line = line.toLowerCase().trim();
                lines.add(line);
                line = inr.readLine();
            }
            proc.waitFor();
            if (proc.exitValue() != 0) {
                throw new IOException("Command line returned OS error code '" + proc.exitValue() + "' for command " + Arrays.asList(cmdAttribs));
            }
            if (lines.isEmpty()) {
                throw new IOException("Command line did not return any info for command " + Arrays.asList(cmdAttribs));
            }
            arrayList = lines;
        }
        catch (InterruptedException ex) {
            try {
                throw new IOException("Command line threw an InterruptedException '" + ex.getMessage() + "' for command " + Arrays.asList(cmdAttribs));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(err);
                IOUtils.closeQuietly(inr);
                if (proc != null) {
                    proc.destroy();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)err);
        IOUtils.closeQuietly((Reader)inr);
        if (proc != null) {
            proc.destroy();
        }
        return arrayList;
    }

    public static Long getFreeSpaceBytesSafe(@NotNull File dir) throws IOException {
        long result;
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(144);
        }
        if ((result = FileUtil.freeSpaceKb(dir) * 1024L) < 0L) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File from, @NotNull File to) throws IOException {
        if (from == null) {
            FileUtil.$$$reportNull$$$0(145);
        }
        if (to == null) {
            FileUtil.$$$reportNull$$$0(146);
        }
        if (FileUtil.areTheSame(from, to)) {
            return;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(from), 20480);
        if (!to.exists()) {
            File parentFile = to.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            to.createNewFile();
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(to), 20480);
        try {
            TCStreamUtil.writeBinary(is, os);
        }
        finally {
            FileUtil.close(is);
            FileUtil.close(os);
        }
    }

    public static boolean areTheSame(@Nullable File file1, @Nullable File file2) throws IOException {
        if (file1 == null && file2 == null) {
            return true;
        }
        if (file1 == null || file2 == null) {
            return false;
        }
        File x1 = file1.getCanonicalFile();
        File x2 = file2.getCanonicalFile();
        return x1.equals(x2);
    }

    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern) {
        if (antPattern == null) {
            FileUtil.$$$reportNull$$$0(147);
        }
        String string = FileUtil.convertAntToRegexp(antPattern, true);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(148);
        }
        return string;
    }

    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        if (antPattern == null) {
            FileUtil.$$$reportNull$$$0(149);
        }
        StringBuilder builder = new StringBuilder(antPattern.length());
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (antPattern.startsWith("/") || antPattern.startsWith("\\")) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|' || ch == '(' || ch == ')') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        String string = builder.toString();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(150);
        }
        return string;
    }

    @NotNull
    public static String getExtension(@NotNull String fileNameWithDirectory) {
        if (fileNameWithDirectory == null) {
            FileUtil.$$$reportNull$$$0(151);
        }
        int dotIdx = fileNameWithDirectory.lastIndexOf(46);
        int pathSeparatorIdx = Math.max(fileNameWithDirectory.lastIndexOf(47), fileNameWithDirectory.lastIndexOf(92));
        if (dotIdx != -1 && pathSeparatorIdx < dotIdx) {
            String string = fileNameWithDirectory.substring(dotIdx + 1);
            if (string == null) {
                FileUtil.$$$reportNull$$$0(152);
            }
            return string;
        }
        if ("" == null) {
            FileUtil.$$$reportNull$$$0(153);
        }
        return "";
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(154);
        }
        String string = FileUtil.getNameWithoutExtension(file.getName());
        if (string == null) {
            FileUtil.$$$reportNull$$$0(155);
        }
        return string;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        String ext;
        if (name == null) {
            FileUtil.$$$reportNull$$$0(156);
        }
        String string = !(ext = FileUtil.getExtension(name)).isEmpty() ? name.substring(0, name.length() - ext.length() - 1) : name;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(157);
        }
        return string;
    }

    @NotNull
    public static String getName(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(158);
        }
        if (path.isEmpty()) {
            if ("" == null) {
                FileUtil.$$$reportNull$$$0(159);
            }
            return "";
        }
        char c = path.charAt(path.length() - 1);
        int end = c == '/' || c == '\\' ? path.length() - 1 : path.length();
        int start = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1)) + 1;
        String string = path.substring(start, end);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(160);
        }
        return string;
    }

    public static void setExectuableAttribute(String path, boolean executableFlag) throws IOException {
        if (IO_FILE_SET_EXECUTABLE_METHOD != null) {
            try {
                IO_FILE_SET_EXECUTABLE_METHOD.invoke((Object)new File(path), executableFlag);
                return;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!SystemInfo.isWindows) {
            Process process = Runtime.getRuntime().exec(new String[]{"chmod", executableFlag ? "u+x" : "u-x", path});
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean checkContentEqual(@NotNull File file1, @NotNull File file2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean haveEqualContentIgnoringLineEndings(@NotNull File file1, @NotNull File file2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(165);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(166);
        }
        try {
            return com.intellij.openapi.util.io.FileUtil.isAncestor((File)ancestor, (File)file, (boolean)strict);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowAsRuntimeException(e);
            return false;
        }
    }

    public static void copy(@NotNull InputStream is, @NotNull OutputStream os) throws IOException {
        if (is == null) {
            FileUtil.$$$reportNull$$$0(167);
        }
        if (os == null) {
            FileUtil.$$$reportNull$$$0(168);
        }
        FileUtil.copyStreams(is, os);
    }

    public static boolean isBinaryFile(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(169);
        }
        try (FileInputStream input = new FileInputStream(file);){
            byte[] buffer = new byte[1024];
            int size = input.read(buffer);
            if (size <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = FileUtil.isBinaryData(buffer, size);
            return bl;
        }
    }

    public static boolean isBinaryData(byte[] data, int size) {
        return !FileUtil.isTextData(data, size);
    }

    public static boolean isTextData(byte[] data, int size) {
        for (int i = 0; i < Math.min(size, data.length); ++i) {
            if (data[i] < 1 || data[i] >= 9) continue;
            return false;
        }
        return true;
    }

    public static boolean isSymlink(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(170);
        }
        try {
            try {
                if (NIO_FILE_FILES_IS_SYMBOLIC_LINK_METHOD != null) {
                    return (Boolean)NIO_FILE_FILES_IS_SYMBOLIC_LINK_METHOD.invoke(null, IO_FILE_TO_PATH_METHOD.invoke((Object)file, new Object[0]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String canonicalPath = FileUtil.normalizeAbsolutePath(file.getCanonicalPath());
            String absolutePath = FileUtil.normalizeAbsolutePath(file.getAbsolutePath());
            char fileSeparator = File.separatorChar;
            assert (canonicalPath.indexOf(fileSeparator) * absolutePath.indexOf(fileSeparator) >= 0) : String.format("Paths use different separators: canonical: \"%s\"; absolute: \"%s\"", canonicalPath, absolutePath);
            return !canonicalPath.equals(absolutePath);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean createSymlink(File target, File symlinkFile) {
        if (!SystemInfo.isUnix) {
            return false;
        }
        if (symlinkFile.exists()) {
            return false;
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            Process exec = runtime.exec(new String[]{"ln", "-s", target.getAbsolutePath(), symlinkFile.getAbsolutePath()});
            exec.waitFor();
            return symlinkFile.exists() && target.equals(symlinkFile.getCanonicalFile());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getNameOrAbsolutePath(@NotNull File baseDir, @NotNull File checkDir) {
        if (baseDir == null) {
            FileUtil.$$$reportNull$$$0(171);
        }
        if (checkDir == null) {
            FileUtil.$$$reportNull$$$0(172);
        }
        if (baseDir.equals(checkDir.getParentFile())) {
            return checkDir.getName();
        }
        return checkDir.getAbsolutePath();
    }

    public static Reader getUTF8Reader(@NotNull File file) throws FileNotFoundException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(173);
        }
        return new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
    }

    static {
        Method getUsableSpaceCandidate;
        Method setExecutableMethodCandidate;
        Method toPath;
        Method isLink;
        LOG = Logger.getInstance((String)FileUtil.class.getName());
        ACCEPT_ALL_FILES_FILTER = pathname -> true;
        FIX_DIRECTORY_NAME_PATTERN = Pattern.compile("[^A-Za-z0-9_ &#.@$%\\[\\](){}\\-+=]");
        FIX_DIRECTORY_NAME_PATTERN_ALLOW_UNICODE = Pattern.compile("[^A-Za-z0-9_ &#.@$%\\[\\](){}\\-+=\\p{L}]");
        BAD_DIRECTORY_NAME_PATTERN = ".*" + FIX_DIRECTORY_NAME_PATTERN + ".*";
        FILE_COMPARATOR = (left, right) -> {
            if (left.isDirectory() && right.isFile()) {
                return -1;
            }
            if (left.isFile() && right.isDirectory()) {
                return 1;
            }
            return left.getName().compareToIgnoreCase(right.getName());
        };
        ourEmptyFilesArray = new File[0];
        try {
            Class<?> filesClass = Class.forName("java.nio.file.Files");
            Class<?> pathClass = Class.forName("java.nio.file.Path");
            isLink = filesClass.getDeclaredMethod("isSymbolicLink", pathClass);
            toPath = File.class.getDeclaredMethod("toPath", new Class[0]);
        }
        catch (Exception ex) {
            isLink = null;
            toPath = null;
        }
        IO_FILE_TO_PATH_METHOD = toPath;
        NIO_FILE_FILES_IS_SYMBOLIC_LINK_METHOD = isLink;
        try {
            setExecutableMethodCandidate = File.class.getDeclaredMethod("setExecutable", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            setExecutableMethodCandidate = null;
        }
        catch (RuntimeException e) {
            if (!"java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) {
                throw e;
            }
            setExecutableMethodCandidate = null;
        }
        IO_FILE_SET_EXECUTABLE_METHOD = setExecutableMethodCandidate;
        try {
            getUsableSpaceCandidate = File.class.getMethod("getUsableSpace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getUsableSpaceCandidate = null;
        }
        catch (RuntimeException e) {
            if (!"java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) {
                throw e;
            }
            getUsableSpaceCandidate = null;
        }
        IO_FILE_GET_USABLE_SPACE = getUsableSpaceCandidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 24: 
            case 26: 
            case 28: 
            case 36: 
            case 37: 
            case 39: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 75: 
            case 77: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 119: 
            case 121: 
            case 122: 
            case 127: 
            case 130: 
            case 131: 
            case 137: 
            case 148: 
            case 150: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 160: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 24: 
            case 26: 
            case 28: 
            case 36: 
            case 37: 
            case 39: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 75: 
            case 77: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 119: 
            case 121: 
            case 122: 
            case 127: 
            case 130: 
            case 131: 
            case 137: 
            case 148: 
            case 150: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 160: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 24: 
            case 26: 
            case 28: 
            case 36: 
            case 37: 
            case 39: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 75: 
            case 77: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 119: 
            case 121: 
            case 122: 
            case 127: 
            case 130: 
            case 131: 
            case 137: 
            case 148: 
            case 150: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/FileUtil";
                break;
            }
            case 3: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_files";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origFile";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeWriteAction";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 45: 
            case 115: 
            case 161: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 46: 
            case 116: 
            case 162: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 50: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 51: 
            case 110: 
            case 112: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 56: 
            case 59: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 57: 
            case 60: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toClose";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 76: 
            case 78: 
            case 79: 
            case 93: 
            case 96: 
            case 132: 
            case 139: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 83: 
            case 85: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFilter";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 98: 
            case 101: 
            case 107: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstUrl";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondUrl";
                break;
            }
            case 123: 
            case 125: 
            case 128: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 124: 
            case 126: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 147: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "antPattern";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithDirectory";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/FileUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readFileImpl";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedDocument";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDocument";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesSignature";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileInSameDir";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "renameFileNameOnly";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubDirectories";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createDir";
                break;
            }
            case 86: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "delete";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "fixDirectoryName";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "fixDirectoryNameAllowUnicode";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "fixDots";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeSeparator";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeRelativePath";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeAbsolutePath";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonParent";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalFile";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "findFiles";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindFiles";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "listFiles";
                break;
            }
            case 148: 
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAntToRegexp";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 155: 
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 24: 
            case 26: 
            case 28: 
            case 36: 
            case 37: 
            case 39: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 75: 
            case 77: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 119: 
            case 121: 
            case 122: 
            case 127: 
            case 130: 
            case 131: 
            case 137: 
            case 148: 
            case 150: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 160: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readFileImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readText";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeFileAndReportErrors";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readXmlFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedDocument";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "parseDocument";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processXmlFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFilesSignature";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFileInSameDir";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "writeViaTmpFile";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "renameAndReportErrors";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sameButDifferInCase";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "renameFileNameOnly";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "copyResource";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "copyResourceIfNotExists";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "copyResourceWithDist";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "readResourceAsString";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "copyFilePart";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "copyStreamRangeAndClose";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "closeAll";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getSubDirectories";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createDir";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyDir";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "deleteIfEmpty";
                break;
            }
            case 80: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "symlinkAwareDelete";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isCanExecute";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "canListFilesInDirectory";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "deleteFiles";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyDir";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isReadonly";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "fixDirectoryName";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "fixDots";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isBadDirectoryName";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "normalizeSeparator";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "normalizeRelativePath";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAbsolutePath";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "sortFiles";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "getCommonParentFile";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getCommonParent";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalFile";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "findFiles";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "doFindFiles";
                break;
            }
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "listFilesRecursively";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "listFiles";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getFreeSpace";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "getFreeSpaceKB";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "freeSpaceKb";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "freeSpaceUnix";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "freeSpaceWindows";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "getFreeSpaceBytesSafe";
                break;
            }
            case 145: 
            case 146: 
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 147: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "convertAntToRegexp";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 154: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "checkContentEqual";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "haveEqualContentIgnoringLineEndings";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryFile";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "isSymlink";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getNameOrAbsolutePath";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "getUTF8Reader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 24: 
            case 26: 
            case 28: 
            case 36: 
            case 37: 
            case 39: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 75: 
            case 77: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 119: 
            case 121: 
            case 122: 
            case 127: 
            case 130: 
            case 131: 
            case 137: 
            case 148: 
            case 150: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 160: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RegexFileFilter
    implements FileFilter {
        @NotNull
        final Pattern myPattern;

        public RegexFileFilter(@NotNull String pattern) {
            if (pattern == null) {
                RegexFileFilter.$$$reportNull$$$0(0);
            }
            this.myPattern = Pattern.compile(pattern, 2);
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            return file.isFile() && this.myPattern.matcher(file.getName()).matches();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "jetbrains/buildServer/util/FileUtil$RegexFileFilter", "<init>"));
        }
    }

    private static class PathNormalizer {
        private final String myPath;
        private final boolean myAbsolute;
        private final List<String> myParts;
        private final StringBuilder myNextPart;

        PathNormalizer(@NotNull String path, boolean isAbsolute) {
            if (path == null) {
                PathNormalizer.$$$reportNull$$$0(0);
            }
            this.myParts = new ArrayList<String>();
            this.myNextPart = new StringBuilder();
            this.myPath = path;
            this.myAbsolute = isAbsolute;
        }

        public String invoke() {
            if (this.pathIsSafe()) {
                return this.myPath;
            }
            this.collectParts();
            return this.joinParts();
        }

        private boolean pathIsSafe() {
            int length = this.myPath.length();
            if (length == 0) {
                return true;
            }
            if (this.myPath.charAt(0) == '/' || this.myPath.charAt(length - 1) == '/') {
                return false;
            }
            int prev = 32;
            for (int i = 0; i < length; ++i) {
                char c = this.myPath.charAt(i);
                if (c == '\\') {
                    return false;
                }
                if (c == '/') {
                    char next;
                    if (prev == 46 || prev == 42) {
                        return false;
                    }
                    if (i < length - 1 && ((next = this.myPath.charAt(i + 1)) == '.' || next == '*' || next == '/')) {
                        return false;
                    }
                }
                prev = c;
            }
            return length != 1 || prev != 46;
        }

        private void collectParts() {
            block3: for (int i = 0; i < this.myPath.length(); ++i) {
                char c = this.myPath.charAt(i);
                switch (c) {
                    case '/': 
                    case '\\': {
                        if (i < 2 && this.myAbsolute) {
                            this.myNextPart.append('/');
                            continue block3;
                        }
                        this.processBoundary();
                        continue block3;
                    }
                    default: {
                        this.myNextPart.append(c);
                    }
                }
            }
            this.processBoundary();
        }

        private void processBoundary() {
            if (this.myNextPart.length() > 0) {
                String val = this.myNextPart.toString();
                if ("..".equals(val)) {
                    if (!this.myParts.isEmpty() && !"..".equals(this.myParts.get(this.myParts.size() - 1))) {
                        this.removeLast();
                    } else {
                        this.myParts.add(val);
                    }
                } else if (!".".equals(val)) {
                    this.myParts.add(val);
                }
                this.reset();
            }
        }

        private void removeLast() {
            this.myParts.remove(this.myParts.size() - 1);
        }

        private void reset() {
            this.myNextPart.delete(0, this.myNextPart.length());
        }

        private String joinParts() {
            return StringUtil.join("/", this.myParts);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/FileUtil$PathNormalizer", "<init>"));
        }
    }

    public static class DeleteState
    implements FilesDeleteListener {
        private final AtomicLong myDeletedSize = new AtomicLong(0L);

        public long getDeletedSize() {
            return this.myDeletedSize.get();
        }

        @Override
        public void fileDeleted(String relativePath, long size, boolean wasDirectory) {
            this.myDeletedSize.addAndGet(size);
        }
    }

    public static interface FilesDeleteListener
    extends EventListener {
        public void fileDeleted(String var1, long var2, boolean var4);
    }

    public static interface Processor {
        public void process(Element var1);
    }

    public static interface ErrorReporter {
        public void error(String var1);
    }

    public static interface IOAction {
        public static final IOAction DO_NOTHING = () -> {};

        public void run() throws IOException;
    }
}

