/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import jetbrains.buildServer.util.StringUtil;

public class HelpURLProvider {
    public static final String HELP_URL = "https://www.jetbrains.com/help/teamcity/2020.2/?";

    public static String getHelpUrl(String pageName) {
        return HelpURLProvider.getHelpUrl(HELP_URL, pageName, null);
    }

    public static String getHelpUrl(String pageName, String anchor) {
        return HelpURLProvider.getHelpUrl(HELP_URL, pageName, anchor);
    }

    public static String getHelpUrl(String baseUrl, String pageName, String anchor) {
        return HelpURLProvider.getHelpUrl(baseUrl, pageName, anchor, true);
    }

    public static String getHelpUrl(String baseUrl, String pageName, String anchor, boolean encodePageName) {
        String helpUrl = StringUtil.isEmpty((String)baseUrl) ? HELP_URL : baseUrl;
        try {
            String encodedPageName = encodePageName ? URLEncoder.encode(pageName, "UTF-8") : pageName;
            String result = helpUrl + encodedPageName;
            if (anchor != null && !"".equals(anchor)) {
                String page = encodePageName ? pageName : URLDecoder.decode(pageName, "UTF-8");
                result = result + "#" + page.replace(" ", "") + "-" + anchor;
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            return helpUrl + pageName.replace(' ', '+');
        }
    }
}

