/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class IncludeExcludeRules {
    @NotNull
    private final List<Rule> myRules;

    public IncludeExcludeRules(@NotNull String lines) {
        if (lines == null) {
            IncludeExcludeRules.$$$reportNull$$$0(0);
        }
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
        for (String line : StringUtil.split(lines, true, '\n', '\r')) {
            Rule rule;
            boolean include;
            String trimmed;
            String pattern = trimmed = line.trim();
            boolean bl = include = !trimmed.startsWith("-:");
            if (trimmed.startsWith("+:") || trimmed.startsWith("-:")) {
                pattern = trimmed.substring(2);
            }
            if (StringUtil.isEmpty((String)pattern) || rules.contains(rule = new Rule(pattern, include))) continue;
            rules.add(rule);
        }
        this.myRules = Collections.unmodifiableList(new ArrayList(rules));
    }

    @NotNull
    public static List<Rule> getRules(@NotNull String lines) {
        if (lines == null) {
            IncludeExcludeRules.$$$reportNull$$$0(1);
        }
        List<Rule> list = new IncludeExcludeRules(lines).getRules();
        if (list == null) {
            IncludeExcludeRules.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<Rule> getRules() {
        List<Rule> list = this.myRules;
        if (list == null) {
            IncludeExcludeRules.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/IncludeExcludeRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/IncludeExcludeRules";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRules";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Rule {
        private final String myRule;
        private final boolean myInclude;

        public Rule(@NotNull String rule, boolean include) {
            if (rule == null) {
                Rule.$$$reportNull$$$0(0);
            }
            this.myRule = rule;
            this.myInclude = include;
        }

        @NotNull
        public String getRule() {
            String string = this.myRule;
            if (string == null) {
                Rule.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isInclude() {
            return this.myInclude;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            if (this.myInclude != rule.myInclude) {
                return false;
            }
            return this.myRule.equals(rule.myRule);
        }

        public int hashCode() {
            int result = this.myRule.hashCode();
            result = 31 * result + (this.myInclude ? 1 : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/IncludeExcludeRules$Rule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/IncludeExcludeRules$Rule";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

