/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongArray;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.SystemTimeService;
import jetbrains.buildServer.util.TimeService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntervalMetric {
    private static final int ONE_MIN_MS = 60000;
    private static final int FIVE_MIN_MS = 300000;
    private static final int TEN_MIN_MS = 600000;
    public static final long[] DEFAULT_INTERVALS = new long[]{60000L, 300000L, 600000L};
    private final ValueType myValueType;
    private final long[] myIntervals;
    private final AtomicLongArray myPrevData;
    private final AtomicLongArray myCurData;
    private final AtomicLongArray myPrevTime;
    private volatile long myUpdateTime;
    private final TimeService myTimeService;
    private final String myDescription;

    public IntervalMetric(@NotNull String description) {
        if (description == null) {
            IntervalMetric.$$$reportNull$$$0(0);
        }
        this(ValueType.SIMPLE, DEFAULT_INTERVALS, description, null);
    }

    public IntervalMetric(@NotNull ValueType valueType, long[] intervals, @NotNull String description, @Nullable TimeService timeService) {
        if (valueType == null) {
            IntervalMetric.$$$reportNull$$$0(1);
        }
        if (description == null) {
            IntervalMetric.$$$reportNull$$$0(2);
        }
        this.myValueType = valueType;
        this.myIntervals = intervals;
        this.myDescription = description;
        this.myPrevData = new AtomicLongArray(this.myIntervals.length);
        this.myCurData = new AtomicLongArray(this.myIntervals.length);
        this.myPrevTime = new AtomicLongArray(this.myIntervals.length);
        this.myTimeService = timeService == null ? SystemTimeService.getInstance() : timeService;
        this.myUpdateTime = 0L;
        long curTime = this.myTimeService.now();
        for (int i = 0; i < this.myPrevTime.length(); ++i) {
            this.myPrevTime.set(i, curTime);
        }
    }

    public void add(long amount) {
        long curTime = this.myTimeService.now();
        for (int i = 0; i < this.myIntervals.length; ++i) {
            long curVal = this.myCurData.getAndAdd(i, amount);
            long prevTime = this.myPrevTime.get(i);
            long diff = curTime - prevTime;
            if (diff < this.myIntervals[i] && diff >= 0L || !this.myPrevTime.compareAndSet(i, prevTime, curTime)) continue;
            this.myCurData.set(i, amount);
            this.myPrevData.set(i, curVal);
        }
        if (amount > 0L) {
            this.myUpdateTime = curTime;
        }
    }

    public long getValue(int idx) {
        if (idx >= this.myIntervals.length || idx < 0) {
            throw new IllegalArgumentException("Incorrect index value: " + idx);
        }
        this.add(0L);
        return this.myPrevData.get(idx);
    }

    private float getAverageRatePerMs(int idx) {
        this.add(0L);
        long prevTime = this.myPrevTime.get(idx);
        long curTime = this.myTimeService.now();
        long interval = this.myIntervals[idx];
        long timeDiff = curTime - prevTime;
        long prevVal = this.myPrevData.get(idx);
        long curVal = this.myCurData.get(idx);
        long totalInterval = interval + timeDiff;
        return 1.0f * (float)(curVal + prevVal) / (float)totalInterval;
    }

    public long getLastModified() {
        return this.myUpdateTime;
    }

    @NotNull
    public List<Float> getRate() {
        ArrayList<Float> res = new ArrayList<Float>();
        for (int i = 0; i < this.myIntervals.length; ++i) {
            float rate = 1000.0f * this.getAverageRatePerMs(i);
            res.add(Float.valueOf(rate));
        }
        ArrayList<Float> arrayList = res;
        if (arrayList == null) {
            IntervalMetric.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getFormattedRate() {
        ArrayList<String> res = new ArrayList<String>();
        for (Float rate : this.getRate()) {
            switch (this.myValueType) {
                case BYTES: {
                    String formatted = StringUtil.formatFileSize(rate.longValue());
                    res.add(formatted + " per second");
                    break;
                }
                case SIMPLE: {
                    res.add(String.format("%.2f per second", rate));
                }
            }
        }
        ArrayList<String> arrayList = res;
        if (arrayList == null) {
            IntervalMetric.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            IntervalMetric.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/IntervalMetric";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/IntervalMetric";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattedRate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ValueType {
        SIMPLE,
        BYTES;

    }
}

