/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.Trinity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.Converter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemSynchronizer<LocalItem, RemoteItem, ItemId> {
    @NotNull
    public List<Item> synchronize(@NotNull Collection<LocalItem> localItems, @NotNull Collection<RemoteItem> remoteItems) {
        Object remoteItem;
        Object localItem;
        if (localItems == null) {
            ItemSynchronizer.$$$reportNull$$$0(0);
        }
        if (remoteItems == null) {
            ItemSynchronizer.$$$reportNull$$$0(1);
        }
        Map<ItemId, LocalItem> localItemIndex = this.buildLocalItemIndex(localItems);
        Map<ItemId, RemoteItem> remoteItemIndex = this.buildRemoteItemIndex(remoteItems);
        if (!localItemIndex.isEmpty() && remoteItemIndex.isEmpty()) {
            if (!this.canDeleteItems()) {
                List<Item> list = Collections.emptyList();
                if (list == null) {
                    ItemSynchronizer.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (!this.canDeleteAllItems()) {
                this.logRefusedToDeleteAllItems();
                List<Item> list = Collections.emptyList();
                if (list == null) {
                    ItemSynchronizer.$$$reportNull$$$0(3);
                }
                return list;
            }
        }
        ArrayList<Trinity> itemsToUpdate = new ArrayList<Trinity>();
        for (Map.Entry<ItemId, LocalItem> localEntry : localItemIndex.entrySet()) {
            ItemId ItemId = localEntry.getKey();
            localItem = localEntry.getValue();
            remoteItem = remoteItemIndex.remove(ItemId);
            if (remoteItem == null) {
                if (this.canDeleteItems()) {
                    this.deleteItem(localItem, ItemId);
                    continue;
                }
                this.logRefusedToDeleteItem(localItem, ItemId);
                continue;
            }
            itemsToUpdate.add(Trinity.create(localItem, remoteItem, ItemId));
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (Trinity trinity : itemsToUpdate) {
            LocalItem newLocalItem;
            localItem = trinity.getFirst();
            remoteItem = trinity.getSecond();
            Object itemId = trinity.getThird();
            if (this.canUpdateItems()) {
                newLocalItem = this.updateItem(localItem, remoteItem, itemId);
            } else {
                this.logRefusedToUpdateItem(localItem, remoteItem, itemId);
                newLocalItem = localItem;
            }
            items.add(new Item(newLocalItem, remoteItem, itemId));
        }
        for (Map.Entry entry : remoteItemIndex.entrySet()) {
            Object itemId = entry.getKey();
            remoteItem = entry.getValue();
            if (this.canCreateItems()) {
                LocalItem newLocalItem = this.createItem(remoteItem, itemId);
                if (newLocalItem == null) continue;
                items.add(new Item(newLocalItem, remoteItem, itemId));
                continue;
            }
            this.logRefusedToCreateItem(remoteItem, itemId);
        }
        ArrayList<Item> arrayList = items;
        if (arrayList == null) {
            ItemSynchronizer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    protected abstract ItemId getLocalItemId(@NotNull LocalItem var1);

    @Nullable
    protected abstract ItemId getRemoteItemId(@NotNull RemoteItem var1);

    @Nullable
    protected abstract LocalItem createItem(@NotNull RemoteItem var1, @NotNull ItemId var2);

    @NotNull
    protected abstract LocalItem updateItem(@NotNull LocalItem var1, @NotNull RemoteItem var2, @NotNull ItemId var3);

    protected abstract void deleteItem(@NotNull LocalItem var1, @NotNull ItemId var2);

    protected boolean canCreateItems() {
        return true;
    }

    protected boolean canUpdateItems() {
        return true;
    }

    protected boolean canDeleteItems() {
        return true;
    }

    protected boolean canDeleteAllItems() {
        return true;
    }

    protected void logRefusedToCreateItem(@NotNull RemoteItem remoteItem, @NotNull ItemId itemId) {
        if (remoteItem == null) {
            ItemSynchronizer.$$$reportNull$$$0(5);
        }
        if (itemId == null) {
            ItemSynchronizer.$$$reportNull$$$0(6);
        }
    }

    protected void logRefusedToUpdateItem(@NotNull LocalItem localItem, @NotNull RemoteItem remoteItem, @NotNull ItemId itemId) {
        if (localItem == null) {
            ItemSynchronizer.$$$reportNull$$$0(7);
        }
        if (remoteItem == null) {
            ItemSynchronizer.$$$reportNull$$$0(8);
        }
        if (itemId == null) {
            ItemSynchronizer.$$$reportNull$$$0(9);
        }
    }

    protected void logRefusedToDeleteItem(@NotNull LocalItem localItem, @NotNull ItemId itemId) {
        if (localItem == null) {
            ItemSynchronizer.$$$reportNull$$$0(10);
        }
        if (itemId == null) {
            ItemSynchronizer.$$$reportNull$$$0(11);
        }
    }

    protected void logRefusedToDeleteAllItems() {
    }

    protected void logWarn(@NotNull String message) {
        if (message == null) {
            ItemSynchronizer.$$$reportNull$$$0(12);
        }
    }

    @NotNull
    protected Map<ItemId, LocalItem> buildLocalItemIndex(@NotNull Collection<LocalItem> localItems) {
        if (localItems == null) {
            ItemSynchronizer.$$$reportNull$$$0(13);
        }
        Map<ItemId, LocalItem> map = this.buildItemIndex(localItems, new Converter<ItemId, LocalItem>(){

            @Override
            public ItemId createFrom(@NotNull LocalItem item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ItemSynchronizer.this.getLocalItemId(item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "jetbrains/buildServer/util/ItemSynchronizer$1", "createFrom"));
            }
        });
        if (map == null) {
            ItemSynchronizer.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    protected Map<ItemId, RemoteItem> buildRemoteItemIndex(@NotNull Collection<RemoteItem> remoteItems) {
        if (remoteItems == null) {
            ItemSynchronizer.$$$reportNull$$$0(15);
        }
        Map<ItemId, RemoteItem> map = this.buildItemIndex(remoteItems, new Converter<ItemId, RemoteItem>(){

            @Override
            public ItemId createFrom(@NotNull RemoteItem item) {
                if (item == null) {
                    2.$$$reportNull$$$0(0);
                }
                return ItemSynchronizer.this.getRemoteItemId(item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "jetbrains/buildServer/util/ItemSynchronizer$2", "createFrom"));
            }
        });
        if (map == null) {
            ItemSynchronizer.$$$reportNull$$$0(16);
        }
        return map;
    }

    @NotNull
    protected <Item, ItemId> Map<ItemId, Item> buildItemIndex(@NotNull Collection<Item> items, @NotNull Converter<ItemId, Item> itemIdProvider) {
        if (items == null) {
            ItemSynchronizer.$$$reportNull$$$0(17);
        }
        if (itemIdProvider == null) {
            ItemSynchronizer.$$$reportNull$$$0(18);
        }
        HashMap<ItemId, Item> result = new HashMap<ItemId, Item>();
        for (Item item : items) {
            Item previousItem;
            ItemId itemId;
            if (item == null || (itemId = itemIdProvider.createFrom(item)) == null || (previousItem = result.put(itemId, item)) == null) continue;
            this.logWarn("Detected clash of indexed items with id '" + itemId.toString() + "' between item {" + item.toString() + "} and item {" + previousItem.toString() + "}");
        }
        HashMap<ItemId, Item> hashMap = result;
        if (hashMap == null) {
            ItemSynchronizer.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localItems";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteItems";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/ItemSynchronizer";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteItem";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemId";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localItem";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemIdProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/ItemSynchronizer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "synchronize";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLocalItemIndex";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRemoteItemIndex";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildItemIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "synchronize";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "logRefusedToCreateItem";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logRefusedToUpdateItem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logRefusedToDeleteItem";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logWarn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildLocalItemIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildRemoteItemIndex";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildItemIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Item {
        @NotNull
        private final LocalItem myLocalItem;
        @NotNull
        private final RemoteItem myRemoteItem;
        @NotNull
        private final ItemId myItemId;

        public Item(@NotNull LocalItem localItem, @NotNull RemoteItem remoteItem, ItemId itemId) {
            if (localItem == null) {
                Item.$$$reportNull$$$0(0);
            }
            if (remoteItem == null) {
                Item.$$$reportNull$$$0(1);
            }
            if (itemId == null) {
                Item.$$$reportNull$$$0(2);
            }
            this.myLocalItem = localItem;
            this.myRemoteItem = remoteItem;
            this.myItemId = itemId;
        }

        @NotNull
        public LocalItem getLocalItem() {
            Object LocalItem = this.myLocalItem;
            if (LocalItem == null) {
                Item.$$$reportNull$$$0(3);
            }
            return LocalItem;
        }

        @NotNull
        public RemoteItem getRemoteItem() {
            Object RemoteItem = this.myRemoteItem;
            if (RemoteItem == null) {
                Item.$$$reportNull$$$0(4);
            }
            return RemoteItem;
        }

        @NotNull
        public ItemId getItemId() {
            Object ItemId = this.myItemId;
            if (ItemId == null) {
                Item.$$$reportNull$$$0(5);
            }
            return ItemId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localItem";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteItem";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemId";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/ItemSynchronizer$Item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/ItemSynchronizer$Item";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocalItem";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteItem";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItemId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

