/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.List;

public class ListConverter
extends AbstractCollectionConverter {
    private final Class myClass;

    public ListConverter(Mapper mapper, Class listDerived) {
        super(mapper);
        this.myClass = listDerived;
        assert (List.class.isAssignableFrom(listDerived)) : listDerived;
    }

    public boolean canConvert(Class type) {
        return type == this.myClass;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        for (Object item : (List)source) {
            this.writeItem(item, context, writer);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        List items;
        try {
            items = (List)this.myClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Object item = this.readItem(reader, context, null);
            items.add(item);
            reader.moveUp();
        }
        return items;
    }
}

