/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.buildServer.util.DiagnosticUtil;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.FuncThrow;
import jetbrains.buildServer.util.NamedThreadUtil;
import jetbrains.buildServer.util.ThreadStat;
import org.jetbrains.annotations.NotNull;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger myCounter = new AtomicInteger(1);
    private final String myNamePrefix;
    private final ThreadFactory myThreadFactory;

    public NamedThreadFactory(String namePrefix) {
        this.myNamePrefix = namePrefix;
        this.myThreadFactory = Executors.defaultThreadFactory();
    }

    @Deprecated
    public static String updateThreadName(@NotNull String newDetails) {
        if (newDetails == null) {
            NamedThreadFactory.$$$reportNull$$$0(0);
        }
        return NamedThreadUtil.updateThreadName(newDetails).getOldName();
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        if (r == null) {
            NamedThreadFactory.$$$reportNull$$$0(1);
        }
        Thread thread = this.myThreadFactory.newThread(r);
        thread.setName(this.myNamePrefix + " " + this.myCounter.getAndIncrement());
        Thread thread2 = thread;
        if (thread2 == null) {
            NamedThreadFactory.$$$reportNull$$$0(2);
        }
        return thread2;
    }

    public String getThreadDump() {
        return DiagnosticUtil.threadDumpToString();
    }

    public static void executeWithNewThreadName(@NotNull String newDetails, @NotNull Runnable action) {
        if (newDetails == null) {
            NamedThreadFactory.$$$reportNull$$$0(3);
        }
        if (action == null) {
            NamedThreadFactory.$$$reportNull$$$0(4);
        }
        Disposable patch = NamedThreadFactory.patchThreadName(newDetails);
        try {
            action.run();
        }
        finally {
            patch.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithNewThreadName(@NotNull String newDetails, @NotNull Callable<T> action) throws Exception {
        if (newDetails == null) {
            NamedThreadFactory.$$$reportNull$$$0(5);
        }
        if (action == null) {
            NamedThreadFactory.$$$reportNull$$$0(6);
        }
        Disposable patch = NamedThreadFactory.patchThreadName(newDetails);
        try {
            T t = action.call();
            return t;
        }
        finally {
            patch.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T executeWithNewThreadNameFuncThrow(@NotNull String newDetails, @NotNull FuncThrow<T, E> action) throws E {
        if (newDetails == null) {
            NamedThreadFactory.$$$reportNull$$$0(7);
        }
        if (action == null) {
            NamedThreadFactory.$$$reportNull$$$0(8);
        }
        Disposable patch = NamedThreadFactory.patchThreadName(newDetails);
        try {
            T t = action.apply();
            return t;
        }
        finally {
            patch.dispose();
        }
    }

    @NotNull
    public static Disposable patchThreadName(@NotNull String newDetails) {
        if (newDetails == null) {
            NamedThreadFactory.$$$reportNull$$$0(9);
        }
        final NamedThreadUtil.ThreadNameCookie threadCookie = NamedThreadUtil.updateThreadName(newDetails);
        final ThreadStat.OperationDisposable operation = ThreadStat.get().startOperation(newDetails);
        Disposable disposable = new Disposable(){

            @Override
            public void dispose() {
                operation.dispose();
                threadCookie.dispose();
            }
        };
        if (disposable == null) {
            NamedThreadFactory.$$$reportNull$$$0(10);
        }
        return disposable;
    }

    public String toString() {
        return "Thread factory \"" + this.myNamePrefix + "\"";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDetails";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/NamedThreadFactory";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/NamedThreadFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newThread";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "patchThreadName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "newThread";
                break;
            }
            case 2: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeWithNewThreadName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeWithNewThreadNameFuncThrow";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "patchThreadName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

